/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationTemplatePage
////i18n-prefix = planningNotificationTemplatePage

define([ "cdes/planning/template/PlanningNotificationTemplateListWidget",
	"clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",	 
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(PlanningNotificationTemplateListWidget,
			TinyLog,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			Button,
			domClass,
			domConstruct,
			domStyle,
			on,		
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.template.PlanningNotificationTemplatePage";

	var log = new TinyLog(className);

	var PlanningNotificationTemplatePage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationTemplatePage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationTemplatePageCaption, captionBarDiv, "cdesGeneralPageCaption");

			// New Button     		
			this.newButton = new Button({
				label : i18n.planningNotificationTemplatePageNewLabel,
				title : i18n.planningNotificationTemplatePageNewToolTip
			});
			domClass.add(this.newButton.domNode, "fixedDialogWidget planningNotificationTemplatePageNewButton");
			domConstruct.place(this.newButton.domNode, captionBarDiv);

			on(this.newButton, "click", lang.hitch(this, function() {
				this.applicationContext.setPage("planningNotificationTemplateEdit",
						{ mode : ContentWidget.Mode.CREATE },
						{ backPage : "planningNotificationTemplateList", backParams : new Object() });
			}));		

			return captionBarDiv;
		},

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationTemplatePageContentDiv");

			// List Widget
			this.listWidget = new PlanningNotificationTemplateListWidget({
				applicationContext : this.applicationContext,
				backPage : "planningNotificationTemplateList",
				backParams : new Object()
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domClass.add(this.listWidgetDiv, "fixedDialogWidget planningNotificationTemplateListWidget");	    
			domConstruct.place(this.listWidgetDiv, contentDiv);	    
			// Reload data after certain operations which change state have been performed
			on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

                    this.listWidget.restoreColumnWidths();

			return contentDiv;
		},

		resize : function(newSize) {
			if (newSize) {
				this.lastNewSize = newSize;
			}

			var totalHeight = this.lastNewSize.h;    		

			var tableWidth = this.captionBarDiv.offsetWidth - 15;
			var tableHeight = totalHeight
			- this.captionBarDiv.offsetHeight
			//	- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
			//	- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
			// 	- this.statusBarDiv.offsetHeight
			- 16;
			this.listWidget.resize({ w : tableWidth, h : tableHeight });

			/*            
	        var contentHeight = totalHeight
		        - this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
		        - this.captionBarDiv.offsetHeight
		        - 16;

	        domStyle.set(this.contentDiv, "height", contentHeight + "px");
			 */
		},

		setData : function() {
			this.reload();
		},

		reload : function() {
			this.registerAsyncOperationStarted(PlanningNotificationTemplatePage.AsyncOperation.LOAD);

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getAllPlanningNotificationTemplates().then(
					lang.hitch(this, function(planningNotificationTemplates) {
						this.registerAsyncOperationFinished(PlanningNotificationTemplatePage.AsyncOperation.LOAD);

						this.listWidget.setData({
							planningNotificationTemplates : planningNotificationTemplates
						});		    
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationTemplatePage.AsyncOperation.LOAD,
							opName : "getAllPlanningNotificationTemplates",
							message : i18n.planningNotificationTemplatePageGetAllFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getAllPlanningNotificationTemplates]", err);
							}));
		},

		updateWidgetState : function() {

		},

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationTemplatePage.AsyncOperation = {
			LOAD : "Load"
	};

	return PlanningNotificationTemplatePage;
});
