/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = columnHelper
//// i18n-prefix = columnHelper

define(["clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "dgrid/util/misc",
    "dojo/_base/lang",
    "dojo/has",
    "dojo/on"        
],
function(TinyLog,
    DateHelper,
    dgridMiscUtil,                
    lang,
    has,
    on                
) {
    
    var className = "at.cdes.web.util.ColumnHelper";

    var log = new TinyLog(className);   
    
    var ColumnHelper = {

        getColumnSettingsForReload : function(baseWidget, searchModel) {
            // summary:
            //     Returns the column settings to be used for a reload of the given baseWidget.
            // description:
            //     The baseWidget is supposed to have a column widget (and probably list and
            //     search widget).  The returned columnSettings are an object consisting of
            //     flag wether to display some particular column, something like showFoo.
            //
            //     baseWidget is supposed to have the following functions:
            //     - getColumnWidget returning the column widget, with at least the following functions:
            //         - getColumnSetting function returning its current settings
            //         - setData(columnSettings), for setting possibly changed columnSettings       
            //     - getAutomaticColumnSettings returning automatically derived column settings
            //         based on the given searchModel       
            
            var columnWidget = baseWidget.getColumnWidget();            
            var columnSettings = baseWidget.getColumnWidget().getColumnSettings();
            if (!columnSettings.manualColumns) {
                columnSettings = baseWidget.getAutomaticColumnSettings(searchModel);
                baseWidget.getColumnWidget().setData(columnSettings);
            }
            return columnSettings;
        },

        emitColumnsChanged : function(applicationContext, columnSettingsWidget, localStorageKey, columnId) {
            // summary:
            //    Function to be called once the checkBox state inside a ColumnSettings widget changes.
            // description:
            //    Updates the columnSettings, sets the flag indicating that the column settings where changed
            //    manually, and transfers the updated column settings into local storage.           
            //
            //    Expects that columnSettingsWidget.updateDataFromWidget updates the columnSettings.

            columnSettingsWidget.updateDataFromWidgets();
            columnSettingsWidget.getColumnSettings().manualColumns = true;
            
            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            var networkId = applicationContext.getPageContextNetworkId();
            
            applicationContext.storeInLocalStorage([organisationPersonId, networkId], localStorageKey, columnSettingsWidget.getColumnSettings());
            // sample key: "/certificate/columns"

            on.emit(columnSettingsWidget, "columnsChanged", columnId);
        },

        getDefaultColumnSettings : function(applicationContext, pageWidget, searchModel, localStorageKey) {
            // summary:
            //     Returns the default column settings for a column setting widget inside the given pageWidget.
            // description:
            //     If columnSettings are stored in the local storage under the given key, they are returned.      
            //     Otherwise, function pageWidget.getAutomaticColumnSettings is used.


            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            var networkId = applicationContext.getPageContextNetworkId();                   
            var oldColumnSettings = applicationContext.getFromLocalStorage([organisationPersonId, networkId], localStorageKey);
            if (oldColumnSettings != null) {
                return oldColumnSettings;
            } else {
                return pageWidget.getAutomaticColumnSettings(searchModel);
            }
        },

        emitColumnsChangedPN : function(applicationContext, columnSettingsWidget, localStorageKey, columnId) {
            // summary:
            //    Function to be called once the checkBox state inside a ColumnSettings widget changes.
            // description:
            //    Updates the columnSettings, sets the flag indicating that the column settings where changed
            //    manually, and transfers the updated column settings into local storage.           
            //
            //    Expects that columnSettingsWidget.updateDataFromWidget updates the columnSettings.

            columnSettingsWidget.updateDataFromWidgets();
            columnSettingsWidget.getColumnSettings().manualColumns = true;
            
            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            var networkId = applicationContext.getPageContextPnNetworkId();
            
            applicationContext.storeInLocalStorage([organisationPersonId, networkId], localStorageKey, columnSettingsWidget.getColumnSettings());
            // sample key: "/certificate/columns"

            on.emit(columnSettingsWidget, "columnsChanged", columnId);
        },

        getDefaultColumnSettingsPN : function(applicationContext, pageWidget, searchModel, localStorageKey) {
            // summary:
            //     Returns the default column settings for a column setting widget inside the given pageWidget.
            // description:
            //     If columnSettings are stored in the local storage under the given key, they are returned.      
            //     Otherwise, function pageWidget.getAutomaticColumnSettings is used.


            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            var networkId = applicationContext.getPageContextPnNetworkId();                   
            var oldColumnSettings = applicationContext.getFromLocalStorage([organisationPersonId, networkId], localStorageKey);
            if (oldColumnSettings != null) {
                return oldColumnSettings;
            } else {
                return pageWidget.getAutomaticColumnSettings(searchModel);
            }
        },

        getNumberOfShownColumns : function(columnSettings, actionColumn) {
            var numberOfColumns = 0;
            for (var c in columnSettings) {
                if (c.indexOf("show") == 0 && columnSettings[c]) {
                    numberOfColumns++;                      
                }                   
            }

            numberOfColumns += (actionColumn ? 1 : 0);

            return numberOfColumns;         
        },

        getColumnWidthMap : function(grid) {
            var columns = grid.get("columns");
            var columnWidthMap = new Object();
            for (var n = 0; n < columns.length; n++) {
                var column = columns[n];
                if (!column.hidden) {
                    var width = column.headerNode != null ? column.headerNode.clientWidth : column.width != null ? column.width : 0;
                    columnWidthMap[column.id] = width;                    
                }                    
            }
            return columnWidthMap;            
        },

        saveColumnWidthsInLocalStorage : function(params) {
            var applicationContext = params.applicationContext;
            var grid = params.grid;
            var contextKeys = params.contextKeys;
            var widthKey = params.widthKey;
			
			//ColumnHelper.cutColumnsToAvailableWidth(grid);
            
            var columnWidthMap = ColumnHelper.getColumnWidthMap(grid);
	    	var columnWidthInfo = applicationContext.getFromLocalStorage(contextKeys, widthKey);
            if (columnWidthInfo == null) {
                columnWidthInfo = new Object();
            }
            columnWidthInfo["last"] = {
                     ts : DateHelper.getCurrentTimeSeconds(),
                    map : columnWidthMap
            };                

	    	applicationContext.storeInLocalStorage(contextKeys, widthKey, columnWidthInfo);
        },

        restoreColumnWidthsFromLocalStorage : function(params) {
            var applicationContext = params.applicationContext;
            var grid = params.grid;
            var contextKeys = params.contextKeys;
            var widthKey = params.widthKey;
            var queryKey = params.queryKey != null ? params.queryKey : "last";
            var minWidth = params.minWidth != null ? params.minWidth : 5;

	    	var columnWidthInfo = applicationContext.getFromLocalStorage(contextKeys, widthKey);
            if (columnWidthInfo != null && queryKey in columnWidthInfo) {
                var columnWidthDetails = columnWidthInfo[queryKey];
                var columnWidthMap = columnWidthDetails.map;

                var columns = grid.get("columns");
                for (var n = 0; n < columns.length; n++) {
                    var column = columns[n];
                    if (!column.hidden) {
                        var desiredWidth = columnWidthMap[column.id];
                        if (desiredWidth < minWidth) {
                            desiredWidth = minWidth;
                        }                            
                        grid.resizeColumnWidth(column.id, desiredWidth);
                    }
                }                    

                ColumnHelper.cutColumnsToAvailableWidth(grid);
            }                
        },

        cutColumnsToAvailableWidth : function(grid, constColumn) {
            var columnWidthMap = ColumnHelper.getColumnWidthMap(grid);
            var columnWidthSum = 0;
            for (var id in columnWidthMap) {
                columnWidthSum += columnWidthMap[id];
            }
            var constColumnWidth = constColumn != null && constColumn in columnWidthMap ? columnWidthMap[constColumn] : null;

            var totalWidth = grid.headerNode.clientWidth; //grid.bodyNode.clientWidth;

            if (columnWidthSum > totalWidth) {
                var factor;
                var recognizeConstColumn = constColumnWidth != null && constColumnWidth < totalWidth;
                if (recognizeConstColumn) {
                    factor = (totalWidth - constColumnWidth) / (columnWidthSum - constColumnWidth);
                } else {
                    factor = totalWidth / columnWidthSum;
                }

                for (var columnId in columnWidthMap) {
                    if (!recognizeConstColumn || columnId != constColumn) {
                        grid.resizeColumnWidth(columnId, columnWidthMap[columnId] * factor);
                    }                        
                }
                
            }
        }
    };
    
    return ColumnHelper;
});
