/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = workflowNodeParticipantChoose
////i18n-prefix = workflowNodeParticipantChoose



define([ "cdes/planning/util/MetaInformationChooseWidget",
	"cdes/planning/workflow/DueDateEditWidget",
	"cdes/widget/project/ProjectParticipantChooseWidget",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateHelper",
	"clazzes/dateTime/FancyDate",
	"clazzes/widgets/layout/ChooseDialog",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",	 
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"
	],
	function(MetaInformationChooseWidget,
			DueDateEditWidget,
			ProjectParticipantChooseWidget,
			TinyLog,
			DateHelper,
			FancyDate,
			ChooseDialog,                
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,		
			i18n) {

	var className = "at.cdes.web.planning.workflow.WorkflowNodeParticipantChooseDialog";

	var log = new TinyLog(className);

	var WorkflowNodeParticipantChooseDialog = declare(className, ChooseDialog, {

		constructChooseWidget : function() {
			// summary:
			//     Constructs the widget in which the user chooses some piece of data.
			// description:
			//     That widget must be saved in the variable this.content, and will 
			//     subsequently be placed in the dialog by superclass code.
			//     If some value is chosen by the user in that widget (e.g. a choosable 
			//     tree node is clicked), the subclass must call setChosenValue.  
			//     Optionally, after doing so, the subclass may emit the valueChosen 
			//     event, and close the dialog (e.g. on a double click into the tree).

			var horizontalPadding = 5;

			this.content = domConstruct.create("div", null, null);
			domClass.add(this.content, "refNodeOfPositionAbsolute");
			domStyle.set(this.content, "width", this.defaultWidth + "px");
			domStyle.set(this.content, "height", this.defaultHeight + "px");	    

			if (this.enterDueDate) {
				var currentTimeFancyDate = new FancyDate({
					utcSeconds : DateHelper.getCurrentTimeSeconds(),
					timeZone : this.applicationContext.getTimeZone()		    
				});
				currentTimeFancyDate.truncateToDays();

				this.dueDateEditWidget = new DueDateEditWidget({
					applicationContext : this.applicationContext
				});		    
				this.dueDateInfo = {
						dueDate : currentTimeFancyDate.getUtcSeconds(),
						dueDateRemark : null	    
				};
				this.dueDateEditWidget.setData(this.dueDateInfo);
				on(this.dueDateEditWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));
				var dueDateEditTopDiv = this.dueDateEditWidget.getContainer();
				domClass.add(dueDateEditTopDiv, "fixedDialogWidget workflowNodeParticipantChooseDueDateDiv");		
				domConstruct.place(dueDateEditTopDiv, this.content);
			}		

			var gridTop = this.enterDueDate ? this.dueDateHeight : 0;
			this.participantChooseWidget = new ProjectParticipantChooseWidget({
				applicationContext : this.applicationContext,
				columnCaption : i18n.workflowNodeParticipantChooseParticipantColumnCaption,
				selectionMode : this.participationSelectionMode
			});		
			on(this.participantChooseWidget, "selectionChanged", lang.hitch(this, function(selectedParticipationJoins) {
				this.selectedParticipationJoins = selectedParticipationJoins;
				this.updateWidgetState();		
			}));		
			var participantChooseTopDiv = this.participantChooseWidget.getContainer();
			domStyle.set(participantChooseTopDiv, "position", "absolute");
			domStyle.set(participantChooseTopDiv, "top", gridTop + "px");
			domStyle.set(participantChooseTopDiv, "left", "0px");
			domStyle.set(participantChooseTopDiv, "width", (this.participantGridWidth - horizontalPadding) + "px");
			domStyle.set(participantChooseTopDiv, "height", this.gridHeight + "px");
			domConstruct.place(participantChooseTopDiv, this.content);

			this.participantChooseWidget.setData({
				participationJoins : this.participationJoins
			});

			if (this.enterBaulos) {
				this.baulosChooseWidget = new MetaInformationChooseWidget({
					applicationContext : this.applicationContext,
					columnCaption : i18n.workflowNodeParticipantChooseBaulosColumnCaption
				});
				on(this.baulosChooseWidget, "selectionChanged", lang.hitch(this, function(selectedMetaInformations) {
					this.selectedMetaInformations = selectedMetaInformations;
					this.updateWidgetState();		
				}));		
				var baulosChooseTopDiv = this.baulosChooseWidget.getContainer();
				domStyle.set(baulosChooseTopDiv, "position", "absolute");
				domStyle.set(baulosChooseTopDiv, "top", gridTop + "px");
				domStyle.set(baulosChooseTopDiv, "left", (this.participantGridWidth + horizontalPadding) + "px");
				domStyle.set(baulosChooseTopDiv, "width", (this.baulosGridWidth - horizontalPadding) + "px");
				domStyle.set(baulosChooseTopDiv, "height", this.gridHeight + "px");
				domConstruct.place(baulosChooseTopDiv, this.content);

				this.baulosChooseWidget.setData({
					metaInformations : this.baulosMetaInformations
				});
			}		
		},

		updateWidgetState : function() {
			var buttonEnabled = this.selectedParticipationJoins != null && this.selectedParticipationJoins.length > 0
			&& (this.dueDateEditWidget == null || this.dueDateEditWidget.isValid());		
			if (this.enterBaulos) {
				// Mail to Michael, 2.4.2017 13:00
				//buttonEnabled &= this.selectedMetaInformations != null && this.selectedMetaInformations.length > 0;
			}

			this.selectButton.set("disabled", !buttonEnabled);
		},	    

		emitValueChosen : function(buttonName) {
			if (this.dueDateEditWidget != null) {
				this.dueDateEditWidget.updateDataFromWidgets();
			}		
			on.emit(this, "valueChosen", {
				selectedParticipationJoins : this.selectedParticipationJoins,
				selectedMetaInformations : this.selectedMetaInformations,
				dueDate : this.dueDateInfo != null ? this.dueDateInfo.dueDate : null,
						dueDateRemark : this.dueDateInfo != null ? this.dueDateInfo.dueDateRemark : null		
			});		    
		},

		destroy : function() {
			this.inherited(arguments);
			this.participantChooseWidget.destroy();
			if (this.baulosChooseWidget != null) {
				this.baulosChooseWidget.destroy();		
			}		
		}
	});

	return WorkflowNodeParticipantChooseDialog;
});
