/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/util/ActionHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(

    ActionHelper,
    ListWidget,
    TinyLog,
    ErrorHelper,
    ContentWidget,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    domClass,
    domConstruct,
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.plot.PlotOrderTemplateAddressListWidget";

    var log = new TinyLog(className);

    var PlotOrderTemplateAddressListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlotOrderTemplateAddressListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "plotOrderTemplateAddressList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                    field : "plotterOrganisationId",
                       id : "plotterOrganisationId",
                formatter : lang.hitch(this, this.plotterFormatter),                
                 sortable : true,
                    label : i18n.plotOrderTemplateAddressListPlotterColumnCaption
            });
            
            columns.push({
                    field : "billingAddressId",
                       id : "billingAddressId",
                formatter : lang.hitch(this, this.billingFormatter),                
                 sortable : true,
                    label : i18n.plotOrderTemplateAddressListBillingColumnCaption
            });

            return columns;
        },

        plotterFormatter : function(plotterOrganisationId, templateJoin) {
            return templateJoin.plotterOrganisationName
                + this.getAddressLine(templateJoin.plotterOrganisationPostalAddress)
                + this.getAddressLine(templateJoin.plotterOrganisationPostalCode + " " + templateJoin.plotterOrganisationLocalityName)
                + this.getAddressLine(templateJoin.plotterCountryDescDe);
        },

        billingFormatter : function(billingAddressId, templateJoin) {
            return templateJoin.billingAddressOrganisationName
                + this.getAddressLine(templateJoin.billingAddressPostalAddress)
                + this.getAddressLine(templateJoin.billingAddressPostalCode + " " + templateJoin.billingAddressLocalityName)
                + this.getAddressLine(templateJoin.billingCountryDescDe);
        },

        getAddressLine : function(s) {
            return s != null ? "<br>" + s : "";
        },            

        constructTopDiv : function() {
            this.constructGrid({
		idProperty : "plottOrderTemplateId", 
            	    gridId : "plotOrderTemplateAddressListGrid",
                 gridClass : "Grid"                
            });
            return this.grid.domNode;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.templateJoins = params.templateJoins;
            this.reload();
        },

        reload : function() {
            this.setStoreData(this.templateJoins);
        },


        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    PlotOrderTemplateAddressListWidget.AsyncOperation = {

    };

    return PlotOrderTemplateAddressListWidget;
});
