define([
    "cdes/core/CdesVoc",
    "clazzes/TinyLog",
    "clazzes/topic",
    "clazzes/util/ErrorHelper",
    "clazzes/util/JobHelper",
    "dijit/form/Button",
    "dojo/_base/lang",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"  
],
function(
    CdesVoc,
    TinyLog,
    topic,
    ErrorHelper,
    JobHelper,
    Button,
    lang,    
    domClass,
    domConstruct,
    on,    
    i18n
) {
    
    var className = "at.cdes.web.util.MspHelper";
    
    var log = new TinyLog(className);
    
    var MspHelper = {

        constructRunMspExportNowButton : function(params) {
            var parentDiv = params.parentDiv;
            var applicationContext = params.applicationContext;
            var widget = params.widget;
            var buttonClass = params.buttonClass;            

     	    var button = new Button({
     		label : i18n.documentPageRunMspExportNowCaption,
		title : i18n.documentPageRunMspExportNowToolTip
     	    });
     	    domClass.add(button.domNode, buttonClass);
     	    domConstruct.place(button.domNode, parentDiv);

	    on(button, "click", lang.hitch(this, function() {
                MspHelper.doRunMspExportNow({
                    applicationContext : applicationContext,
                                widget : widget
                });                    
            }));                

	    return button;	    
        },	

        doRunMspExportNow : function(params) {
            var applicationContext = params.applicationContext;
            var widget = params.widget;

            widget.registerAsyncOperationStarted(MspHelper.AsyncOperation.RUN_MSP_EXPORT_NOW);

            topic.publish("message/message", i18n.mspHelperTriggerExportDocumentsNowRunning);

            var mspService = applicationContext.getService("mspService");
            mspService.triggerExportDocumentsToMspNow().then(
                lang.hitch(widget, function(jobId) {
                    this.registerAsyncOperationFinished(MspHelper.AsyncOperation.RUN_MSP_EXPORT_NOW);

                    var jobStatusService = applicationContext.getService("jobStatusService");
		    var deferred = JobHelper.registerJobStatusQueryForGettingResult({
                                     jobId : jobId,
                          jobStatusService : jobStatusService
                    });
                    deferred.then(function() {
                        topic.publish("message/message", i18n.mspHelperTriggerExportDocumentsNowSuccess);                        
                    }, function(err) {
                        log.error("JobStatusQuery had some problem, see server log", err);
                        topic.publish("message/warn", i18n.mspHelperTriggerExportDocumentsNowFailure);                        
                    }).otherwise(function(err) {
                        log.error("Error while processing JobStatusQueryForGettingResult result", err);
                    });                        
                }),
                lang.hitch(widget, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : MspHelper.AsyncOperation.RUN_MSP_EXPORT_NOW,
                                opName : "triggerExportDocumentsToMspNow",
                               message : i18n.documentPageRunMspExportNowFailed
                    });
                }))
            .otherwise(
                lang.hitch(widget, function(err) {
                    log.error("Error while calling function [triggerExportDocumentsToMspNow]", err);
                }));
        }
    };
    
    MspHelper.AsyncOperation = {
        RUN_MSP_EXPORT_NOW : "RunMspExportNow"
    };        

    return MspHelper;
});
