/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = workflowNodeEdit
////i18n-prefix = workflowNodeEdit



define([ "cdes/planning/workflow/WorkflowNodeParticipantChooseDialog",
    "cdes/planning/workflow/WorkflowNodePositionListWidget",
    "clazzes/TinyLog",
    "clazzes/form/FancyButton",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ChooseDialog",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(WorkflowNodeParticipantChooseDialog,
    WorkflowNodePositionListWidget,
    TinyLog,
    FancyButton,
    DOMHelper,
    ErrorHelper,
    ChooseDialog,
    ContentWidget,
    InfoDialog,
    domClass,
    domConstruct,
    domStyle,
    on,
    string,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.workflow.WorkflowNodeEditWidget";

    var log = new TinyLog(className);

    var WorkflowNodeEditWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.updateWidgetState();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "WorkflowNodeEditWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "fixedDialogWidget");          

            this.captionBarDiv = domConstruct.create("div", null, null);
            domClass.add(this.captionBarDiv, "fixedDialogWidget workflowNodeEditCaptionBarDiv");
            domConstruct.place(this.captionBarDiv, topDiv);

            this.captionDiv = DOMHelper.createTextNode("h3", "", this.captionBarDiv, "workflowNodeEditCaption");

            this.newButton = this.constructNewButton(this.captionBarDiv);       

            this.listWidget = new WorkflowNodePositionListWidget({
                applicationContext : this.applicationContext,
                             index : this.index,
                       showDueDate : this.showDueDate,
                        showBaulos : this.showBaulos                            
            });             
            on(this.listWidget, "reloadRequested", lang.hitch(this, this.emitReloadRequested));
            var listWidgetTopDiv = this.listWidget.getContainer();
            domClass.add(listWidgetTopDiv, "fixedDialogWidget workflowNodeEditListWidgetTopDiv");
            domConstruct.place(listWidgetTopDiv, topDiv);       

            this.listWidget.restoreColumnWidths();

            return topDiv;
        },

        constructNewButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.workflowNodeEditNewButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
            });

            domClass.add(button.domNode, "listButton workflowNodeEditNewButton");

            on(button, "click", lang.hitch(this, this.addNewParticipant));

            domConstruct.place(button.domNode, captionBarDiv);          

            return button;
        },          

        addNewParticipant : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var roleTypeId = this.workflowNodeJoin.workflowNodeTemplateRoleTypeId;
            var projectIds = [];
            for (var n = 0; n < this.projectJoins.length; n++) {
                projectIds.push(this.projectJoins[n].projectId);
            }

            var projectService = this.applicationContext.getService("projectService");
            this.registerAsyncOperationStarted(WorkflowNodeEditWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS);
            projectService.getParticipationJoins(organisationPersonId, roleTypeId, projectIds).then(
                lang.hitch(this, function(participationJoins) {
                    this.registerAsyncOperationFinished(WorkflowNodeEditWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS);
                    this.possibleParticipationJoins = participationJoins;
                    this.openParticipantChooseDialog(participationJoins, null);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : WorkflowNodeEditWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS,
                                opName : "getParticipationJoins",
                               message : i18n.workflowNodeEditGetParticipationJoinsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getParticipationJoins]", err);
                    }));

        },

        openParticipantChooseDialog : function(participationJoins, workflowNodePositionId) {
            var position = this.workflowNodeJoin.workflowNodeTemplatePosition;
            //                  var this.workflowNodePositionId = workflowNodePositionId;
            
            var dueDateHeight = 80;
            var participantGridWidth = 700;
            var baulosGridWidth = 150;
            var gridHeight = 320;

            var defaultWidth = participantGridWidth + (position == 1 || this.showBaulos ? baulosGridWidth : 0) + 15;
            var defaultHeight = gridHeight + (position == 1 ? dueDateHeight : 0) + 15;

            var chooseDialog = new WorkflowNodeParticipantChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.workflowNodeEditAddParticipantDialogCaption,
                           buttons : [ 
                               { type : ChooseDialog.Button.CHOOSE,
                                    name : "selectButton",                                              
                                   label : i18n.workflowNodeEditAddParticipantButtonCaption,
                                   title : i18n.workflowNodeEditAddParticipantButtonToolTip
                               },
                               { type : InfoDialog.Button.ABORT,
                                   title : i18n.abortToolTip }
                           ],
                      defaultWidth : defaultWidth,
                     defaultHeight : defaultHeight,
                     dueDateHeight : dueDateHeight,
              participantGridWidth : participantGridWidth,
                   baulosGridWidth : baulosGridWidth,
                        gridHeight : gridHeight,                
                      enterDueDate : position == 1,
        participationSelectionMode : (position == 1 ? "extended" : "single"),
                       enterBaulos : position == 1 || this.showBaulos,
            baulosMetaInformations : position == 1 || this.showBaulos ? this.baulosMetaInformations : null,
                participationJoins : participationJoins         
            });

            on(chooseDialog, "valueChosen", lang.hitch(this, function(params) {
                var selectedParticipationJoins = params.selectedParticipationJoins;
                var selectedMetaInformations = params.selectedMetaInformations;         
                var dueDate = params.dueDate;
                var dueDateRemark = params.dueDateRemark;               

                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

                var participationIds = [];
                for (var n = 0; n < selectedParticipationJoins.length; n++) {
                    participationIds.push(selectedParticipationJoins[n].projectParticipationId);
                }

                var metaInformationIds = [];
                for (var n = 0; selectedMetaInformations != null && n < selectedMetaInformations.length; n++) {
                    metaInformationIds.push(selectedMetaInformations[n].metaInformationId);
                }                   

                if (workflowNodePositionId == null){
                    //add
                    var newPositionTemplate = {
                         workflowNodeId : this.workflowNodeJoin.workflowNodeId,
                                dueDate : dueDate,
                          dueDateRemark : dueDateRemark,
                        optionalDueDate : null              
                    };
                    var planningNotificationService = this.applicationContext.getService("planningNotificationService");
                    this.registerAsyncOperationStarted(WorkflowNodeEditWidget.AsyncOperation.SAVE_NEW_POSITIONS);
                    planningNotificationService.addWorkflowNodePositions(organisationPersonId, newPositionTemplate, participationIds, metaInformationIds).then(
                        lang.hitch(this, function(alreadyExistingPairs) {
                            this.registerAsyncOperationFinished(WorkflowNodeEditWidget.AsyncOperation.SAVE_NEW_POSITIONS);
                            
                            if (alreadyExistingPairs.length > 0) {
                                this.showAlreadyExistingInfoDialog(alreadyExistingPairs, position, lang.hitch(this, this.emitReloadRequested));
                            } else {
                                this.emitReloadRequested();
                            }                   
                        }),
                        lang.hitch(this, function(err) {
                        	var typePos = err.message.indexOf("[TYPE");
                            var type = err.message.substring(typePos+5, typePos+6);
                            // type1: the endNode must contain either the same MetaInfoId as the startNode or a position with a null metaInfoId ('ohne Baulos')
                            // type2: Check whether condition concerning supported combinations of Baulos / non-Baulos are met
                            errMessage = i18n.workflowNodeEditForbiddenCombinationMessage;
                            if (type == 1)
                                errMessage = i18n.workflowNodeEditMissingValidEndNodeConfigMessage;

                            InfoDialog.showError({
                                title : i18n.workflowNodeEditForbiddenCombinationCaption,
                              message : errMessage
                            });
/*                        	
                            ErrorHelper.processAsyncError({
                                           err : err,
                                        widget : this,
                                asyncOperation : WorkflowNodeEditWidget.AsyncOperation.SAVE_NEW_POSITIONS,
                                        opName : "addWorkflowNodePositions",
                                       message : i18n.workflowNodeEditForbiddenCombinationMessage
                            });
*/                            
                        })).otherwise(
                            lang.hitch(this, function(err) {
                                log.error("Error while calling function [addWorkflowNodePositions]", err);
                            }));        
                }else{
                    //replace
                    /*                                  this.registerAsyncOperationStarted(WorkflowNodePositionListWidget.AsyncOperation.REPLACE_POSITION);
                    planningNotificationService.replaceWorkflowNodePositionsPP(organisationPersonId, this.workflowNodePositionId, participationId).then(
                        lang.hitch(this, function(alreadyExistingPair) {
                            this.registerAsyncOperationFinished(WorkflowNodePositionListWidget.AsyncOperation.REPLACE_POSITION);

                            if (alreadyExistingPair != null) {
                                var alreadyExistingPairs = [];
                                alreadyExistingPairs.push(alreadyExistingPair);
                                this.showAlreadyExistingInfoDialog(alreadyExistingPairs, position, lang.hitch(this, this.emitReloadRequested));
                            } else {
                                this.emitReloadRequested();
                            }                   
                        }),
                        lang.hitch(this, function(err) {
                            ErrorHelper.processAsyncError({
                                           err : err,
                                        widget : this,
                                asyncOperation : WorkflowNodePositionListWidget.AsyncOperation.REPLACE_POSITION,
                                        opName : "replaceWorkflowNodePositionsPP",
                                       message : i18n.workflowNodePositionListReplaceWorkflowNodePositionsFailed
                            });
                        })).otherwise(
                            lang.hitch(this, function(err) {
                                log.error("Error while calling function [replaceWorkflowNodePositionsPP]", err);
                            }));                
                    */                                  
                }
                
            }));                

            chooseDialog.show(null);
        },          

        showAlreadyExistingInfoDialog : function(alreadyExistingPairs, position, callbackFct) {
            var topDiv = domConstruct.create("div", null, null);
            //                      var position = this.workflowNodeJoin.workflowNodeTemplatePosition;
            domClass.add(topDiv, "workflowNodeEditAlreadyExistingDialogTopDiv occupyWholeParent");

            var enumerationStrings = [];
            var header = position == 1 ? i18n.workflowNodeEditAlreadyExistingDialogContentStart : i18n.workflowNodeEditAlreadyExistingDialogContent;
            for (var n = 0; n < alreadyExistingPairs.length; n++) {
                var projectParticipationId = alreadyExistingPairs[n].first;
                var baulosMetaInformationId = alreadyExistingPairs[n].second;

                var participationJoin = null;
                for (var z = 0; z < this.possibleParticipationJoins.length; z++) {
                    if (this.possibleParticipationJoins[z].projectParticipationId == projectParticipationId) {
                        participationJoin = this.possibleParticipationJoins[z];
                    }
                }

                var baulos = null;
                for (var z = 0; z < this.baulosMetaInformations.length; z++) {
                    if (this.baulosMetaInformations[z].metaInformationId == baulosMetaInformationId) {
                        baulos = this.baulosMetaInformations[z];
                    }
                }

                var participationString = participationJoin != null ?
                string.substitute(i18n.projectParticipantNameOrganisationFirstwComment, {
                               organisationName : participationJoin.organisationName,
                                personGivenName : participationJoin.personGivenName,
                                  personSurName : participationJoin.personSurName,
                    projectParticipationComment : (participationJoin.projectParticipationComment!=null && participationJoin.projectParticipationComment.length>0)?" - "+participationJoin.projectParticipationComment:""
                }) : i18n.nothing;
                var baulosString = baulos != null ? baulos.value : i18n.nothing;
                var lineString = null;
                if (position == 1){
                    lineString = string.substitute(i18n.workflowNodeEditAlreadyExistingEntry, {
                        participation : participationString,
                               baulos : baulosString
                    });
                }else{
                    lineString = string.substitute(i18n.workflowNodeEditAlreadyExistingEntryWithoutMeta, {
                        participation : participationString
                    });
                }
                enumerationStrings.push(lineString);            
            }

            var captionLineTable = domConstruct.create("table", null, topDiv);
            var captionLineTableRow = domConstruct.create("tr", null, captionLineTable);

            var warnTD = domConstruct.create("td", null, captionLineTableRow);
            var warnIcon = domConstruct.create("div", null, warnTD);
            domClass.add(warnIcon, "clazzesWarnIcon32");

            DOMHelper.createTextNode("td", header, captionLineTableRow, "");

            var     enumerationNode = DOMHelper.constructEnumeration(enumerationStrings);
            domConstruct.place(enumerationNode, topDiv);        

            var infoDialog = new InfoDialog({
                 defaultWidth : 400,
                defaultHeight : 350, 
                        title : i18n.workflowNodeEditAlreadyExistingDialogCaption,
                      content : topDiv,
                      buttons : [ { type : InfoDialog.Button.OK }
                      ]                               
            });
            on(infoDialog, "confirm", callbackFct);
            infoDialog.show();
        },          

        emitReloadRequested : function() {
            on.emit(this, "reloadRequested");
        },          

        setData : function(params) {
            this.workflowNodeJoin = params.workflowNodeJoin;
            // On server side, these instances also are WorkflowNodeJoins - just with different attributes set
            this.workflowNodePositionJoins = params.workflowNodePositionJoins;
            this.maxPositionPositionJoins = params.maxPositionPositionJoins;
            this.workflowNodePositionIdToBaulose = params.workflowNodePositionIdToBaulose;      
            this.workflowNodePositionIdToInitiatorTokens = params.workflowNodePositionIdToInitiatorTokens;
            this.workflowNodePositionIdToOwnerTokens = params.workflowNodePositionIdToOwnerTokens;
            this.baulosMetaInformations = params.baulosMetaInformations;
            this.projectJoins = params.projectJoins;
            this.workflowInitialized = params.workflowInitialized;
            this.workflowNodeInitiatorPositionIdToHasResults = params.workflowNodeInitiatorPositionIdToHasResults;
            this.initiatorPositionIdToHasFreigabeResults = params.initiatorPositionIdToHasFreigabeResults;            
            this.globalActions = params.globalActions;

            var position = this.workflowNodeJoin.workflowNodeTemplatePosition;
            this.maxNumberOfEntries = (position == 1 ? null : 1); // null means unbounded
            this.fullColumns = (position == 1);                   // true means, add columns for Baulos and deadlines

            if (position == 1) {
                this.widthFraction = 1.0;
                this.height = 200;
                this.expandHeightIfSpaceAvailable = true;               
            } else {
                this.widthFraction = 0.5;
                this.height = 100;
                this.expandHeightIfSpaceAvailable = true;
            }               

            this.listWidget.setData({
                                  workflowNodePositionJoins : this.workflowNodePositionJoins,
                                   maxPositionPositionJoins : this.maxPositionPositionJoins,
                    workflowNodePositionIdToInitiatorTokens : this.workflowNodePositionIdToInitiatorTokens,
                        workflowNodePositionIdToOwnerTokens : this.workflowNodePositionIdToOwnerTokens,
                            workflowNodePositionIdToBaulose : this.workflowNodePositionIdToBaulose,
                workflowNodeInitiatorPositionIdToHasResults : this.workflowNodeInitiatorPositionIdToHasResults,
                    initiatorPositionIdToHasFreigabeResults : this.initiatorPositionIdToHasFreigabeResults,                
                              workflowNodeTemplateMandatory : this.workflowNodeJoin.workflowNodeTemplateMandatory,
                                               projectJoins : this.projectJoins,
                             workflowNodeTemplateRoleTypeId : this.workflowNodeJoin.workflowNodeTemplateRoleTypeId,
                               workflowNodeTemplatePosition : this.workflowNodeJoin.workflowNodeTemplatePosition,
                                     baulosMetaInformations : this.baulosMetaInformations,
                //                              openParticipantChooseDialog : this.openParticipantChooseDialog,
                              showAlreadyExistingInfoDialog : this.showAlreadyExistingInfoDialog,
                    						  globalActions : this.globalActions
            });

            this.reload();
        },

        reload : function() {
            this.updateWidgetsFromData();
            this.updateWidgetState();
        },

        updateWidgetsFromData : function() {
            var position = this.workflowNodeJoin.workflowNodeTemplatePosition;
            /* This would be the long version.
            var caption = string.substitute(i18n.workflowNodeEditCaption, {
                position : position,
                    name : this.workflowNodeJoin.workflowNodeTemplateName               
            });         
            */         
            var caption = this.workflowNodeJoin.workflowNodeTemplateName;
            DOMHelper.setInnerText(this.captionDiv, caption);
        },          

        updateWidgetState : function() {
            if (this.workflowNodeJoin == null || this.workflowNodePositionJoins == null) {
                domClass.replace(this.newButton.domNode, "invisible", "visible");
            } else {
                var multipleAllowed = this.workflowNodeJoin.workflowNodeTemplateHasMultiplePositions || this.showBaulos;
                var addAllowed = multipleAllowed || this.workflowNodePositionJoins.length == 0;
                if (addAllowed) {
                    domClass.replace(this.newButton.domNode, "visible", "invisible");

                    var title = null;
                    var mandatory = this.workflowNodeJoin.workflowNodeTemplateMandatory;
                    if (mandatory) {
                        if (multipleAllowed) {
                            title = i18n.workflowNodeEditMultipleMandatoryTitle;
                        } else {
                            title = i18n.workflowNodeEditSingleMandatoryTitle;
                        }
                    } else {
                        if (multipleAllowed) {
                            title = i18n.workflowNodeEditMultipleTitle;
                        } else {
                            title = i18n.workflowNodeEditSingleTitle;
                        }                           
                    }                       
                    this.newButton.set("title", title);
                } else {
                    domClass.replace(this.newButton.domNode, "invisible", "visible");
                }                   
            }

            this.listWidget.setIsWorkflowInitialized(this.workflowInitialized);         
        },

        getNumberOfEntries : function() {
            return this.workflowNodePositionJoins == null ? 0 : this.workflowNodePositionJoins.length;
        },          

        getWidthFraction : function() {
            // summary:
            //     Returns the fraction of the available horizontal space the widget should occupy      
            return this.widthFraction;
        },

        getHeight : function() {
            // summary:
            //     Returns the height the widget needs to occupy.
            return this.height;
        },

        doExpandHeightIfSpaceAvailable : function() {
            // summary:
            //     Returns wether the widget should occupy vertical space beyond
            //     the space indicated by getHeight, if such space is available.        
            return this.expandHeightIfSpaceAvailable;           
        },          

        place : function(params) {
            domStyle.set(this.topDiv, "left", params.x + "px");
            domStyle.set(this.topDiv, "top", params.y + "px");          
            domStyle.set(this.topDiv, "width", params.width + "px");
            domStyle.set(this.topDiv, "height", params.height + "px");          
            this.listWidget.resize({ w : params.width, h : params.height - 40 });
        },          

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    WorkflowNodeEditWidget.AsyncOperation = {
        GET_PROJECT_PARTICIPATIONS : "GetProjectParticipations",
        SAVE_NEW_POSITIONS : "SaveNewPositions"/*,
        REPLACE_POSITION :  "ReplacePosition"*/
    };

    return WorkflowNodeEditWidget;
});
