/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationReportData
////i18n-prefix = planningNotificationReportData



define([
    "cdes/core/CdesVoc",
    "cdes/planning/report/PlanningNotificationReportListWidget",
    "cdes/planning/report/PlanningNotificationReportSearchWidget",
    "cdes/planning/report/PlanningNotificationReportStepWidget",
    "cdes/planning/util/PlanningNotificationHelper",
    "cdes/util/ColumnHelper",
    "clazzes/TinyLog",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "dijit/form/Button",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    CdesVoc,
    PlanningNotificationReportListWidget,
    PlanningNotificationReportSearchWidget,
    PlanningNotificationReportStepWidget,
    PlanningNotificationHelper,
    ColumnHelper,
    TinyLog,
    topic,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    Button,
    domClass,                

    domConstruct,
    domStyle,
    on,
    string,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.report.PlanningNotificationReportDataWidget";

    var log = new TinyLog(className);

    var PlanningNotificationReportDataWidget = declare(className, PlanningNotificationReportStepWidget, {

        constructor : function(params) {
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationReportDataTopDiv");

            return topDiv;
        },

        initialize : function() {
            // Search Widget
            this.searchWidget = new PlanningNotificationReportSearchWidget({
                applicationContext : this.applicationContext
            });

            this.reloadSearchInfo();

            this.searchWidgetDiv = this.searchWidget.getContainer();
            domConstruct.place(this.searchWidgetDiv, this.topDiv);
            on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));               
            on(this.searchWidget, "doSearch", lang.hitch(this, function() {
                this.reload(),
                this.adaptPlanningNotificationSearchModelInLocalStorage();
            }));            
            on(this.searchWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));

            // List Widget
            this.listWidget = new PlanningNotificationReportListWidget({
                applicationContext : this.applicationContext,
                       showActions : true                 
            });

            this.listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(this.listWidgetDiv, this.topDiv);
        },

        processNetworkChange : function() {
            this.reloadSearchInfo();                
        },              

        reloadSearchInfo : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();

            var firstCall = this.lastSearchInfoReloadNetworkId == null;
            if (this.lastSearchInfoReloadNetworkId != networkId) {
                this.lastSearchInfoReloadNetworkId = networkId;                

                if (this.getSearchInfoRequest != null) {
                    this.getSearchInfoRequest.cancel();
                }                   

                this.registerAsyncOperationStarted(PlanningNotificationReportDataWidget.AsyncOperation.LOAD_SEARCH_INFO);
                var planningNotificationService = this.applicationContext.getService("planningNotificationService");
                this.getSearchInfoRequest = planningNotificationService.getPlanningNotificationReportSearchInfo(organisationPersonId, networkId).then(
                    lang.hitch(this, function(searchInfo) {             
                        delete this.getSearchInfoRequest;
                        this.registerAsyncOperationFinished(PlanningNotificationReportDataWidget.AsyncOperation.LOAD_SEARCH_INFO);

                        var metaTags = searchInfo.metaTags;
                        if (metaTags != null) {
                            metaTags.sort(function(metaTagOne, metaTagTwo) {
                                return (metaTagOne.position != null ? metaTagOne.position : 0) - (metaTagTwo.position != null ? metaTagTwo.position : 0);
                            });
                        }                       

                        this.searchWidget.initialize(metaTags, searchInfo, firstCall);
                        this.listWidget.initialize(metaTags);

                        var defaultColumnSettings = ColumnHelper.getDefaultColumnSettings(this.applicationContext, this, null, "planningNotificationReport/columns");
                        this.searchWidget.setData(this.config);

                        this.projectIdToActions = searchInfo.projectIdToAllowedActions;

                        this.reload();              
                    }),
                    lang.hitch(this, function(err) {
                        // Don't do error processing if this is an explicit cancel, since the user chose to leave the page
                        if (!this.cancellingGetSearchInfoRequest) {
                            delete this.getSearchInfoRequest;
                            ErrorHelper.processAsyncError({
                                           err : err,
                                        widget : this,
                                asyncOperation : PlanningNotificationReportDataWidget.AsyncOperation.LOAD_SEARCH_INFO,
                                        opName : "getPlanningNotificationSearchInfo",
                                       message : i18n.planningNotificationPageGetPlanningNotificationSearchInfoFailed
                            });
                        }                                    
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [getPlanningNotificationSearchInfo]", err);
                            delete this.getSearchInfoRequest;
                        }));
            }                
        },

        getWidgetId : function() {
            return "PlanningNotificationReportDataWidget";
        },

        getPageCaption : function() {
            return i18n.planningNotificationReportDataPageCaption;
        },              

        getStepForwardCaption : function() {
            return i18n.planningNotificationReportDoGenerateCaption;
        },

        getStepForwardToolTip : function() {
            return i18n.planningNotificationReportDoGenerateToolTip;
        },                          

        getCustomButtons : function() {
            this.exportToMspButton = new Button({
                label : i18n.planningNotificationReportDataMspButtonCaption,
                title : i18n.planningNotificationReportDataMspButtonToolTip
            });
            domClass.add(this.exportToMspButton.domNode, "planningNotificationReportDataMspButton hidden");
            on(this.exportToMspButton, "click", lang.hitch(this, function() {
                this.triggerExportReport(true);
            }));               

            return [ this.exportToMspButton ];
        },

        stepBackwardHandler : function() {
            if (this.getSearchInfoRequest != null) {
                this.cancellingGetSearchInfoRequest = true;
                this.getSearchInfoRequest.cancel();
                delete this.cancellingGetSearchInfoRequest;
            }                   

            if (this.searchRequest != null) {
                this.cancellingSearchRequest = true;
                this.searchRequest.cancel();
                delete this.cancellingSearchRequest;
                topic.publish("message/info", i18n.searchCancelled);
            }                       
        },              

        performStepForward : function(stepWidgets) {
            this.triggerExportReport(false);
        },            

        triggerExportReport : function(askForMsp) {
            var columnToWidth = new Object();
            var columns = this.listWidget.grid.get("columns");
            for (var n = 0; n < columns.length; n++) {
                var column = columns[n];
                if (!column.hidden) {
                    columnToWidth[column.id] = (column.headerNode != null ? column.headerNode.clientWidth : null);
                }                   
            }               

            this.storeConfigToLocalStorage();
            this.adaptPlanningNotificationSearchModelInLocalStorage();            
            return PlanningNotificationHelper.triggerExportReport(this.applicationContext, this, this.config, columnToWidth, this.listWidget.getSortSpecs(), askForMsp);
        },

        adaptPlanningNotificationSearchModelInLocalStorage : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var notificationSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotification/search");
            var orderSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search");

            if (notificationSearchModel == null) {
                notificationSearchModel = new Object();
            }
            if (orderSearchModel == null) {
                orderSearchModel = new Object();
            }

            notificationSearchModel.planningNotificationEntries = this.config.data.notificationSearchModel.planningNotificationEntries;
            notificationSearchModel.comment = this.config.data.notificationSearchModel.comment;
            notificationSearchModel.networkId = this.config.data.notificationSearchModel.networkId;
            notificationSearchModel.projectId = this.config.data.notificationSearchModel.projectId;
            notificationSearchModel.textMetaTagIdToValue = this.config.data.notificationSearchModel.textMetaTagIdToValue;
            notificationSearchModel.dateMetaTagIdToFrom = this.config.data.notificationSearchModel.dateMetaTagIdToFrom;
            notificationSearchModel.dateMetaTagIdToTo = this.config.data.notificationSearchModel.dateMetaTagIdToTo;

            orderSearchModel.planningNotificationEntries = this.config.data.notificationSearchModel.planningNotificationEntries;
            orderSearchModel.serialNumber = this.config.data.orderSearchModel.serialNumber;
            orderSearchModel.subjectAreaName = this.config.data.orderSearchModel.subjectAreaName;
            orderSearchModel.invalidated = this.config.data.orderSearchModel.invalidated;
            orderSearchModel.state = this.config.data.orderSearchModel.state;
            orderSearchModel.reference = this.config.data.orderSearchModel.reference;
            orderSearchModel.statutoryDutyId = this.config.data.orderSearchModel.statutoryDutyId;
            orderSearchModel.text = this.config.data.orderSearchModel.text;
            orderSearchModel.authorizedInspector = this.config.data.orderSearchModel.authorizedInspector;
            orderSearchModel.statutoryDutyFromFrom = this.config.data.orderSearchModel.statutoryDutyFromFrom;
            orderSearchModel.statutoryDutyFromTo = this.config.data.orderSearchModel.statutoryDutyFromTo;
            orderSearchModel.statutoryDutyToFrom = this.config.data.orderSearchModel.statutoryDutyToFrom;
            orderSearchModel.statutoryDutyToTo = this.config.data.orderSearchModel.statutoryDutyToTo;
            orderSearchModel.statutoryDutyInterval = this.config.data.orderSearchModel.statutoryDutyInterval;
            orderSearchModel.statutoryDutyLeadTime = this.config.data.orderSearchModel.statutoryDutyLeadTime;
            orderSearchModel.statutoryDutyExpired = this.config.data.orderSearchModel.statutoryDutyExpired;
            orderSearchModel.documentPage = this.config.data.orderSearchModel.documentPage;
            orderSearchModel.documentPosition = this.config.data.orderSearchModel.documentPosition;         
            orderSearchModel.source = this.config.data.orderSearchModel.source;
            orderSearchModel.personInChargeId = this.config.data.orderSearchModel.personInChargeId;
            orderSearchModel.tags =  this.config.data.orderSearchModel.tags;
            orderSearchModel.environmentallyRelevant = this.config.data.orderSearchModel.environmentallyRelevant;           
            orderSearchModel.submitAuthority = this.config.data.orderSearchModel.submitAuthority;
            orderSearchModel.comment = this.config.data.orderSearchModel.comment;

            this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/search", notificationSearchModel);
            this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search", orderSearchModel);          
        },              

        getColumnSettings : function() {
            return this.searchWidget.getColumnSettings();
        },              

        setData : function(config) {
            this.config = config;
            this.searchWidget.setData(this.config);

            this.reload();
        },

        reload : function() {
            // Ensure that column widths stay constant
//            this.listWidget.handleColumnResize();

            this.listWidget.setData({ reportInfos : [] });

            this.updateWidgetState();

            if (this.searchWidget.isAlreadyInitialized()) {
                this.reloadData();
            }
        },

        reloadData : function() {
            this.storeConfigToLocalStorage();
            var notificationSearchModel = this.getPlanningNotificationSearchModel();
            var orderSearchModel = this.getPlanningNotificationOrderSearchModel();
            var reviewSearchModel = this.getPlanningNotificationReviewSearchModel();

            if (this.searchRequest != null) {
                this.searchRequest.cancel();
            }               

            topic.publish("message/info", i18n.searchRuns);

            PlanningNotificationHelper.convertSearchModelPlanningNotificationEntriesForServer(notificationSearchModel);

            this.registerAsyncOperationStarted(PlanningNotificationReportDataWidget.AsyncOperation.LOAD_DATA);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.searchRequest = planningNotificationService.getPlanningNotificationReportJoins(notificationSearchModel, orderSearchModel, reviewSearchModel, null).then(
                lang.hitch(this, function(reportInfos) {
                    this.registerAsyncOperationFinished(PlanningNotificationReportDataWidget.AsyncOperation.LOAD_DATA);

                    delete this.searchRequest;

                    // Transform from List to Set, for easier handling lateron.
                    // TODO: Note: Maybe not necessary here, as we probably have no actions in this table
                    for (var n = 0; n < reportInfos.length; n++) {
                        var reportInfo = reportInfos[n];
                        var allowedProjectActionsList = reportInfo.allowedProjectActions;
                        var allowedProjectActionsSet = new Object();
                        for (var v = 0; v < allowedProjectActionsList.length; v++) {
                            allowedProjectActionsSet[allowedProjectActionsList[v]] = true;
                        }

                        reportInfo.allowedProjectActions = allowedProjectActionsSet;
                    }                           

                    // TODO                    
                    // var columnSettings = ColumnHelper.getColumnSettingsForReload(this, searchModel);


                    this.listWidget.setData({ 
                           reportInfos : reportInfos,
                        columnSettings : this.config.data.columnSettings
                    });

                    // TODO Maybe improve feedback message
                    var message = string.substitute(i18n.planningNotificationOrderSearchSuccessful, {
                        count : reportInfos.length
                    });

                    // Ensure that column widths stay constant
//                    this.listWidget.restoreColumnWidths();

                    topic.publish("message/ok", message);                   
                }),
                lang.hitch(this, function(err) {
                    // Don't do error processing if this is an explicit cancel, since the user chose to leave the page
                    if (!this.cancellingSearchRequest) {
                        delete this.searchRequest;
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : PlanningNotificationReportDataWidget.AsyncOperation.LOAD_DATA,
                                    opName : "getPlanningNotificationReportJoins",
                            // TODO: Maybe improve feedback message
                                   message : i18n.planningNotificationSearchGetPlanningNotificationJoinsFailed
                        });
                    }                       
                    // Ensure that column widths stay constant
//                    this.listWidget.restoreColumnWidths();
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPlanningNotificationReportJoins]", err);
                        delete this.searchRequest;                  
                    }));        
        },            

        updateWidgetsFromData : function() {
            this.searchWidget.updateWidgetsFromData();
        },

        updateDataFromWidgets : function() {
            this.searchWidget.updateDataFromWidgets();
        },              

        updateWidgetState : function() {
            var mayStepForward = true;

            if (mayStepForward != this.mayStepForward) {
                this.mayStepForward = mayStepForward;
                on.emit(this, "mayStepChanged");
            }

            var anyProjectHasAction = false;
            if (this.projectIdToActions != null) {
                for (var projectId in this.projectIdToActions) {
                    var actions = this.projectIdToActions[projectId];
                    if (actions != null) {
                        for (var n = 0; n < actions.length; n++) {
                            anyProjectHasAction |= (actions[n] == "exportPlanningNotificationReportMSP");
                        }                                    
                    }                                
                }
            }

            if (this.exportToMspButton != null) {
                if (anyProjectHasAction) {
                    domClass.remove(this.exportToMspButton.domNode, "hidden");
                } else {
                    domClass.add(this.exportToMspButton.domNode, "hidden");
                }                                            
            }

            this.searchWidget.setDisabled(this.isAsyncOperationRunning());
        },

        getPlanningNotificationSearchModel : function() {
            return PlanningNotificationHelper.getPlanningNotificationSearchModel(this.searchWidget);
        },

        getPlanningNotificationOrderSearchModel : function() {
            var searchModel = PlanningNotificationHelper.getPlanningNotificationOrderSearchModel(this.searchWidget);

            // These two are handled via PlanningNotificationSearchModel above.
            searchModel.planningNotificationEntries = null;
            searchModel.projectId = null;

            searchModel.subjectAreaId = searchModel.subjectAreaId != CdesVoc.MagicSelectOption.ALL
                                      ? searchModel.subjectAreaId : null;

            return searchModel;
        },              

        getPlanningNotificationReviewSearchModel : function() {
            return PlanningNotificationHelper.getPlanningNotificationReviewSearchModel(this.searchWidget);
        },


        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;                   

            var tableHeight = totalHeight
            - this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
            - 16;

            // If the search widget is higher than the available space, then the tableHeight calculated here becomes negative.
            // In this case, we don't want to show the table, but this should be done using size zero, not using negative size.        
            this.listWidget.resize({ h : Math.max(tableHeight, 0) });

            // If the search widget is higher than the available space, we need to increase the height of the topDiv.  This triggers
            // a scrollbar, and thus makes the whole search widget accessible.        
            var topDivHeight = Math.max(totalHeight, this.searchWidgetDiv.offsetHeight);
            domStyle.set(this.topDiv, "height", topDivHeight + "px");
        },

        getAutomaticColumnSettings : function(searchModel) {
            return {
                                showTitle : true,
                  showNotificationComment : false,
                              showProject : true,
                         showSerialNumber : true,
                                 showText : true,
                        showStatutoryDuty : true,
                          showInvalidated : false,
                         showWorkflowNode : true,
                                showState : true,
                         showDocumentPage : false,
                     showDocumentPosition : false,
                               showSource : false,
                       showPersonInCharge : false,
                    showStatutoryDutyFrom : false,
                      showStatutoryDutyTo : false,
                showStatutoryDutyInterval : false,
                showStatutoryDutyLeadTime : false,
                             showSiteType : false,
                 showStatutoryDutyExpired : false,
                      showSubmitAuthority : false,
                                  showTag : false,
                         showOrderComment : false
            };              
        },

        processColumnsChanged : function(columnId) {
            var columnSettings = this.config.data.columnSettings;
            this.listWidget.setColumns(columnSettings, columnId);
            this.manualColumns = true;
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    PlanningNotificationReportDataWidget.AsyncOperation = {
        LOAD_SEARCH_INFO : "LoadSearchInfo",
        LOAD_DATA : "LoadData"        
    };

    PlanningNotificationReportDataWidget.getDefaultConfig = function() {
        return {
			notificationSearchModel : {
			},
			orderSearchModel : {
			},
			columnSettings : {
				showTitle : true,
				showNotificationComment : false,
				showProject : true,
				showSerialNumber : true,
				showText : true,
				showSubjectArea : false,
				showAuthorizedInspector : false,
				showStatutoryDuty : true,
				showInvalidated : true,
				showState : false,
				showReference : false,
				showStatutoryDutyFrom : false,
				showDocumentPage : false,
				showDocumentPosition : false,
				showSource : false,
				showStatutoryDutyTo : false,
				showPersonInCharge : false,
				showStatutoryDutyInterval : false,
				showStatutoryDutyLeadTime : false,
				showSiteType : false,
				showTag : false,
				showStatutoryDutyExpired : false,
				showSubmitAuthority : false,
				showOrderComment : false,
				showWorkflowNode : true,
				
				showWorkflowNodeName : true,
				showReviewBaulos : true,
				showTokenInitiator : true,
				showReviewer : true,
				showIssued : true,
				showReviewComment : true,
				showResult : true,
				showAttachment : true,
				
				metaTagIdToShow : new Object()                   
			}
        };          
    };

    return PlanningNotificationReportDataWidget;
});
