/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/plot/PlotOrderItemListWidget",
    "cdes/widget/AddressShowWidget",
    "cdes/widget/ContextBar",
    "clazzes/TinyLog",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dijit/form/Textarea",
    "dijit/form/ValidationTextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/keys",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    PlotOrderItemListWidget,
    AddressShowWidget,
    ContextBar,
    TinyLog,
    topic,    
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    Button,
    Textarea,
    ValidationTextBox,
    domClass,
    domConstruct,
    domStyle,
    Keys,
    on,    
    string,    
    declare,
    lang,
    i18n
) {

    var className = "at.cdes.web.plot.PlotOrderSignPage";

    var log = new TinyLog(className);

    var PlotOrderSignPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var serviceParams = {
                plotOrderTemplateId : this.plotOrderTemplateId,
                 withValidReceivers : true                
            };                

            var plotService = this.applicationContext.getService("plotService");
    	    this.registerAsyncOperationStarted(PlotOrderSignPage.AsyncOperation.LOAD);
            plotService.getCreateManualPlotOrderData(organisationPersonId, this.documentVersionId, serviceParams).then(
                lang.hitch(this, function(createPlotOrderData) {
                    this.initialize(createPlotOrderData);
    	            this.registerAsyncOperationFinished(PlotOrderSignPage.AsyncOperation.LOAD);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlotOrderSignPage.AsyncOperation.LOAD,
                                opName : "getCreateManualPlotOrderData",
                               message : i18n.plotOrderTemplateChooseLoadFailed
                    });
                })
            ).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Error while calling function [getCreateManualPlotOrderData]", err);
                }));

        },

        getWidgetId : function() {
            return "PlotOrderSignPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        initialize : function(createPlotOrderData) {
            this.document = createPlotOrderData.document;
            this.documentRelease = createPlotOrderData.documentRelease;
            this.templateJoin = createPlotOrderData.templateJoins[0];
            this.itemJoins = createPlotOrderData.templateIdToItemJoins[this.templateJoin.plottOrderTemplateId];
            this.validReceivers = createPlotOrderData.validReceivers;            

            var caption = string.substitute(i18n.plotOrderSignPageCaption, {
                   documentName : this.document.name,
                documentContent : this.documentRelease!=null?this.documentRelease.content:this.document.content
            });
            DOMHelper.setInnerText(this.captionDiv, caption);

    	    this.billingAddressWidget.setData(this.templateJoin);
    	    this.plotterAddressWidget.setData(this.templateJoin);

            this.listWidget.setData({
                             itemJoins : this.itemJoins,
                        validReceivers : this.validReceivers,
                editablePlotProperties : createPlotOrderData.editablePlotProperties
            });                

            var kindOfDeliveryLabel = string.substitute(i18n.plotOrderSignDeliveryKindOfDeliveryLabel, {
                kindOfDelivery : this.templateJoin.plottOrderTemplateKindOfDelivery
            });
            DOMHelper.setInnerText(this.kindOfDeliveryDiv, kindOfDeliveryLabel);            

            this.resize(this.lastResizeParameter);
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesSmallPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h3", "", captionBarDiv, "cdesGeneralPageCaption");

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentParentDiv = domConstruct.create("div", null, null);
            domClass.add(contentParentDiv, "refNodeOfPositionAbsolute plotOrderSignPageContentParentDiv");

            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute plotOrderSignPageContentDiv");
            domConstruct.place(contentDiv, contentParentDiv);            

            // Billing address
            this.billingAddressWidget = new AddressShowWidget({
                   applicationContext : this.applicationContext,
    			 nameProperty : "billingAddressOrganisationName",
    		postalAddressProperty : "billingAddressPostalAddress",
    		   postalCodeProperty : "billingAddressPostalCode",
    		 localityNameProperty : "billingAddressLocalityName",
    		      countryProperty : "billingCountryDescDe"                
            });
            this.billingAddressDiv = this.billingAddressWidget.getContainer();
            domClass.add(this.billingAddressDiv, "plotOrderSignBillingAddressDiv");
            domConstruct.place(this.billingAddressDiv, contentDiv);

            // Plotter address
            this.plotterAddressWidget = new AddressShowWidget({
                   applicationContext : this.applicationContext,
			 nameProperty : "plotterOrganisationName",
		postalAddressProperty : "plotterOrganisationPostalAddress",
		   postalCodeProperty : "plotterOrganisationPostalCode",
		 localityNameProperty : "plotterOrganisationLocalityName",
		      countryProperty : "plotterCountryDescDe"                
            });
            this.plotterAddressDiv = this.plotterAddressWidget.getContainer();
            domClass.add(this.plotterAddressDiv, "plotOrderSignPlotterAddressDiv");
            domConstruct.place(this.plotterAddressDiv, contentDiv);            
            
            // Project
            var project = this.applicationContext.getPageContextProject();
            var projectLabel = string.substitute(i18n.plotOrderEditProjectLabel, {
                projectCode : project.code,
                projectName : project.name                
            });
            this.projectDiv = domConstruct.create("div", null, null);
            DOMHelper.setInnerText(this.projectDiv, projectLabel);
            domClass.add(this.projectDiv, "plotOrderSignProjectDiv");
            domConstruct.place(this.projectDiv, contentDiv);

    	    // List Widget
    	    this.listWidget = new PlotOrderItemListWidget({
    		applicationContext : this.applicationContext,
                  showPaperQuality : true,
                         showColor : true,
                        showMargin : true,
                        showMirror : true,
                         showScale : true,
                         showCount : true,
                          showArea : false,
                      showReceiver : true                
    	    });
    	    this.listWidgetDiv = this.listWidget.getContainer();
    	    domConstruct.place(this.listWidgetDiv, contentDiv);
            on(this.listWidget, "validStateChanged", lang.hitch(this, this.updateWidgetState));
            
            this.listWidget.restoreColumnWidths();

            // Delivery address, delivery date, kind of delivery
            this.deliveryAddressDiv = DOMHelper.createTextNode("div", i18n.plotOrderSignDeliveryAddressLabel, contentDiv, "plotOrderSignDeliveryAddressDiv");
            this.deliveryDateDiv = DOMHelper.createTextNode("div", i18n.plotOrderSignDeliveryDateLabel, contentDiv, "plotOrderSignDeliveryDateDiv");
            this.kindOfDeliveryDiv = DOMHelper.createTextNode("div", "", contentDiv, "plotOrderSignKindOfDeliveryDiv");

            // Additional information
            this.additionalInfoLabel = DOMHelper.createTextNode("div", i18n.plotOrderSignAdditionalInformationLabel, contentDiv, "plotOrderSignAdditionalInfoLabel");
            this.additionalInfoTextArea = new Textarea({
                label : i18n.plotOrderSignAdditionalInformationLabel
            });
            domClass.add(this.additionalInfoTextArea.domNode, "plotOrderSignAdditionalInfoTextArea");
            domConstruct.place(this.additionalInfoTextArea.domNode, contentDiv);            

            // Button div
            this.buttonDiv = domConstruct.create("div", null, null);
            domClass.add(this.buttonDiv, "plotOrderSignButtonDiv");
            domConstruct.place(this.buttonDiv, contentDiv);

            // Abort button
    	    this.abortButton = new Button({
    		  label : i18n.abortButtonCaption,
    		  title : i18n.abortButtonCaption,
    		onClick : lang.hitch(this, this.doAbort) 
    	    });
    	    domClass.add(this.abortButton.domNode, "plotOrderSignAbortButton");
    	    domConstruct.place(this.abortButton.domNode, contentDiv);

            // Password
            DOMHelper.createTextNode("span", i18n.passwordLabel, contentDiv, "plotOrderSignPasswordLabel");
    	    this.passwordTextBox = new ValidationTextBox({
    		   label : i18n.passwordLabel,
    		   title : i18n.passwordLabel,
    		    type : "password",
    		tabIndex : 1
    	    });
    	    domClass.add(this.passwordTextBox.domNode, "plotOrderSignPasswordTextBox");
    	    domConstruct.place(this.passwordTextBox.domNode, contentDiv);
            WidgetHelper.setMustField(this.passwordTextBox, true);
            WidgetHelper.handleTextBoxEvents(this.passwordTextBox, lang.hitch(this, this.updateWidgetState));            
     	    on(this.passwordTextBox.domNode, "keyup", lang.hitch(this, this.proceedIfEnter));

            // Listen to input event, in order to get notified once the browser fills in the password automatically.            
            on(this.passwordTextBox.domNode, "input", lang.hitch(this, this.updateWidgetState));            


            // Sign button
    	    this.signButton = new Button({
    		  label : i18n.signButtonCaption,
    		  title : i18n.signButtonCaption,
    		onClick : lang.hitch(this, this.doSign) 
    	    });
    	    domClass.add(this.signButton.domNode, "plotOrderSignAbortButton");
    	    domConstruct.place(this.signButton.domNode, contentDiv);

            return contentDiv;
        },

        doAbort : function() {
            if (this.backPage != null) {
     		this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
            }                                
        },

        resize : function(newSize) {
            this.lastResizeParameter = newSize;

            var totalHeight = newSize.h;

            var width = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                - this.captionBarDiv.offsetHeight
                - 20 // top of contentDiv            
                - 16;

            // We need to resize to the desired width first, in order to be able to determine the needed height correctly
            this.listWidget.resize({ w : width });
            var listWidgetHeight = this.listWidget.getActualHeight();
            this.listWidget.resize({ w : width, h : listWidgetHeight });
            domStyle.set(this.additionalInfoTextArea.domNode, "width", (Math.min(width, 700)) + "px");

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
        },

        setData : function() {

        },

        reload : function() {
            //this.contextBar.reload();
        },

        updateWidgetState : function() {
            WidgetHelper.updateEmptyTextBoxState(this.passwordTextBox);

            var allFieldsValid = WidgetHelper.isTextBoxValid(this.passwordTextBox) && this.listWidget.isValid();

            this.signButton.set("disabled", !allFieldsValid);            
        },

        goBack : function() {
            this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
        },

     	proceedIfEnter : function(e) {
 	    if (e.keyCode == Keys.ENTER) {
 		this.doSign();
 	    }
     	},

        doSign : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var comment = this.additionalInfoTextArea.get("value");
            var password = this.passwordTextBox.get("value");
            var signInfos = this.listWidget.getSignInfos();            

            var plotService = this.applicationContext.getService("plotService");
    	    this.registerAsyncOperationStarted(PlotOrderSignPage.AsyncOperation.SIGN);
            plotService.signPlotOrders(organisationPersonId, this.documentVersionId, comment, password, signInfos).then(
                lang.hitch(this, function() {
    	            this.registerAsyncOperationFinished(PlotOrderSignPage.AsyncOperation.SIGN);
                    topic.publish("message/ok", i18n.plotOrderSignSignSuccessful);
                    this.applicationContext.setPage("documentList", new Object(), new Object());
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlotOrderSignPage.AsyncOperation.SIGN,
                                opName : "signPlotOrders",
                               message : i18n.plotOrderSignSignFailed
                    });
                })
            ).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Error while calling function [signPlotOrders]", err);
                }));
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    PlotOrderSignPage.AsyncOperation = {
        LOAD : "Load",
        SIGN : "Sign"        
    };

    return PlotOrderSignPage;
});
