/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/string"
], function(
    ListWidget,
    TinyLog,
    DOMHelper,
    domClass,
    domConstruct,
    domStyle,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.review.ReviewProtocolOebbCommentListWidget";

    var log = new TinyLog(className);

    var ReviewProtocolOebbCommentListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolOebbCommentListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "reviewProtocolOebbCommentList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

	    columns.push({
		   field : "oebbCommentReviewer",
		      id : "reviewer",
		sortable : true,
  		   label : i18n.reviewProtocolOebbCommentReviewerCaption
	    });

	    columns.push({
		   field : "oebbCommentRealm",
		      id : "realm",
		sortable : true,
		   label : i18n.reviewProtocolOebbCommentRealmCaption
	    });

	    columns.push({
		   field : "oebbCommentComment",
		      id : "review",
		sortable : true,
		   label : i18n.reviewProtocolOebbCommentCommentCaption
	    });

	    columns.push({
		     field : "_result",
		        id : "result",
                renderCell : lang.hitch(this, this.renderResult),                
		  sortable : true,
		     label : i18n.reviewProtocolOebbCommentResultCaption
	    });

            return columns;            
        },

        getResult : function(oebbCommentJoin) {
            var result = oebbCommentJoin.oebbCommentResult;
            if (result == null) {
                return i18n.reviewProtocolOebbCommentNoResultLabel;
            } else if (result.toLowerCase() == "n") {
                return i18n.reviewProtocolOebbCommentNegativeResultLabel;
            } else if (result.toLowerCase() == "y") {
                return i18n.reviewProtocolOebbCommentPositiveResultLabel;
            } else {
                return result;
            }                
        },

        renderResult : function(oebbCommentJoin, data, cell) {
            var resultLabel = this.getResult(oebbCommentJoin);
            var result = oebbCommentJoin.oebbCommentResult;
            if (result != null && result.toLowerCase() == "n") {
                domClass.add(cell, "reviewProtocolNegativeReview");
            }                

            var cellDiv = domConstruct.create("div", null, null);
            DOMHelper.createTextNode("span", resultLabel, cellDiv, null);
            return cellDiv;            
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            this.captionDiv = DOMHelper.createTextNode("div", "", topDiv, "reviewProtocolOebbCommentCaption");

	    var grid = this.constructGrid({
		idProperty : "_id", 
		    gridId : "ReviewProtocolOebbCommentGrid",
                 gridClass : "Grid"
	    });
            /*            
	    on(grid, "dgrid-sort", lang.hitch(this, function(e) {
		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		var networkId = this.applicationContext.getPageContextPnNetworkId();
		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
	    }));
            */
            domConstruct.place(grid, topDiv);

            return topDiv;
        },

        setData : function(params) {
            this.nodeResultJoin = params.nodeResultJoin;
            this.reviewContext = params.reviewContext;

            this.reload();
        },

        reload : function() {
            var nodeResultId = this.nodeResultJoin.reviewCycleNodeResultId;
            this.oebbCommentJoins = this.reviewContext.getOebbComments(nodeResultId);
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(this.nodeResultJoin.reviewCycleNodeName, locale);

            var caption = string.substitute(i18n.reviewProtocolOebbCommentCaption, {
                nodeName : reviewCycleNodeName
            });
            DOMHelper.setInnerText(this.captionDiv, caption);

            this.updateAuxiliaryData();
            this.setStoreData(this.oebbCommentJoins);
            this.grid.resize();
        },

	updateAuxiliaryData : function() {
            for (var n = 0; n < this.oebbCommentJoins.length; n++) {
                var oebbCommentJoin = this.oebbCommentJoins[n];
                oebbCommentJoin._result = this.getResult(oebbCommentJoin);
            }                
	},

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            var width = newSize.w + 0.01;
            var height = this.getActualHeight();
            this.grid.resize({ w : width, h : height });
        },

        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });

    ReviewProtocolOebbCommentListWidget.AsyncOperation = {
        DELETE : "Delete"
    };        

    return ReviewProtocolOebbCommentListWidget;
});
