/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

//// css-prefix = projectParticipantChoose
//// i18n-prefix = projectParticipantChoose

define([ "cdes/widget/base/ListWidget",
	 "clazzes/TinyLog",
	 "dojo/dom-class",
	 "dojo/dom-construct",
	 "dojo/on",
	 "dojo/string",
	 "dojo/_base/declare",
	 "dojo/_base/lang",
	 "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
       function(ListWidget,
		TinyLog,
		domClass,
		domConstruct,
		on,
		string,
		declare,
		lang,
		i18n) {

    var className = "at.cdes.web.widget.project.ProjectParticipantChooseWidget";

    var log = new TinyLog(className);

    var ProjectParticipantChooseWidget = declare(className, ListWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.topDiv = this.constructTopDiv();

	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "ProjectParticipantChooseWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructColumns : function() {
	    var columns = [];

            // ProjectParticipant
            columns.push({
                     field : "_projectParticipant",
                        id : "projectParticipant",
                 formatter : lang.hitch(this, this.projectParticipantFormatter),
                  sortable : true,
                     label : this.columnCaption
             });     

            // Comment
//            columns.push({
//                     field : "projectParticipationComment",
//                        id : "projectParticipationComment",
//                  sortable : true,
//                     label : i18n.comment
//             });     

	    return columns;
	},

        projectParticipantFormatter : function(_projectParticipant, join) {
            return string.substitute(i18n.projectParticipantNameOrganisationFirstwComment, {
                organisationName : join.organisationName,
                 personGivenName : join.personGivenName,
                   personSurName : join.personSurName,
   	 projectParticipationComment : (join.projectParticipationComment != null && join.projectParticipationComment.length>0)?" - "+join.projectParticipationComment:""
            });     
        },

	constructTopDiv : function() {
	    // See https://github.com/SitePen/dgrid/blob/master/doc/components/mixins/Selection.md for selection modes

            var grid = this.constructGrid({
		   idProperty : "projectParticipantId", 
            	       gridId : "ProjectParticipantChooseGrid",
		selectionMode : this.selectionMode
            });

    	    on(grid, "dgrid-select", lang.hitch(this, this.emitSelectionChanged));
    	    on(grid, "dgrid-deselect", lang.hitch(this, this.emitSelectionChanged));

	    return grid;	    
	},

        emitSelectionChanged : function() {
            on.emit(this, "selectionChanged", this.getSelectedItems());
        },

	resize : function(newSize) {
	    this.grid.resize(newSize);
	},

	setData : function(params) {
	    this.participationJoins = params.participationJoins;

	    this.updateAuxiliaryData();

	    this.reload();
	},

	updateAuxiliaryData : function() {
	    for (var n = 0; n < this.participationJoins.length; n++) {
		var participationJoin = this.participationJoins[n];
		this.updateAuxiliaryDataForJoinDto(participationJoin);
	    }
	},

	updateAuxiliaryDataForJoinDto : function(participationJoin) {
	    participationJoin._projectParticipant = this.projectParticipantFormatter(null, participationJoin);
	},

	reload : function(params) {

	    this.store.setData(this.participationJoins);

	    this.grid.set("sort", "_projectParticipant", false);
	    this.grid.updateSortArrow(this.grid.sort);
	    this.grid.refresh();
	},

	destroy : function() {
	    this.inherited(arguments);

	    this.grid.destroy();
	}
    });

    ProjectParticipantChooseWidget.AsyncOperation = {

    };

    return ProjectParticipantChooseWidget;
});
