define([
    "cdes/certificate/CertificateCreateWidget",
    "cdes/certificate/SetUserPolicyWidget",
    "cdes/certificate/CertificateHelper",
    "cdes/certificate/CertificateInviteChooseDialog",
    "cdes/certificate/CertificateRequestShowWidget",
    "cdes/certificate/RenewCertificateDialog",
    "cdes/util/ActionHelper",
    "cdes/util/JoinHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/util/DataHelper",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/StringHelper",
    "clazzes/widgets/DisableButton",
    "clazzes/widgets/layout/ChooseDialog",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/Editor",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dgrid/util/misc",
    "dojo/aspect",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/has",
    "dojo/on",
    "dojo/string",
    "dojo/topic",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
    CertificateCreateWidget,
    SetUserPolicyWidget,
    CertificateHelper,
    CertificateInviteChooseDialog,
    CertificateRequestShowWidget,
    RenewCertificateDialog,
    ActionHelper,
    JoinHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    DataHelper,
    DOMHelper,
    ErrorHelper,
    StringHelper,
    DisableButton,
    ChooseDialog,
    ContentWidget,
    InfoDialog,
    Editor,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    dgridMiscUtil,
    aspect,
    domClass,
    domConstruct,
    has,
    on,
    string,
    topic,
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.certificate.CertificateListWidget";

    var log = new TinyLog(className);

    var CertificateListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this,params);

            this.networkIdToActions = new Object();
            this.globalActions = new Object();
            this.columnSettings = new Object();
            this.oldRowIdToFound = new Object();

            /* Dynamic column hiding based on the ColumnHider plugin of dgrid, but with own CheckBoxes outside the table */
            this.columnVisibility = new Object();
            this.columnHiderRules = new Object();

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "CertificateListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "certificate/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
                                     personId : 250,
                                  networkName : 180,
                               organisationId : 250,
                                        valid : 180,
                               issuerPersonId : 200,
                    certificateRequestCreated : 120,
                            invitatorPersonId : 200,
            certificateRequestRequestDatetime : 120,
                        certificateCertSerial : 120,
                          certificateMayLogin : 120,
                                      actions : 90
        },

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            return [organisationPersonId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                    field : "_name",
                       id : "personId",
                formatter : lang.hitch(this, this.personNameFormatter),
                 sortable : true,
                    label : i18n.certificateListNameColumnCaption
            });

            columns.push({
                   field : "_networkString",
                      id : "networkName",
                sortable : true,
                   label : i18n.certificateListNetworkColumnCaption
            });

            columns.push({
                    field : "organisationName",
                       id : "organisationId",
               renderCell : lang.hitch(this, this.renderOrganisation),
                 sortable : true,
                    label : i18n.certificateListOrganisationColumnCaption
            });

            columns.push({
                   field : "validString",
                      id : "valid",
                //formatter : lang.hitch(this, this.validFormatter),
                sortable : true,
                   label : i18n.certificateListValidColumnCaption
            });

            columns.push({
                    field : "_issuerName",
                       id : "issuerPersonId",
                formatter : lang.hitch(this, this.issuerFormatter),
                 sortable : true,
                    label : i18n.certificateListIssuerColumnCaption
            });

            columns.push({
                    field : "certificateRequestCreated",
                       id : "certificateRequestCreated",
                formatter : lang.hitch(this, this.invitationFormatter),
                 sortable : true,
                    label : i18n.certificateListInvitationColumnCaption
            });

            columns.push({
                    field : "invitatorPersonId",
                       id : "invitatorPersonId",
                formatter : lang.hitch(this, this.invitatorFormatter),
                 sortable : true,
                    label : i18n.certificateListInvitatorColumnCaption
            });

            columns.push({
                    field : "certificateRequestRequestDatetime",
                       id : "certificateRequestRequestDatetime",
                formatter : lang.hitch(this, this.requestedFormatter),
                 sortable : true,
                    label : i18n.certificateListRequestedColumnCaption
            });

            columns.push({
                   field : "certificateCertSerial",
                      id : "certificateCertSerial",
                sortable : true,
                   label : i18n.certificateListSerialNumberColumnCaption
            });

            columns.push({
                    field : "status",
                       id : "certificateMayLogin",
                formatter : lang.hitch(this, this.statusFormatter),
                 sortable : true,
                    label : i18n.certificateListStatusColumnCaption
            });

            columns.push({
                     field : "certificateId",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : true,
                     label : i18n.actionColumnCaption
            });

            return columns;
        },

        personNameFormatter : function(personId, certificateJoin) {
            return certificateJoin.personSurName + " " + certificateJoin.personGivenName;
        },

        validFormatter : function(certificateId, certificateJoin) {

            var fromGiven = certificateJoin.certificateCertValidFrom != null;
            var toGiven = certificateJoin.certificateCertValidTo != null;

            if (fromGiven || toGiven) {
                var fromString = fromGiven
                ? DateHelper.formatUtcSecondsWithTimeZone(certificateJoin.certificateCertValidFrom, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern)
                : "----";

                var toString = toGiven
                ? DateHelper.formatUtcSecondsWithTimeZone(certificateJoin.certificateCertValidTo, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern)
                : "----";

                return string.substitute(i18n.certificateListValidPeriod, {
                    from : fromString,
                      to : toString
                });
            } else {
                return "";
            }
        },

        issuerFormatter : function(issuerPersonId, certificateJoin) {
            if (certificateJoin.issuerPersonGivenName != null || certificateJoin.issuerPersonSurName != null) {
                return certificateJoin.issuerPersonGivenName + " " + certificateJoin.issuerPersonSurName;
            } else {
                return "";
            }
        },

        organisationFormatter : function(organisationPersonId, certificateJoin) {
            if (certificateJoin.organisationName != null) {
                if (certificateJoin.organisationPersonOrganisationalUnitName != null)
                	organisationText = certificateJoin.organisationName + " (" +certificateJoin.organisationPersonOrganisationalUnitName + ")";
                else if (certificateJoin.organisationPersonPostalAddress != null)
                           return certificateJoin.organisationName + " (" +certificateJoin.organisationPersonPostalAddress
                                           + ", " +certificateJoin.organisationPersonPostalCode
                                           + " " +certificateJoin.organisationPersonLocalityName + ")";
                else
                return certificateJoin.organisationName;
            } else {
                return "";
            }
        },
        
        renderOrganisation : function(certificateJoin, data, cell) {
            var organisationText = "";
            if (certificateJoin.organisationName != null) {
                if (certificateJoin.organisationPersonOrganisationalUnitName != null)
                	organisationText = certificateJoin.organisationName + " (" +certificateJoin.organisationPersonOrganisationalUnitName + ")";
                else if (certificateJoin.organisationPersonPostalAddress != null)
                	organisationText = certificateJoin.organisationName + " (" +certificateJoin.organisationPersonPostalAddress
		                + ", " +certificateJoin.organisationPersonPostalCode
		                + " " +certificateJoin.organisationPersonLocalityName + ")";
            	else
                	organisationText = certificateJoin.organisationName;
            }
            var organisationStyle = "";
            if (certificateJoin.organisationPersonRetiredFlag)
            	organisationStyle = "certificateListGridOrganisationSpanInvalidated";

            var cellSpan = DOMHelper.createTextNode("span", organisationText, null, organisationStyle);
            return cellSpan;            	

		},        
        
        statusFormatter : function(certificateMayLogin, certificateJoin) {

            var statusString = "";
            var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();
            var expired = certificateJoin.certificateId != null
            && (certificateJoin.certificateCertValidFrom == null || certificateJoin.certificateCertValidTo == null
                || certificateJoin.certificateCertValidFrom > currentTimeSeconds
                || certificateJoin.certificateCertValidTo < currentTimeSeconds);
            var locked = (certificateJoin.certificateMayLogin != null && certificateJoin.certificateMayLogin == 0)
            	|| (certificateJoin.certificateMaySign != null && certificateJoin.certificateMaySign == 0);
            var invalidUserPolicy = certificateJoin.certificateRequestRequestPdfUploadVersion < this.userPolicyVersion;
            var validUserPolicy = certificateJoin.certificateRequestRequestPdfUploadVersion && certificateJoin.certificateRequestRequestPdfUploadVersion >= this.userPolicyVersion;
            var noUserPolicy = certificateJoin.certificateRequestRequestPdfUploadVersion == null;
            var personLoginExpired = !StringHelper.isEmpty(certificateJoin.personLogin) && certificateJoin.personPassword == CertificateListWidget.Status.PASSWORD_EXPIRED;
            var personLoginWillExpire = !StringHelper.isEmpty(certificateJoin.personLogin) && certificateJoin.personPassword == CertificateListWidget.Status.PASSWORD_WILL_EXPIRE;
            
            
            if (locked && expired) {
                statusString = i18n.certificateListLockedStatus + ", " + i18n.certificateExpiredStatus;
            } else if (locked) {
                statusString = i18n.certificateListLockedStatus;
                locked = true;
            } else if (certificateJoin.status == CertificateListWidget.Status.NO_CERTIFICATE) {
                statusString = i18n.certificateListNoCertificateStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.NO_CERTIFICATE_OlDREQUEST) {
                statusString = i18n.certificateListNoCertificateStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.INVITATION) {
                statusString = i18n.certificateListInvitationStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.REQUEST) {
                statusString = i18n.certificateListRequestStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.VALID_EXPIRES_SOON) {
                statusString = i18n.certificateListValidExpiresSoonStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.VALID) {
                statusString = i18n.certificateListValidStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.EXPIRED) {
                statusString = i18n.certificateExpiredStatus;
            } else if (certificateJoin.status == CertificateListWidget.Status.INCONSISTENT) {
                statusString = i18n.certificateInconsistentStatus;
            }

            if (!locked && (certificateJoin.status == CertificateListWidget.Status.VALID_EXPIRES_SOON
                || certificateJoin.status == CertificateListWidget.Status.VALID)) {
                if (certificateJoin.certificateMayLogin) {
                    statusString += ", " + i18n.certificateMayLoginStatus;
                }
                if (certificateJoin.certificateMaySign) {
                    statusString += ", " + i18n.certificateMaySignStatus;
                }
            }
            if (invalidUserPolicy){
				statusString += ", " + i18n.certificateInvalidUserPolicy;
			} else if (validUserPolicy){
				statusString += ", " + i18n.certificateValidUserPolicy;
			}
            if (noUserPolicy){
				statusString += ", " + i18n.certificateNoUserPolicy;
			}
            if (personLoginExpired)
				statusString += ", " + i18n.certificatePasswordExpired;
			else if (personLoginWillExpire)
				statusString += ", " + i18n.certificatePasswordWillExpire;
			
            return statusString;
            /*
            if (certificateMayLogin) {
                return i18n.yes;
            } else {
                return "";
            }*/
        },

        invitationFormatter : function(certificateRequestCreated, certificateJoin) {
            if (certificateRequestCreated) {
                return DateHelper.formatUtcSecondsWithTimeZone(certificateRequestCreated, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);
            } else {
                return "";
            }
        },

        invitatorFormatter : function(invitatorPersonId, certificateJoin) {
            var givenName = certificateJoin.invitatorPersonGivenName ? certificateJoin.invitatorPersonGivenName : "";
            var surName = certificateJoin.invitatorPersonSurName ? certificateJoin.invitatorPersonSurName : "";
            return givenName + " " + surName;
        },

        requestedFormatter : function(certificateRequestRequestDateTime, certificateJoin) {
            if (certificateRequestRequestDateTime) {
                return DateHelper.formatUtcSecondsWithTimeZone(certificateRequestRequestDateTime, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);
            } else {
                return "";
            }
        },

        renderActionCell : function(certificateJoin, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);



            // Probably not necessary any longer - functionality wasn´t known anyway
            //var editButton = this.constructEditButton();
            //domConstruct.place(editButton.domNode, buttonDiv);

            var valid = certificateJoin.status == CertificateListWidget.Status.VALID_EXPIRES_SOON || certificateJoin.status == CertificateListWidget.Status.VALID;
            var validExpiresSoon = certificateJoin.status == CertificateListWidget.Status.VALID_EXPIRES_SOON;
            var expired = certificateJoin.status == CertificateListWidget.Status.EXPIRED;
            var request = certificateJoin.status == CertificateListWidget.Status.REQUEST;
            var invitation = certificateJoin.status == CertificateListWidget.Status.INVITATION;
            var noCertificate = certificateJoin.status == CertificateListWidget.Status.NO_CERTIFICATE;
            var noCertificateOldRequest = certificateJoin.status == CertificateListWidget.Status.NO_CERTIFICATE_OlDREQUEST;
            var noPersonLogin = StringHelper.isEmpty(certificateJoin.personLogin) || StringHelper.isEmpty(certificateJoin.personPassword);
            var personLoginExpired = !StringHelper.isEmpty(certificateJoin.personLogin) && certificateJoin.personPassword == CertificateListWidget.Status.PASSWORD_EXPIRED;
/*
    		log.info("Status for "+certificateJoin.personSurName + " " + certificateJoin.personGivenName+" ("+certificateJoin.organisationName+"):");
    		log.info("valid: "+valid);
    		log.info("validExpiresSoon: "+validExpiresSoon);
    		log.info("expired: "+expired);
    		log.info("request: "+request);
    		log.info("invitation: "+invitation);
    		log.info("noCertificate: "+noCertificate);
    		log.info("noCertificateOldRequest: "+noCertificateOldRequest);
    		log.info("noPersonLogin: "+noPersonLogin);
    		log.info("hasActionsForNetwork networkOrganisationNetworkId ("+certificateJoin.networkOrganisationNetworkId+"): "+ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.networkOrganisationNetworkId, ["editPerson"]));
    		log.info("hasActionsForNetwork certificateRequestNetworkId ("+certificateJoin.certificateRequestNetworkId+"): "+ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]));
    		log.info("hasActionsForNetwork caNetworkId ("+certificateJoin.caNetworkId+"): "+ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"]));
*/
    		// InviteForCertificateButton

            if (certificateJoin.personId != null &&
                ((noPersonLogin || !valid) && !invitation && !request /*&& !noCertificateOldRequest*/)
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.networkOrganisationNetworkId, ["editPerson"]))) {

                var inviteForCertificateButton = this.constructInviteForCertificateButton(certificateJoin);
                domConstruct.place(inviteForCertificateButton.domNode, buttonDiv);
            }

            // ConfirmCertificateButton
//            if (expired
//                && !noPersonLogin
//                && certificateJoin.certificateRequestId != null
//                && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"])) {
//
//                var confirmCertificateButton = this.constructConfirmCertificateButton(certificateJoin);
//                domConstruct.place(confirmCertificateButton.domNode, buttonDiv);
//            }

            // IssueCertificateButton
            // Zertifikat ausstellen
            if (request 
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson", "editOrganisationPerson"]))) {

                var issueCertificateButton = this.constructIssueCertificateButton(certificateJoin);
                domConstruct.place(issueCertificateButton.domNode, buttonDiv);
            }

            // NewCertificateButton (with existing request)
            // Zertifikat mit vorhandener Anforderung neu ausstellen
/*            if (!noPersonLogin
                && !valid
                && ((certificateJoin.certificateId != null
                    && certificateJoin.certificateRequestId != null
                    && (   certificateJoin.certificateRequestRequestType == "Accepted"
                        || certificateJoin.certificateRequestRequestType == "pkcs10"
                        || certificateJoin.certificateRequestRequestType == "spkac"))
                    || noCertificate || noCertificateOldRequest)
                	// && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"])) {
	                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
//	                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]))) {
	                 || !this.certificateAdministrationGlobal && ActionHelper.hasActions(this.networkIdToActions, ["editPerson"]))) {

                var newCertificateButton = this.constructNewCertificateButton(certificateJoin);
                domConstruct.place(newCertificateButton.domNode, buttonDiv);
            }
*/
            // RenewButton
            // Das Zertifikat verlängern
            if ((validExpiresSoon || expired)
                && certificateJoin.certificateMaySign
                && certificateJoin.personId != null
                && !noPersonLogin
                // && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"])) {
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
//                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]))) {
	                 || !this.certificateAdministrationGlobal && ActionHelper.hasActions(this.networkIdToActions, ["editPerson"]))) {

                var renewButton = this.constructRenewButton(certificateJoin);
                domConstruct.place(renewButton.domNode, buttonDiv);
            }
            // ExtendChangePasswordButton
            // Möglichkeit der Passwortänderung verlängern
            if ((personLoginExpired)
                && certificateJoin.certificateMaySign
                && certificateJoin.personId != null
                && !noPersonLogin
                // && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"])) {
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
//                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]))) {
	                 || !this.certificateAdministrationGlobal && ActionHelper.hasActions(this.networkIdToActions, ["editPerson"]))) {

                var extendChangePasswordButton = this.constructExtendChangePasswordButton(certificateJoin);
                domConstruct.place(extendChangePasswordButton.domNode, buttonDiv);
            }

            // InvalidateButton
            if (valid
                && certificateJoin.certificateMaySign
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"]))) {

                var invalidateButton = this.constructInvalidateButton(certificateJoin);
                domConstruct.place(invalidateButton.domNode, buttonDiv);
            }

            // UnlockButton
            var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();
            if (       certificateJoin.certificateCertValidFrom != null
                && certificateJoin.certificateCertValidFrom <= currentTimeSeconds
                && certificateJoin.certificateCertValidTo != null
                && certificateJoin.certificateCertValidTo >= currentTimeSeconds
                && (!certificateJoin.certificateMayLogin || !certificateJoin.certificateMaySign)
                && !noPersonLogin
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"]))) {
                var unlockButton = this.constructUnlockButton(certificateJoin);
                domConstruct.place(unlockButton.domNode, buttonDiv);
            }



            // DeleteButton
            if (valid && !noPersonLogin
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"]))) {
                var deleteButton = this.constructDeleteButton(certificateJoin);
                domConstruct.place(deleteButton.domNode, buttonDiv);
            }

            // DownloadRequestButton
            if ((valid || expired || request)
                && certificateJoin.certificateRequestRequestPdfUploaded
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.caNetworkId, ["editPerson"]))) {
                var downloadRequestButton = this.constructDownloadRequestButton(certificateJoin);
                domConstruct.place(downloadRequestButton.domNode, buttonDiv);
            }

            // SetUserPolicyButton
            if (/*this.userPolicyPath != null && this.userPolicyPath.length>0 &&*/ valid 
            	&& (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]))) {
                var setUserPolicyButton = this.constructSetUserPolicyButton(certificateJoin);
                domConstruct.place(setUserPolicyButton.domNode, buttonDiv);
            }

            // DeleteRequestButton
            if (request
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]))) {

                var deleteRequestButton = this.constructDeleteRequestButton(certificateJoin);
                domConstruct.place(deleteRequestButton.domNode, buttonDiv);
            }

            // DeleteInvitationButton
            if (invitation
                && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 || !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, certificateJoin.certificateRequestNetworkId, ["editPerson"]))) {

                var deleteInvitationButton = this.constructDeleteInvitationButton(certificateJoin);
                domConstruct.place(deleteInvitationButton.domNode, buttonDiv);
            }

            // ShowDetailsButton
            if ((request || invitation || valid)
                && ("administrateCertificate" in this.globalActions 
                 	|| ActionHelper.hasActions(this.networkIdToActions, ["editPerson"]))) {

                var showDetailsButton = this.constructShowCertificateDetailsButton(certificateJoin);
                domConstruct.place(showDetailsButton.domNode, buttonDiv);
            }

            return buttonDiv;
        },

        constructInviteForCertificateButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListInviteForCertificateButtonCaption,
                showLabel : false,
                    title : i18n.certificateListInviteForCertificateButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      CertificateHelper.askInviteForCertificate({
                             certificateJoin : joinDto,
                          applicationContext : this.applicationContext,
                                  baseWidget : this,
                             successCallback : lang.hitch(this, this.successCallback)
                      });
                  }),
                iconClass : "inviteCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },

        constructConfirmCertificateButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListConfirmCertificateButtonCaption,
                showLabel : false,
                    title : i18n.certificateListConfirmCertificateButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.askSendCertificateConfirmationLetter(joinDto);
                  }),
                iconClass : "confirmCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },

        //Zertifikat ausstellen
        constructIssueCertificateButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListIssueCertificateButtonCaption,
                showLabel : false,
                    title : i18n.certificateListIssueCertificateButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.issueCertificate(joinDto, false);
                  }),
                iconClass : "issueCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        //Zertifikat mit vorhandener Anforderung neu ausstellen
/*        constructNewCertificateButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListNewCertificateButtonCaption,
                showLabel : false,
                    title : i18n.certificateListNewCertificateButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.issueCertificate(joinDto, true);
                  }),
                iconClass : "newCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
*/
        constructDeleteButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListDeleteAccessButtonCaption,
                showLabel : false,
                    title : i18n.certificateListDeleteAccessButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.invalidateUserLogin(joinDto);
                  }),
                iconClass : "deleteButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },

        constructEditButton : function() {
            return new DisableButton({
                    label : i18n.certificateListEditPersonButtonCaption,
                showLabel : false,
                    title : i18n.certificateListEditPersonButtonToolTip,
                  onClick : lang.hitch(this, function() {
                  }),
                iconClass : "editButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        //Das Zertifikat verlängern
        constructRenewButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListRenewButtonCaption,
                showLabel : false,
                    title : i18n.certificateListRenewButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.renewCertificate(joinDto);
                  }),
                iconClass : "renewCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        //Zertifikat sperren
        constructInvalidateButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListInvalidateButtonCaption,
                showLabel : false,
                    title : i18n.certificateListInvalidateButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.invalidateCertificate(joinDto);
                  }),
                iconClass : "invalidateCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        //Zertifikat entsperren
        constructUnlockButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListUnlockButtonCaption,
                showLabel : false,
                    title : i18n.certificateListUnlockButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.unlockCertificate(joinDto);
                  }),
                iconClass : "reactivateCertificateButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },



        constructDownloadRequestButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListDownloadRequestButtonCaption,
                showLabel : false,
                    title : i18n.certificateListDownloadRequestButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.downloadRequest(joinDto);
                  }),
                iconClass : "exportToPdfButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },

        constructSetUserPolicyButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListSetUserPolicyButtonCaption,
                showLabel : false,
                    title : i18n.certificateListSetUserPolicyButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.setUserPolicy(joinDto);
                  }),
                iconClass : "plotOrderDeliveryButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        //ExtendChangePasswordButton
        constructExtendChangePasswordButton : function(joinDto) {
            var title = string.substitute(i18n.extendChangePasswordButtonToolTip, {
                  amount : this.passwordExpireExtendInterval
            });
            return new DisableButton({
                    label : i18n.extendChangePasswordButtonCaption,
                showLabel : false,
                    title : title,
                  onClick : lang.hitch(this, function() {
                      this.extendChangePassword(joinDto);
                  }),
                iconClass : "reloadButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },



        constructDeleteRequestButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListDeleteRequestButtonCaption,
                showLabel : false,
                    title : i18n.certificateListDeleteRequestButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.deleteRequest(joinDto);
                  }),
                iconClass : "deleteButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },

        constructDeleteInvitationButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListDeleteInvitationButtonCaption,
                showLabel : false,
                    title : i18n.certificateListDeleteInvitationButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.deleteInvitation(joinDto);
                  }),
                iconClass : "deleteButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },

        constructShowCertificateDetailsButton : function(joinDto) {
            return new DisableButton({
                    label : i18n.certificateListShowDetailsButtonCaption,
                showLabel : false,
                    title : i18n.certificateListShowDetailsButtonToolTip,
                  onClick : lang.hitch(this, function() {
                      this.showCertificateRequestDetails(joinDto);
                  }),
                iconClass : "showButton",
                "class" : "cdesWebButton17x18 gridButton",
         controllerWidget : this,
             disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },



        showCertificateRequestDetails : function(joinDto) {
            var certificateRequestShowWidget = new CertificateRequestShowWidget({
                applicationContext : this.applicationContext,
    	    		userPolicyPath : this.userPolicyPath,
	  administrateCertificateRight : (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
	                 					|| !this.certificateAdministrationGlobal && ActionHelper.hasActionsForNetwork(this.networkIdToActions, joinDto.certificateRequestNetworkId, ["editPerson"]))
            });
            certificateRequestShowWidget.setData(joinDto);

            var caption = string.substitute(i18n.certificateRequestShowDialogCaption, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });

            var certificateRequestShowDialog = new InfoDialog({
                        title : caption,
                      content : certificateRequestShowWidget.getContainer(),
                 defaultWidth : 570,
                defaultHeight : 230,
                      buttons : [ { type : InfoDialog.Button.CLOSE }
                      ]
            });

            on(certificateRequestShowDialog, "hide", lang.hitch(this, function() {
                certificateRequestShowWidget.destroy();
            }));

            certificateRequestShowDialog.show();
        },

        askSendCertificateConfirmationLetter : function(joinDto) {
            InfoDialog.showQuestion({
                  title : i18n.certificateListAskSendConfirmationLetterDialogCaption,
                message : i18n.certificateListAskSendConfirmationLetterDialogQueston,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.sendCertificateConfirmationLetter(joinDto);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        sendCertificateConfirmationLetter : function(joinDto) {
            var certificateService = this.applicationContext.getService("certificateService");

            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.SEND_CONFIRMATION_LETTER);
            var deferred = certificateService.sendCertificateConfirmation(joinDto.certificateRequestId, joinDto.organisationPersonId, this.applicationContext.getPageContextOrganisationPersonId());
            deferred.then(lang.hitch(this, function() {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.SEND_CONFIRMATION_LETTER);

                topic.publish("message/ok", i18n.certificateListSendConformationLetterOk);

                delete deferred;
            }),
                lang.hitch(this, function(err) {
                    delete deferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.SEND_CONFIRMATION_LETTER,
                                opName : "sendCertificateConfirmation",
                               message : i18n.certificateListSendConfirmationLetterFailed
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling invalidateCertificate: ", err);
            }));
        },

        /*
        *              var button = new DisableButton({
                label : i18n.deviceListEditButtonCaption,
            showLabel : false,
              tooltip : i18n.deviceListEditButtonToolTip,
              onClick : lang.hitch(this, function() {
                  var hashString = ioQuery.objectToQuery({
                        page : "editDevice",
                      device : deviceData.deviceId
                  });

                  this.applicationContext.setHash(this, hashString);
              }),
            iconClass : "editButton",
            "class" : "mdaWebButton22 gridButton",
     controllerWidget : this,
         disableEvent : "disableEditButton",
            _destroyOnRemove : true
        });
        */

        constructTopDiv : function() {

            var gridDiv = this.constructGrid({
                idProperty : "id",
                    gridId : "CertificateListGrid",
                 gridClass : "OnDemandGrid"
            });

            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));

            return gridDiv;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {

            var organisationPersonIdsWithoutCertificateSoFar = new Object();
            this.certificateJoins = [];
            for (var n = 0; n < params.data.length; n++) {
                var currJoin = params.data[n];
                if (currJoin.status == CertificateListWidget.Status.NO_CERTIFICATE) {
                    // In order to gather the information wether there is a possibly no longer valid certificate for the person at hand,
                    // which is needed for controlling button visibility below, we join certificates into the "persons without (valid) certificates" join.
                    // This may lead to duplicate person tuples, which we filter out here.
                    if (!(currJoin.organisationPersonId in organisationPersonIdsWithoutCertificateSoFar)) {
                        organisationPersonIdsWithoutCertificateSoFar[currJoin.organisationPersonId] = true;
                        this.certificateJoins.push(currJoin);
                    }
                } else {
                    this.certificateJoins.push(currJoin);
                }
            }

            this.updateAuxiliaryData();
            this.networkIdToActions = params.networkIdToActions;
            this.globalActions = params.globalActions;
            this.userPolicyVersion = params.userPolicyVersion;
            this.userPolicyPath = params.userPolicyPath;
            this.certificateAdministrationGlobal = params.certificateAdministrationGlobal;
            this.passwordExpireExtendInterval = params.passwordExpireExtendInterval;

            if (params.columnSettings) {
                this.setColumnSettings(params.columnSettings);
            }

            this.reload();
        },

        setSearchModel : function(searchModel) {
            // summary:
            //     Set a read-only-copy of the search model used to populate this CertificateListWidget with data.
            this.searchModel = searchModel;
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.certificateJoins.length; n++) {
                var joinDto = this.certificateJoins[n];
                this.updateAuxiliaryDataForJoinDto(joinDto);
            }
        },

        updateAuxiliaryDataForJoinDto : function(joinDto) {
            joinDto.validString = this.validFormatter(null, joinDto);
            joinDto.id = this.getRowId(joinDto);

            joinDto._networkString = joinDto.networkName;

            // toLowerCase to fix the sort order (RUBIK is supposed to be listed *after* Riess, not before)
            joinDto._name = this.personNameFormatter(null, joinDto).toLowerCase();
            if (typeof joinDto._name.trim == "function") {
                joinDto._name = joinDto._name.trim();
            }

            joinDto._issuerName = this.issuerFormatter(null, joinDto).toLowerCase();
            if (typeof joinDto._issuerName.trim == "function") {
                joinDto._issuerName = joinDto._issuerName.trim();
            }
        },

        //PLAN_DELIVER_SORT_PROPERTIES : [{ attribute : "documentName", descending : false}],

        reload : function(params) {
            this.updateColumns();

            this.store.setData(this.certificateJoins);

            this.grid.set("sort", "_name", false);
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        updateRowClass : function(domNode, joinDto) {
            domClass.remove(domNode, "personListInvalidatedPerson");
            if (joinDto.personStatus == 1 || joinDto.personStatus == 2) {
                domClass.add(domNode, "personListInvalidatedPerson");
            }
        },

        getRowId : function(joinDto) {
            return (joinDto.certificateId != null ? joinDto.certificateId.toString() : "") + "_"
            + (joinDto.personId != null ? joinDto.personId.toString() : "") + "_"
			+ (joinDto.networkOrganisationNetworkId != null ? joinDto.networkOrganisationNetworkId.toString() : "") + "_"
			+ (joinDto.organisationId != null ? joinDto.organisationId.toString() : "");
        },

        updateIndividualColumns : function() {
            this.updateColumn("personId", this.columnSettings.showName);
            this.updateColumn("networkName", this.columnSettings.showNetwork);
            this.updateColumn("organisationId", this.columnSettings.showOrganisation);
            this.updateColumn("valid", this.columnSettings.showValid);
            this.updateColumn("issuerPersonId", this.columnSettings.showIssuer);
            this.updateColumn("certificateMayLogin", this.columnSettings.showStatus);
            this.updateColumn("certificateRequestCreated", this.columnSettings.showInvitation);
            this.updateColumn("invitatorPersonId", this.columnSettings.showInvitator);
            this.updateColumn("certificateRequestRequestDatetime", this.columnSettings.showRequested);
            this.updateColumn("certificateCertSerial", this.columnSettings.showSerialNumber);
        },

        /***************************************** Filter *******************************************/

        filter : function(searchString) {

            // Don´t filter too often.  If filtering starts while one is typing, and the list is big,
            // then the textbox freezes while one types until filtering has finished.
            if (this.filterHandle) {
                window.clearInterval(this.filterHandle);
                delete this.filterHandle;
            }

            this.filterHandle = window.setInterval(lang.hitch(this, function() {
                this.startFilterUtcMillis = (new Date()).getTime();

                var searchStrings = StringHelper.isEmpty(searchString) ? [] : searchString.split(",");
                var trimmedSearchStrings = [];
                for (var n = 0; n < searchStrings.length; n++) {
                    if (searchStrings[n] && searchStrings[n].trim().length > 0) {
                        trimmedSearchStrings.push(searchStrings[n].trim().toLowerCase());
                    }
                }

                var middleMillis = (new Date()).getTime();

                var rowIdToFound = new Object();
                var filteredDtos = [];
                var numberOfNewFound = 0;
                for (var n = 0; n < this.certificateJoins.length; n++) {
                    var rowId = this.certificateJoins[n].id;
                    rowIdToFound[rowId] = this.filterRow(this.certificateJoins[n], trimmedSearchStrings);
                    if (rowIdToFound[rowId]) {
                        filteredDtos.push(this.certificateJoins[n]);
                        numberOfNewFound++;
                    }
                }

                var difference = false;
                var numberOfOldFound = 0;
                for (var rowId in this.oldRowIdToFound) {
                    if (this.oldRowIdToFound[rowId]) {
                        numberOfOldFound++;
                        if (!(rowId in rowIdToFound) || !rowIdToFound[rowId]) {
                            difference = true;
                        }
                    }
                }
                difference |= (numberOfNewFound != numberOfOldFound);

                this.oldRowIdToFound = new Object();
                for (var rowId in rowIdToFound) {
                    this.oldRowIdToFound[rowId] = rowIdToFound[rowId];
                }

                if (difference) {
                    this.store.setData(filteredDtos);
                    this.grid.refresh();
                }

                var endMillis = (new Date()).getTime();

                window.clearInterval(this.filterHandle);
                delete this.filterHandle;
            }), 0);

        },

        filterRow : function(joinDto, searchStrings) {

            var tokens = [];

            if (this.columnSettings.showName) {
                tokens.push(this.personNameFormatter(null, joinDto));
            }

            if (this.columnSettings.showNetwork) {
                tokens.push(this.networkName);
            }

            if (this.columnSettings.showOrganisation) {
                tokens.push(this.organisationFormatter(null, joinDto));
            }

            if (this.columnSettings.showValid) {
                tokens.push(joinDto.validString);
            }

            if (this.columnSettings.showIssuer) {
                tokens.push(this.issuerFormatter(null, joinDto));
            }

            if (this.columnSettings.showStatus) {
                tokens.push(this.statusFormatter(null, joinDto));
            }

            if (this.columnSettings.showInvitation) {
                tokens.push(this.invitationFormatter(null, joinDto));
            }

            if (this.columnSettings.showInvitator) {
                tokens.push(this.invitatorFormatter(null, joinDto));
            }

            if (this.columnSettings.showRequested) {
                tokens.push(this.requestedFormatter(null, joinDto));
            }

            if (this.columnSettings.showSerialNumber) {
                tokens.push(joinDto.certificateCertSerial);
            }

            var allFound = true;

            for (var z = 0; z < searchStrings.length; z++) {

                var found = false;
                for (var n = 0; n < tokens.length; n++) {
                    if (tokens[n] != null) {
                        if (!(typeof tokens[n] == "string")) {
                            tokens[n] = tokens[n].toString();
                        }

                        tokens[n] = tokens[n].toLowerCase();

                        // TODO: Escape such that e.g. ":" can be searched properly (currently, searching for 17:04:26 gives no result even if
                        // there is such a timestamp
                        if (tokens[n].indexOf(searchStrings[z]) != -1) {
                            found = true;
                            break;
                        }
                    }
                }

                if (!found) {
                    allFound = false;
                    break;
                }
            }

            return allFound;
        },

        doesJoinMatchSearchModel : function(certificateJoin) {
            var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();

            var matched = false;

            if (this.searchModel.showValid) {
                matched |= (   certificateJoin.certificateCertValidFrom != null && certificateJoin.certificateCertValidFrom <= currentTimeSeconds
                    && certificateJoin.certificateCertValidTo != null && certificateJoin.certificateCertValidTo >= currentTimeSeconds
                    && certificateJoin.certificateMayLogin
                    && certificateJoin.certificateMaySign);
            }
            if (this.searchModel.showInvitations) {
                matched |= certificateJoin.certificateRequestId != null
                && certificateJoin.certificateRequestRequestType == "Invitation"
                && certificateJoin.certificateRequestCreated != null;
            }
            if (this.searchModel.showExpired) {
                matched |= (certificateJoin.certificateId != null
                    && (certificateJoin.certificateCertValidFrom == null || certificateJoin.certificateCertValidTo == null
                        || certificateJoin.certificateCertValidFrom > currentTimeSeconds
                        || certificateJoin.certificateCertValidTo < currentTimeSeconds
                        || !certificateJoin.certificateMayLogin
                        || !certificateJoin.certificateMaySign));
            }
            if (this.searchModel.showValidExpiredSoon) {
                matched |= (   certificateJoin.certificateCertValidFrom != null && certificateJoin.certificateCertValidFrom <= currentTimeSeconds
                    && certificateJoin.certificateCertValidTo != null
                    && certificateJoin.certificateCertValidTo <= currentTimeSeconds + 30 * 86400 && certificateJoin.certificateCertValidTo >= currentTimeSeconds
                    && certificateJoin.certificateMayLogin
                    && certificateJoin.certificateMaySign);
            }
            if (this.searchModel.showRequested) {
                matched |= certificateJoin.certificateRequestId != null
                && certificateJoin.certificateRequestRequestType == "Request"
                && certificateJoin.certificateRequestRequestDateTime != null;
            }
            if (this.searchModel.showPersonsWithoutCertificate) {
                matched |= (certificateJoin.certificateId == null
                    || certificateJoin.certificateCertValidFrom == null || certificateJoin.certificateCertValidTo == null
                    || certificateJoin.certificateCertValidFrom > currentTimeSeconds
                    || certificateJoin.certificateCertValidTo < currentTimeSeconds
                    || !certificateJoin.certificateMayLogin
                    || !certificateJoin.certificateMaySign);
            }

            return matched;
        },

        /*
        * var password = new ValidationTextBox({
            name: "password",
            type: "password"
        }, "password");
        */

        renewCertificate : function(joinDto) {
            var dialog = new RenewCertificateDialog({
                applicationContext : this.applicationContext,
                             title : i18n.renewCertificateDialogCaption,
                      defaultWidth : 700,
                     defaultHeight : 220,
                           joinDto : joinDto,
                   successCallback : lang.hitch(this, this.successfullyRenewCallback)
            });
            dialog.show();
        },

        successCallback : function() {
            on.emit(this, "doSearch");
        },

        successfullyRenewCallback : function(touchedCertificateJoins) {

            on.emit(this, "doSearch");


            /* CDES-1424: Outcommented due to problems regarding correctly insert / update / delete the joinDtos on completion.
            var oldCertificateJoin = touchedCertificateJoins[0];
            var newCertificateJoin = touchedCertificateJoins[1];

            this.store.emit("delete", { target : oldCertificateJoin });
            if (this.doesJoinMatchSearchModel(oldCertificateJoin)) {
                this.updateAuxiliaryDataForJoinDto(oldCertificateJoin);
                this.store.emit("insert", { target : oldCertificateJoin });
            }

            if (this.doesJoinMatchSearchModel(newCertificateJoin)) {
                this.updateAuxiliaryDataForJoinDto(newCertificateJoin);
                this.store.emit("insert", { target : newCertificateJoin });
            }
            */
            /*
            for (var n = 0; n < this.certificateJoins.length; n++) {
                if (this.certificateJoins[n].certificateId == oldCertificateJoin.certificateId) {
                    this.certificateJoins[n] = oldCertificateJoin;
                    this.certificateJoins.splice(n + 1, 0, newCertificateJoin);
                    n++;
                }
            }

            this.setData({ data : this.certificateJoins });
            */
        },

        unlockCertificate : function(joinDto) {
            InfoDialog.showQuestion({
                  title : i18n.unlockCertificateReallyDoDialogCaption,
                message : i18n.unlockCertificateReallyDoQuestion,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doUnlockCertificate(joinDto);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        doUnlockCertificate : function(joinDto) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var certificateService = this.applicationContext.getService("certificateService");

            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.UNLOCK_CERTIFICATE);
            var unlockDeferred = certificateService.unlockCertificate(joinDto.certificateId, organisationPersonId);
            unlockDeferred.then(lang.hitch(this, function(certificate) {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.UNLOCK_CERTIFICATE);

                this.copyCertificateIntoJoinDto(joinDto, certificate);

                topic.publish("message/ok", string.substitute(i18n.certificateListUnlockCertificateOk, {
                           givenName : joinDto.personGivenName,
                             surName : joinDto.personSurName,
                    organisationName : joinDto.organisationName
                }));

                if (this.doesJoinMatchSearchModel(joinDto)) {
                    CertificateHelper.updateCertificateStatus(joinDto);
                    this.store.emit("update", { target : joinDto });
                } else {
                    this.store.emit("delete", { target : joinDto });
                }

                delete unlockDeferred;
            }),
                lang.hitch(this, function(err) {
                    delete unlockDeferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.UNLOCK_CERTIFICATE,
                                opName : "unlockCertificate",
                               message : i18n.certificateListUnlockCertificateFailed
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling invalidateCertificate: ", err);
            }));
        },

        invalidateCertificate : function(joinDto) {
            InfoDialog.showQuestion({
                  title : i18n.invalidateCertificateReallyDoDialogCaption,
                message : i18n.invalidateCertificateReallyDoQuestion,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doInvalidateCertificate(joinDto);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        doInvalidateCertificate : function(joinDto) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var certificateService = this.applicationContext.getService("certificateService");

            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.INVALIDATE_CERTIFICATE);
            var invalidateDeferred = certificateService.invalidateCertificate(joinDto.certificateId, organisationPersonId);
            invalidateDeferred.then(lang.hitch(this, function(certificate) {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.INVALIDATE_CERTIFICATE);

                this.copyCertificateIntoJoinDto(joinDto, certificate);

                topic.publish("message/ok", string.substitute(i18n.certificateListInvalidateCertificateOk, {
                           givenName : joinDto.personGivenName,
                             surName : joinDto.personSurName,
                    organisationName : joinDto.organisationName
                }));

                //                      on.emit(this, "doSearch");

                if (this.doesJoinMatchSearchModel(joinDto)) {
                    CertificateHelper.updateCertificateStatus(joinDto);
                    this.store.emit("update", { target : joinDto });
                } else {
                    this.store.emit("delete", { target : joinDto });
                }

                delete invalidateDeferred;
            }),
                lang.hitch(this, function(err) {
                    delete invalidateDeferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.INVALIDATE_CERTIFICATE,
                                opName : "invalidateCertificate",
                               message : i18n.certificateListInvalidateCertificateFailed
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling invalidateCertificate: ", err);
            }));
        },

        downloadRequest : function(joinDto) {
            if (joinDto.certificateRequestId != null) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var url = "/cdes-dojo-impl/repositoryDownload/requests/" + organisationPersonId + "/" + joinDto.certificateRequestId;

                var downloadFrame = this.applicationContext.getFancyIFrame();
                downloadFrame.set("src", url);
            }
        },

        setUserPolicy : function(joinDto) {
            if (joinDto.certificateRequestId != null) {
                var setUserPolicyWidget = new SetUserPolicyWidget({
                    applicationContext : this.applicationContext,
                    certificateJoin: joinDto,
                });

                var caption = string.substitute(i18n.certificateListSetUserPolicyCaption, {
                    givenName : joinDto.personGivenName,
                    surName : joinDto.personSurName,
                });

                var setUserPolicyDialog = new InfoDialog({
                    title : caption,
                    content : setUserPolicyWidget.getContainer(),
                    defaultWidth : 630,
                    defaultHeight : 230,
                    buttons : [
                        {
                            type : InfoDialog.Button.CUSTOM,
                            name : "setUserPolicyButtom",
                            label : i18n.setUserPolicySubmit,
                            manualClose : true,
                            fct : lang.hitch(this, function() {
                                setUserPolicyWidget.setUserPolicy();
                            }),
                        },
                        { type : InfoDialog.Button.CLOSE },
                    ],
                });

                on(setUserPolicyDialog, "hide", lang.hitch(this, function() {
                    setUserPolicyWidget.destroy();
                }));

                on(setUserPolicyWidget, "success", lang.hitch(this, function() {
                    setUserPolicyDialog.close();
                    //update data
                    joinDto.certificateRequestRequestPdfUploadVersion = this.userPolicyVersion;
                    joinDto.certificateRequestRequestPdfUploaded = true;
                    this.store.emit("update", { target : joinDto });
                }));

                setUserPolicyDialog.show();
            } else {
                InfoDialog.showError({ title : i18n.error, message : i18n.setUserPolicyUploadError });
            }
        },

        issueCertificate : function(joinDto, fromOtherOrganisationPerson) {
            if (joinDto.status == CertificateListWidget.Status.NO_CERTIFICATE) {
                this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.GET_OTHER_CERTIFICATE);
                var certificateService = this.applicationContext.getService("certificateService");
                //get all valid certificates for person
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var deferred = certificateService.getCertificateJoinForOrganisationPersonPerson(organisationPersonId, joinDto.personId);
                deferred.then(lang.hitch(this, function(certificateJoin) {

                    this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.GET_OTHER_CERTIFICATE);

                    if (certificateJoin != null) {
                        // Create a certificate for the OrganisationPerson of the grid line at hand, but fetch all
                        // certificate related information from fetched valid certificate join (which belongs to the same person)
                        var combinedJoin = DataHelper.clone(certificateJoin);
                        JoinHelper.copyOrganisationPerson(joinDto, combinedJoin, "organisationPerson");
                        JoinHelper.copyOrganisation(joinDto, combinedJoin, "organisation");

                        CertificateHelper.doIssueCertificate({
                            applicationContext : this.applicationContext,
                                       joinDto : combinedJoin,
                                    baseWidget : this,
                               successCallback : lang.hitch(this, this.successCallback),
                                userPolicyPath : this.userPolicyPath
                        });
                    } else {
                        InfoDialog.showError({ title : i18n.certificateListNoOtherCertificateCaption, message : i18n.certificateListNoOtherCertificateMessage });
                    }

                    delete deferred;
                }),
                    lang.hitch(this, function(err) {
                        delete deferred;

                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : CertificateListWidget.AsyncOperation.GET_OTHER_CERTIFICATE,
                                    opName : "getCertificateJoinForOrganisationPersonPerson",
                                   message : i18n.certificateListGetOtherCertificateFailed
                        });
                    })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getCertificateJoinForOrganisationPersonPerson: ", err);
                }));
            } else {
                CertificateHelper.doIssueCertificate({
                    applicationContext : this.applicationContext,
                               joinDto : joinDto,
                            baseWidget : this,
                       successCallback : lang.hitch(this, this.successCallback),
                        userPolicyPath : this.userPolicyPath
                });
            }
        },

        deleteInvitation : function(joinDto) {
            var okMessage = string.substitute(i18n.certificateListDeleteInvitationOk, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });
            var failedMessage = string.substitute(i18n.certificateListDeleteInvitationFailed, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });

            InfoDialog.showQuestion({
                  title : i18n.certificateInvitationAskDeleteCaption,
                message : i18n.certificateInvitationAskDeleteQuestion,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        // Actually, it is the same operation on server side for both invitations and requests
                        this.doDeleteRequest(joinDto, okMessage, failedMessage);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        deleteRequest : function(joinDto) {
            var okMessage = string.substitute(i18n.certificateListDeleteRequestOk, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });
            var failedMessage = string.substitute(i18n.certificateListDeleteRequestFailed, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });

            InfoDialog.showQuestion({
                  title : i18n.certificateRequestAskDeleteCaption,
                message : i18n.certificateRequestAskDeleteQuestion,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doDeleteRequest(joinDto, okMessage, failedMessage);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        doDeleteRequest : function(joinDto, okMessage, failedMessage) {
            var certificateService = this.applicationContext.getService("certificateService");

            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.DELETE_CERTIFICATE_REQUEST);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var deleteDeferred = certificateService.deleteCertificateRequest(joinDto.certificateRequestId, organisationPersonId);
            deleteDeferred.then(lang.hitch(this, function(certificate) {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.DELETE_CERTIFICATE_REQUEST);

                topic.publish("message/ok", okMessage);

                this.store.emit("delete", { target : joinDto });

                delete deleteDeferred;
            }),
                lang.hitch(this, function(err) {
                    delete deleteDeferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.DELETE_CERTIFICATE_REQUEST,
                                opName : "deleteCertificateRequest",
                               message : failedMessage
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling deleteCertificateRequest: ", err);
            }));
        },

        extendChangePassword : function(joinDto) {
            var okMessage = string.substitute(i18n.extendChangePasswordOK, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName,
                   amount : this.passwordExpireExtendInterval
            });
            var failedMessage = string.substitute(i18n.extendChangePasswordFailed, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });
            var askMessage = string.substitute(i18n.extendChangePasswordAskQuestion, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName,
                   amount : this.passwordExpireExtendInterval
            });

            InfoDialog.showQuestion({
                  title : i18n.extendChangePasswordAskCaption,
                message : askMessage,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doExtendChangePassword(joinDto, okMessage, failedMessage);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        doExtendChangePassword : function(joinDto, okMessage, failedMessage) {
            var certificateService = this.applicationContext.getService("certificateService");

            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.EXTEND_CHANGE_PASSWORD);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var deferred = certificateService.extendChangePassword(joinDto.certificateId, organisationPersonId);
            deferred.then(lang.hitch(this, function(certificate) {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.EXTEND_CHANGE_PASSWORD);

                topic.publish("message/ok", okMessage);

                joinDto.personPassword = CertificateListWidget.Status.PASSWORD_WILL_EXPIRE;
                CertificateHelper.updateCertificateStatus(joinDto);
                this.store.emit("update", { target : joinDto });

                delete deferred;
            }),
                lang.hitch(this, function(err) {
                    delete deferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.EXTEND_CHANGE_PASSWORD,
                                opName : "extendChangePassword",
                               message : failedMessage
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling extendChangePassword: ", err);
            }));
        },

        copyCertificateIntoJoinDto : function(joinDto, certificate) {
            joinDto.certificateId = certificate.id;
            joinDto.certificateCertSerial = certificate.certSerial;
            joinDto.certificateCertValidFrom = certificate.certValidFrom;
            joinDto.certificateCertValidTo = certificate.certValidTo;
            joinDto.certificateMayLogin = certificate.mayLogin;
            joinDto.certificateMaySign = certificate.maySign;
        },

        copyPersonIntoJoinDto : function(joinDto, person) {
            joinDto.personId = person.id;
            joinDto.personGivenName = person.givenName;
            joinDto.personSurName = person.surName;
            joinDto.personLogin = person.login;
        },



        invalidateUserLogin : function(joinDto) {
            var personService = this.applicationContext.getService("personService");
            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.TRY_INVALIDATE_LOGIN);
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var deferred = personService.mayInvalidateUserLoginAndCertificates(organisationPersonId, joinDto.personId);
            deferred.then(lang.hitch(this, function(result) {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.TRY_INVALIDATE_LOGIN);
                result = true; // TODO: Remove this line to make client side privilege check active.
                if (result) {
                    InfoDialog.showQuestion({
                          title : i18n.invalidateUserLoginReallyDoDialogCaption,
                        message : string.substitute(i18n.invalidateUserLoginReallyDoQuestion, {
                            givenName : joinDto.personGivenName,
                              surName : joinDto.personSurName
                        }),
                        buttons : [
                            { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                                this.doInvalidateUserLogin(joinDto);
                            })},
                            { type : InfoDialog.Button.NO }
                        ]
                    });
                } else {
                    InfoDialog.showError({ title : i18n.certificateListMayInvalidateLoginDialogCaption, message : i18n.certificateListMayInvalidateLoginDialogMessage });
                }

                delete deferred;
            }),
                lang.hitch(this, function(err) {
                    delete deferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.TRY_INVALIDATE_LOGIN,
                                opName : "mayInvalidateUserLoginAndCertificates",
                               message : i18n.certificateListMayInvalidateLoginFailed
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling mayInvalidateUserLoginAndCertificates: ", err);
            }));

        },

        doInvalidateUserLogin : function(joinDto) {

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var myJoinDto = joinDto;
            var personService = this.applicationContext.getService("personService");
            this.registerAsyncOperationStarted(CertificateListWidget.AsyncOperation.INVALIDATE_LOGIN);
            var invalidateDeferred = personService.invalidateUserLoginAndCertificates(organisationPersonId, joinDto.personId);
            invalidateDeferred.then(lang.hitch(this, function(personCertificates) {

                this.registerAsyncOperationFinished(CertificateListWidget.AsyncOperation.INVALIDATE_LOGIN);

                topic.publish("message/ok", string.substitute(i18n.certificateListInvalidateLoginOk, {
                    givenName : myJoinDto.personGivenName,
                      surName : myJoinDto.personSurName
                }));

                // Update list, personCertificates contains all pieces of data changed by the operation
                var idToNewCertificate = new Object();
                for (var n = 0; n < personCertificates.certificates.length; n++) {
                    idToNewCertificate[personCertificates.certificates[n].id] = personCertificates.certificates[n];
                }
                for (var n = 0; n < this.certificateJoins.length; n++) {
                    var joinDto = this.certificateJoins[n];
                    if (joinDto.certificateId in idToNewCertificate) {
                        this.copyCertificateIntoJoinDto(joinDto, idToNewCertificate[joinDto.certificateId]);
                    }
                    if (joinDto.personId == personCertificates.person.id) {
                        this.copyPersonIntoJoinDto(joinDto, personCertificates.person);
                    }

                    if (this.doesJoinMatchSearchModel(joinDto)) {
                        this.store.emit("update", { target : joinDto });
                    } else {
                        this.store.emit("delete", { target : joinDto });
                    }
                }

                delete invalidateDeferred;
            }),
                lang.hitch(this, function(err) {
                    delete invalidateDeferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateListWidget.AsyncOperation.INVALIDATE_LOGIN,
                                opName : "invalidateUserLoginAndCertificates",
                               message : string.substitute(i18n.certificateListInvalidateLoginFailed, {
                                   givenName : joinDto.personGivenName,
                                     surName : joinDto.personSurName
                               })
                    });
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling invalidateUserLoginAndCertificates: ", err);
            }));
        },



        /****************************************** CanEdit ******************************************/
        /*
        canEditDocumentContent : function(joinDto) {
            return this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue");
        },
        */

        /**************************************** Formatters *****************************************/

        /*
        plannerFormatter : function(projectParticipationId, planDeliverJoinDto) {
            if (this.columnSettings.showPlannerPerson && this.columnSettings.showPlannerOrganisation) {
                return string.substitute(i18n.planDeliverPlannerString, {
                    organisation : planDeliverJoinDto.organisationName,
                          person : NameHelper.getPersonCommonName(planDeliverJoinDto, "person")
                });
            } else if (this.columnSettings.showPlannerPerson) {
                return NameHelper.getPersonCommonName(planDeliverJoinDto, "person");
            } else if (this.columnSettings.showPlannerOrganisation) {
                return planDeliverJoinDto.organisationName;
            } else {
                return "";
            }
        },
        */

        destroy : function() {
            this.inherited(arguments);

            // Remove columnHider CSS rules, to avoid that they get active again when such a grid is constructed again at a later time.
            for (id in this.columnHiderRules) {
                this.columnHiderRules[id].remove();
            }

            this.grid.destroy();
        }
    });

    CertificateListWidget.AsyncOperation = {
        INVALIDATE_CERTIFICATE : "InvalidateCertificate",
        UNLOCK_CERTIFICATE : "UnlockCertificate",
        DELETE_CERTIFICATE_REQUEST : "DeleteCertificateRequest",
        TRY_INVALIDATE_LOGIN : "TryInvalidateLogin",
        INVALIDATE_LOGIN : "InvalidateLogin",
        SEND_CONFIRMATION_LETTER : "SendConfirmationLetter",
        INVITE_SEND_ALL_PER_MAIL : "InviteSendAllPerMail",
        INVITE_SEND_INVITATION_PER_MAIL : "InviteSendInvitationPerMail",
        GET_OTHER_CERTIFICATE : "GetOtherCertificate",
        EXTEND_CHANGE_PASSWORD : "ExtendChangePassword"
   };

    CertificateListWidget.Status = {
        NO_CERTIFICATE : "NoCertificate",
        NO_CERTIFICATE_OlDREQUEST : "NoCertificateOldRequest",
        INVITATION : "Invitation",
        REQUEST : "Request",
        VALID_EXPIRES_SOON : "ValidExpiresSoon",
        VALID : "Valid",
        EXPIRED : "Expired",
        INCONSISTENT : "Inconsistent",
        PASSWORD_EXPIRED : "EXPIRED",
        PASSWORD_WILL_EXPIRE : "WILL_EXPIRE"
    };

    CertificateListWidget.CertificateJoinComponent = {
        CERTIFICATES : 1,
        INVITATIONS : 2,
        WITHOUT_CERTIFICATE : 3,
        WITHOUT_CERTIFICATE_OlDREQUEST : 4
    };

    return CertificateListWidget;
});
