define([ 
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/dateTime/DateTimeSpinBox",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/layout/InfoDialog",
         "dijit/form/Button",
         "dijit/form/TextBox",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/Evented",
         "dojo/io-query",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 topic,
    		 DateTimeSpinBox,
    		 DOMHelper,
    		 ErrorHelper,
    		 WidgetHelper,
    		 ContentWidget,
    		 InfoDialog,
    		 Button,
    		 TextBox,
    		 domClass,
    		 domConstruct,
    		 Evented,
    		 ioQuery,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.certificate.CertificateRequestShowWidget";

	var log = new TinyLog(className);
	
    var CertificateRequestShowWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "CertificateRequestShowWidget";
    	},
    	
    	getDataId : function() {
    		return this.certificateJoin.certificateRequestId;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		domClass.add(topDiv, "refNodeOfPositionAbsolute certificateRequestShowTopDiv");
    		
    		// Date
    		DOMHelper.createTextNode("div", i18n.certificateRequestDateLabel, topDiv, "propertyLabel certificateRequestShowDateLabel");
     		this.dateSpinner = new DateTimeSpinBox({
			           label : i18n.certificateRequestDateLabel,
			           title : i18n.certificateRequestDateToolTip,
			         pattern : i18n.dateWithSecondsPattern,
			        timeZone : this.applicationContext.getTimeZone(),
			        disabled : true
     		});
     		domClass.add(this.dateSpinner.domNode, "fixedDialogWidget certificateRequestShowDateSpinner");
     		domConstruct.place(this.dateSpinner.domNode, topDiv);    		
    		
     		// Challenge1
    		DOMHelper.createTextNode("div", i18n.certificateRequestChallengeOneLabel, topDiv, "propertyLabel certificateRequestShowChallengeOneLabel");
    		this.challengeOneTextBox = new TextBox({
    			label : i18n.certificateRequestChallengeOneLabel,
    			title : i18n.certificateRequestChallengeOneToolTip,
    			disabled : true
    		});
    		domClass.add(this.challengeOneTextBox.domNode, "fixedDialogWidget certificateRequestShowChallengeOneTextBox");
    		domConstruct.place(this.challengeOneTextBox.domNode, topDiv);
    		
    		// Challenge2
    		DOMHelper.createTextNode("div", i18n.certificateRequestChallengeTwoLabel, topDiv, "propertyLabel certificateRequestShowChallengeTwoLabel");
    		this.challengeTwoTextBox = new TextBox({
    			label : i18n.certificateRequestChallengeTwoLabel,
    			title : i18n.certificateRequestChallengeTwoToolTip,
    			disabled : true
    		});
    		domClass.add(this.challengeTwoTextBox.domNode, "fixedDialogWidget certificateRequestShowChallengeTwoTextBox");
    		domConstruct.place(this.challengeTwoTextBox.domNode, topDiv); 
    		
    		// Mail Address
    		DOMHelper.createTextNode("div", i18n.certificateRequestMailLabel, topDiv, "propertyLabel certificateRequestShowMailLabel");
    		this.mailAddressTextBox = new TextBox({
    			label : i18n.certificateRequestMailLabel,
    			title : i18n.certificateRequestMailToolTip,
    			disabled : true
    		});
    		domClass.add(this.mailAddressTextBox.domNode, "fixedDialogWidget certificateRequestShowMailTextBox");
    		domConstruct.place(this.mailAddressTextBox.domNode, topDiv);

    		// SendInvitationMail button
			if (this.administrateCertificateRight){
	    		this.sendInvitationMailButton = new Button({
			           title : i18n.certificateRequestSendMailAgainToolTip,
			       baseClass : "cdesWebButton17x18",
			       iconClass : "cdesWebButton17x18 sendMailButton"
	    		});
	    		on(this.sendInvitationMailButton, "click", lang.hitch(this, function() {
	    			this.askSendInvitationMail(3);
	    		}));
	    		domClass.add(this.sendInvitationMailButton.domNode, "fixedDialogWidget certificateRequestShowMailButton");
	    		domConstruct.place(this.sendInvitationMailButton.domNode, topDiv); 
    		
	    		// PDF Version of Invitation only if userPolicyPath is not set
/*	    		if (this.userPolicyPath == null || this.userPolicyPath.length==0){
		    		this.downloadInvitationPdfButton = new Button({
				           title : i18n.certificateRequestPdfToolTip,
				       baseClass : "cdesWebButton17x18",
				       iconClass : "cdesWebButton17x18 exportToPdfButton"
		    		});
		    		on(this.downloadInvitationPdfButton, "click", lang.hitch(this, function() {
		    			this.exportInvitationPdf();
		    		}));
		    		domClass.add(this.downloadInvitationPdfButton.domNode, "fixedDialogWidget certificateRequestShowPdfButton");
		    		domConstruct.place(this.downloadInvitationPdfButton.domNode, topDiv);
	    		}
*/	    		     		
			}
    		
    		// Mail Address UserPolicy
	    	if (this.userPolicyPath != null && this.userPolicyPath.length>0){
		    	DOMHelper.createTextNode("div", i18n.certificateRequestUserPolicyMailLabel, topDiv, "propertyLabel certificateRequestUserPolicyMailLabel");
	    		this.mailAddressUserPolicyTextBox = new TextBox({
	    			label : i18n.certificateRequestUserPolicyMailLabel,
	    			title : i18n.certificateRequestUserPolicyMailToolTip,
	    			disabled : true
	    		});
	    		domClass.add(this.mailAddressUserPolicyTextBox.domNode, "fixedDialogWidget certificateRequestUserPolicyMailTextBox");
	    		domConstruct.place(this.mailAddressUserPolicyTextBox.domNode, topDiv);
		    	
		    	// SendUserPolicyMail button
				if (this.administrateCertificateRight){
		    		this.sendUserPolicyMailButton = new Button({
				           title : i18n.certificateRequestSendUserPolicyMailAgainToolTip,
				       baseClass : "cdesWebButton17x18",
				       iconClass : "cdesWebButton17x18 sendMailButton"
		    		});
		    		on(this.sendUserPolicyMailButton, "click", lang.hitch(this, function() {
		    			this.askSendInvitationMail(2);
		    		}));
		    		domClass.add(this.sendUserPolicyMailButton.domNode, "fixedDialogWidget certificateRequestShowUserPolicyMailButton");
		    		domConstruct.place(this.sendUserPolicyMailButton.domNode, topDiv); 
	    		}
    		}
    		return topDiv;
    	},

    	setData : function(certificateJoin) {
    		this.certificateJoin = certificateJoin;
    		this.reload();
    	},
    	
    	reload : function() {
    		if (this.certificateJoin.certificateRequestCreated != null) {
    			this.dateSpinner.setUtcSeconds(this.certificateJoin.certificateRequestCreated, this.applicationContext.getTimeZone());	
    		}    		
    		this.challengeOneTextBox.set("value", this.certificateJoin.certificateRequestChallenge1);
    		this.challengeTwoTextBox.set("value", this.certificateJoin.certificateRequestChallenge2);
    		this.mailAddressTextBox.set("value", this.certificateJoin.organisationPersonEmailAddress);
    		if (this.userPolicyPath != null && this.userPolicyPath.length>0)
    			this.mailAddressUserPolicyTextBox.set("value", this.certificateJoin.organisationPersonEmailAddress);
    	},
    	
    	updateDataFromWidgets : function() {
    		// Nothing to do here
    	},
    	
    	askSendInvitationMail : function(type) {
    		InfoDialog.showQuestion({
  			  title : type==3?i18n.certificateRequestAskSendInvitationCaption:i18n.certificateRequestAskSendUserPolicyCaption,
  			message : type==3?i18n.certificateRequestAskSendInvitationQuestion:i18n.certificateRequestAskSendUserPolicyQuestion,
  			buttons : [
  			           { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
  			        	   this.sendInvitationMail(type);
  			           })},    			           
  			           { type : InfoDialog.Button.NO }
  			           ]
    		});    		
    	},    	

    	sendInvitationMail : function(type) {
       		var certificateService = this.applicationContext.getService("certificateService");
       		
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		this.registerAsyncOperationStarted(CertificateRequestShowWidget.AsyncOperation.SEND_INVITATION_MAIL);       		

    		var deferred = certificateService.sendCertificateInvitationMail(organisationPersonId, this.certificateJoin.certificateId, this.certificateJoin.certificateRequestId, type);
    		deferred.then(lang.hitch(this, function() {
    			this.registerAsyncOperationFinished(CertificateRequestShowWidget.AsyncOperation.SEND_INVITATION_MAIL);
    			
    			topic.publish("message/ok", type==3?i18n.certificateRequestSendInvitationMailOk:certificateRequestSendUserPolicyMailOk);
    			
				delete deferred;
    		}),
   			lang.hitch(this, function(err) {    			
				delete deferred;
				
		        ErrorHelper.processAsyncError({
  		                       err : err,
  		                    widget : this,
                    asyncOperation : CertificateRequestShowWidget.AsyncOperation.SEND_INVITATION_MAIL,
	                        opName : "sendCertificateInvitationMail",
                           message : i18n.certificateRequestSendInvitationMailFailed
		        });				
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling sendCertificateInvitationMail: ", err);
    		}));     		
    	},
    	
    	exportInvitationPdf : function() {
   			var parameters = ioQuery.objectToQuery({
   				service : "OOo2PDFService/1/ShowCreatedInvitationOOo/pdf/editOrganisationPerson/Zertifikatseinladung",
   				     sp : this.certificateJoin.certificateRequestId,
				     ts : dojoConfig.tabSessionId
   			});

       		var url = "/cdes/app?" + parameters;
       		window.open(url);     			
    	},
		//userPolicyPdf
/*    	exportUserPolicyPdf : function() {
	   			var parameters = ioQuery.objectToQuery({
   				service : "/cdes/svc/userPolicy",
   				     sp : this.certificateJoin.certificateRequestCreatedFor,
				     ts : dojoConfig.tabSessionId
   			});
       		var url = "/cdes/app?" + parameters;
       		window.open(url);     	
    	},
*/     	
   });
    
    CertificateRequestShowWidget.AsyncOperation = {
    	SEND_INVITATION_MAIL : "SendInvitationMail"
    };
    
    return CertificateRequestShowWidget;
});