define([ 
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/dateTime/DateHelper",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/DisableButton",
    	 "clazzes/widgets/layout/InfoDialog",
         "cdes/core/CdesVoc",
         "cdes/plot/PlotOrderItemListWidgetOld",
         "cdes/util/NameHelper",
         "cdes/util/JobHelper",
         "cdes/widget/AddressShowWidget",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/string",
         "dojo/on",
         "dojo/io-query",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 topic,
    		 DateHelper,
    		 DOMHelper,
    		 ErrorHelper,
    		 ContentWidget,
    		 DisableButton,
    		 InfoDialog,
    		 CdesVoc,
    		 PlotOrderItemListWidgetOld,
    		 NameHelper,
    		 JobHelper,
    		 AddressShowWidget,
    		 domClass,
    		 domConstruct,
    		 string,
    		 on,
    		 ioQuery,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plot.PlotOrderEditWidget";

	var log = new TinyLog(className);
	
    var PlotOrderEditWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();

    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlotOrderEditWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		
    		// Billing Address
    		this.billingAddressWidget = new AddressShowWidget({
    			     applicationContext : this.applicationContext,
    			           nameProperty : "billingAddressOrganisationName",
    			  postalAddressProperty : "billingAddressPostalAddress",
    			     postalCodeProperty : "billingAddressPostalCode",
    			   localityNameProperty : "billingAddressLocalityName",
    			        countryProperty : "billingCountryDescDe"
    		});
    		this.billingAddressDiv = this.billingAddressWidget.getContainer();
    		domClass.add(this.billingAddressDiv, "plotOrderEditBillingAddressDiv");
    		domConstruct.place(this.billingAddressDiv, topDiv);
    		
    		// Plotter
    		this.plotterAddressWidget = new AddressShowWidget({
			     applicationContext : this.applicationContext,
			           nameProperty : "plotterName",
			  postalAddressProperty : "plotterPostalAddress",
			     postalCodeProperty : "plotterPostalCode",
			   localityNameProperty : "plotterLocalityName",
			        countryProperty : "plotterCountryDescDe"
    		});
    		this.plotterAddressDiv = this.plotterAddressWidget.getContainer();
    		domClass.add(this.plotterAddressDiv, "plotOrderEditPlotterAddressDiv");
    		domConstruct.place(this.plotterAddressDiv, topDiv);   
    		
    		// Network
    		this.networkDiv = DOMHelper.createTextNode("div", "", topDiv, "plotOrderEditNetworkLabel");
    		domConstruct.place(this.networkDiv, topDiv);
    		
    		// Project
    		this.projectDiv = DOMHelper.createTextNode("div", "", topDiv, "plotOrderEditProjectLabel");
    		domConstruct.place(this.projectDiv, topDiv);
    		
    		// Date
    		var requestCreatedDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(requestCreatedDiv, "plotOrderEditProjectRequestCreatedDiv");
    		DOMHelper.createTextNode("span", i18n.plotOrderEditRequestCreatedLabel, requestCreatedDiv, "plotOrderEditProjectRequestCreatedCaption");
    		this.requestCreatedDateSpan = DOMHelper.createTextNode("span", "", requestCreatedDiv, "plotOrderEditProjectRequestCreatedLabel");
    		
    		// Client code
    		var clientCodeDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(clientCodeDiv, "plotOrderEditProjectClientCodeDiv");
    		DOMHelper.createTextNode("span", i18n.plotOrderEditClientCodeLabel, clientCodeDiv, "plotOrderEditProjectClientCodeCaption");
    		this.clientCodeSpan = DOMHelper.createTextNode("span", "", clientCodeDiv, "plotOrderEditProjectClientCodeLabel");
    		
    		// Job number
    		var jobNumberDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(jobNumberDiv, "plotOrderEditProjectJobNumberDiv");
    		DOMHelper.createTextNode("span", i18n.plotOrderEditJobNumberLabel, jobNumberDiv, "plotOrderEditProjectJobNumberCaption");
    		this.jobNumberSpan = DOMHelper.createTextNode("span", "", jobNumberDiv, "plotOrderEditProjectJobNumberLabel");     	
    		
    		// Item caption
    		var itemDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(itemDiv, "plotOrderEditItemDiv");
    		var itemCaption = DOMHelper.createTextNode("span", i18n.plotOrderEditItemCaption, itemDiv, "plotOrderEditItemCaption");

    		// Download zip- archive Button
    		//TODO: check
//    		var orderJoin = this.getSomePlotOrderJoin();
//    		if (orderJoin != null && orderJoin.acceptanceStepId != null && orderJoin.acceptanceStepAcceptedMode == CdesVoc.OrderStepMode.ACCEPTED) {
	    		this.zipExportButton = this.constructZipExportButton();
	    		domConstruct.place(this.zipExportButton.domNode, itemDiv); 
//    		}
    		
    		// CheckAndCreatePlotTask Button
            if (this.applicationContext.isActionAllowedForProject("superAdminRight", { globalContext : true })) {
	    		this.checkAndCreatePlotTaskButton = this.constructCheckAndCreatePlotTaskButton();
	    		domConstruct.place(this.checkAndCreatePlotTaskButton.domNode, itemDiv); 
    		}

    		// List Widget
    		this.listWidget = new PlotOrderItemListWidgetOld({
    			applicationContext : this.applicationContext
    		});
    		this.listWidgetDiv = this.listWidget.getContainer();
    		domConstruct.place(this.listWidgetDiv, topDiv);
    		
            this.listWidget.restoreColumnWidths();

    		// Legend below List Widget
    		this.constructDocumentVersionStatusLegend(topDiv);
    		
    		// Billing Address
    		DOMHelper.createTextNode("div", i18n.plotOrderEditBillingAddressLabel, topDiv, "plotOrderEditBillingAddressLabel");
    		
    		// Delivery Date
    		DOMHelper.createTextNode("div", i18n.plotOrderEditDeliveryDateLabel, topDiv, "plotOrderEditDeliveryDateLabel");
    		
    		// Kind of Delivery
    		var kindOfDeliveryDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(kindOfDeliveryDiv, "plotOrderEditKindOfDeliveryDiv");
    		DOMHelper.createTextNode("span", i18n.plotOrderEditKindOfDeliveryLabel, kindOfDeliveryDiv, "plotOrderEditKindOfDeliveryCaption");
    		this.kindOfDeliverySpan = DOMHelper.createTextNode("span", "", kindOfDeliveryDiv, "plotOrderEditKindOfDeliveryLabel");
    		
    		// Comment
    		var commentDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(commentDiv, "plotOrderEditCommentDiv");
    		DOMHelper.createTextNode("span", i18n.plotOrderEditCommentLabel, commentDiv, "plotOrderEditCommentCaption");
    		this.commentSpan = DOMHelper.createTextNode("span", "", commentDiv, "plotOrderEditCommentLabel");
    		
    		// Order Confirmation
    		DOMHelper.createTextNode("div", i18n.plotOrderEditOrderConfirmationCaption, topDiv, "plotOrderEditOrderConfirmationCaption");
    		DOMHelper.createTextNode("div", i18n.plotOrderEditOrderReceiptCaption, topDiv, "plotOrderEditOrderReceiptCaption");
    		
    		this.receiptPersonDiv = DOMHelper.createTextNode("div", i18n.plotOrderEditReceiptPerson, topDiv, "invisible plotOrderEditReceiptPersonLabel");
    		this.receiptDecisionDiv = DOMHelper.createTextNode("div", i18n.plotOrderEditReceiptDecision, topDiv, "invisible plotOrderEditReceiptDecisionLabel");
    		this.receiptCommentDiv = DOMHelper.createTextNode("div", i18n.plotOrderEditReceiptComment, topDiv, "invisible plotOrderEditReceiptCommentLabel");
    		
    		DOMHelper.createTextNode("div", i18n.plotOrderEditOrderCompletionCaption, topDiv, "plotOrderEditOrderCompletionCaption");
    		this.completionPersonDiv = DOMHelper.createTextNode("div", i18n.plotOrderEditCompletionPerson, topDiv, "invisible plotOrderEditCompletionPersonLabel");
    		this.completionDecisionDiv = DOMHelper.createTextNode("div", i18n.plotOrderEditCompletionDecision, topDiv, "invisible plotOrderEditCompletionDecisionLabel");
    		this.completionCommentDiv = DOMHelper.createTextNode("div", i18n.plotOrderEditCompletionComment, topDiv, "invisible plotOrderEditCompletionCommentLabel");    		
    		
    		return topDiv;    		
    	},
    	
    	constructDocumentVersionStatusLegend : function(topDiv) {
    		var legendDiv = domConstruct.create("div", null, topDiv);
    		domClass.add(legendDiv, "plotOrderEditDocumentVersionStatusDiv");
    		
    		DOMHelper.createTextNode("span", i18n.documentVersionStatusULegendExample, legendDiv, "smallFont documentVersionStatusU");
    		DOMHelper.createTextNode("span", i18n.documentVersionStatusULegendLabel, legendDiv, "smallFont plotOrderEditStatusULabel");
    		DOMHelper.createTextNode("span", i18n.documentVersionStatusXLegendExample, legendDiv, "smallFont documentVersionStatusX");
    		DOMHelper.createTextNode("span", i18n.documentVersionStatusXLegendLabel, legendDiv, "smallFont plotOrderEditStatusXLabel");    		
    		this.numberOfDatasetsSpan = DOMHelper.createTextNode("span", i18n.entries, legendDiv, "smallFont plotOrderEditCountLabel");    		
    		
    		return legendDiv;    		
    	},
    	
    	constructZipExportButton : function() {
       	 	var zipExportButton = new DisableButton({
	 	    	        label : i18n.plotOrderListZipExportButtonCaption,
	 	    	    showLabel : false,
	 		            title : i18n.plotOrderListZipExportButtonToolTip,
		              onClick : lang.hitch(this, function() {
		            	  this.triggerZipExport();
		              }),
		            iconClass : "downloadIcon",
		              "class" : "cdesWebButton17x18 gridButton",
             controllerWidget : this,
                 disableEvent : "disableButtons",
             _destroyOnRemove : true
       	 	});    		
    		return zipExportButton;    		
    	},
    	
    	constructCheckAndCreatePlotTaskButton : function() {
            return new DisableButton({
                           label : i18n.checkAndCreatePlotTaskCaption,
                       showLabel : false,
                         tooltip : i18n.checkAndCreatePlotTaskCaption,
		              	 onClick : lang.hitch(this, function() {
		            	  		this.checkAndCreatePlotTask();
		              	  }),
                       iconClass : "repairIcon",
                		 "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });   		
    	},
    	
    	setData : function(plotOrderId) {
    		this.plotOrderId = plotOrderId;
    		return this.reload();
    	},
    	
    	reload : function() {
    		this.registerAsyncOperationStarted(PlotOrderEditWidget.AsyncOperation.GET_DATA);
    		
    		var plotService = this.applicationContext.getService("plotService");
    		
    		// If the previous search still runs, cancel it
    		if (this.joinDeferred != null) {
    			this.joinDeferred.cancel();
    		}
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();    		
    		
    		this.joinDeferred = plotService.getPlotOrderEditJoin(this.plotOrderId, organisationPersonId);
    		this.joinDeferred.then(lang.hitch(this, function(plotOrderEditJoins) {
    			
    			this.plotOrderEditJoins = plotOrderEditJoins;
    			topic.publish("message/ok", string.substitute(i18n.plotOrderEditGetDataOk, {
    				numberOfItems : plotOrderEditJoins.length
    			}));
    			
    			this.updateWidgetsFromData();
    			
				delete this.joinDeferred;
				
	    		this.registerAsyncOperationFinished(PlotOrderEditWidget.AsyncOperation.GET_DATA);
    		}),
   			lang.hitch(this, function(err) {    			
				delete this.joinDeferred;
   				ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : PlotOrderEditWidget.AsyncOperation.GET_DATA,
                            opName : "getPlotOrderEditJoin",
                           message : i18n.plotOrderEditGetDataFailed
   				});  				
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling getPlotOrderEditJoin: ", err);
    		}));
    		
    		return this.joinDeferred;
    	},
    	
    	getSomePlotOrderJoin : function() {
    		var orderJoin = this.plotOrderEditJoins != null && this.plotOrderEditJoins.length > 0 ? this.plotOrderEditJoins[0] : null;
    		return orderJoin;
    	},
    	
    	triggerZipExport : function() {
    		var plotService = this.applicationContext.getService("plotService");
    		
			topic.publish("message/info", i18n.plotOrderListExportPlotOrderStarted);

    		this.registerAsyncOperationStarted(PlotOrderEditWidget.AsyncOperation.EXPORT_PLOT_ORDER);
    		
//    		joinDto = 
    		
    		var projectId = this.applicationContext.getPageContextProjectId();
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var personVariablesUserLocale = this.applicationContext.getPageContextPersonVariablesUserLocale();
    		
    		// TODO: Pass additional data for privilege check    		
    		plotService.triggerExportCompletePlotOrder(organisationPersonId, projectId, this.plotOrderId, personVariablesUserLocale).then(lang.hitch(this, function(jobId) {
    			// TODO: Treat the case that the jobStatus code throws an exception correctly.  Currently, it will log the error, but
    			// *not* jump into the ErrorHelper code below.
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.plotOrderListExportPlotOrderFinished);
					var parameterString = ioQuery.objectToQuery({
						jobId : jobId
					});
					return "/cdes-dojo-impl/download?" + parameterString;
				});
				this.registerAsyncOperationFinished(PlotOrderEditWidget.AsyncOperation.EXPORT_PLOT_ORDER);
			}),
			lang.hitch(this, function(err) {
   				ErrorHelper.processAsyncError({
                             err : err,
                          widget : this,
                  asyncOperation : PlotOrderEditWidget.AsyncOperation.EXPORT_PLOT_ORDER,
                          opName : "triggerExportCompletePlotOrder",
                         message : i18n.plotOrderListExportPlotOrderFailed
   				});    				
			})
		).otherwise(lang.hitch(this, function(err) {
			log.error("Error while processing the results of a call to triggerExportCompletePlotOrder: ", err);
		}));     		
    	},
    	
    	checkAndCreatePlotTask : function() {
            InfoDialog.showQuestion({
                  title : i18n.checkAndCreatePlotTaskCaption,
                message : i18n.checkAndCreatePlotTaskCaptionToolTip,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doCheckAndCreatePlotTask();
                    })},                                    
                    { type : InfoDialog.Button.NO }
                ]
            });             
		},	
			
    	doCheckAndCreatePlotTask : function() {
    		var plotService = this.applicationContext.getService("plotService");
    		
			topic.publish("message/info", i18n.plotOrderListExportPlotOrderStarted);

    		this.registerAsyncOperationStarted(PlotOrderEditWidget.AsyncOperation.CHECKCREATE_PLOT_TASK);
    		var projectId = this.applicationContext.getPageContextProjectId();
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var personVariablesUserLocale = this.applicationContext.getPageContextPersonVariablesUserLocale();
    		
    		this.joinDeferred = plotService.checkAndCreatePlotTask(organisationPersonId, projectId, this.plotOrderId, personVariablesUserLocale);
    		this.joinDeferred.then(lang.hitch(this, function(result) {
    			
    			topic.publish("message/ok",result);
    			
				delete this.joinDeferred;
				
	    		this.registerAsyncOperationFinished(PlotOrderEditWidget.AsyncOperation.CHECKCREATE_PLOT_TASK);
    		}),
   			lang.hitch(this, function(err) {    			
				delete this.joinDeferred;
   				ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : PlotOrderEditWidget.AsyncOperation.CHECKCREATE_PLOT_TASK,
                            opName : "checkAndCreatePlotTask",
                           message : i18n.plotOrderEditGetDataFailed
   				});  				
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing checkAndCreatePlotTask: ", err);
    		}));
    		
    		return this.joinDeferred;
  		
    	},
    	
    	updateWidgetsFromData : function() {
    		// The pieces of data that correspond to the PlotOrder (which is the same in all joinDtos),
    		// not to one of the individual PlotOrderItems
    		var orderJoin = this.getSomePlotOrderJoin();
    		
    		this.billingAddressWidget.setData(orderJoin);
    		this.plotterAddressWidget.setData(orderJoin);
    		
    		DOMHelper.setInnerText(this.networkDiv, string.substitute(i18n.plotOrderEditNetworkLabel, {
    			networkName : orderJoin.networkName
    		}));
    		DOMHelper.setInnerText(this.projectDiv, string.substitute(i18n.plotOrderEditProjectLabel, {
    			projectCode : orderJoin.projectCode,
    			projectName : orderJoin.projectName
    		}));    	
    		
    		var requestCreatedString = orderJoin.requestStepCreated != null 
					? DateHelper.formatUtcSecondsWithTimeZone(orderJoin.requestStepCreated, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern)
					: "";
    		DOMHelper.setInnerText(this.requestCreatedDateSpan, requestCreatedString);
    		
    		DOMHelper.setInnerText(this.clientCodeSpan, orderJoin.billingAddressClientCode ? orderJoin.billingAddressClientCode : "");
    		DOMHelper.setInnerText(this.jobNumberSpan, orderJoin.plotOrderJobNumber ? orderJoin.plotOrderJobNumber : "");
    		
    		this.listWidget.setData({ data : this.plotOrderEditJoins });
    		
    		DOMHelper.setInnerText(this.numberOfDatasetsSpan, this.plotOrderEditJoins.length + ' ' + i18n.entries);    
    		
    		DOMHelper.setInnerText(this.kindOfDeliverySpan, orderJoin.plotOrderKindOfDelivery ? orderJoin.plotOrderKindOfDelivery : "");
    		DOMHelper.setInnerText(this.commentSpan, orderJoin.plotOrderComment ? orderJoin.plotOrderComment : "");    
    		
    		if (orderJoin.acceptanceStepFinished != null) {
    			var personName = orderJoin.acceptancePersonId != null ? NameHelper.getPersonCommonName(orderJoin, "acceptancePerson") : "";
    			DOMHelper.setInnerText(this.receiptPersonDiv, string.substitute(i18n.plotOrderEditReceiptPerson, {
    				  date : DateHelper.formatUtcSecondsWithTimeZone(orderJoin.acceptanceStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern),
    				person : personName
    			}));
    			
    			var decision;
    			if (orderJoin.acceptanceStepAcceptedMode == CdesVoc.OrderStepMode.ACCEPTED) {
    				decision = i18n.accepted;
    			} else if (orderJoin.acceptanceStepAcceptedMode == CdesVoc.OrderStepMode.DECLINED) {
    				decision = i18n.declined;
    			} else {
    				decision = "-";
    			}
    			DOMHelper.setInnerText(this.receiptDecisionDiv, string.substitute(i18n.plotOrderEditReceiptDecision, {
    				decision : decision
    			}));
    			
    			DOMHelper.setInnerText(this.receiptCommentDiv, string.substitute(i18n.plotOrderEditReceiptComment, {
    				comment : orderJoin.acceptanceStepComment ? orderJoin.acceptanceStepComment : ""
    			}));
    			domClass.replace(this.receiptPersonDiv, "visible", "invisible");
    			domClass.replace(this.receiptDecisionDiv, "visible", "invisible");
    			domClass.replace(this.receiptCommentDiv, "visible", "invisible");
    		} else {
    			domClass.replace(this.receiptPersonDiv, "invisible", "visible");
    			domClass.replace(this.receiptDecisionDiv, "invisible", "visible");
    			domClass.replace(this.receiptCommentDiv, "invisible", "visible");
    		}
    		
    		if (orderJoin.completedStepFinished != null) {
    			var personName = orderJoin.completedPersonId != null ? NameHelper.getPersonCommonName(orderJoin, "completedPerson") : "";
    			DOMHelper.setInnerText(this.completionPersonDiv, string.substitute(i18n.plotOrderEditCompletionPerson, {
    				  date : DateHelper.formatUtcSecondsWithTimeZone(orderJoin.completedStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern),
    				person : personName
    			}));
    			
    			var decision;
    			if (orderJoin.completedStepAcceptedMode == CdesVoc.OrderStepMode.ACCEPTED) {
    				decision = i18n.ok;
    			} else if (orderJoin.completedStepAcceptedMode == CdesVoc.OrderStepMode.DECLINED) {
    				decision = i18n.notOk;
    			} else {
    				decision = "-";
    			}
    			DOMHelper.setInnerText(this.completionDecisionDiv, string.substitute(i18n.plotOrderEditCompletionDecision, {
    				decision : decision
    			}));
    			
    			DOMHelper.setInnerText(this.completionCommentDiv, string.substitute(i18n.plotOrderEditCompletionComment, {
    				comment : orderJoin.completedStepComment ? orderJoin.completedStepComment : ""
    			}));
    			domClass.replace(this.completionPersonDiv, "visible", "invisible");
    			domClass.replace(this.completionDecisionDiv, "visible", "invisible");
    			domClass.replace(this.completionCommentDiv, "visible", "invisible");
    		} else {
    			domClass.replace(this.completionPersonDiv, "invisible", "visible");
    			domClass.replace(this.completionDecisionDiv, "invisible", "visible");
    			domClass.replace(this.completionCommentDiv, "invisible", "visible");
    		}    		
    	},
    	
    	destroy : function() {
    		this.inherited(arguments);
    		this.listWidget.destroy();
    	}    	
    });
    
    PlotOrderEditWidget.AsyncOperation = {
    		GET_DATA : "GetData",
        	EXPORT_PLOT_ORDER : "ExportPlotOrder",
        	CHECKCREATE_PLOT_TASK : "CheckAndCreatePlotTask"
    };    
    
    return PlotOrderEditWidget;
});
