define([
         "clazzes/TinyLog",
         "clazzes/util/DOMHelper",
         "dojo/dom-construct",
         "dojo/_base/declare",
         "dojo/_base/lang"
    ], 
    function (
    	 TinyLog,
    	 DOMHelper,
    	 domConstruct,
    	 declare, 
    	 lang
    ) {
	
	var className = "at.cdes.web.plot.PlotOrderItemListSummaryRow";

	var log = new TinyLog(className);
	
    var PlotOrderItemListSummaryRow = declare(className, null, {
        showFooter: true,
 
        buildRendering: function () {
            this.inherited(arguments);
 
            var areaNode = this.summaryAreaNode =
                domConstruct.create("div", {
                    className: "summary-row",
                    role: "row",
                    style: { overflow: "hidden" }
                }, this.footerNode);
            
            // Keep horizontal alignment in sync
            this.on('scroll', lang.hitch(this, function () {
                areaNode.scrollLeft = this.getScrollPosition().x;
            }));            
        },
        

        _renderSummaryCell: function (item, cell, column) {
            var value = item[column.field] || '';
            
            var topNode = domConstruct.create("div", null, null);
            var tokens = value.split("<br>");
            for (var n = 0; n < tokens.length; n++) {
            	DOMHelper.createTextNode("span", tokens[n], topNode);
            	if (n < tokens.length - 1) {
            		domConstruct.create("br", null, topNode);
            	}
            }

            cell.appendChild(topNode);
        },
        
        _setSummary: function (data) {
            var tableNode = this.summaryTableNode;
         
            this.summary = data;
         
            // Remove any previously-rendered summary row
            if (tableNode) {
                domConstruct.destroy(tableNode);
            }
            
            tableNode = this.summaryTableNode = this.createRowCells("td", lang.hitch(this, "_renderSummaryCell", data));            
         
            this.summaryAreaNode.appendChild(tableNode);
            
            // Force resize processing, in case summary row's height changed
            if (this._started) {
                this.resize();
            }
        }        
    });
    
    return PlotOrderItemListSummaryRow;
});