define([ 
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/util/WidgetFactory",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/CheckBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/Evented",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         TinyLog,
         DOMHelper,
         WidgetFactory,
         WidgetHelper,
         IconTitlePane,
         ContentWidget,
         CheckBox,
         domClass,
         domConstruct,
         Evented,
         on,
         declare,
         lang,
         i18n
         ) {
    
    var className = "at.cdes.web.project.ProjectParticipationColumnWidget";

    var log = new TinyLog(className);
    
    var ProjectParticipationColumnWidget = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.topDiv = this.constructTopDiv();
            this.updateTitlePane();
            
            this.allFieldsValid = true;
        },
        
        getWidgetId : function() {
            return "ProjectParticipationColumnWidget";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute participationColumnTopDivReduced");
            
            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);
            
            return topDiv;
        },
        
        updateTitlePane : function() {
            var open = this.titlePane.get("open");
            if (open) {
                this.titlePane.set("title", i18n.columnOpenCaption);
                domClass.replace(this.topDiv, "participationColumnTopDivFull", "participationColumnTopDivReduced");
            } else {
                this.titlePane.set("title", i18n.columnClosedCaption);
                domClass.replace(this.topDiv, "participationColumnTopDivReduced", "participationColumnTopDivFull");
            }                   
        },
        
        postTitleClick : function() {
            this.updateTitlePane();
            on.emit(this, "titlePaneToggled");
        },
        
        constructTitlePane : function() {
            var columnDiv = this.constructColumnDiv();
            
            var titlePane = new IconTitlePane({
                       title   : i18n.participationColumnOpenCaption,
                       content : columnDiv,
                    toggleable : true,
                          open : false,
                      duration : 0,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "occupyWholeParent");
            
            return titlePane;
        },
        
        constructColumnDiv : function() {
            var columnDiv = domConstruct.create("div", null, null);
            domClass.add(columnDiv, "refNodeOfPositionAbsolute participationColumnDiv");

            this.networkCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.networkLabel,
                         title : i18n.networkLabel,
                    labelClass : "participationColumnNetworkLabel",
                   widgetClass : "participationColumnNetworkCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.projectCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.project,
                         title : i18n.project,
                    labelClass : "participationColumnProjectLabel",
                   widgetClass : "participationColumnProjectCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.organisationCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.organisationLabel,
                         title : i18n.organisationLabel,
                    labelClass : "participationColumnOrganisationLabel",
                   widgetClass : "participationColumnOrganisationCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.cdesRoleCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnRoleLabel,
                         title : i18n.participationColumnRoleLabel,
                    labelClass : "participationColumnCdesRoleLabel",
                   widgetClass : "participationColumnCdesRoleCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.participantCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnParticipantLabel,
                         title : i18n.participationColumnParticipantLabel,
                    labelClass : "participationColumnParticipantLabel",
                   widgetClass : "participationColumnParticipantCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.mainParticipantCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnMainParticipantLabel,
                         title : i18n.participationColumnMainParticipantLabel,
                    labelClass : "participationColumnMainParticipantLabel",
                   widgetClass : "participationColumnMainParticipantCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;                                    

            this.subProjectCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.subProject,
                         title : i18n.subProject,
                    labelClass : "participationColumnSubProjectLabel",
                   widgetClass : "participationColumnSubProjectCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.objectReleaseCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.object,
                         title : i18n.object,
                    labelClass : "participationColumnObjectReleaseLabel",
                   widgetClass : "participationColumnObjectReleaseCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.objectPlannerReleaseCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.objectPlanner,
                         title : i18n.objectPlanner,
                    labelClass : "participationColumnObjectPlannerReleaseLabel",
                   widgetClass : "participationColumnObjectPlannerReleaseCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.objectPlannerPositionDefinitionCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnObjectPlannerPositionDefinitionLabel,
                         title : i18n.participationColumnObjectPlannerPositionDefinitionLabel,
                    labelClass : "participationColumnObjectPlannerPositionDefinitionLabel",
                   widgetClass : "participationColumnObjectPlannerPositionDefinitionCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.reviewCycleInstanceReleasedCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnReviewCycleInstanceLabel,
                         title : i18n.participationColumnReviewCycleInstanceLabel,
                    labelClass : "participationColumnReviewCycleInstanceReleasedLabel",
                   widgetClass : "participationColumnReviewCycleInstanceReleasedCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.reviewCycleCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnReviewCycleLabel,
                         title : i18n.participationColumnReviewCycleLabel,
                    labelClass : "participationColumnReviewCycleLabel",
                   widgetClass : "participationColumnReviewCycleCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.reviewCycleCellCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.reviewCycleCell,
                         title : i18n.reviewCycleCell,
                    labelClass : "participationColumnReviewCycleCellLabel",
                   widgetClass : "participationColumnReviewCycleCellCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.reviewCycleNodeCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.reviewCycleNode,
                         title : i18n.reviewCycleNode,
                    labelClass : "participationColumnReviewCycleNodeLabel",
                   widgetClass : "participationColumnReviewCycleNodeCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;

            this.realmCheckBox = WidgetFactory.constructCheckBox({
                    parentNode : columnDiv,
                         label : i18n.participationColumnRealmLabel,
                         title : i18n.participationColumnRealmLabel,
                    labelClass : "participationColumnRealmLabel",
                   widgetClass : "participationColumnRealmCheckBox",
                          mode :  WidgetFactory.PlacementMode.ABSOLUTE,
                usePropertyDiv : false,
                 eventCallback : lang.hitch(this, this.emitColumnsChanged)
            }).widget;                                                
            
            return columnDiv;
        },
        
        emitColumnsChanged : function() {
            this.updateDataFromWidgets();

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.applicationContext.storeInLocalStorage([organisationPersonId], "/participation/columns", this.columnSettings);
            on.emit(this, "columnsChanged");
        },
        
        setData : function(columnSettings) {
            this.columnSettings = columnSettings;
            this.reload();
        },
        
        reload : function() {
            this.updateWidgetsFromData();
        },
        
        updateWidgetsFromData : function() {
            this.networkCheckBox.set("checked", this.columnSettings.showNetwork);
            this.projectCheckBox.set("checked", this.columnSettings.showProject);
            this.organisationCheckBox.set("checked", this.columnSettings.showOrganisation);
            this.cdesRoleCheckBox.set("checked", this.columnSettings.showCdesRole);
            this.participantCheckBox.set("checked", this.columnSettings.showParticipant);
            this.mainParticipantCheckBox.set("checked", this.columnSettings.showMainParticipant);
            this.subProjectCheckBox.set("checked", this.columnSettings.showSubProject);
            this.objectReleaseCheckBox.set("checked", this.columnSettings.showObjectRelease);
            this.objectPlannerReleaseCheckBox.set("checked", this.columnSettings.showObjectPlannerRelease);
            this.objectPlannerPositionDefinitionCheckBox.set("checked", this.columnSettings.showObjectPlannerPositionDefinition);
            this.reviewCycleInstanceReleasedCheckBox.set("checked", this.columnSettings.showReviewCycleInstanceReleased);
            this.reviewCycleCheckBox.set("checked", this.columnSettings.showReviewCycle);
            this.reviewCycleCellCheckBox.set("checked", this.columnSettings.showReviewCycleCell);
            this.reviewCycleNodeCheckBox.set("checked", this.columnSettings.showReviewCycleNode);
            this.realmCheckBox.set("checked", this.columnSettings.showRealm);
        },

        updateDataFromWidgets : function() {
            this.columnSettings.showNetwork = this.networkCheckBox.get("checked");
            this.columnSettings.showProject = this.projectCheckBox.get("checked");
            this.columnSettings.showOrganisation = this.organisationCheckBox.get("checked");
            this.columnSettings.showCdesRole = this.cdesRoleCheckBox.get("checked");
            this.columnSettings.showParticipant = this.participantCheckBox.get("checked");
            this.columnSettings.showMainParticipant = this.mainParticipantCheckBox.get("checked");
            this.columnSettings.showSubProject = this.subProjectCheckBox.get("checked");
            this.columnSettings.showObjectRelease = this.objectReleaseCheckBox.get("checked");
            this.columnSettings.showObjectPlannerRelease = this.objectPlannerReleaseCheckBox.get("checked");
            this.columnSettings.showObjectPlannerPositionDefinition = this.objectPlannerPositionDefinitionCheckBox.get("checked");
            this.columnSettings.showReviewCycleInstanceReleased = this.reviewCycleInstanceReleasedCheckBox.get("checked");
            this.columnSettings.showReviewCycle = this.reviewCycleCheckBox.get("checked");
            this.columnSettings.showReviewCycleCell = this.reviewCycleCellCheckBox.get("checked");
            this.columnSettings.showReviewCycleNode = this.reviewCycleNodeCheckBox.get("checked");
            this.columnSettings.showRealm = this.realmCheckBox.get("checked");
        },
        
        getColumnSettings : function() {
            this.updateDataFromWidgets();
            return this.columnSettings;
        }
    });
    
    return ProjectParticipationColumnWidget;
});
