/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = personPage
////i18n-prefix = personPage


define(["cdes/core/CdesVoc",
        "cdes/person/PersonListWidget",
        "cdes/person/PersonSearchWidget",
        "cdes/util/SearchPageHelper",
        "cdes/widget/ContextBar",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/GridHelper",
        "clazzes/util/JobHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/Button",
        "dijit/form/CheckBox",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",       
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         CdesVoc,
         PersonListWidget,
         PersonSearchWidget,
         SearchPageHelper,
         ContextBar,
         TinyLog,
         DateHelper,
         FancyButton,
         topic,
         DOMHelper,
         ErrorHelper,
         GridHelper,
         JobHelper,
         WidgetHelper,
         ContentWidget,
         Button,
         CheckBox,
         TextBox,
         domClass,
         domConstruct,
         domStyle,
         ioQuery,
         on,             
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.person.PersonPage";

    var log = new TinyLog(className);

    var PersonPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;

            var networkService = this.applicationContext.getService("networkService");
            networkService.getAllNetworks().then(
                lang.hitch(this, function(networks) {
                    this.registerAsyncOperationFinished(PersonPage.AsyncOperation.GET_NETWORKS);

                    this.searchWidget.setNetworks(networks);

	            	this.loadSearchInfo();
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonPage.AsyncOperation.GET_NETWORKS,
                                opName : "getAllNetworks",
                               message : i18n.consortiumPageGetAllNetworksFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getAllNetworks]", err);
                    }));
        },

        getWidgetId : function() {
            return "PersonPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Context Bar
/*            this.contextBar = new ContextBar({
                applicationContext : this.applicationContext,
                              mode : ContextBar.Mode.DEFAULT
            });
            this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
            this.contextBarDiv = this.contextBar.getContainer();
            domClass.add(this.contextBarDiv, "personPageContextBarDiv");
            domConstruct.place(this.contextBarDiv, topDiv); 
*/
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.personPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            return captionBarDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.exportToPdfButtonCaption,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);

            return button;
        },

        constructNewButton : function(captionBarDiv) {
            var newButton = new FancyButton({ 
                label : i18n.personPageNewButtonCaption,
                title : i18n.personPageNewButtonToolTip
            });
            domClass.add(newButton.domNode, "textButton personPageNewPersonButton");
            domConstruct.place(newButton.domNode, captionBarDiv);

            on(newButton, "click", lang.hitch(this, this.addNewPerson));
            return newButton;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute wholeRegion");

            // Search Widget
            this.searchWidget = new PersonSearchWidget({
                applicationContext : this.applicationContext
            });
            this.searchWidgetDiv = this.searchWidget.getContainer();
            domConstruct.place(this.searchWidgetDiv, contentDiv);
            on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));                   
            on(this.searchWidget, "doSearch", lang.hitch(this, this.setData));
            on(this.searchWidget, "doReloadSearchInfo", lang.hitch(this, this.doReloadSearchInfo));
            
            // Status Bar
            this.statusBarTable = domConstruct.create("table", null, null);
            domClass.add(this.statusBarTable, "personPageStatusBarTable");
            domConstruct.place(this.statusBarTable, contentDiv);

            this.statusBarRow = domConstruct.create("tr", null, null);
            domConstruct.place(this.statusBarRow, this.statusBarTable);

            this.statusCell = DOMHelper.createTextNode("td", i18n.notYetSearched, this.statusBarRow, "personPageStatusCell");

            this.filterCell = domConstruct.create("td", null, null);
            domClass.add(this.filterCell, "personPageFilterCell");
            domConstruct.place(this.filterCell, this.statusBarRow);

            // Show details Checkbox
            this.showDetailsCheckBox = new CheckBox({
                label : i18n.personSearchShowDetailsLabel,
                title : i18n.personSearchShowDetailsToolTip,
            });
            domClass.add(this.showDetailsCheckBox.domNode, "personPageShowDetailsCheckBox");
            domConstruct.place(this.showDetailsCheckBox.domNode, this.filterCell);
            WidgetHelper.handleCheckBoxEvents(this.showDetailsCheckBox, lang.hitch(this, this.handleShowDetailsChange));

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldColumnSettings = this.applicationContext.getFromLocalStorage([organisationPersonId], "/person/columnSettings");
            this.showDetailsCheckBox.set("checked", oldColumnSettings != null && !!oldColumnSettings.showProject);

            // Filter label
            DOMHelper.createTextNode("div", i18n.personSearchShowDetailsLabel, this.filterCell, "personPageShowDetailsLabel");

            // Filter textbox
            this.quickSearchTextBox = new TextBox({
                label : i18n.quickSearchLabel,
                title : i18n.quickSearchToolTip
            });
            domClass.add(this.quickSearchTextBox.domNode, "personPageQuickSearchTextBox");
            domConstruct.place(this.quickSearchTextBox.domNode, this.filterCell);
            WidgetHelper.handleTextBoxEvents(this.quickSearchTextBox, lang.hitch(this, this.processQuickSearchChange));
            
            // List Widget
            this.listWidget = new PersonListWidget({
                applicationContext : this.applicationContext,
                          backPage : "personList",
                        backParams : new Object()
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domClass.add(this.listWidgetDiv, "fixedDialogWidget listWidget");       
            domConstruct.place(this.listWidgetDiv, contentDiv);
            // Reload data after certain operations which change state have been performed
            on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

            this.listWidget.restoreColumnWidths();
            this.handleShowDetailsChange();

            return contentDiv;
        },

        handleShowDetailsChange : function() {
            var showDetails = this.showDetailsCheckBox.get("checked");
            this.listWidget.setShowDetails(showDetails);
            this.quickSearchTextBox.set("disabled", !showDetails);            
        },        

        processQuickSearchChange : function() {
            var quickSearchContent = this.quickSearchTextBox.get("value");
            this.listWidget.setProjectRoleFilter(quickSearchContent);
        },        

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;                   

            var tableHeight = totalHeight
                            //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                            - this.captionBarDiv.offsetHeight
                            - this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
                            - this.statusBarTable.offsetHeight
                            - 16;
            this.listWidget.resize({ h : tableHeight });
        },

        loadSearchInfo : function() {
            this.doReloadSearchInfo(true);
        },

        doReloadSearchInfo : function(checkAutoLoad) {
            var networkId = this.searchWidget.getSelectedNetworkId();
            if (networkId == CdesVoc.MagicSelectOption.ALL) {
                networkId = null;
            }

            DOMHelper.setInnerText(this.statusCell, i18n.searchBeingInitialized);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(PersonPage.AsyncOperation.LOAD_SEARCH_INFO);
            var personService = this.applicationContext.getService("personService");
            personService.getPersonSearchInfo(organisationPersonId, networkId).then(
                lang.hitch(this, function(searchInfo) {
                    this.registerAsyncOperationFinished(PersonPage.AsyncOperation.LOAD_SEARCH_INFO);

                    if (log.isDebugEnabled()) {
                        log.debug("Successfully queried personSearchInfo for networkId [" + networkId + "]");
                    }
				    
	                this.administratedNetworks = searchInfo.administratedNetworks;
                    this.searchWidget.setSearchInfo(searchInfo, networkId);
	                this.listWidget.setAdministratedNetworks(searchInfo.administratedNetworks);
                    this.networkActions = searchInfo.networkActions;
                    this.certificateAdministrationGlobal = searchInfo.certificateAdministrationGlobal;
					this.globalActions = new Object();
					for (var n = 0; n < searchInfo.globalActions.length; n++) {
						this.globalActions[searchInfo.globalActions[n]] = true;
					}                        

                    if (this.exportToPdfButton == null && this.networkActions != null
                        && ("editPerson" in this.networkActions || "showPerson" in this.networkActions)) {
                        this.exportToPdfButton = this.constructExportToPdfButton(this.captionBarDiv);
                    }
//                    this.exportToPdfButton = this.constructExportToPdfButton(this.captionBarDiv);
                    
                    //if (this.newButton == null && this.networkActions != null && "editPerson" in this.networkActions) {
		            if (this.newButton == null && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 		|| !this.certificateAdministrationGlobal && this.administratedNetworks != null && this.administratedNetworks.length > 0)) {
                        this.newButton = this.constructNewButton(this.captionBarDiv);
                    }
                    //cameBack is set via this.applicationContext.popLastPageHistoryPage({ cameBack : true});
					if (checkAutoLoad && (searchInfo.enableAutoInitSearch || this.cameBack))
				    	this.reload();
			    	else if (checkAutoLoad)
						DOMHelper.setInnerText(this.statusCell, i18n.notYetSearched);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonPage.AsyncOperation.LOAD_SEARCH_INFO,
                                opName : "getPersonSearchInfo",
                               message : i18n.personPageGetSearchInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPersonSearchInfo]", err);
                }));
        },

        cloneAndConvertSearchModelForServer : function(searchModel) {
            return {
                organisationPersonId : searchModel.organisationPersonId,
                showInvalidPersons :   searchModel.showInvalidPersons,
                            personId : searchModel.personId != CdesVoc.MagicSelectOption.ALL ? searchModel.personId : null,
                                name : searchModel.name,
                      organisationId : searchModel.organisationId != CdesVoc.MagicSelectOption.ALL
                                                                   ? searchModel.organisationId : null,
                        organisation : searchModel.organisation,
                           networkId : searchModel.networkId != CdesVoc.MagicSelectOption.ALL ? searchModel.networkId : null,
                         networkName : searchModel.networkName,
                           projectId : searchModel.projectId != CdesVoc.MagicSelectOption.ALL ? searchModel.projectId : null,
                             project : searchModel.project,
                          cdesRoleId : searchModel.cdesRoleId != CdesVoc.MagicSelectOption.ALL ? searchModel.cdesRoleId : null,
                                role : searchModel.role
            };
        },

        setData : function() {
            this.reload();
            if (this.searchWidget.getNetworkChanged())
           		this.doReloadSearchInfo();
        },

        reload : function() {
            this.registerAsyncOperationStarted(PersonPage.AsyncOperation.LOAD);

            this.quickSearchTextBox.set("value", "");

            DOMHelper.setInnerText(this.statusCell, i18n.searchRuns);
            var prevSeconds = DateHelper.getCurrentTimeSeconds();

            var searchModel = this.searchWidget.getSearchModel();
	    	var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    	this.applicationContext.storeInLocalStorage([organisationPersonId], "/personList/search", searchModel);
            
            searchModelRPC = this.cloneAndConvertSearchModelForServer(searchModel);
            var personService = this.applicationContext.getService("personService");
            personService.getPersonJoins(searchModelRPC).then(
                lang.hitch(this, function(personInfo) {
                    this.registerAsyncOperationFinished(PersonPage.AsyncOperation.LOAD);

                    var postSeconds = DateHelper.getCurrentTimeSeconds();
                    var searchInfoString = this.getSearchInfoString(personInfo);
                    topic.publish("message/ok", searchInfoString);
                    DOMHelper.setInnerText(this.statusCell, searchInfoString);

                    this.listWidget.setData({
                        personInfo : personInfo,
                        certificateAdministrationGlobal : this.certificateAdministrationGlobal,
                        globalActions : this.globalActions
                    });
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonPage.AsyncOperation.LOAD,
                                opName : "getPersonJoins",
                               message : i18n.personPageLoadDataFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPersonJoins]", err);
                    }));
        },

        getSearchInfoString : function(personInfo) {
            var persons = personInfo.persons;
            var numberOfPersons = (persons != null ? persons.length : 0);
            return string.substitute(i18n.personPageSearchResult, {
                count : numberOfPersons
            });
        },
        /*
        processQuickSearchChange : function() {
            var newSearch = this.quickSearchTextBox.get("value");
            if (newSearch != this.lastQuickSearch) {
                this.listWidget.filter(newSearch);
                this.lastQuickSearch = newSearch;
            }
        },
        
        clearQuickSearch : function() {
            this.quickSearchTextBox.set("value", "", false);
            this.processQuickSearchChange();
        },*/

        updateWidgetState : function() {
            var asyncRunning = this.isAsyncOperationRunning();
            if (this.searchWidget != null) {
                this.searchWidget.setAsyncRunning(asyncRunning);
            }
        },

        exportToPdf : function() {
            var columnToWidth = this.listWidget.getColumnToWidth();
            var personService = this.applicationContext.getService("personService");
            var sortSpecs = this.listWidget.getSortSpecs({ pdf : true });
            var searchModel = this.searchWidget.getSearchModel();
            topic.publish("message/info", i18n.personPagePdfExportStarted);

            var showDetails = this.showDetailsCheckBox.get("checked");

            searchModelRPC = this.cloneAndConvertSearchModelForServer(searchModel);            

            this.registerAsyncOperationStarted(PersonPage.AsyncOperation.EXPORT_TO_PDF);
            personService.triggerExportPersonList(searchModelRPC, showDetails, columnToWidth, sortSpecs).then(
                lang.hitch(this, function(jobId) {
                    JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
                        topic.publish("message/ok", i18n.personPagePdfExportFinished);

                        var parameterString = ioQuery.objectToQuery({
                            jobId : jobId
                        });
                        return "/cdes-dojo-impl/download?" + parameterString;
                    });
                    
                    this.registerAsyncOperationFinished(PersonPage.AsyncOperation.EXPORT_TO_PDF);
                }), lang.hitch(this, function(err){                             
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonPage.AsyncOperation.EXPORT_TO_PDF,
                                opName : "triggerExportPersonList",
                               message : i18n.personPagePdfExportFailed
                    });                             
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Handling the results of executing triggerExportPersonList failed", err);
                    }));
        },

        addNewPerson : function() {
            this.applicationContext.setPage("personEdit",
                                            { mode : ContentWidget.Mode.CREATE,
                     	     administratedNetworks : this.getNetworkIdsList(this.administratedNetworks)},
                                            null, "personList", null);
        },
                  
        getNetworkIdsList : function(networks) {
            var networkIdsList = [];
            if (networks != null) {
				for (var n = 0; n < networks.length; n++) {
	                var networkId = networks[n].id;                
	                if (!(networkId in networkIdsList))
	                    networkIdsList.push(networkId);
                }
            }
            return networkIdsList;
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    PersonPage.AsyncOperation = {
        EXPORT_TO_PDF : "ExportToPdf",
        GET_NETWORKS : "GetNetworks",
        LOAD : "Load",
        LOAD_SEARCH_INFO : "LoadSearchInfo"
    };

    return PersonPage;
});
