/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationOrderEdit
////i18n-prefix = planningNotificationOrderEdit



define([ "cdes/planning/order/PlanningNotificationOrderEditWidget",
	"cdes/planning/util/PlanningNotificationHelper",
	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/form/MultiWidget",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
	"dijit/form/Button",
	"dijit/form/CheckBox",
	"dijit/form/ComboBox",
	"dijit/form/Select",
	"dijit/form/SimpleTextarea",
	"dijit/form/Textarea",
	"dijit/form/ValidationTextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(PlanningNotificationOrderEditWidget,
			PlanningNotificationHelper,
			ContextBar,
			TinyLog,
			DateTimeSpinBox,
			MultiWidget,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			InfoDialog,
			Button,
			CheckBox,
			ComboBox,
			Select,
			SimpleTextarea,
			Textarea,
			ValidationTextBox,
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderEditPage";

	var log = new TinyLog(className);

	var PlanningNotificationOrderEditPage = declare(className, ContentWidget, {

		// Remaining TODOs:
		// - event handling (do the setter-functions trigger events triggering updateWidgetState?)	
		// - hide tags Select depending on project config

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			this.loadEditInfo();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderEditPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		loadEditInfo : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();

			this.registerAsyncOperationStarted(PlanningNotificationOrderEditPage.AsyncOperation.LOAD_EDIT_INFO);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			var filterProjects = (this.mode == ContentWidget.Mode.CREATE);
			planningNotificationService.getPlanningNotificationOrderSearchInfo(organisationPersonId, networkId, filterProjects, [ "editPlanningNotificationOrder" ]).then(
					lang.hitch(this, function(editInfo) {		    
						this.registerAsyncOperationFinished(PlanningNotificationOrderEditPage.AsyncOperation.LOAD_EDIT_INFO);

						this.editWidget.setEditInfo(editInfo);
						this.projectIdToEditableProject = editInfo.projectIdToEditableProject;
						this.projectIdToAllowedActions = editInfo.projectIdToAllowedActions;
						this.reload();
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderEditPage.AsyncOperation.LOAD_EDIT_INFO,
							opName : "getPlanningNotificationOrderEditInfo",
							message : i18n.planningNotificationOrderEditWidgetGetEditInfoFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationOrderEditInfo]", err);
							}));
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentParentDiv = this.constructContentDiv();
			domConstruct.place(this.contentParentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationOrderEditCreateCaption, captionBarDiv, "cdesGeneralPageCaption");

			// Save button
			this.saveButton = new Button({
				label : i18n.saveAndExitButtonCaption,
				title : i18n.planningNotificationOrderEditSaveToolTip
			});
			domClass.add(this.saveButton.domNode, "planningNotificationOrderEditSaveButton");
			domConstruct.place(this.saveButton.domNode, captionBarDiv);

			on(this.saveButton, "click", lang.hitch(this, function() {
				this.askSavePlanningNotificationOrder(false);
			}));		

			// Save and define workflow button
			this.saveAndDefineWorkflowButton = new Button({
				label : i18n.planningNotificationOrderSaveDefineWorkflowButtonCaption,
				title : i18n.planningNotificationOrderSaveDefineWorkflowToolTip
			});
			domClass.add(this.saveAndDefineWorkflowButton.domNode, "planningNotificationOrderEditSaveDefineWorkflowButton");
			domConstruct.place(this.saveAndDefineWorkflowButton.domNode, captionBarDiv);

			on(this.saveAndDefineWorkflowButton, "click", lang.hitch(this, function() {
				this.save(true);
			}));		

			// Abort button
			this.abortButton = new Button({
				label : i18n.abortButtonCaption
				/*     		 title : i18n.abortToolTip */       // Removed on ÖBB request
			});
			domClass.add(this.abortButton.domNode, "planningNotificationOrderEditAbortButton");
			domConstruct.place(this.abortButton.domNode, captionBarDiv);
			on(this.abortButton, "click", lang.hitch(this, this.abort));

			return captionBarDiv;
		},	

        askSavePlanningNotificationOrder : function(gotoDefineWorkflow) {
			var planningNotificationIdChanged = (this.mode != ContentWidget.Mode.CREATE && 
								this.orderJoin.planningNotificationId != WidgetHelper.getSelectValue(this.editWidget.planningNotificationSelect));
			if (planningNotificationIdChanged) {
	            InfoDialog.showQuestion({
	                  title : i18n.planningNotificationOrderEditAskSaveDialogCaption,
	                message : i18n.planningNotificationOrderEditAskSaveDialogQuestion,
	                buttons : [
	                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
	                        this.save(gotoDefineWorkflow);
	                    })},                                       
	                    { type : InfoDialog.Button.NO }
	                ]
	            });    
            } else
            	this.save(gotoDefineWorkflow);
        },

		save : function(gotoDefineWorkflow) {
			this.orderJoin = this.editWidget.getData();

			PlanningNotificationHelper.saveOrUpdatePlanningNotificationOrder({
				applicationContext : this.applicationContext,
				widget : this,
				mode : this.mode,
				asyncOperation : PlanningNotificationOrderEditPage.AsyncOperation.SAVE,
				orderJoin : this.orderJoin,
				callbackFct : lang.hitch(this, function(workflowEntityId) {
					if (gotoDefineWorkflow) {
						this.applicationContext.setPage("defineWorkflow",
								{ id : workflowEntityId },
								{ backPage : "planningNotificationOrderList", backParams : new Object() });		       
					} else if (this.backPage != null) {
						this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
					}
				})			   
			});		
		},

		abort : function() {
			if (this.backPage != null) {
				this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
			}                                    
		},

		constructContentDiv : function() {
			var contentParentDiv = domConstruct.create("div", null, null);
			domClass.add(contentParentDiv, "refNodeOfPositionAbsolute planningNotificationOrderEditContentParentDiv");

			this.editWidget = new PlanningNotificationOrderEditWidget({
				applicationContext : this.applicationContext,
				mode : this.mode		
			});		
			on(this.editWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));

			var contentDiv = this.editWidget.getContainer();
			domClass.add(contentDiv, "fixedDialogWidget planningNotificationOrderEditContentDiv");
			domConstruct.place(contentDiv, contentParentDiv);	    

			return contentParentDiv;
		},

		resize : function(newSize) {
			var totalHeight = newSize.h;

			var contentHeight = totalHeight
			//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			- 16;

			domStyle.set(this.contentParentDiv, "height", contentHeight + "px");
		},

		setData : function() {

		},

		reload : function() {
			//this.contextBar.reload();

			if (this.mode == ContentWidget.Mode.CREATE) {
				this.orderJoin = PlanningNotificationHelper.createEmptyPlanningNotificationOrderJoin();

				this.editWidget.setData({
					orderJoin : this.orderJoin,
					mayChangePlanningNotification : true,
					initialProjectId : this.initialProjectId,
					initialPlanningNotificationId : this.initialPlanningNotificationId,
					initialPlanningNotificationTitle : this.initialPlanningNotificationTitle,
					projectIdToAllowedActions : this.projectIdToAllowedActions
				});
			} else {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				this.registerAsyncOperationStarted(PlanningNotificationOrderEditPage.AsyncOperation.LOAD);

				planningNotificationService.getPlanningNotificationOrderJoin(this.id, organisationPersonId).then(
						lang.hitch(this, function(planningNotificationOrderInfo) {
							this.orderJoin = planningNotificationOrderInfo.orderJoin;
							this.orderJoin.projectJoins = planningNotificationOrderInfo.projectJoins;
							this.orderJoin.referenceInfos = planningNotificationOrderInfo.referenceInfos;
							this.orderJoin.tags = planningNotificationOrderInfo.tags;
							this.orderJoin.siteTypes = planningNotificationOrderInfo.siteTypes;
							this.workflowInitialized = planningNotificationOrderInfo.workflowInitialized;
							this.workflowHasResults = !(Object.keys(planningNotificationOrderInfo.workflowNodeInitiatorPositionIdToHasResults).length === 0);

							this.editWidget.setData({
								orderJoin : this.orderJoin,
								mayChangePlanningNotification : true,
								projectIdToAllowedActions : this.projectIdToAllowedActions,
								workflowInitialized : this.workflowInitialized,
								workflowHasResults : this.workflowHasResults
							});				
							this.registerAsyncOperationFinished(PlanningNotificationOrderEditPage.AsyncOperation.LOAD);
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationOrderEditPage.AsyncOperation.LOAD,
								opName : "getPlanningNotificationOrderJoin",
								message : i18n.planningNotificationOrderEditGetJoinFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [getPlanningNotificationOrderJoin]", err);
								}));
			}		
		},

		updateWidgetState : function() {
			var projectsOk;
			if (this.mode == ContentWidget.Mode.CREATE) {
				DOMHelper.setInnerText(this.captionDiv, i18n.planningNotificationOrderEditCreateCaption);
//				this.saveButton.set("label", i18n.createButtonCaption);
				this.saveButton.set("title", i18n.planningNotificationOrderEditCreateToolTip);
				this.saveAndDefineWorkflowButton.set("label", i18n.planningNotificationOrderCreateDefineWorkflowButtonCaption);
				this.saveAndDefineWorkflowButton.set("title", i18n.planningNotificationOrderCreateDefineWorkflowToolTip);

				// When creating a planning notification order, only ok projects should be presented.  Thus do not do any check here.
				projectsOk = true;                
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				DOMHelper.setInnerText(this.captionDiv, i18n.planningNotificationOrderEditEditCaption);
//				this.saveButton.set("label", i18n.saveButtonCaption);
				this.saveButton.set("title", i18n.planningNotificationOrderEditSaveToolTip);
				this.saveAndDefineWorkflowButton.set("label", i18n.planningNotificationOrderSaveDefineWorkflowButtonCaption);
				this.saveAndDefineWorkflowButton.set("title", i18n.planningNotificationOrderSaveDefineWorkflowToolTip);

				var projectJoins = this.orderJoin != null && this.orderJoin.projectJoins != null ? this.orderJoin.projectJoins : [];
				projectsOk = false;
				for (var n = 0; n < projectJoins.length; n++) {
					if (this.projectIdToEditableProject != null && projectJoins[n].projectId in this.projectIdToEditableProject) {
						projectsOk = true;
					}                    
				}                
			} else {
				throw new Error("Mode [" + this.mode + "] is not supported.");
			}

			var allFieldsValid = this.editWidget.isValid() && projectsOk;
			this.saveButton.set("disabled", !allFieldsValid);
			this.saveAndDefineWorkflowButton.set("disabled", !allFieldsValid);
		},



		destroy : function() {
			this.inherited(arguments);
			this.editWidget.destroy();
		}
	});

	PlanningNotificationOrderEditPage.AsyncOperation = {
			LOAD_EDIT_INFO : "LoadEditInfo",
			LOAD : "Load",
			SAVE : "Save"	
	};

	return PlanningNotificationOrderEditPage;
});
