/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationOrderPage
////i18n-prefix = planningNotificationOrderPage


define(["cdes/core/CdesVoc",
	"cdes/planning/order/PlanningNotificationOrderColumnWidget",
	"cdes/planning/order/PlanningNotificationOrderListWidget",
	"cdes/planning/order/PlanningNotificationOrderSearchWidget",
	"cdes/util/ColumnHelper",
	"cdes/widget/ContextBar",
	"cdes/widget/msp/MspProjectChooseDialog",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateHelper",
	"clazzes/form/FancyButton",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/DataHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/GridHelper",
	"clazzes/util/JobHelper",
	"clazzes/widgets/layout/ChooseDialog",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dijit/form/Button",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/io-query",
	"dojo/on",   
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			PlanningNotificationOrderColumnWidget,
			PlanningNotificationOrderListWidget,
			PlanningNotificationOrderSearchWidget,
			ColumnHelper,
			ContextBar,
			MspProjectChooseDialog,
			TinyLog,
			DateHelper,
			FancyButton,
			topic,
			DOMHelper,
			DataHelper,
			ErrorHelper,
			GridHelper,
			JobHelper,
			ChooseDialog,
			ContentWidget,
			InfoDialog,
			Button,                
			domClass,
			domConstruct,
			domStyle,
			ioQuery,
			on,
			string,             
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderPage";

	var log = new TinyLog(className);

	var PlanningNotificationOrderPage = declare(className, ContentWidget, {

		constructor : function(params) {
			// Remaining TODOs:
			// - search by enter
			// - disabling while async operations are running
			// - input validation
			// - showing some of the m:n relations in grid (see TODOs in list widget)
			// - sorting in grid
			// - tab order
			// - explicitely query for union clause in extra join
			// - show tags only for SBTN projects            

			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			this.reloadSearchInfo();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		getColumnWidget : function() {
			return this.columnWidget;           
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Context Bar
/*			this.contextBar = new ContextBar({
				applicationContext : this.applicationContext,
				mode : ContextBar.Mode.PLANNING_NOTIFICATION,
				editable : true
			});
			this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
			this.contextBarDiv = this.contextBar.getContainer();
			domConstruct.place(this.contextBarDiv, topDiv);
*/			
			topic.subscribe("context/change", lang.hitch(this, function() {
				var networkId = this.applicationContext.getPageContextPnNetworkId();
				if (this.lastPageContextPnNetworkId != null && this.lastPageContextPnNetworkId != networkId) {
					this.searchWidget.clearSearchFields();

					var searchModel = this.searchWidget.getSearchModel();
					var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
					searchModel.timestamp = DateHelper.getCurrentTimeSeconds();                     

					this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search", searchModel);            
				}

				this.lastPageContextPnNetworkId = networkId;
				this.reloadSearchInfo();
			}));                

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Search Widget
			this.searchWidget = new PlanningNotificationOrderSearchWidget({
				applicationContext : this.applicationContext
			});
			this.searchWidgetDiv = this.searchWidget.getContainer();
			domConstruct.place(this.searchWidgetDiv, topDiv);
			on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));               
			on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));

			// Column Widget
			this.columnWidget = new PlanningNotificationOrderColumnWidget({
				applicationContext : this.applicationContext
			});
			this.columnWidgetDiv = this.columnWidget.getContainer();
			domConstruct.place(this.columnWidgetDiv, topDiv);
			on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.resize));
			on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));

			// List Widget
			this.listWidget = new PlanningNotificationOrderListWidget({
				applicationContext : this.applicationContext,
				backPage : "planningNotificationOrderList",
				backParams : new Object(),
				showActions : true                 
			});

			this.listWidgetDiv = this.listWidget.getContainer();
			domConstruct.place(this.listWidgetDiv, topDiv);

			// Reload data after certain operations which change state have been performed
			on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

			return topDiv;
		},

		reloadSearchInfo : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();

			var firstCall = this.lastSearchInfoReloadNetworkId == null;
			if (this.lastSearchInfoReloadNetworkId != networkId) {
				this.lastSearchInfoReloadNetworkId = networkId;                
				this.registerAsyncOperationStarted(PlanningNotificationOrderPage.AsyncOperation.LOAD_SEARCH_INFO);
				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				planningNotificationService.getPlanningNotificationOrderSearchInfo(organisationPersonId, networkId, true).then(
						lang.hitch(this, function(searchInfo) {
							this.registerAsyncOperationFinished(PlanningNotificationOrderPage.AsyncOperation.LOAD_SEARCH_INFO);

							this.searchWidget.setSearchInfo(searchInfo, firstCall);
							this.projectIdToActions = searchInfo.projectIdToAllowedActions;
							//                          this.columnWidget.initialize(metaTags);
							//                          this.listWidget.initialize(metaTags);
							var defaultColumnSettings = ColumnHelper.getDefaultColumnSettingsPN(this.applicationContext, this, null, "planningNotificationOrder/columns");
							this.columnWidget.setData(defaultColumnSettings);

							this.reload();              
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationOrderPage.AsyncOperation.LOAD_SEARCH_INFO,
								opName : "getPlanningNotificationOrderSearchInfo",
								message : i18n.planningNotificationOrderPageGetPlanningNotificationOrderSearchInfoFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [getPlanningNotificationOrderSearchInfo]", err);
								}));
			}
		},            

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationOrderPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			this.constructExportToPdfButton(captionBarDiv);
			this.newButton = this.constructNewButton(captionBarDiv);
			domClass.add(this.newButton.domNode, "hidden");

			// TODO privileges
			if (true) {
				this.exportToMspButton = this.constructExportToMspButton(captionBarDiv);
			}

			return captionBarDiv;
		},

		constructExportToPdfButton : function(captionBarDiv) {
			var button = new FancyButton({
				title : i18n.planningNotificationOrderExportToPdfButtonToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, this.exportToPdf));

			domConstruct.place(button.domNode, captionBarDiv);

			return button;
		},      

		constructNewButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.planningNotificationOrderNewButtonCaption,
				title : i18n.planningNotificationOrderNewButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationOrderNewButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				var selectedProjectId = this.searchWidget.getSelectedProjectId();
				var selectedPlanningNotificationTitle = this.searchWidget.getSelectedPlanningNotificationTitle();                

				this.applicationContext.setPage("planningNotificationOrderEdit",
						{ mode : ContentWidget.Mode.CREATE, initialProjectId : selectedProjectId, initialPlanningNotificationTitle : selectedPlanningNotificationTitle, mayChangePlanningNotification : true },
						{ backPage : "planningNotificationOrderList", backParams : new Object() });
			}));            
			return button;
		},

		constructExportToMspButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.planningNotificationOrderExportToMspButtonCaption,
				title : i18n.planningNotificationOrderExportToMspButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationOrderExportToMspButton hidden");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				this.exportToMsp();
			}));            
			return button;
		},

		exportToPdf : function() {
			var columnToWidth = GridHelper.getColumnToWidth(this.listWidget.grid);

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");

			var sortSpecs = this.listWidget.getSortSpecs();

			var searchModel = this.searchWidget.getSearchModel();
                    searchModel = this.cloneAndConvertSearchModelForServer(searchModel);                    

			topic.publish("message/info", i18n.planningNotificationOrderPdfExportStarted);

			this.registerAsyncOperationStarted(PlanningNotificationOrderPage.AsyncOperation.EXPORT_TO_PDF);
			planningNotificationService.triggerExportPlanningNotificationOrderList(searchModel, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.planningNotificationOrderPdfExportFinished);

					var parameterString = ioQuery.objectToQuery({
						jobId : jobId
					});
					return "/cdes-dojo-impl/download?" + parameterString;
				});

				this.registerAsyncOperationFinished(PlanningNotificationOrderPage.AsyncOperation.EXPORT_TO_PDF);
			}), lang.hitch(this, function(err){                             
				ErrorHelper.processAsyncError({
					err : err,
					widget : this,
					asyncOperation : PlanningNotificationOrderPage.AsyncOperation.EXPORT_TO_PDF,
					opName : "triggerExportPlanningNotificationOrderList",
					message : i18n.planningNotificationOrderExportListFailed
				});                             
			})).otherwise(
					lang.hitch(this, function(err) {
						log.error("Handling the results of executing triggerExportPlanningNotificationOrderList failed", err);
					}));
		},

		exportToMsp : function() {
			var totalOrderCount = this.planningNotificationOrderInfos.length;
			var exportOrderCount = 0;
			var alreadyExportedCount = 0;
			var orderInvalidatedCount = 0;
			for (var n = 0; n < this.planningNotificationOrderInfos.length; n++) {
				var orderJoin = this.planningNotificationOrderInfos[n].orderJoin;
				var statutoryDutyName = orderJoin.statutoryDutyName;
				var expired = orderJoin.planningNotificationOrderStatutoryDutyExpired;
				var alreadyExported = orderJoin.planningNotificationOrderExportedToMsp;
				var orderInvalidated = orderJoin.workflowEntityInvalidated; //Vorgabe entfällt

				// TODO: Control this using a flag
				if (statutoryDutyName != null && statutoryDutyName != "Keine Rechtspflicht" && !expired) {
					if (alreadyExported) {
						alreadyExportedCount++;
					} else if (orderInvalidated){
						orderInvalidatedCount++;
					} else {
						exportOrderCount++;
					}
				}
			}

			if (exportOrderCount == 0) {
				InfoDialog.showWarning({
					title : i18n.planningNotificationOrderMspExportNoneFoundCaption,
					message : i18n.planningNotificationOrderMspExportNoneFoundText
				});
				return;                
			}                

			var chooseDialog = new MspProjectChooseDialog({
				applicationContext : this.applicationContext,
				title : i18n.planningNotificationOrderChooseMspProjectForExportCaption,
				buttons : [ 
					{ type : ChooseDialog.Button.CHOOSE,
						name : "selectButton"/*,
				   label : i18n.workflowNodeEditAddParticipantButtonCaption,
				   title : i18n.workflowNodeEditAddParticipantButtonToolTip*/
					},
					{ type : InfoDialog.Button.ABORT,
						title : i18n.abortToolTip }
					],
					defaultWidth : 500,
					defaultHeight : 200
			});

			on(chooseDialog, "valueChosen", lang.hitch(this, function(mspItem) {
				this.askExportToMsp(mspItem, totalOrderCount, exportOrderCount, alreadyExportedCount, orderInvalidatedCount);
			}));

			chooseDialog.show(null);
		},

		askExportToMsp : function(mspItem, totalOrderCount, exportOrderCount, alreadyExportedCount, orderInvalidatedCount) {
			var summary = string.substitute(i18n.planningNotificationOrderAskExportToMspQuestionSummary, {
				totalCount : totalOrderCount,
				exportCount : exportOrderCount
			});
			var ignoredClause = string.substitute(i18n.planningNotificationOrderAskExportToMspQuestionIgnoredClause, {
				alreadyExportedCount : alreadyExportedCount
			});
			var invalidatedClause = string.substitute(i18n.planningNotificationOrderAskExportToMspQuestionInvalidatedClause, {
				orderInvalidatedCount : orderInvalidatedCount
			});
			var question = i18n.planningNotificationOrderAskExportToMspQuestionQuestion;

			InfoDialog.showQuestion({
				title : i18n.planningNotificationOrderAskExportToMspCaption,
				message : summary + (alreadyExportedCount > 0 ? ignoredClause : "") + (orderInvalidatedCount > 0 ? invalidatedClause : "") + question,
				buttons : [
					{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
						this.doExportToMsp(mspItem);
					})},                        
					{ type : InfoDialog.Button.NO }
					]
			});
		},

		doExportToMsp : function(mspItem) {
			var projectPath = mspItem.path;

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			var workflowEntityIds = [];
			for (var n = 0; n < this.planningNotificationOrderInfos.length; n++) {
				workflowEntityIds.push(this.planningNotificationOrderInfos[n].orderJoin.planningNotificationOrderWorkflowEntityId);
			}                  

			this.registerAsyncOperationStarted(PlanningNotificationOrderPage.AsyncOperation.EXPORT_TO_MSP);
			var mspService = this.applicationContext.getService("mspService");
			mspService.triggerExportPlanningNotificationOrdersToMsp(organisationPersonId, networkId, projectPath, workflowEntityIds).then(
					lang.hitch(this, function(jobId) {
						this.registerAsyncOperationFinished(PlanningNotificationOrderPage.AsyncOperation.EXPORT_TO_MSP);
						this.registerMspExportJobStatusQuery(jobId);

						topic.publish("message/ok", i18n.planningNotificationOrderTriggerMspExportFinished);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderPage.AsyncOperation.EXPORT_TO_MSP,
							opName : "triggerExportToMsp",
							message : i18n.planningNotificationOrderTriggerExportToMspFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [triggerExportToMsp]", err);
							}));            
		},

		registerMspExportJobStatusQuery : function(jobId) {
			var jobStatusService = this.applicationContext.getService("jobStatusService");

			JobHelper.registerJobStatusQueryForGettingResult({
				jobStatusService : jobStatusService,
				jobId : jobId
			}).then(lang.hitch(this, function() {
				topic.publish("message/message", i18n.planningNotificationOrderMspExportFinished);
			}), lang.hitch(this, function(err) {
				topic.publish("message/error", i18n.planningNotificationOrderMspExportFailed, true);
			})).otherwise(function(err) {
				log.error("Handling the results of exporting the planning notification orders to sharepoint failed.", err);
			});            
		},

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationOrderPageContentDiv");

			return contentDiv;
		},

		resize : function(newSize) {
			if (newSize) {
				this.lastNewSize = newSize;
			}

			var totalHeight = this.lastNewSize.h;                   

			var tableWidth = this.captionBarDiv.offsetWidth - 15;
			//              var tableWidth = this.searchWidgetDiv.offsetWidth;
			var tableHeight = totalHeight
			//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
			- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
			//      - this.statusBarDiv.offsetHeight
			- 20;
			this.listWidget.resize({ w : tableWidth, h : tableHeight });
		},

             cloneAndConvertSearchModelForServer : function(searchModel) {
                 var retModel = {
                                            ids : searchModel.id,
                           organisationPersonId : searchModel.organisationPersonId,
                                      networkId : searchModel.networkId,
                                   serialNumber : searchModel.serialNumber,
                                      projectId : searchModel.projectId,
                         planningNotificationId : searchModel.planningNotificationId,
                                  subjectAreaId : searchModel.subjectAreaId != CdesVoc.MagicSelectOption.ALL
                                                                             ? searchModel.subjectAreaId : null,
                                subjectAreaName : searchModel.subjectAreaName,
                                    invalidated : searchModel.invalidated,
                                          state : searchModel.state,
                                      reference : searchModel.reference,
                        environmentallyRelevant : searchModel.environmentallyRelevant,
                                statutoryDutyId : searchModel.statutoryDutyId,
                             allStatutoryDuties : searchModel.allStatutoryDuties,
                                           text : searchModel.text,
                                         baulos : searchModel.baulos,
                            authorizedInspector : searchModel.authorizedInspector,
                          statutoryDutyFromFrom : searchModel.statutoryDutyFromFrom,
                            statutoryDutyFromTo : searchModel.statutoryDutyFromTo,
                            statutoryDutyToFrom : searchModel.statutoryDutyToFrom,
                              statutoryDutyToTo : searchModel.statutoryDutyToTo,
                          statutoryDutyInterval : searchModel.statutoryDutyInterval,
                          statutoryDutyLeadTime : searchModel.statutoryDutyLeadTime,
                           statutoryDutyExpired : searchModel.statutoryDutyExpired,
                                   documentPage : searchModel.documentPage,
                               documentPosition : searchModel.documentPosition,
                                         source : searchModel.source,
                               personInChargeId : searchModel.personInChargeId,
                                           tags : searchModel.tags,
                                submitAuthority : searchModel.submitAuthority,
                                        comment : searchModel.comment,
                                    dueDateFrom : searchModel.dueDateFrom,
                                      dueDateTo : searchModel.dueDateTo,
                                  dueDateRemark : searchModel.dueDateRemark,
                          organisationPersonIds : searchModel.organisationPersonIds,
                 };

                 var entries = searchModel.planningNotificationEntries;
                 var planningNotificationTitles = [];
                 var planningNotificationIds = [];
                 for (var n = 0; n < entries.length; n++) {
                     var entry = entries[n];
                     if (entry.id != CdesVoc.MagicSelectOption.ALL && (entry.title == null || entry.title.trim() != i18n.allOption)) {
                         if (entry.id != null) {
                             planningNotificationIds.push(entry.id);
                         } else if (entry.title != null && entry.title.trim().length > 0) {
                             planningNotificationTitles.push(entry.title);
                         }
                     }
                 }
                 retModel.planningNotificationIds = planningNotificationIds;
                 retModel.planningNotificationTitles = planningNotificationTitles;

                 return retModel;
             },

		setData : function() {

		},

		reload : function() {
			//this.contextBar.reload();
			this.listWidget.setData({ planningNotificationOrderInfos : [], columnSettings : this.columnWidget.getColumnSettings() });

			var searchModel = this.searchWidget.getSearchModel();
			searchModel.timestamp = DateHelper.getCurrentTimeSeconds();             

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search", searchModel);

			// Synchronize project id between planningNotification and planningNotificationOrder search widgets            
			var planningNotificationSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotification/search");
			if (planningNotificationSearchModel == null) {
				planningNotificationSearchModel = new Object();
			}                
			planningNotificationSearchModel.projectId = searchModel.projectId;
		    planningNotificationSearchModel.planningNotificationEntries = searchModel.planningNotificationEntries;
			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/search", planningNotificationSearchModel);
			
			this.adaptReportSearchModelInLocalStorage(organisationPersonId, networkId, searchModel);

			topic.publish("message/info", i18n.searchRuns);

			// Update visibility of new button and export to msp button 
			var anyProjectHasNewAction = false;
			var anyProjectHasExportToMspAction = false;
			if (this.projectIdToActions != null) {
				for (var projectId in this.projectIdToActions) {
					var actions = this.projectIdToActions[projectId];
					if (actions != null) {
						for (var n = 0; n < actions.length; n++) {
							anyProjectHasExportToMspAction |= (actions[n] == "exportPlanningNotificationOrdersMSP");
							anyProjectHasNewAction |= (actions[n] == "editPlanningNotificationOrder");
						}                                    
					}                                
				}
			}

			if (anyProjectHasNewAction) 
				domClass.remove(this.newButton.domNode, "hidden");
			else
				domClass.add(this.newButton.domNode, "hidden");
			                   
			if (anyProjectHasExportToMspAction)
				domClass.remove(this.exportToMspButton.domNode, "hidden");
			else
				domClass.add(this.exportToMspButton.domNode, "hidden");

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);                    

			this.registerAsyncOperationStarted(PlanningNotificationOrderPage.AsyncOperation.LOAD_DATA);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getPlanningNotificationOrderJoins(searchModel).then(
					lang.hitch(this, function(planningNotificationOrderInfos) {
						this.registerAsyncOperationFinished(PlanningNotificationOrderPage.AsyncOperation.LOAD_DATA);

						// Transform from List to Set, for easier handling lateron.
						for (var n = 0; n < planningNotificationOrderInfos.length; n++) {
							var planningNotificationInfo = planningNotificationOrderInfos[n];
							var allowedProjectActionsList = planningNotificationInfo.allowedProjectActions;
							var allowedProjectActionsSet = new Object();
							for (var v = 0; v < allowedProjectActionsList.length; v++) {
								allowedProjectActionsSet[allowedProjectActionsList[v]] = true;
							}

							planningNotificationInfo.allowedProjectActions = allowedProjectActionsSet;
						}                          

						var columnSettings = ColumnHelper.getColumnSettingsForReload(this, searchModel);

						this.planningNotificationOrderInfos = planningNotificationOrderInfos;
						this.listWidget.setData({ 
							planningNotificationOrderInfos : this.planningNotificationOrderInfos,
							columnSettings : columnSettings
						});
						this.updateWidgetState();

						var message = string.substitute(i18n.planningNotificationOrderSearchSuccessful, {
							count : planningNotificationOrderInfos.length
						});

						// Store for the question "Do you really want to export to MSP?"
						this.numberOfPlanningNotificationOrders = this.planningNotificationOrderInfos.length;

						topic.publish("message/ok", message);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderPage.AsyncOperation.LOAD_DATA,
							opName : "getPlanningNotificationOrderJoins",
							message : i18n.planningNotificationOrderPageGetJoinsFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationOrderJoins]", err);
							}));        
		},

		adaptReportSearchModelInLocalStorage : function(organisationPersonId, networkId, searchModel) {
			var reportConfig = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId],
					"/planningNotificationReport/config");

			if (reportConfig == null) {
				reportConfig = {
						options : new Object(),
						data : { notificationSearchModel : new Object(), orderSearchModel : new Object(), columnSettings : new Object() }
				};
			}            

			reportConfig.options.projectId = searchModel.projectId;
			reportConfig.data.notificationSearchModel.planningNotificationEntries = searchModel.planningNotificationEntries;
			reportConfig.data.notificationSearchModel.projectId = searchModel.projectId;
			reportConfig.data.orderSearchModel.serialNumber = searchModel.serialNumber;
			reportConfig.data.orderSearchModel.subjectAreaName = searchModel.subjectAreaName;
			reportConfig.data.orderSearchModel.invalidated = searchModel.invalidated;
			reportConfig.data.orderSearchModel.state = searchModel.state;
			reportConfig.data.orderSearchModel.reference = searchModel.reference;
			reportConfig.data.orderSearchModel.statutoryDutyId = searchModel.statutoryDutyId;
			reportConfig.data.orderSearchModel.text = searchModel.text;
			reportConfig.data.orderSearchModel.baulos = searchModel.baulos;
			reportConfig.data.orderSearchModel.authorizedInspector = searchModel.authorizedInspector;
			reportConfig.data.orderSearchModel.statutoryDutyFromFrom = searchModel.statutoryDutyFromFrom;
			reportConfig.data.orderSearchModel.statutoryDutyFromTo = searchModel.statutoryDutyFromTo;
			reportConfig.data.orderSearchModel.statutoryDutyToFrom = searchModel.statutoryDutyToFrom;
			reportConfig.data.orderSearchModel.statutoryDutyToTo = searchModel.statutoryDutyToTo;
			reportConfig.data.orderSearchModel.statutoryDutyInterval = searchModel.statutoryDutyInterval;
			reportConfig.data.orderSearchModel.statutoryDutyLeadTime = searchModel.statutoryDutyLeadTime;
			reportConfig.data.orderSearchModel.statutoryDutyExpired = searchModel.statutoryDutyExpired;
			reportConfig.data.orderSearchModel.documentPage = searchModel.documentPage;
			reportConfig.data.orderSearchModel.documentPosition = searchModel.documentPosition;         
			reportConfig.data.orderSearchModel.source = searchModel.source;
			reportConfig.data.orderSearchModel.personInChargeId = searchModel.personInChargeId;
			reportConfig.data.orderSearchModel.tags =  searchModel.tags;
			reportConfig.data.orderSearchModel.environmentallyRelevant = searchModel.environmentallyRelevant;       
			reportConfig.data.orderSearchModel.submitAuthority = searchModel.submitAuthority;
			reportConfig.data.orderSearchModel.comment = searchModel.comment;

			reportConfig.data.columnSettings.showSerialNumber = true;
			reportConfig.data.columnSettings.showText = true;
			reportConfig.data.columnSettings.showProject = true;
			reportConfig.data.columnSettings.showTitle = true;      

			reportConfig.data.columnSettings.showSubjectArea = searchModel.subjectAreaName != null && searchModel.subjectAreaName.length > 0;       
			reportConfig.data.columnSettings.showInvalidated = searchModel.invalidated != null;
			reportConfig.data.columnSettings.showState = searchModel.state != null && searchModel.state != CdesVoc.WHATEVER;        
			reportConfig.data.columnSettings.showReference = searchModel.reference != null && searchModel.reference.length > 0;
			reportConfig.data.columnSettings.showStatutoryDuty = searchModel.statutoryDutyId != null && searchModel.statutoryDutyId != CdesVoc.WHATEVER;
			reportConfig.data.columnSettings.showAuthorizedInspector = searchModel.authorizedInspector != null && searchModel.authorizedInspector.length > 0;       
			reportConfig.data.columnSettings.showStatutoryDutyFrom = searchModel.statutoryDutyFromFrom != null || searchModel.statutoryDutyFromTo != null;
			reportConfig.data.columnSettings.showStatutoryDutyTo = searchModel.statutoryDutyToFrom != null || searchModel.statutoryDutyToTo != null;        
			reportConfig.data.columnSettings.showStatutoryDutyInterval = searchModel.statutoryDutyInterval != null;
			reportConfig.data.columnSettings.showStatutoryDutyLeadTime = searchModel.statutoryDutyLeadTime != null;         
			reportConfig.data.columnSettings.showStatutoryDutyExpired = searchModel.statutoryDutyExpired != null;
			reportConfig.data.columnSettings.showEnvironmentallyRelevant = searchModel.environmentallyRelevant != null;
			reportConfig.data.columnSettings.showDocumentPage = searchModel.documentPage != null && searchModel.documentPage.length > 0;
			reportConfig.data.columnSettings.showDocumentPosition = searchModel.documentPosition != null && searchModel.documentPosition.length > 0;
			reportConfig.data.columnSettings.showSource = searchModel.source != null && searchModel.source.length > 0;
			reportConfig.data.columnSettings.showPersonInCharge = searchModel.personInChargeId != null && searchModel.personInChargeId != CdesVoc.WHATEVER;
			reportConfig.data.columnSettings.showTags = searchModel.tags != null && searchModel.tags.length > 0;
			reportConfig.data.columnSettings.showSubmitAuthority = searchModel.submitAuthority != null;
			reportConfig.data.columnSettings.showOrderComment = searchModel.comment != null && searchModel.comment.length > 0;      

			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationReport/config", reportConfig);                     
		},

		updateWidgetState : function() {
		    if (this.exportToMspButton != null) {
			var orderJoins = this.listWidget.getOrderJoins();
			var projectIds = new Object();
			for (var n = 0; n < orderJoins.length; n++) {
                            if (orderJoins[n].projects != null) {
				var projects = orderJoins[n].projects;
				for (var z = 0; z < projects.length; z++) {
				    projectIds[projects[z].id] = true;
				}
                            } else if (orderJoins[n].projectJoins != null) {
                                var projectJoins = orderJoins[n].projectJoins;
				for (var z = 0; z < projectJoins.length; z++) {
				    projectIds[projectJoins[z].projectId] = true;
				}
			    }
                        }                                
			var numberOfProjects = DataHelper.getMapSize(projectIds);
			var disableMspExport = (numberOfProjects > 1);
			this.exportToMspButton.set("disabled", disableMspExport);              
		    }          
		},

		getAutomaticColumnSettings : function(searchModel) {
			return {
				showSerialNumber : true,
				showText : true,
				showPlanningNotification : true,
				showProject : false,
				showSubjectArea : true,
				showAuthorizedInspector : true,
				showReference : true,
				showStatutoryDuty : true,
				showInvalidated : false,
				showWorkflowNode : true,
				showState : true,
				showDocumentPage : false,
				showDocumentPosition : false,
				showSource : false,
				showPersonInCharge : false,
				showStatutoryDutyFrom : false,
				showStatutoryDutyTo : false,
				showStatutoryDutyInterval : false,
				showStatutoryDutyLeadTime : false,
				showStatutoryDutyExpired : false,
				showSubmitAuthority : false,
				showTag : false,
				showOrderComment : false,
				showActions : true                
			};                
		},


		processColumnsChanged : function(columnId) {
		    var columnSettings = this.columnWidget.getColumnSettings();
		    this.listWidget.setColumns(columnSettings, columnId);
		    this.manualColumns = true;
		},


		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationOrderPage.AsyncOperation = {
			EXPORT_TO_MSP : "ExportToMsp",
			EXPORT_TO_PDF : "ExportToPdf",
			LOAD_SEARCH_INFO : "LoadSearchInfo",
			LOAD_DATA : "LoadData"        
	};

	return PlanningNotificationOrderPage;
});
