/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/core/CdesVoc",
    "cdes/document/DocumentHelper",
    "cdes/util/CodeHelper",
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dojo/dom-attr",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/string"
], function(
    CdesVoc,
    DocumentHelper,
    CodeHelper,
            I18nHelper,
            NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    InfoDialog,
    domAttr,
    domClass,
    domConstruct,
    domStyle,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.review.ReviewProtocolVersionListWidget";

    var log = new TinyLog(className);

    var ReviewProtocolVersionListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolVersionListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "reviewProtocolVersionList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

	    columns.push({
		     field : "_documentVersionInfo",
			id : "documentVersionInfo",
                renderCell : lang.hitch(this, this.renderDocumentVersionInfo),
		  sortable : true,
		    label : i18n.reviewProtocolVersionVersionCaption
	    });

	    columns.push({
		     field : "_comment",
			id : "comment",
                renderCell : lang.hitch(this, this.renderComment),
		  sortable : true,
		    label : i18n.reviewProtocolVersionCommentCaption
	    });

	    columns.push({
		     field : "documentVersionId",
			id : "file",
		renderCell : lang.hitch(this, this.renderFileCell),
		  sortable : false,
		     label : i18n.reviewProtocolVersionFileCaption
	    });

	    columns.push({
		     field : "_date",
			id : "date",
		renderCell : lang.hitch(this, this.renderDate),
		  sortable : true,
		    label : i18n.reviewProtocolVersionDateCaption
	    });

	    columns.push({
		     field : "_uploadPerson",
			id : "uploadPerson",
                renderCell : lang.hitch(this, this.renderUploadPerson),
		  sortable : true,
		    label : i18n.reviewProtocolVersionUploadPersonCaption
	    });

	    columns.push({
		     field : "documentVersionId",
			id : "actions",
		renderCell : lang.hitch(this, this.renderActionCell),
		  sortable : false,
		     label : i18n.actionColumnCaption
	    });

            return columns;            
        },

        renderDocumentVersionInfo : function(reviewProtocolVersionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            domClass.add(cell, reviewProtocolVersionJoin._cellClass);

            // Inverted order due to float : right
            var lineOneDiv = domConstruct.create("div", null, cellDiv);
            DOMHelper.createTextNode("span", reviewProtocolVersionJoin._documentVersionString, lineOneDiv,
                reviewProtocolVersionJoin._baseCssClass + " reviewProtocolVersionVersionInfo");
            if (reviewProtocolVersionJoin._sourcePrefix != null) {
                DOMHelper.createTextNode("span", reviewProtocolVersionJoin._sourcePrefix, lineOneDiv,
                    reviewProtocolVersionJoin._baseCssClass + " reviewProtocolVersionVersionInfo reviewProtocolVersionSmallFont");
            }

            // Inverted order due to float : right
            var lineTwoDiv = domConstruct.create("div", null, cellDiv);
            if (reviewProtocolVersionJoin._statusString != null) {
                DOMHelper.createTextNode("span", reviewProtocolVersionJoin._statusString, lineTwoDiv,
                    reviewProtocolVersionJoin._baseCssClass + " reviewProtocolVersionVersionInfo");
            }
            if (reviewProtocolVersionJoin._unchangedString != null) {
                DOMHelper.createTextNode("span", reviewProtocolVersionJoin._unchangedString, lineTwoDiv,
                    reviewProtocolVersionJoin._baseCssClass + " reviewProtocolVersionVersionInfo");
            }
            if (reviewProtocolVersionJoin.documentVersionAlternativeName != null) {
	            domConstruct.create("span", { innerHTML : '&nbsp' }, lineTwoDiv, "reivewProtocolVersionVersionInfo");
	            DOMHelper.createTextNode("span", reviewProtocolVersionJoin.documentVersionAlternativeName, lineTwoDiv,
	                reviewProtocolVersionJoin._baseCssClass + " reviewProtocolVersionVersionInfo reviewProtocolVersionSmallFont");
			}

            return cellDiv;            
        },

        renderComment : function(reviewProtocolVersionJoin, data, cell) {
	
	        var referenceDiv = domConstruct.create("div", null, null);
            var comment = "";
            if (reviewProtocolVersionJoin._entryResultComment != null && reviewProtocolVersionJoin._connectionComment != null) {
                comment = reviewProtocolVersionJoin._entryResultComment + " " + reviewProtocolVersionJoin._connectionComment;
            } else {
                comment = (reviewProtocolVersionJoin._entryResultComment != null ? reviewProtocolVersionJoin._entryResultComment : "")
                    + (reviewProtocolVersionJoin._connectionComment != null ? reviewProtocolVersionJoin._connectionComment : "");                
            }
            // Safe html thanks to server side
        	var node = domConstruct.create("div", { innerHTML : comment });
            domClass.add(node, "reviewProtocolVersionJoin._baseCssClass");                    
            domConstruct.place(node, referenceDiv);                
            return referenceDiv;
        },

		renderFileCell : function(reviewProtocolVersionJoin, data, cell) {
            // description:
            //     Needed fields in reviewProtocolVersionJoin:
            //       - documentVersionFiletype
            //       - documentVersionStatus
            //       - documentObjectPlannerId            
            //       - subProjectInvalidated
            //       - previewSupportDocumentVersionId (if null, the comparison button just won't be shown)            
            //       - _objectPlannerIdToActions

            domClass.add(cell, reviewProtocolVersionJoin._cellClass);
            return DocumentHelper.renderFileButtons({
                                      documentListJoin : reviewProtocolVersionJoin,
                                    applicationContext : this.applicationContext,
                        checkForInvalidDocumentVersion : false,
                checkForInvalidDocumentVersionDownload : true                                
            });
        },        
            
        renderDate : function(reviewProtocolVersionJoin, data, cell) {
            domClass.add(cell, reviewProtocolVersionJoin._cellClass);
            var uploaded = reviewProtocolVersionJoin.documentVersionUploaded;
            var formattedUploaded = this.formatDate(null, reviewProtocolVersionJoin);
            return DOMHelper.createTextNode("div", formattedUploaded, null, reviewProtocolVersionJoin._baseCssClass);
        },

        formatDate : function(date, reviewProtocolVersionJoin) {
            var uploaded = reviewProtocolVersionJoin.documentVersionUploaded;
    	    if (uploaded != null) {
    		return DateHelper.formatUtcSecondsWithTimeZone(uploaded, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern); 
    	    } else {
    		return "";
    	    }            
        },

        renderUploadPerson : function(reviewProtocolVersionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            domClass.add(cell, reviewProtocolVersionJoin._cellClass);
            if (reviewProtocolVersionJoin._entryResultPerson != null) {            
                DOMHelper.createTextNode("div", reviewProtocolVersionJoin._entryResultPerson, cellDiv, reviewProtocolVersionJoin._baseCssClass);
            }
            if (reviewProtocolVersionJoin._connectionResultPerson != null) {            
                DOMHelper.createTextNode("div", reviewProtocolVersionJoin._connectionResultPerson, cellDiv, reviewProtocolVersionJoin._baseCssClass);
            }                
            return cellDiv;            
        },            

	renderActionCell : function(reviewProtocolVersionJoin, data, cell) {
	    var buttonDiv = domConstruct.create("div", null, null);
            domClass.add(cell, reviewProtocolVersionJoin._cellClass);
            
            /* DO NOT USE THIS FUNCTION.  IT IS POTENTIALLY DANGEROUS            
            if ("superAdminRight" in this.globalActions) {
                var deleteDocumentVersionButton = this.constructDeleteDocumentVersionButton(reviewProtocolVersionJoin);
                domConstruct.place(deleteDocumentVersionButton.domNode, buttonDiv);
            }
            */

	    return buttonDiv;	    
	},	    

        constructDeleteDocumentVersionButton : function(reviewProtocolVersionJoin) {
	    var button = new FancyButton({
		    title : i18n.reviewProtocolVersionDeleteButtonToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
	    });

	    domClass.add(button.domNode, "listButton");

	    on(button, "click", lang.hitch(this, function() {
		var message = string.substitute(i18n.reviewProtocolVersionAskDeleteDialogQuestion, {
		    name : reviewProtocolVersionJoin.documentVersionName
		});

		InfoDialog.showQuestion({
		      title : i18n.reviewProtocolVersionAskDeleteDialogCaption,
		    message : message,
		    buttons : [
			{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                            this.doDeleteDocumentVersion(reviewProtocolVersionJoin);
			})},    			           
			{ type : InfoDialog.Button.NO }
		    ]
		}); 
	    }));

	    return button;
        },            

        doDeleteDocumentVersion : function(reviewProtocolVersionJoin) {
	    var documentService = this.applicationContext.getService("documentService");
	    this.registerAsyncOperationStarted(ReviewProtocolVersionListWidget.AsyncOperation.DELETE);

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    documentService.deleteDocumentVersion(organisationPersonId, reviewProtocolVersionJoin.documentVersionId).then(
		lang.hitch(this, function(result) {
		    this.registerAsyncOperationFinished(ReviewProtocolVersionListWidget.AsyncOperation.DELETE);

                    if (result) {
                        var message = string.substitute(i18n.reviewProtocolVersionDeleteSuccessful, {
                            name : reviewProtocolVersionJoin.documentVersionName
                        });                        
                        
                        topic.publish("message/ok", message);
		        on.emit(this, "doLeave");
                    } else {
                        var errorMessage = string.substitute(i18n.reviewProtocolVersionDeleteNotPossible, {
                            name : reviewProtocolVersionJoin.documentVersionName                            
                        });
                        topic.publish("message/error", errorMessage, true);                        
                    }                        
		}),
		lang.hitch(this, function(err) {
		    ErrorHelper.processAsyncError({
				   err : err,
				widget : this,
			asyncOperation : ReviewProtocolVersionListWidget.AsyncOperation.DELETE,
				opName : "deleteDocumentVersion",
			       message : i18n.reviewProtocolVersionDeleteFailed
		    });
		})).otherwise(
		    lang.hitch(this, function(err) {
			log.error("Error while calling function [deleteDocumentVersion]", err);
		    }));
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            this.ownVersionTable = domConstruct.create("table", null, null);
            domClass.add(this.ownVersionTable, "reviewProtocolVersionListOwnVersionTable");            
            domConstruct.place(this.ownVersionTable, topDiv);
            var rowOne = domConstruct.create("tr", null, this.ownVersionTable);
            DOMHelper.createTextNode("td", i18n.reviewProtocolVersionDocumentName, rowOne, "reviewProtocolVersionLeftLabel reviewProtocolVersionLabel");
            this.ownDocumentVersionNameCell = domConstruct.create("td", null, rowOne);
            domClass.add(this.ownDocumentVersionNameCell, "reviewProtocolVersionValue");
            DOMHelper.createTextNode("td", i18n.reviewProtocolVersionDocumentScale, rowOne, "reviewProtocolVersionRightLabel reviewProtocolVersionLabel");
            this.ownDocumentVersionScaleCell = domConstruct.create("td", null, rowOne);
            domClass.add(this.ownDocumentVersionScaleCell, "reviewProtocolVersionValue");

            var rowTwo = domConstruct.create("tr", null, this.ownVersionTable);            
            DOMHelper.createTextNode("td", i18n.reviewProtocolVersionDocumentContent, rowTwo, "reviewProtocolVersionLeftLabel reviewProtocolVersionLabel");
            this.ownDocumentVersionContentCell = domConstruct.create("td", null, rowTwo);
            domClass.add(this.ownDocumentVersionContentCell, "reviewProtocolVersionValue");
            domAttr.set(this.ownDocumentVersionContentCell, "colspan", "3");

	    var grid = this.constructGrid({
		idProperty : "documentVersionId", 
		    gridId : "ReviewProtocolVersionGrid",
                 gridClass : "Grid"
	    });
            /*            
	    on(grid, "dgrid-sort", lang.hitch(this, function(e) {
		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		var networkId = this.applicationContext.getPageContextPnNetworkId();
		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
	    }));
            */
            domConstruct.place(grid, topDiv);

            return topDiv;
        },

        setData : function(params) {
            this.documentVersionId = params.documentVersionId;
            this.globalActions = params.globalActions;
            this.baseJoin = params.baseJoin;
            this.versionJoins = [];

            for (var n = 0; n < params.versionJoins.length; n++) {
                if (params.versionJoins[n].documentVersionId == this.documentVersionId) {
                    this.ownVersionJoin = params.versionJoins[n];
                }
                this.versionJoins.push(params.versionJoins[n]);
            }                
            
            if (this.ownVersionJoin == null) {
                throw new Error("Expecting at least the own version join.  Something is weird here for documentVersionid = [" + this.documentVersionId + "]");
            }                
            this.updateAuxiliaryData();

            this.reload();
        },

        reload : function() {
            DOMHelper.setInnerText(this.ownDocumentVersionNameCell, this.ownVersionJoin.documentVersionName);
            DOMHelper.setInnerText(this.ownDocumentVersionScaleCell, (this.baseJoin.documentReleaseScale != null && this.baseJoin.documentReleaseScale !== "undefined")?this.baseJoin.documentReleaseScale:this.ownVersionJoin.documentScale);

            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var rawContent = (this.baseJoin.documentReleaseContent && this.baseJoin.documentReleaseContent !== "undefined")
                           ? this.baseJoin.documentReleaseContent : this.ownVersionJoin.documentContent;
            var content = I18nHelper.getCurrentLocaleString(rawContent, locale);

            DOMHelper.setInnerText(this.ownDocumentVersionContentCell, content);

            this.setStoreData(this.versionJoins);
            this.grid.resize();

            /*
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotification/sort");

			if (oldSort == null) {
				this.grid.set("sort", "_planningNotificationTitle", false);
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", this.grid.get("sort"));
			} else {
				this.grid.set("sort", oldSort);
			}		

			this.grid.updateSortArrow(this.grid.sort);
            */
        },

	updateAuxiliaryData : function() {
	    for (var n = 0; n < this.versionJoins.length; n++) {
		var versionJoin = this.versionJoins[n];

                // General CSS classes
                var documentVersionStatus = versionJoin.documentVersionStatus;
                if (documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == CdesVoc.DocumentVersionStatus.DELETED) {
                    versionJoin._baseCssClass = "reviewProtocolVersionInvalidated";
                } else if (documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
                    versionJoin._baseCssClass = "reviewProtocolVersionInvalidatedAll";
                } else {
                    versionJoin._baseCssClass = "reviewProtocolVersionDefault";
                }

                if (versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV) {
                    versionJoin._cellClass = "documentVersionReleasedPositiv";
                } else {
                    versionJoin._cellClass = "";
                }                    

                // documentVersionInfo
                if ("superAdminRight" in this.globalActions && versionJoin.destVersionCellConnectionResultId != null) {
                    versionJoin._sourcePrefix = "[sourceVersionId=" + versionJoin.destVersionCellConnectionResultSourceDocumentVersionId + "]";
                } else {
                    versionJoin._sourcePrefix = null;
                }
                versionJoin._documentVersionString = string.substitute(i18n.reviewProtocolVersionVersionInfo, {
                    version : CodeHelper.getDocumentVersionPart(versionJoin, "documentVersion")
                });

                var unchanged = versionJoin.documentVersionFileName == versionJoin.asBuiltDocumentVersionFileName;
                versionJoin._unchangedString = versionJoin.asBuiltDocumentVersionFileName != null && unchanged ? i18n.reviewProtocolVersionFileUnchangedLabel : null;

                var lastDocumentVersion = DocumentHelper.getLastDocumentVersion(this.versionJoins);
                var isLastDocumentVersion = lastDocumentVersion.documentVersionId == versionJoin.documentVersionId;
                var revisedCount = DocumentHelper.getRevisedCount(this.versionJoins, versionJoin.documentVersionId);
                
                var inReviewStillValid = versionJoin.revisedDocumentVersionId != null
                    && versionJoin.revisedDocumentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDALL
                    && versionJoin.revsiedDocumentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                    && isLastDocumentVersion
                    && versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.INREVIEW;                
                var invalidNewVersionInReview = revisedCount > 0 && versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                  && lastDocumentVersion.documentVersionStatus != CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV; 
                var invalidReplaced = revisedCount > 0 && versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                  && lastDocumentVersion.documentVersionStatus == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV;
                var currentlyReleasedVersion = revisedCount > 0 && versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV;
                var invalidPreviousVersionReactivated = versionJoin.documentVersionReactivatedDocumentVersionId != null;
                var deleted = versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.DELETED;

                var statusString = null;
                if (inReviewStillValid) {
                    statusString = i18n.reviewProcotolVersionStatusInReviewStillValid;
                } else if (invalidNewVersionInReview) {
                    statusString = i18n.reviewProcotolVersionStatusInvalidNewVersionInReview;
                } else if (invalidReplaced) {
                    statusString = i18n.reviewProcotolVersionStatusInvalidReplaced;
                } else if (currentlyReleasedVersion) {
                    statusString = i18n.reviewProcotolVersionStatusCurrentlyReleasedVersion;
                } else if (invalidPreviousVersionReactivated) {
                    statusString = i18n.reviewProcotolVersionStatusInvalidPreviousVersionReactivated;
                } else if (deleted) {
                    statusString = i18n.reviewProcotolVersionStatusDeleted;
                }                    

                // Only used for establishing a proper sort order.  Displayment is done using formatter code.
                versionJoin._statusString = statusString,
                versionJoin._documentVersionInfo = (versionJoin._sourcePrefix != null ? versionJoin._sourcePrefix : "")
                    + versionJoin._documentVersionString + versionJoin.documentVersionAlternativeName + versionJoin._unchangedString
                    + (statusString != null ? statusString : "");

                versionJoin._comment = null;

                // comments
                versionJoin._entryResultComment = (versionJoin.reviewCycleEntryResultId != null ? versionJoin.reviewCycleEntryResultComment : null);
                versionJoin._connectionComment = (versionJoin.destVersionCellConnectionResultId != null ? versionJoin.destVersionCellConnectionResultComment : null);
                versionJoin._comment = (versionJoin._entryResultComment != null ? versionJoin._entryResultComment : "")
                    + (versionJoin._connectionComment != null ? versionJoin._connectionComment : "");                

                // date
                versionJoin._date = this.formatDate(null, versionJoin);                

                versionJoin._entryResultPerson = NameHelper.getOrganisationPersonDtoName(versionJoin, "entryResultOrganisation", "entryResultPerson");
                versionJoin._connectionResultPerson = NameHelper.getOrganisationPersonDtoName(versionJoin, "connectionResultOrganisation", "connectionResultPerson");
                versionJoin._uploadPerson = versionJoin._entryResultPerson + versionJoin._connectionResultPerson;

	    }
	},

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            var width = newSize.w + 0.01;
            var height = this.getActualHeight();
            this.grid.resize({ w : width, h : height });
        },

        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });

    ReviewProtocolVersionListWidget.AsyncOperation = {
        DELETE : "Delete"
    };        

    return ReviewProtocolVersionListWidget;
});
