define([ 
        "cdes/util/I18nHelper",
        "cdes/widget/util/DnDCellWidget",
        "cdes/widget/util/MultiI18nTextAreaDialog",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/Tooltip",
        "dijit/_WidgetBase",
        "dijit/form/Textarea",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-attr",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"  
],
function(
         I18nHelper,
         DnDCellWidget,
         MultiI18nTextAreaDialog,
         TinyLog,
         topic,
         WidgetHelper,
         InfoDialog,
         Tooltip,
         _WidgetBase,
         TextArea,
         domClass,
         domConstruct,
         domAttr,
         on,
         declare,
         lang,
         i18n    
         ) {
    
    var className = "at.cdes.widget.util.TextAreaDnDCellWidget";

    var log = new TinyLog(className);
    
    var TextAreaDnDCellWidget = declare(className, [_WidgetBase, DnDCellWidget ], {
        
        buildRendering : function() {
            this.inherited(arguments);
            
            this.domNode = domConstruct.create("table", null, null);
            var tr = domConstruct.create("tr", null, this.domNode);
            
            var td = domConstruct.create("td", null, tr);
            this.textArea = new TextArea({
                label : "TODO",
                title : ""
            });
            
            domConstruct.place(this.textArea.domNode, td);
            
            WidgetHelper.handleTextBoxEvents(this.textArea, lang.hitch(this, function(e) {
                on.emit(this, "change", e);
            }));

            if (this.contentLocaleGetter != null && this.contentLocaleGetter() != null) {
     			// Icon for opening the editDialog
                var iconEDTd = domConstruct.create("td", null, tr);
                domAttr.set(iconEDTd, "style", "width: 20px;");
	    		var editDialogIcon = domConstruct.create("div", null, iconEDTd);
	    		
	    		var contentLocales = this.contentLocaleGetter();
	    		var iconName = "i18n" + this.locale.toUpperCase();
                if (contentLocales != null && contentLocales.indexOf(this.locale) < 0)
                	iconName = "i18n" + contentLocales[0].toUpperCase();
                
	    		domClass.add(editDialogIcon, "cdesWebIcon17x18 " + iconName);
	    		domClass.add(editDialogIcon, "boxedIcon");
	    		domAttr.set(editDialogIcon, "title", i18n.textAreaDnDEditTranslationsCaptionToolTip);
	    		
	    		on(editDialogIcon, "click", lang.hitch(this, function() {
	                var contentLocales = this.contentLocaleGetter();
	                if (contentLocales != null) {
	                	//update jsonValue in case it was edited in the textArea
	                	this.jsonValue = this.getEditorValue();
	                    this.openLocaleEditDialog();
	                }
	    		}));    		
            }
            
            if (this.dndStartTopic) {
                var iconTd = domConstruct.create("td", null, tr);
                this.constructDnDButtonCell(iconTd, "pullUpDownIcon");                          
            }
        },
        
        _setValueAttr : function(value, priorityChange) {
            this.inherited(arguments);
        },

        constructToolTip : function() {
            
        },        
        
        setEditorValue : function(value, priorityChange) {
            if (this.locale != null) {
                this.jsonValue = value;
                var displayValue = I18nHelper.getCurrentLocaleString(this.jsonValue, this.locale);
                this.textArea.set("value", displayValue);

                var contentLocales = (this.contentLocaleGetter != null ? this.contentLocaleGetter() : null);
                if (contentLocales != null) {
                    this.translationToolTip = new Tooltip({
                        connectId : [this.textArea.domNode],
                        label     : ""
                    });

                    var localeMap = I18nHelper.getLocaleMap(this.jsonValue, this.locale);

                    // DOJOSKETCH-119: It seems that the built-in code for hiding the ToolTip provided by
                    //                 Dojo (using connectId specified above) does not work reliable on
                    //                 Firefox.
                    this.own(
                        on(this.textArea.domNode, "mouseleave", lang.hitch(this, function(event) {
                            this.translationToolTip._onUnHover();       
                        }))
                             );

                    var tooltipLabel = "";
                    for (var n = 0; n < contentLocales.length; n++) {
                        var contentLocale = contentLocales[n];
                        var translation = contentLocale in localeMap ? localeMap[contentLocale] : null;
                        if (translation != null) {
                            var localeLabel = I18nHelper.getLocaleLabel(contentLocale);
                            tooltipLabel += localeLabel + ": " + translation + "<br>";
                        }
                    }
                    this.translationToolTip.set("label", tooltipLabel);
                }
            } else {
                this.textArea.set("value", value);
            }
        },
        
        getEditorValue : function() {
            var contentLocales = (this.contentLocaleGetter != null ? this.contentLocaleGetter() : null);
            
            if (this.locale != null && contentLocales != null) {
                var textAreaValue = this.textArea.get("value");
                var updatedJsonValue = this.jsonValue;
                //check if this.locale (userLocale) is part of contentLocales to update it with textArea.value 
                //or add it to jsonValue in case translation for this locale is not jet existing
                //if this.locale is not part of contentLocales, jsonValue of contentLocales[0] (i.e. projectLocale) will be updated with textArea.value
            	if (contentLocales.indexOf(this.locale) > -1)
                	updatedJsonValue = I18nHelper.updateCurrentLocaleString(this.jsonValue, textAreaValue, this.locale);
            	else
                	updatedJsonValue = I18nHelper.updateCurrentLocaleString(this.jsonValue, textAreaValue, contentLocales[0]);
               
                return updatedJsonValue;
                
            } else {
                return this.textArea.get("value");
            }
        },

        getLocaleEditButtons : function() {
            var buttons = [
                           { type : InfoDialog.Button.OK,
                               fct : lang.hitch(this, function() {
                                   //this.jsonValue = editDialog.getUpdatedJsonValue();
                                   this.setEditorValue(this.editDialog.getUpdatedJsonValue());
                               })},
                           { type : InfoDialog.Button.ABORT }
            ];
            return buttons;
        },

        openLocaleEditDialog : function() {
            this.editDialog = new MultiI18nTextAreaDialog({
                         title : i18n.textAreaDnDEditTranslationsCaption,
                  defaultWidth : 400,
                 defaultHeight : 80,
                       buttons : this.getLocaleEditButtons(),
                contentLocales : this.contentLocaleGetter(),
                        locale : this.locale,
                         value : this.jsonValue
            });
            
            on(this.editDialog, "hide", lang.hitch(this, function() {
                this.editDialog.destroy();
                this.editDialog = null;
            }));
            
            this.editDialog.show();             
        }
    });
    
    return TextAreaDnDCellWidget;
});
