/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationReportOptions
////i18n-prefix = planningNotificationReportOptions



define([
	"cdes/core/CdesVoc",
	"cdes/planning/report/PlanningNotificationReportCoverWidget",
	"cdes/planning/report/PlanningNotificationReportDataWidget",
	"cdes/planning/report/PlanningNotificationReportStepWidget",
	"cdes/planning/util/PlanningNotificationHelper",
	"clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"dijit/form/Button",
	"dijit/form/Textarea",
	"dijit/form/CheckBox",
	"dijit/form/NumberSpinner",
	"dijit/form/Select",
	"dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(
			CdesVoc,
			PlanningNotificationReportCoverWidget,
			PlanningNotificationReportDataWidget,
			PlanningNotificationReportStepWidget,
			PlanningNotificationHelper,
			TinyLog,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			Button,
			Textarea,
			CheckBox,
			NumberSpinner,
			Select,
			TextBox,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.report.PlanningNotificationReportOptionsWidget";

	var log = new TinyLog(className);

	var PlanningNotificationReportOptionsWidget = declare(className, PlanningNotificationReportStepWidget, {

		FILE_FORMAT_OPTIONS_ALL : [ CdesVoc.ReportFileFormat.PDF, CdesVoc.ReportFileFormat.XLS ],
		FILE_FORMAT_OPTIONS_INDIVIDUAL : [ CdesVoc.ReportFileFormat.PDF, CdesVoc.ReportFileFormat.PDF_LIST, CdesVoc.ReportFileFormat.XLS ],

		constructor : function() {
		},

		processNetworkChange : function() {
			this.loadProjects();		
		},		

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
//			domClass.add(topDiv, "fixedDialogWidget occupyWholeParent");

			return topDiv;
		},

		initialize : function() {
			var reportTypeDiv = domConstruct.create("div", null, null);
			domClass.add(reportTypeDiv, "refNodeOfPositionAbsolute planningNotificationReportReportTypeDiv");
			domConstruct.place(reportTypeDiv, this.topDiv);            

			// Type
			var typeOptions = [{ label : i18n.planningNotificationReportTypeAll, value : "ALL" },
				{ label : i18n.planningNotificationReportTypeIndividual, value : "INDIVIDUAL" } ];                               

			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsTypeLabel, reportTypeDiv, "propertyLabel planningNotificationReportOptionsTypeLabel");
			this.typeSelect = new Select({
				label : i18n.planningNotificationReportOptionsTypeLabel,
				title : i18n.planningNotificationReportOptionsTypeTitle,
				options : typeOptions                
			});                
			domClass.add(this.typeSelect.domNode, "fixedDialogWidget planningNotificationReportOptionsTypeSelect");
			domConstruct.place(this.typeSelect.domNode, reportTypeDiv);
			WidgetHelper.handleSelectEvents(this.typeSelect, lang.hitch(this, this.updateWidgetState));

			// Project
			this.projectLabel = DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsProjectLabel, reportTypeDiv, "propertyLabel planningNotificationReportOptionsProjectLabel");
			this.projectSelect = new Select({
				label : i18n.planningNotificationReportOptionsProjectLabel,
				title : i18n.planningNotificationReportOptionsProjectTitle,
				options : []
			});                
			domClass.add(this.projectSelect.domNode, "fixedDialogWidget planningNotificationReportOptionsProjectSelect");
			domConstruct.place(this.projectSelect.domNode, reportTypeDiv);
			this.loadProjects();

			// Comment
			var commentOneDiv = domConstruct.create("div", null, null);
			domClass.add(commentOneDiv, "planningNotificationReportCommentOneDiv");
			domConstruct.place(commentOneDiv, this.topDiv);

			this.commentOneLabel = DOMHelper.createTextNode("div", i18n.planningNotificationReportCoverCommentLabel, commentOneDiv, "planningNotificationReportOptionsCommentOneLabel");
			this.commentOneTextArea = new Textarea({
				label : i18n.planningNotificationReportCoverCommentLabel,
				title : i18n.planningNotificationReportCoverCommentToolTip,
				maxLength : 255		
			});
			domClass.add(this.commentOneTextArea.domNode, "planningNotificationReportOptionsCommentOneTextArea");
			domConstruct.place(this.commentOneTextArea.domNode, commentOneDiv);

			// Comment Two
			var commentTwoDiv = domConstruct.create("div", null, null);
			domClass.add(commentTwoDiv, "planningNotificationReportCommentTwoDiv");
			domConstruct.place(commentTwoDiv, this.topDiv);

			this.commentTwoLabel = DOMHelper.createTextNode("div", i18n.planningNotificationReportCoverCommentTwoLabel, commentTwoDiv, "planningNotificationReportOptionsCommentOneLabel");
			this.commentTwoTextArea = new Textarea({
				label : i18n.planningNotificationReportCoverCommentLabel,
				title : i18n.planningNotificationReportCoverCommentToolTip,
				maxLength : 255		
			});
			domClass.add(this.commentTwoTextArea.domNode, "planningNotificationReportOptionsCommentOneTextArea");
			domConstruct.place(this.commentTwoTextArea.domNode, commentTwoDiv);

			var lowerBlockDiv = domConstruct.create("div", null, null);
			domClass.add(lowerBlockDiv, "refNodeOfPositionAbsolute planningNotificationReportOptionsLowerBlockDiv");
			domConstruct.place(lowerBlockDiv, this.topDiv);            

			// FileFormatSelect
			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsFileFormatLabel, lowerBlockDiv, "propertyLabel planningNotificationReportOptionsFileFormatLabel");
			this.fileFormatSelect = new Select({
				label : i18n.planningNotificationReportOptionsFileFormatLabel,
				title : i18n.planningNotificationReportOptionsFileFormatToolTip
			});
			domClass.add(this.fileFormatSelect.domNode, "fixedDialogWidget planningNotificationReportOptionsFileFormatSelect");
			domConstruct.place(this.fileFormatSelect.domNode, lowerBlockDiv);
			WidgetHelper.handleSelectEvents(this.fileFormatSelect, lang.hitch(this, this.updateWidgetState));

			// LayoutFormatSelect
			var layoutFormatOptions = [CdesVoc.LayoutFormat.PORTRAIT, CdesVoc.LayoutFormat.LANDSCAPE ];
			this.layoutFormatLabel = DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsLayoutFormatLabel, lowerBlockDiv, "propertyLabel planningNotificationReportOptionsLayoutFormatLabel");
			this.layoutFormatSelect = new Select({
				label : i18n.planningNotificationReportOptionsLayoutFormatLabel,
				title : i18n.planningNotificationReportOptionsLayoutFormatToolTip,
				options : layoutFormatOptions           
			});
			domClass.add(this.layoutFormatSelect.domNode, "fixedDialogWidget planningNotificationReportOptionsLayoutFormatSelect");
			domConstruct.place(this.layoutFormatSelect.domNode, lowerBlockDiv);
			WidgetHelper.handleSelectEvents(this.layoutFormatSelect, lang.hitch(this, this.updateWidgetState));

			this.statusGraphDiv = domConstruct.create("div", null, lowerBlockDiv);
			domClass.add(this.statusGraphDiv, "fixedDialogWidget planningNotificationReportOptionsStatusGraphDiv");            

			// FileNameTextBox
			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsFileNameLabel, lowerBlockDiv, "propertyLabel planningNotificationReportOptionsFileNameLabel");
			this.fileNameTextBox = new TextBox({
				label : i18n.planningNotificationReportOptionsFileNameLabel,
				title : i18n.planningNotificationReportOptionsFileNameToolTip
			});
			domClass.add(this.fileNameTextBox.domNode, "fixedDialogWidget planningNotificationReportOptionsFileNameSelect");
			domConstruct.place(this.fileNameTextBox.domNode, lowerBlockDiv);
			WidgetHelper.handleSelectEvents(this.fileNameTextBox, lang.hitch(this, this.updateWidgetState));
			this.suffixLabel = DOMHelper.createTextNode("div", "", lowerBlockDiv, "propertyLabel planningNotificationReportOptionsFileNameSuffixLabel");

			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsHeaderFontSizeLabel, this.statusGraphDiv, "propertyLabel planningNotificationReportOptionsHeaderFontSizeLabel");
			this.headerFontSizeSpinner = new NumberSpinner({
				label : i18n.planningNotificationReportOptionsHeaderFontSizeLabel,
				title : i18n.planningNotificationReportOptionsHeaderFontSizeLabel,
				constraints : { min:4, max:32 }
			});
			domClass.add(this.headerFontSizeSpinner.domNode, "fixedDialogWidget planningNotificationReportOptionsHeaderFontSizeSpinner");
			domConstruct.place(this.headerFontSizeSpinner.domNode, this.statusGraphDiv);

			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsDataFontSizeLabel, this.statusGraphDiv, "propertyLabel planningNotificationReportOptionsDataFontSizeLabel");
			this.dataFontSizeSpinner = new NumberSpinner({
				label : i18n.planningNotificationReportOptionsDataFontSizeLabel,
				title : i18n.planningNotificationReportOptionsDataFontSizeLabel,
				constraints : { min:4, max:32 }                
			});
			domClass.add(this.dataFontSizeSpinner.domNode, "fixedDialogWidget planningNotificationReportOptionsDataFontSizeSpinner");
			domConstruct.place(this.dataFontSizeSpinner.domNode, this.statusGraphDiv);

			this.overallStatusCheckBox = new CheckBox({
				label : i18n.planningNotificationReportOptionsOverallStatusLabel,
				title : i18n.planningNotificationReportOptionsOverallStatusToolTip
			});
			domClass.add(this.overallStatusCheckBox.domNode, "fixedDialogWidget planningNotificationReportOptionsOverallStatusCheckBox");
			domConstruct.place(this.overallStatusCheckBox.domNode, this.statusGraphDiv);            

			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsOverallStatusLabel, this.statusGraphDiv, "fixedDialogWidget planningNotificationReportOptionsOverallStatusLabel");

			this.orderStatusCheckBox = new CheckBox({
				label : i18n.planningNotificationReportOptionsOrderStatusLabel,
				title : i18n.planningNotificationReportOptionsOrderStatusToolTip
			});
			domClass.add(this.orderStatusCheckBox.domNode, "fixedDialogWidget planningNotificationReportOptionsOrderStatusCheckBox");
			domConstruct.place(this.orderStatusCheckBox.domNode, this.statusGraphDiv);

			DOMHelper.createTextNode("div", i18n.planningNotificationReportOptionsOrderStatusLabel, this.statusGraphDiv, "fixedDialogWidget planningNotificationReportOptionsOrderStatusLabel");

			/* 
            Berichtsart (Gesamt, individuell)
            Dateiformat (pdf, xls)
            Layoutformat (hoch, quer) (nur pdf)
            Status-Grafik Gesamt erzeugen
            Status-Grafik je Vorgabe erzeugen

            Sortier-Optionen?  Vgl. handschriftliche Anmerkung Seite 5
			 */            

			this.initialized = true;
		},            

		loadProjects : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();            

			if (this.lastSearchInfoReloadNetworkId != networkId) {
				this.lastSearchInfoReloadNetworkId = networkId;
			} else {
				// Don't load twice for the same network.
				return;		
			}		

			this.registerAsyncOperationStarted(PlanningNotificationReportOptionsWidget.AsyncOperation.LOAD_PROJECTS);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getReportOptionsInfo(organisationPersonId, networkId).then(
					lang.hitch(this, function(idToProject) {
						this.registerAsyncOperationFinished(PlanningNotificationReportOptionsWidget.AsyncOperation.LOAD_PROJECTS);

						var initialProjectId = this.config.options.projectId;
						PlanningNotificationHelper.processProjectChange({
							projectSelect : this.projectSelect, 
							projectIdToProject : idToProject,
							initialProjectId   : initialProjectId,
							addWhateverOption : false,
							noWhateverDefault : true                
						});

						if (this.config.options.projectId != null) {
							WidgetHelper.setSelectValue(this.projectSelect, this.config.options.projectId);
						}				    

					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationReportOptionsWidget.AsyncOperation.LOAD_PROJECTS,
							opName : "getReportOptionsInfo",
							message : i18n.planningNotificationReportLoadProjectsFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getReportOptionsInfo]", err);
							}));
		},            

		getWidgetId : function() {
			return "PlanningNotificationReportOptionsWidget";
		},

		getPageCaption : function() {
			return i18n.planningNotificationReportOptionsPageCaption;
		},

		getType : function() {
			return WidgetHelper.getSelectValue(this.typeSelect);
		},

		getFileFormat : function() {
			return WidgetHelper.getSelectValue(this.fileFormatSelect);
		},		    

		getLayoutFormat : function() {
			return WidgetHelper.getSelectValue(this.layoutFormatSelect);
		},            

		doIncludeOverallStatusGraphic : function() {
			return !!this.overallStatusCheckBox.get("checked");
		},            

		doIncludeOrderStatusGraphics : function() {
			return !!this.orderStatusCheckBox.get("checked");
		},            

		getProjectId : function() {
			return WidgetHelper.getSelectValue(this.projectSelect);
		},  

		getComment : function() {
			return this.commentOneTextArea.get("value");
		},

		getCommentTwo : function() {
			return this.commentTwoTextArea.get("value");
		},            

		getStepForwardCaption : function() {
			var fileFormat = WidgetHelper.getSelectValue(this.fileFormatSelect);
			var type = WidgetHelper.getSelectValue(this.typeSelect);

			/*			if (fileFormat == CdesVoc.ReportFileFormat.PDF.value || fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value) {
		return i18n.planningNotificationReportGotoCoverCaption;
	    } else*/ if (type == "INDIVIDUAL") {
	    	return i18n.planningNotificationReportGotoDataCaption;
	    } else {
	    	return i18n.planningNotificationReportDoGenerateCaption;
	    }                
		},		

		getStepForwardToolTip : function() {
			var fileFormat = WidgetHelper.getSelectValue(this.fileFormatSelect);
			var type = WidgetHelper.getSelectValue(this.typeSelect);

			/*			if (fileFormat == CdesVoc.ReportFileFormat.PDF.value || fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value) {
		return i18n.planningNotificationReportGotoCoverToolTip;
	    } else*/ if (type == "INDIVIDUAL") {
	    	return i18n.planningNotificationReportGotoDataToolTip;
	    } else {
	    	return i18n.planningNotificationReportDoGenerateToolTip;
	    }                
		},		


		getCustomButtons : function() {
			if (!this.showExportToMspButton()) {
				return [];               
			} else {
				var exportToMspButton = new Button({
					label : i18n.planningNotificationReportDataMspButtonCaption,
					title : i18n.planningNotificationReportDataMspButtonToolTip
				});
				domClass.add(exportToMspButton.domNode, "planningNotificationReportDataMspButton");
				on(exportToMspButton, "click", lang.hitch(this, function() {
					this.triggerExportReport(true);
				}));               

				return [ exportToMspButton ];
			}
		},

		showExportToMspButton : function() {
			var fileFormat = WidgetHelper.getSelectValue(this.fileFormatSelect);
			var type = WidgetHelper.getSelectValue(this.typeSelect);
			return !(/*fileFormat == CdesVoc.ReportFileFormat.PDF.value || fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value ||*/ type == "INDIVIDUAL");
		},

		performStepForward : function(stepWidgets) {
			this.storeConfigToLocalStorage();

			var fileFormat = WidgetHelper.getSelectValue(this.fileFormatSelect);
			var type = WidgetHelper.getSelectValue(this.typeSelect);

			/*			if (fileFormat == CdesVoc.ReportFileFormat.PDF.value || fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value) {
		// If the pdf format is chosen, the next widget is the cover widget.
		return this.createOrReuseStepForwardWidget(stepWidgets, "PlanningNotificationReportCoverWidget", lang.hitch(this, function() {
		    var coverWidget = new PlanningNotificationReportCoverWidget({
			applicationContext : this.applicationContext
		    });

		    on(coverWidget, "customButtonsChanged", lang.hitch(this, function(widget) {
			on.emit(this, "customButtonsChanged", widget);
		    }));                                    

		    return coverWidget;                    
		}));                     
	    } else*/ if (type == "INDIVIDUAL") {
	    	// Case XLS; in case INDIVIDUAL, the next widget is the data widget.
	    	return this.createOrReuseStepForwardWidget(stepWidgets, "PlanningNotificationReportDataWidget", lang.hitch(this, function() {
	    		return new PlanningNotificationReportDataWidget({
	    			applicationContext : this.applicationContext
	    		});
	    	}));
	    } else {
	    	// Case XLS and ALL, no further widgets, we start generating the report right now
	    	return this.triggerExportReport(false);
	    }                
		},        

		triggerExportReport : function(askForMsp) {
			return PlanningNotificationHelper.triggerExportReport(this.applicationContext, this, this.config, null, null, askForMsp);
		},

		getData : function() {
			return {
				reportType : WidgetHelper.getSelectValue(this.typeSelect),
				fileFormat : WidgetHelper.getSelectValue(this.fileFormatSelect),
				layoutFormat : WidgetHelper.getSelectValue(this.layoutFormatSelect),
				projectId : WidgetHelper.getSelectValue(this.projectSelect),
				generateOverallStatusGraph : this.overallStatusCheckBox.get("checked"),
				orderStatusGraph : this.orderStatusCheckBox.get("checked"),
				comment : this.commentOneTextArea.get("value"),
				commentTwo : this.commentTwoTextArea.get("value")                
			};                
		},            

		setData : function(config) {
			this.config = config;
			this.reload();
		},

		reload : function() {
			this.updateWidgetsFromData();
			this.updateWidgetState();
		},

		updateWidgetsFromData : function() {
			var type = this.config.options.reportType;
			if (type == null) {
				type = "INDIVIDUAL";
			}		    
			var fileFormatOptions = type == "ALL" ? this.FILE_FORMAT_OPTIONS_ALL : this.FILE_FORMAT_OPTIONS_INDIVIDUAL;
			WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.fileFormatSelect, fileFormatOptions);

			var fileFormat = this.config.options.fileFormat;
			if (fileFormat == null) {
				fileFormat =  CdesVoc.ReportFileFormat.PDF.value;
			}

			var layoutFormat = this.config.options.layoutFormat;
			if (layoutFormat == null) {
				layoutFormat = CdesVoc.LayoutFormat.LANDSCAPE.value;
			}

			WidgetHelper.setSelectValue(this.typeSelect, type);
			WidgetHelper.setSelectValue(this.fileFormatSelect, fileFormat);
			WidgetHelper.setSelectValue(this.fileNameTextBox, this.config.options.fileName);
			WidgetHelper.setSelectValue(this.layoutFormatSelect, layoutFormat);
			WidgetHelper.setSelectValue(this.projectSelect, this.config.options.projectId);
			this.headerFontSizeSpinner.set("value", this.config.options.headerFontSize != null ? this.config.options.headerFontSize : 8);
			this.dataFontSizeSpinner.set("value", this.config.options.dataFontSize != null ? this.config.options.dataFontSize : 9);
			this.overallStatusCheckBox.set("checked", !!this.config.options.includeOverallStatusGraphic);
			this.orderStatusCheckBox.set("checked", !!this.config.options.includeOrderStatusGraphics);
			this.commentOneTextArea.set("value", this.config.options.comment);
			this.commentTwoTextArea.set("value", this.config.options.commentTwo);
		},	    

		updateDataFromWidgets : function() {
			this.config.options.reportType = WidgetHelper.getSelectValue(this.typeSelect);
			this.config.options.fileFormat = WidgetHelper.getSelectValue(this.fileFormatSelect);
			this.config.options.fileName = this.fileNameTextBox.get("value");
			this.config.options.layoutFormat = WidgetHelper.getSelectValue(this.layoutFormatSelect);		
			this.config.options.projectId = WidgetHelper.getSelectValue(this.projectSelect);
			this.config.options.headerFontSize = this.headerFontSizeSpinner.get("value");
			this.config.options.dataFontSize = this.dataFontSizeSpinner.get("value");            
			this.config.options.includeOverallStatusGraphic = this.overallStatusCheckBox.get("checked");
			this.config.options.includeOrderStatusGraphics = this.orderStatusCheckBox.get("checked");		
			this.config.options.comment = this.commentOneTextArea.get("value");
			this.config.options.commentTwo = this.commentTwoTextArea.get("value");            
		},		

		updateWidgetState : function() {
			if (!this.initialized) {
				return;
			}                

			domClass.add(this.projectLabel, "invisible");
			domClass.add(this.projectSelect.domNode, "invisible");            
			domClass.add(this.layoutFormatLabel, "invisible");
			domClass.add(this.layoutFormatSelect.domNode, "invisible");
			domClass.add(this.statusGraphDiv, "invisible");

			var type = WidgetHelper.getSelectValue(this.typeSelect);
			if (type == "ALL") {
				domClass.remove(this.projectLabel, "invisible");
				domClass.remove(this.projectSelect.domNode, "invisible");                
			}                

			var fileFormat = WidgetHelper.getSelectValue(this.fileFormatSelect);
			var fileFormatOptions = type == "ALL" ? this.FILE_FORMAT_OPTIONS_ALL : this.FILE_FORMAT_OPTIONS_INDIVIDUAL;
			WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.fileFormatSelect, fileFormatOptions);
			if (type == "ALL" && fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value) {
				fileFormat = CdesVoc.ReportFileFormat.PDF.value;
				WidgetHelper.setSelectValue(this.fileFormatSelect, fileFormat);		    
			}		    

			if (fileFormat == CdesVoc.ReportFileFormat.PDF.value || fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value) {
				domClass.remove(this.layoutFormatLabel, "invisible");
				domClass.remove(this.layoutFormatSelect.domNode, "invisible");
				domClass.remove(this.statusGraphDiv, "invisible");
				DOMHelper.setInnerText(this.suffixLabel, ".pdf");            
				//				domClass.remove(this.commentLabel, "invisible");
				//				domClass.remove(this.commentTextArea.domNode, "invisible");
				this.commentOneTextArea.set("disabled", false);
				this.commentTwoTextArea.set("disabled", false);                
			} else {
				DOMHelper.setInnerText(this.suffixLabel, ".xlsx");
				//				domClass.add(this.commentLabel, "invisible");
				//				domClass.add(this.commentTextArea.domNode, "invisible");
				this.commentOneTextArea.set("value", "");
				this.commentTwoTextArea.set("value", "");
				this.commentOneTextArea.set("disabled", true);
				this.commentTwoTextArea.set("disabled", true);                
			}            

			var mayStepForward = (fileFormat == CdesVoc.ReportFileFormat.PDF.value) || fileFormat == CdesVoc.ReportFileFormat.PDF_LIST.value
			|| (fileFormat == CdesVoc.ReportFileFormat.XLS.value);
			var stepForwardCaption = this.getStepForwardCaption();
			var doShowExportToMspButton = this.showExportToMspButton();
			if (mayStepForward != this.mayStepForward || stepForwardCaption != this.stepForwardCaption) {
				this.mayStepForward = mayStepForward;
				this.stepForwardCaption = stepForwardCaption;                
				on.emit(this, "stepWidgetChanged");
			}
			if (doShowExportToMspButton != this.doShowExportToMspButton) {
				on.emit(this, "customButtonsChanged", this);
			}                    
		},

		destroy : function() {
			this.inherited(arguments);
		}
	});

	PlanningNotificationReportOptionsWidget.AsyncOperation = {
			LOAD_PROJECTS : "LoadProjects"        
	};

	PlanningNotificationReportOptionsWidget.getDefaultConfig = function() {
		return {
			reportType : "INDIVIDUAL",
			fileFormat : CdesVoc.ReportFileFormat.PDF.value,
			fileName : "",
			layoutFormat : CdesVoc.LayoutFormat.LANDSCAPE.value,
			projectId : null,
			headerFontSize : 8,
			dataFontSize : 9,        
			generateOverallStatusGraph : true,
			orderStatusGraph : true,
			comment : "",
			commentTwo : ""
		};	    
	};	

	return PlanningNotificationReportOptionsWidget;
});
