/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = asBuiltSign
//// i18n-prefix = asBuiltSign


define([ 
	"cdes/document/DocumentListWidget",
    "cdes/document/DocumentSearchWidget",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dijit/form/TextBox",
	"dijit/form/CheckBox",
    "dijit/form/ValidationTextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/keys",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
	DocumentListWidget,
	DocumentSearchWidget,
    TinyLog,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    InfoDialog,
    TextBox,
	CheckBox,
    ValidationTextBox,
    domClass,
    domConstruct,
    domStyle,
    Keys,
    on,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.document.AsBuiltSignWidget";

    var log = new TinyLog(className);

    var AsBuiltSignWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.changed = true;

            this.allFieldsValid = false;
        },

        getWidgetId : function() {
            return "AsBuiltSignWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Search Widget
/*            this.searchWidget = new DocumentSearchWidget({
                applicationContext : this.applicationContext,
                		  cameBack : this.cameBack
            });
            this.searchWidgetDiv = this.searchWidget.getContainer();
            domConstruct.place(this.searchWidgetDiv, topDiv);
            on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));
            on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));
*/

			// SelectAllCheckBox
			this.contentDiv = domConstruct.create("div", null, null);
			domClass.add(this.contentDiv, "refNodeOfPositionAbsolute asBuiltSignContentDiv");
			this.selectAllLabel = DOMHelper.createTextNode("div", i18n.asBuiltSignSelectAllCheckBoxLabel, this.contentDiv, "fixedDialogWidget asBuiltSignSelectAllCheckBoxLabel");
			this.selectAllCheckBox = new CheckBox({
			    label : i18n.asBuiltSignSelectAllCheckBoxLabel,
			    title : i18n.asBuiltSignSelectAllCheckBoxToolTip
			});
			domClass.add(this.selectAllCheckBox.domNode, "fixedDialogWidget asBuiltSignSelectAllCheckBox");
			domConstruct.place(this.selectAllCheckBox.domNode, this.contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.selectAllCheckBox, lang.hitch(this, this.selectAllUsingCheckBox));
			domConstruct.place(this.contentDiv, topDiv);

            // List Widget
            this.listWidgetAsBuilt = new DocumentListWidget({
                applicationContext : this.applicationContext,
                          backPage : "documentList",
                        backParams : new Object({ cameBack : true}),
                			  mode : this.mode
                             
            });
            this.listWidgetDiv = this.listWidgetAsBuilt.getContainer();
            domConstruct.place(this.listWidgetDiv, topDiv);

            this.pseudoUserTextBox = new TextBox({

            });
            domClass.add(this.pseudoUserTextBox.domNode, "fixedDialogWidget reviewSignPseudoUser");
            domConstruct.place(this.pseudoUserTextBox.domNode, topDiv);            

            // Sign
            DOMHelper.createTextNode("div", i18n.passwordLabel, topDiv, "propertyLabel reviewSignPasswordLabel");
            this.passwordTextBox = new ValidationTextBox({
                   label : i18n.passwordLabel,
                   title : i18n.reviewSignPasswordToolTip,
                    type : "password",
                tabIndex : 1        
            });
            domClass.add(this.passwordTextBox.domNode, "fixedDialogWidget reviewSignPasswordTextBox");
            domConstruct.place(this.passwordTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.passwordTextBox, lang.hitch(this, this.updateWidgetState));
            on(this.passwordTextBox.domNode, "keyup", lang.hitch(this, this.signIfEnter));
            
            this.listWidgetAsBuilt.restoreColumnWidths();

            return topDiv;
        },

        signIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.save();
                on.emit(this, "triggerClose");      
            }
        },

/*        postResizeFunction : function(newSize) {
            var totalHeight = newSize.h;

            var contentHeight = totalHeight - 16;

            domStyle.set(this.topDiv, "height", contentHeight + "px");
            this.listWidgetAsBuilt.resize({ h : contentHeight - 55});
        },*/
		
		postResizeFunction : function(newSize) {
		    // AbstractEditWidget.constructTopContainer configures calls to postResizeFunction,
		    // thus we need this delegate when using the page inside a Dialog.          
		    this.resize(newSize);
		},

		resize : function(newSize) {
			var totalHeight = newSize.h;

			var contentHeight = totalHeight - 16;

			domStyle.set(this.topDiv, "height", contentHeight + "px");
			this.listWidgetAsBuilt.resize({ h : contentHeight - 55});
		},
		
		selectAllUsingCheckBox : function() {
		    var checked = this.selectAllCheckBox.get("checked");
		    if (checked) {
		        this.listWidgetAsBuilt.selectAll(true);
		    } else {
		        this.listWidgetAsBuilt.selectAll(false);
		    }                
		},            

        setData : function(params) {
            this.documentListRows = params.documentListRows; 
            this.listWidgetAsBuilt.setData(params);
        },
		//CAUTION: this function is used by EditDialog Button ClazzesVoc.Button.REVERT
        reload : function() {
			var onlyDocumentReference = true;
			this.insertCopies(onlyDocumentReference);
        },
        
        save : function() {
			var onlyDocumentReference = false;
			this.insertCopies(onlyDocumentReference);
		},
		
        createAsBuilt : function() {
			var onlyDocumentReference = true;
			this.insertCopies(onlyDocumentReference);
		},

        insertCopies : function(onlyDocumentReference) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var subProjectId = this.applicationContext.getPageContextSubProjectId();
            var password = this.passwordTextBox.get("value");
            var selectedDocumentVersionIds = [];
            for (var n = 0; n < this.documentListRows.length; n++) {
                var currTokenInfo = this.documentListRows[n];
				if (currTokenInfo._selected)
                	selectedDocumentVersionIds.push(currTokenInfo.documentVersion.id);
            }                

            this.registerAsyncOperationStarted(AsBuiltSignWidget.AsyncOperation.SIGN_BATCH);
            var documentService = this.applicationContext.getService("documentService");
            documentService.insertCopiesOfAsBuiltDocumentVersions(selectedDocumentVersionIds, subProjectId, organisationPersonId, password, onlyDocumentReference).then(
                lang.hitch(this, function(errorStrings) {
                    this.registerAsyncOperationFinished(AsBuiltSignWidget.AsyncOperation.SIGN_BATCH);
                    var errorString = "Folgende Pläne wurden wegen Fehler ignoriert: ";
                    for (var n = 0; n < errorStrings.length; n++) {
                        errorString += errorStrings[n] + (n < errorStrings.length-1?" ":"");
					}
        			var infoDialog = new InfoDialog({
			                        title : i18n.error,
			                      content : errorString,
			                 defaultWidth : 350,
			                defaultHeight : 150,
			                      buttons : [{    type : InfoDialog.Button.OK }]                                 
		            });
		            if (errorStrings.length > 0)
    					infoDialog.show();
    					
                    on.emit(this, "batchSignCompleted");
                }),
                lang.hitch(this, function(err) {
					var message = i18n.documentPageAsBuiltSignFailed;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : AsBuiltSignWidget.AsyncOperation.SIGN_BATCH,
                                opName : "batchSignWorkflowNodePositionResults",
                               message : message
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [batchSignWorkflowNodePositionResults]", err);
                    }));            
        },

        updateWidgetState : function() {
            var password = this.passwordTextBox.get("value");
            var allFieldsValid = password != null && password.length > 0;
            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;
                on.emit(this, "validStateChange");
            }       
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidgetAsBuilt.destroy();
        }
    });

    AsBuiltSignWidget.AsyncOperation = {
        SIGN : "Sign",
        SIGN_BATCH : "SignBatch"        
    };

    return AsBuiltSignWidget;
});
