define([ 
         "clazzes/TinyLog",
         "clazzes/util/DOMHelper",
         "clazzes/widgets/layout/ContentWidget",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 DOMHelper,
    		 ContentWidget,
    		 domClass,
    		 domConstruct,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.widget.AddressShowWidget";

	var log = new TinyLog(className);
	
    var AddressShowWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();

    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "AddressShowWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		domClass.add(topDiv, "refNodeOfPositionAbsolute addressShowTopDiv");
    		
    		this.nameDiv = DOMHelper.createTextNode("div", "", topDiv, "fixedDialogWidget addressShowNameLabel addressShowLabel");
    		this.postalAddressDiv = DOMHelper.createTextNode("div", "", topDiv, "fixedDialogWidget addressShowPostalAddressLabel addressShowLabel");
    		this.localityDiv = DOMHelper.createTextNode("div", "", topDiv, "fixedDialogWidget addressShowLocalityLabel addressShowLabel");
    		this.countryDiv = DOMHelper.createTextNode("div", "", topDiv, "fixedDialogWidget addressShowCountryLabel addressShowLabel");
    		
    		return topDiv;    		
    	},
    	
     	setData : function(joinDto) {
     		this.joinDto = joinDto;
     		this.updateWidgetsFromData();
     	},
     	
     	updateWidgetsFromData : function() {
     		if (this.joinDto) {
         		DOMHelper.setInnerText(this.nameDiv, this.joinDto[this.nameProperty]);
         		DOMHelper.setInnerText(this.postalAddressDiv, this.joinDto[this.postalAddressProperty]);
         		DOMHelper.setInnerText(this.localityDiv, this.joinDto[this.postalCodeProperty] + " " + this.joinDto[this.localityNameProperty]);
         		DOMHelper.setInnerText(this.countryDiv, this.joinDto[this.countryProperty]);     			
     		} else {
         		DOMHelper.setInnerText(this.nameDiv, "");
         		DOMHelper.setInnerText(this.postalAddressDiv, "");
         		DOMHelper.setInnerText(this.localityDiv, "");
         		DOMHelper.setInnerText(this.countryDiv, "");     			
     		}
     	}
    });
    
    return AddressShowWidget;
});