define([ 
         "cdes/core/CdesVoc",
         "clazzes/TinyLog",
         "clazzes/dateTime/DateHelper",
         "clazzes/util/DOMHelper",
         "clazzes/widgets/layout/ContentWidget",
         "dgrid/OnDemandGrid",
         "dgrid/extensions/ColumnResizer",
         "dgrid/extensions/DijitRegistry",
         "dgrid/util/misc",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dstore/Memory",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 CdesVoc,
    		 TinyLog,
    		 DateHelper,
    		 DOMHelper,
    		 ContentWidget,
    		 OnDemandGrid,
    		 ColumnResizer,
    		 DijitRegistry,
    		 dgridMiscUtil,    		 
    		 domClass,
    		 domConstruct,
    		 declare,
    		 lang,
    		 Memory,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plan.DocumentDateHistoryWidget";

	var log = new TinyLog(className);
	
    var DocumentDateHistoryWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();

    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "DocumentDateHistoryWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructColumns : function() {
    		var columns = [];
 		
       		columns.push({
        			  field : "_number",
        			     id : "number",
        	       sortable : true,
        			  label : i18n.documentDateHistoryNumberColumnCaption
       		});    			

       		columns.push({
        			  field : "_startDate",
        			     id : "startDate",
        		  formatter : lang.hitch(this, this.startDateFormatter),
        	       sortable : true,
        			  label : i18n.documentDateHistoryStartDateColumnCaption
       		});
       		
       		columns.push({
  			          field : "_endDate",
  			             id : "endDate",
  		          formatter : lang.hitch(this, this.endDateFormatter),
  	               sortable : true,
  			          label : i18n.documentDateHistoryEndDateColumnCaption
 		    });       		

       		columns.push({
        			  field : "_changed",
        			     id : "changed",
        		  formatter : lang.hitch(this, this.changedFormatter),
        	       sortable : true,
        			  label : i18n.documentDateHistoryChangedColumnCaption
       		});    			

    		return columns;
    	},    	
    	
    	constructTopDiv : function() {
    		var columns = this.constructColumns();
    		this.store = new Memory({data : [], idProperty : "documentDateHistoryPartId"});
    		
    		var MyGrid = declare([OnDemandGrid, ColumnResizer, DijitRegistry]);
    		this.grid = new MyGrid({
    			collection : this.store,
    			   columns : columns,
    			   		id : "DocumentDateHistoryPartGrid"
    		});
    		
    		domClass.add(this.grid.domNode, "documentDateHistoryGrid");
    		
    		this.grid.startup();    		
    		
            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);
    		
    		//var topDiv = domConstruct.create("div", null, null);
    		//domClass.add(topDiv, "refNodeOfPositionAbsolute documentDateHistoryTopDiv");
    		
    		return this.grid.domNode;
    	},
    	
    	startDateFormatter : function(_startDate, joinDto) {
    		var bold = (   joinDto.documentDateHistoryPartModType == CdesVoc.DocumentDateHistoryModType.START
    				    || joinDto.documentDateHistoryPartModType == CdesVoc.DocumentDateHistoryModType.BOTH);
    		
    		var start = joinDto.documentDateHistoryPartStartDate;
    		var s = start ? DateHelper.formatUtcSecondsWithTimeZone(start, this.applicationContext.getTimeZone(), i18n.datePattern) : "";
    		return bold ? "<b>" + s + "</b>" : s;
    	},
    	
    	endDateFormatter : function(_endDate, joinDto) {
    		var bold = (   joinDto.documentDateHistoryPartModType == CdesVoc.DocumentDateHistoryModType.END
				        || joinDto.documentDateHistoryPartModType == CdesVoc.DocumentDateHistoryModType.BOTH);    		
    		
    		var end = joinDto.documentDateHistoryPartEndDate;
    		var s = end ? DateHelper.formatUtcSecondsWithTimeZone(end, this.applicationContext.getTimeZone(), i18n.datePattern) : "";
    		return bold ? "<b>" + s + "</b>" : s;
    	},
    	
    	changedFormatter : function(_changed, joinDto) {
    		var givenNameString = (joinDto.personGivenName ? joinDto.personGivenName : "");
    		var surNameString = (joinDto.personSurName ? joinDto.personSurName : "");
    		var both = givenNameString.length > 0 && surNameString.length > 0;

    		var s = givenNameString + (both ? " " : "") + surNameString;
    		if (joinDto.documentDateHistoryPartEditDate != null) {
    			s += "<br>";
    			s += "(";
    			s += DateHelper.formatUtcSecondsWithTimeZone(joinDto.documentDateHistoryPartEditDate, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);
    			s += ")";
    		}
    		return s;
    	},
    	
    	setData : function(historyItems) {
    		this.historyItems = historyItems;
    		this.updateAuxiliaryData();
    		this.reload();
    	},
    	
    	updateAuxiliaryData : function() {
    		this.historyItems.sort(function(itemOne, itemTwo) {
    			// Decreasing sort order
    			return itemTwo.documentDateHistoryPartEditDate - itemOne.documentDateHistoryPartEditDate;
    		});    		
    		
    		for (var n = 0; n < this.historyItems.length; n++) {
    			var item = this.historyItems[n];
    			item._number = (this.historyItems.length - n).toString();
    			item._startDate = this.startDateFormatter(null, item).replace("<b>", " ").replace("</b>", " ");
    			item._endDate = this.endDateFormatter(null, item).replace("<b>", " ").replace("</b>", " ");
    			item._changed = this.changedFormatter(null, item).replace("<br>", " ");
    		}
    	},
    	
    	reload : function() {
    		this.store.setData(this.historyItems);
    		this.grid.refresh();
    	},
    	
    	destroy : function() {
    		this.inherited(arguments);
    		this.grid.destroy();
    	}
    });
    
    return DocumentDateHistoryWidget;
});