/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationOrderImport
////i18n-prefix = planningNotificationOrderImport


define([ "clazzes/TinyLog",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dijit/form/Form",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojox/form/Uploader",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(TinyLog,
			topic,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			InfoDialog,
			Form,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,		
			declare,
			lang,
			Uploader,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderImportWidget";

	var log = new TinyLog(className);

	var PlanningNotificationOrderImportWidget = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			this.changed = true;

			this.allFieldsValid = false;
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderImportWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "planningNotificationOrderImportImportDiv");

			DOMHelper.createTextNode("div", i18n.planningNotificationOrderImportLabel, topDiv, "propertyLabel planningNotificationOrderImportImportLabel");

			// Import form etc.
			var uploadUrl = "/cdes-dojo-impl/tempFileUpload";

			var importFrame = this.applicationContext.getFancyIFrame();

			this.importForm = new Form({method : "post", encType : "multipart/form-data"});
			domClass.add(this.importForm.domNode, "planningNotificationOrderImportForm");
			domConstruct.place(this.importForm.domNode, topDiv);

			this.importForm.set("action", uploadUrl);
			this.importForm.set("target", importFrame.id);

			this.documentLoadRegistration = on(importFrame, "documentLoad", lang.hitch(this, function(event) {
				var content = event.document ? event.document.body.innerHTML : null;
				log.info("Received content [" + content + "]");

				this.tempFileName = content;

				this.changed = true;
				this.allFieldsValid = true;		
				on.emit(this, "changedStateChange");
				on.emit(this, "fileUploaded");

				this.uploader.reset();

				this.updateWidgetState();
			}));	    

			// Uploader
			this.uploader = new dojox.form.Uploader({
				name : "uploadedFile",
				multiple : false,
				type : "file",
				label : i18n.chooseFile
			});
			domClass.add(this.uploader.domNode, "planningNotificationOrderImportUpload");
			domConstruct.place(this.uploader.domNode, this.importForm.domNode);  
			this.uploader.set("url", uploadUrl);
			this.uploader.startup();

			on(this.uploader, "change", lang.hitch(this, function(fileInfos) {
				if (fileInfos.length > 0 && fileInfos[0].name != null) {
					this.uploadedFileName = fileInfos[0].name;
				} else {
					this.uploadedFileName = null;
				}

				DOMHelper.setInnerText(this.uploadStatusNode, this.uploadedFileName);

				this.importForm.submit();
			}));

			this.uploadStatusNode = domConstruct.create("div", null, null);
			domClass.add(this.uploadStatusNode, "fixedDialogWidget planningNotificationOrderImportStatusDiv");
			domConstruct.place(this.uploadStatusNode, topDiv);

			return topDiv;
		},

		postResizeFunction : function(newSize) {
		},

		setData : function(params) {
		},

		reload : function() {
		},

		save : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

			this.registerAsyncOperationStarted(PlanningNotificationOrderImportWidget.AsyncOperation.UPLOAD);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.importPlanningNotificationOrdersFromCsv(organisationPersonId, this.planningNotificationId, this.tempFileName).then(
					lang.hitch(this, function(importLines) {
						this.registerAsyncOperationFinished(PlanningNotificationOrderImportWidget.AsyncOperation.UPLOAD);

						this.showResultDialog(importLines);		    

						this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderImportWidget.AsyncOperation.UPLOAD,
							opName : "importPlanningNotificationOrdersFromCsv",
							message : i18n.planningNotificationOrderImportFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [importPlanningNotificationOrdersFromCsv]", err);
							}));            
		},

		showResultDialog : function(importLines) {
			var numberOfSuccess = 0;
			var errorMessage = null;
			for (var n = 0; n < importLines.length; n++) {
				var importLine = importLines[n];
				if (importLine.error) {
					errorMessage = importLine.message;
				} else {
					numberOfSuccess++;
				}		    
			}

			if (errorMessage != null) {
				InfoDialog.showError({
					message : errorMessage,
					title : i18n.planningNotificationOrderImportFailedSummaryCaption
				});
			} else {
				var serialNumberString = "";
				for (var n = 0; n < importLines.length; n++) {
					serialNumberString += importLines[n].serialNumber;
					if (n < importLines.length - 1) {
						serialNumberString += ", ";
					}			
				}

				var resultString = string.substitute(i18n.planningNotificationOrderImportResult, {
					serialNumbers : serialNumberString
				});		    

				InfoDialog.open({
					title : i18n.planningNotificationOrderImportResultSummaryCaption,
					content : DOMHelper.createTextNode("div", resultString, null, null),
					buttons : [ { type : InfoDialog.Button.OK } ]
				});

				topic.publish("message/ok", resultString);		
			}
		},

		constructResultDiv : function(importLines) {

		},	

		updateWidgetState : function() {
			var allFieldsValid = this.tempFileName != null;
			if (this.allFieldsValid != allFieldsValid) {
				on.emit(this, "validStateChange");
				this.allFieldsValid = allFieldsValid;		
			}		
		},

		getTempFileName : function() {
			return this.tempFileName;
		},

		destroy : function() {
			this.inherited(arguments);
			if (this.documentLoadRegistration != null) {
				this.documentLoadRegistration.remove();
			}
		}
	});

	PlanningNotificationOrderImportWidget.AsyncOperation = {
			IMPORT : "Import"
	};

	return PlanningNotificationOrderImportWidget;
});
