/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = jobPage
////i18n-prefix = jobPage



define([ "cdes/admin/job/JobListWidget",
    "cdes/core/CdesVoc",
    "cdes/util/ActionHelper",
    "cdes/util/MspHelper",
    "cdes/widget/ContextBar",
    "clazzes/TinyLog",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",       
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(JobListWidget,
    CdesVoc,
    ActionHelper,
    MspHelper,
    ContextBar,
    TinyLog,
    topic,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    Button,
    domClass,
    domConstruct,
    domStyle,
    on,             
    string,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.admin.job.JobPage";

    var log = new TinyLog(className);

    var JobPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.destroyedJobUuids = new Object();

            this.allFieldsValid = true;
            this.reload();
        },

        getWidgetId : function() {
            return "JobPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            topic.subscribe("context/change", lang.hitch(this, function() {
                this.reload();
            }));

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            // List Widget
            this.listWidget = new JobListWidget({
                applicationContext : this.applicationContext,
                          backPage : "jobList",
                        backParams : new Object()
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(this.listWidgetDiv, topDiv);

            this.listWidget.restoreColumnWidths();

            // Reload data after certain operations which change state have been performed
            on(this.listWidget, "doSearch", lang.hitch(this, this.reload));
            on(this.listWidget, "jobDestroyed", lang.hitch(this, function(uuid) {
                this.destroyedJobUuids[uuid] = true;
                this.setupPostDestroyTimer();
            }));
            on(this.listWidget, "jobDeleted", lang.hitch(this, function(uuid) {
                this.reload();
            }));                                            

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);
            
            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.jobPageCaption, captionBarDiv, "cdesGeneralPageCaption");
            
            this.constructReloadButton(captionBarDiv);

            MspHelper.constructRunMspExportNowButton({
                         parentDiv : captionBarDiv,
                       buttonClass : "jobPageRunMspExportNowButton",
                            widget : this,
                applicationContext : this.applicationContext                    
            });
            
            return captionBarDiv;
        },

        constructReloadButton : function(captionBarDiv) {
            // Save button
            var button = new Button({
                label : i18n.jobListReloadButtonCaption,
                title : i18n.jobListReloadButtonToolTip
            });
            domClass.add(button.domNode, "jobPageReloadButton");
            domConstruct.place(button.domNode, captionBarDiv);

            on(button, "click", lang.hitch(this, function() {
                this.reload();
            }));            

            return button;      
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute", "jobPageContentDiv");

            return contentDiv;
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;                   

            var tableHeight = totalHeight
            //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
            - this.captionBarDiv.offsetHeight
            //      - this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
            //      - this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
            //      - this.statusBarDiv.offsetHeight
            - 16;
            this.listWidget.resize({ h : tableHeight });
        },

        setData : function() {

        },

        reload : function() {
            if (log.isDebugEnabled()) {
                log.debug("Started JobPage.reload, about to call contextBar.reload()");     
            }               

            //this.contextBar.reload();
            this.listWidget.setData({ jobs : [] });

            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var searchModel = {
                organisationPersonId : organisationPersonId,
                           networkId : networkId,
                    includeScheduled : true,
                      includeStarted : true,
                  includeInterrupted : true,
                     includeFinished : true,
                       includeFailed : true             
            };                  

            if (this.getJobsHandle != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Not reloading since a query is already running");
                }
                return;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Reloading jobs...");
                }
            }                   

            this.registerAsyncOperationStarted(JobPage.AsyncOperation.LOAD);
            var networkService = this.applicationContext.getService("networkService");
            this.getJobsHandle = networkService.getJobs(searchModel).then(
                lang.hitch(this, function(jobJoins) {
                    this.registerAsyncOperationFinished(JobPage.AsyncOperation.LOAD);

                    this.jobJoins = jobJoins;
                    this.listWidget.setData({ 
                        jobs : jobJoins
                    });
                    
                    var message = string.substitute(i18n.jobPageSearchSuccessful, {
                        count : jobJoins.length
                    });

                    delete this.getJobsHandle;
                    topic.publish("message/ok", message);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : JobPage.AsyncOperation.LOAD,
                                opName : "getJobs",
                               message : i18n.planningNotificationProjectPageGetProjectsFailed
                    });
                    delete this.getJobsHandle;
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getJobs]", err);
                    }));
        },

        updateWidgetState : function() {

        },

        postDestroyTimerMillis : 1000,

        setupPostDestroyTimer : function() {
            if (this.postDestroyTimerHandle == null) {
                if (log.isDebugEnabled()) {
                    log.debug("setupPostDestroyTimer starts timer");
                }                   
                this.postDestroyTimerHandle = window.setInterval(lang.hitch(this, this.checkForDestroyProcessDisappeared), this.postDestroyTimerMillis);  
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("setupPostDestroyTimer does not start timer, since it is already started.");
                }
            }                   
        },

        tearDownPostDestroyTimer : function() {
            if (this.postDestroyTimerHandle != null) {
                window.clearInterval(this.postDestroyTimerHandle);
                this.postDestroyTimerHandle = null;
                if (log.isDebugEnabled()) {
                    log.debug("tearDownPostDestroyTimer stopped timer");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("tearDownPostDestroyTimer did not stop timer since there is none");
                }
            }                   
        },


        checkForDestroyProcessDisappeared : function() {
            if (log.isDebugEnabled()) {
                log.debug("checkForDestroyProcessDisappeared called.");
            }

            var destroyedUuidsStillThere = new Object();
            for (var n = 0; n < this.jobJoins.length; n++) {
                if (this.jobJoins[n].jobUuid in this.destroyedJobUuids) {
                    destroyedUuidsStillThere[this.jobJoins[n].jobUuid] = true;
                }
            }

            var anyDestroyedUuidStillThere = false;
            for (var uuid in this.destroyedJobUuids) {
                if (uuid in destroyedUuidsStillThere) {
                    if (log.isDebugEnabled()) {
                        log.debug("uuid [" + uuid + "] still there");
                    }                           
                    anyDestroyedUuidStillThere = true;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("uuid [" + uuid + "] no longer there");
                    }

                    delete this.destroyedJobUuids[uuid];
                }                   
            }

            if (!anyDestroyedUuidStillThere) {
                this.tearDownPostDestroyTimer();
            }                   

            this.reload();          
        },

        destroy : function() {
            this.inherited(arguments);
            //                      this.listWidget.destroy();
        }
    });

    JobPage.AsyncOperation = {
        LOAD : "Load"
    };

    return JobPage;
});
