/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = defineWorkflow
////i18n-prefix = defineWorkflow


define([ "cdes/planning/workflow/WorkflowNodeEditWidget",
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
    	"clazzes/form/FancyButton",
        "dijit/form/Button",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(WorkflowNodeEditWidget,
         TinyLog,
         DOMHelper,
         ErrorHelper,
         ContentWidget,
         InfoDialog,
    	 FancyButton,
         Button,
         TextBox,
         domClass,
         domConstruct,
         domStyle,
         on,
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.planning.workflow.DefineWorkflowPage";

    var log = new TinyLog(className);

    var DefineWorkflowPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.nodeIdToEditInfo = new Object();
            
            this.topDiv = this.constructTopDiv();

            this.reload();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "DefineWorkflowPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.defineWorkflowShortPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            // InitWorkflow button
            this.initWorkflowButton = new Button({
                label : i18n.defineWorkflowInitWorkflowButtonCaption,
                title : i18n.defineWorkflowInitWorkflowToolTip
            });
            domClass.add(this.initWorkflowButton.domNode, "defineWorkflowInitWorkflowButton");
            domConstruct.place(this.initWorkflowButton.domNode, captionBarDiv);

            on(this.initWorkflowButton, "click", lang.hitch(this, function() {
                this.askInitWorkflow();
            }));            

            // Close button
            this.closeButton = new Button({
                label : i18n.closeButtonCaption,
                title : i18n.defineWorkflowCloseButtonToolTip
            });
            domClass.add(this.closeButton.domNode, "defineWorkflowCloseButton");
            domConstruct.place(this.closeButton.domNode, captionBarDiv);

            on(this.closeButton, "click", lang.hitch(this, function() {
                this.close();
            }));            

            // resetWorkflowButton if user has the superAdmin permission (will checked serverside)
            this.resetWorkflowButton = new FancyButton({
                    title : i18n.defineWorkflowResetWorkflowToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });
            domClass.add(this.resetWorkflowButton.domNode, "listButton deleteButton hidden");
            domConstruct.place(this.resetWorkflowButton.domNode, captionBarDiv);

            on(this.resetWorkflowButton, "click", lang.hitch(this, function() {
                this.askResetWorkflow();
            }));
            return captionBarDiv;
        },

        askInitWorkflow : function() {
            InfoDialog.showQuestion({
                  title : i18n.defineWorkflowInitWorkflowQuestionCaption,
                message : i18n.defineWorkflowInitWorkflowQuestionText,
                buttons : [
                           { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                               this.initWorkflow();
                           })},                                       
                           { type : InfoDialog.Button.NO }
                ]
            });                         
        },          

        initWorkflow : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(DefineWorkflowPage.AsyncOperation.INITIALIZE_WORKFLOW);

            planningNotificationService.initializeWorkflow(organisationPersonId, this.orderJoin.workflowEntityWorkflowId).then(
                lang.hitch(this, function(result) {
                    this.registerAsyncOperationFinished(DefineWorkflowPage.AsyncOperation.INITIALIZE_WORKFLOW);
                    if (!result) {
                        InfoDialog.showError({
                              title : i18n.defineWorkflowInitializeWorkflowNotPossibleTitle,
                            message : i18n.defineWorkflowInitializeWorkflowNotPossibleText
                        });
                    } else {
                        this.reload();
                    }                       
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DefineWorkflowPage.AsyncOperation.INITIALIZE_WORKFLOW,
                                opName : "initializeWorkflow",
                               message : i18n.defineWorkflowInitializeWorkflowFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [initializeWorkflow]", err);
                    }));            
        },

        askResetWorkflow : function() {
            InfoDialog.showQuestion({
                  title : i18n.defineWorkflowResetWorkflowTitle,
                message : i18n.defineWorkflowResetWorkflowText,
           defaultWidth : 500,
                buttons : [
                    { type : InfoDialog.Button.CUSTOM,
                                 name : "defineWorkflowResetButtonWithPositions",
                                label : i18n.defineWorkflowResetButtonWithPositions,
                                title : i18n.defineWorkflowResetButtonWithPositionsToolTip,
                          manualClose : false,
                       			  fct : lang.hitch(this, function() {
                        this.resetWorkflow(true);
                    })},                                       
                    { type : InfoDialog.Button.CUSTOM,
                                 name : "defineWorkflowResetButtonWithoutPositions",
                                label : i18n.defineWorkflowResetButtonWithoutPositions,
                                title : i18n.defineWorkflowResetButtonWithoutPositionsToolTip,
                          manualClose : false,
                       			  fct : lang.hitch(this, function() {
                        this.resetWorkflow(false);
                    })},                                       
                    { type : InfoDialog.Button.ABORT }
                ]
            });
        },

        resetWorkflow : function(includingPositions) {
            var workflowId = this.orderJoin.workflowEntityWorkflowId;
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(DefineWorkflowPage.AsyncOperation.RESET_WORKFLOW);

            planningNotificationService.resetPlanningNotificationWorkflow(workflowId, organisationPersonId, includingPositions).then(
                lang.hitch(this, function(result) {
                    this.registerAsyncOperationFinished(DefineWorkflowPage.AsyncOperation.INITIALIZE_WORKFLOW);
                    if (result<0) {
                        InfoDialog.showError({
                              title : i18n.defineWorkflowResetWorkflowTitle,
                            message : i18n.defineWorkflowResetWorkflowFailed
                        });
                    } else {
                    	var messageText = result==0?i18n.defineWorkflowResetResultWithoutPositions:i18n.defineWorkflowResetResultWithPositions;
                        InfoDialog.showWarning({
                              title : i18n.defineWorkflowResetWorkflowTitle,
                            message : messageText
                        });
                    }                       
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DefineWorkflowPage.AsyncOperation.RESET_WORKFLOW,
                                opName : "resetWorkflow",
                               message : i18n.defineWorkflowResetWorkflowFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [resetWorkflow]", err);
                    }));            
        },

        close : function() {
            if (this.backPage != null) {
                this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
            }                                                
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute defineWorkflowPageContentDiv");

            // SerialNumberTextBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, contentDiv, "propertyLabel defineWorkflowSerialNumberLabel");
            this.serialNumberTextBox = new TextBox({
                   label : i18n.planningNotificationOrderSerialNumberLabel,
                   title : i18n.planningNotificationOrderSerialNumberToolTip,
                disabled : true
            });
            domClass.add(this.serialNumberTextBox.domNode, "fixedDialogWidget defineWorkflowSerialNumberTextBox");
            domConstruct.place(this.serialNumberTextBox.domNode, contentDiv);


            // PlanningNotificationTextBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderPlanningNotificationLabel, contentDiv, "propertyLabel defineWorkflowPlanningNotificationLabel");
            this.planningNotificationTextBox = new TextBox({
                   label : i18n.planningNotificationOrderPlanningNotificationLabel,
                /*                   title : i18n.planningNotificationOrderPlanningNotificationToolTip,*/ // Removed on ÖBB Request
                disabled : true         
            });
            domClass.add(this.planningNotificationTextBox.domNode, "fixedDialogWidget defineWorkflowPlanningNotificationTextBox");
            domConstruct.place(this.planningNotificationTextBox.domNode, contentDiv);

            // ProjectTextBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderProjectLabel, contentDiv, "propertyLabel defineWorkflowProjectLabel");
            this.projectTextBox = new TextBox({
                   label : i18n.planningNotificationOrderProjectLabel,
                /*                   title : i18n.planningNotificationOrderProjectToolTip, */ // Removed on ÖBB Request
                disabled : true 
            });
            domClass.add(this.projectTextBox.domNode, "fixedDialogWidget defineWorkflowProjectTextBox");
            domConstruct.place(this.projectTextBox.domNode, contentDiv);

            this.nodeEditDiv = domConstruct.create("div", null, null);
            domClass.add(this.nodeEditDiv, "fixedDialogWidget defineWorkflowNodeEditDiv");
            domConstruct.place(this.nodeEditDiv, contentDiv);       

            return contentDiv;
        },

        resize : function(newSize) {
            var totalHeight = newSize.h;

            this.contentHeight = totalHeight
                               - this.captionBarDiv.offsetHeight
                               - 16;

            domStyle.set(this.contentDiv, "height", this.contentHeight + "px");
            
            this.updateNodeEditWidgetsFromData();
        },

        setData : function() {

        },

        reload : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(DefineWorkflowPage.AsyncOperation.LOAD);

            planningNotificationService.getPlanningNotificationOrderJoin(this.id, organisationPersonId).then(
                lang.hitch(this, function(planningNotificationOrderInfo) {
                    this.orderJoin = planningNotificationOrderInfo.orderJoin;
                    this.projectJoins = planningNotificationOrderInfo.projectJoins;
                    this.baulosMetaInformations = planningNotificationOrderInfo.baulosMetaInformations;
                    this.workflowNodeJoins = planningNotificationOrderInfo.workflowNodeJoins;
                    this.workflowNodeIdToPositions = planningNotificationOrderInfo.workflowNodeIdToPositions;
                    this.workflowNodePositionIdToBaulose = planningNotificationOrderInfo.workflowNodePositionIdToBaulose;                   
                    this.workflowNodePositionIdToOwnerTokens = planningNotificationOrderInfo.workflowNodePositionIdToOwnerTokens;
                    this.workflowNodePositionIdToInitiatorTokens = planningNotificationOrderInfo.workflowNodePositionIdToInitiatorTokens;
                    this.workflowInitialized = planningNotificationOrderInfo.workflowInitialized;
                    this.workflowNodeInitiatorPositionIdToHasResults = planningNotificationOrderInfo.workflowNodeInitiatorPositionIdToHasResults;
                    this.initiatorPositionIdToHasFreigabeResults = planningNotificationOrderInfo.initiatorPositionIdToHasFreigabeResults;                    
                    // Transform from List to Set, for easier handling lateron.
                    var allowedGlobalActionsList = planningNotificationOrderInfo.globalActions;
                    var allowedGlobalActionsSet = new Object();
                    for (var v = 0; v < allowedGlobalActionsList.length; v++) {
                        allowedGlobalActionsSet[allowedGlobalActionsList[v]] = true;
                    }
					this.globalActions = allowedGlobalActionsSet;
					
                    this.workflowNodeJoins.sort(function(joinOne, joinTwo) {
                        return joinOne.workflowNodeTemplatePosition - joinTwo.workflowNodeTemplatePosition;
                    });                         

                    this.updateWidgetsFromData();
                    this.updateNodeEditWidgetsFromData();
                    this.updateWidgetState();

                    this.registerAsyncOperationFinished(DefineWorkflowPage.AsyncOperation.LOAD);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DefineWorkflowPage.AsyncOperation.LOAD,
                                opName : "getPlanningNotificationOrderJoin",
                               message : i18n.defineWorkflowGetJoinFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPlanningNotificationOrderJoin]", err);
                    }));
        },

        updateWidgetState : function() {
            var initDisabled = this.workflowInitialized;
                             //check if there are new positions, if not disable the button
            initDisabled |= this.noNewPositions;
            if (this.workflowNodeJoins == null) {
                initDisabled = true;
            } else {
                for (var n = 0; n < this.workflowNodeJoins.length; n++) {
                    var workflowNodeJoin = this.workflowNodeJoins[n];
                    if (workflowNodeJoin.workflowNodeTemplateMandatory) {
                        var nodeEditWidget = this.nodeIdToEditInfo[workflowNodeJoin.workflowNodeId].nodeEditWidget;
                        if (nodeEditWidget != null) {
                            initDisabled |= nodeEditWidget.getNumberOfEntries() == 0;
                        }                       
                    }                   
                }               
            }       
            
            //if workflowEntityStatusId != null the workflow has been already initialized
            if (this.orderJoin && this.orderJoin.workflowEntityStatusId != null){
                this.initWorkflowButton.set("label", i18n.defineWorkflowReInitWorkflowButtonCaption);
                this.initWorkflowButton.set("title", "");
            }else{
                this.initWorkflowButton.set("label", i18n.defineWorkflowInitWorkflowButtonCaption);
                this.initWorkflowButton.set("title", i18n.defineWorkflowInitWorkflowToolTip);
            }

            this.initWorkflowButton.set("disabled", !!initDisabled);
        },

        updateWidgetsFromData : function() {
            var caption = string.substitute(i18n.defineWorkflowLongPageCaption, {
                serialNumber : this.orderJoin.planningNotificationOrderSerialNumber
            });
            DOMHelper.setInnerText(this.captionDiv, caption);

            this.serialNumberTextBox.set("value", this.orderJoin.planningNotificationOrderSerialNumber);
            this.planningNotificationTextBox.set("value", this.orderJoin.planningNotificationTitle);

            var projectName = null;
            for (var n = 0; n < this.projectJoins.length; n++) {
                projectName = this.projectJoins[n].projectName;
                break;          
            }

            this.projectTextBox.set("value", projectName);
            
           // Show resetWorkflowButton if user has the superAdmin permission
            if (this.globalActions && "deleteTask" in this.globalActions) {
				domClass.remove(this.resetWorkflowButton.domNode, "hidden");
            } else {
				//domClass.add(this.resetWorkflowButton.domNode, "hidden");
				this.resetWorkflowButton.domNode.remove();
            }
            
        },

        updateNodeEditWidgetsFromData : function() {
            var maxPosition = null;
            var maxPositionWorkflowNodeId = null;
            if (this.workflowNodeJoins == null)
            	return;
            for (var n = 0; n < this.workflowNodeJoins.length; n++) {
                var workflowNodeJoin = this.workflowNodeJoins[n];
                var position = workflowNodeJoin.workflowNodeTemplatePosition;
                if (maxPosition == null || position > maxPosition) {
                    maxPosition = position;
                    maxPositionWorkflowNodeId = workflowNodeJoin.workflowNodeId;
                }
            }
            var maxPositionPositionJoins = (maxPositionWorkflowNodeId != null && maxPositionWorkflowNodeId in this.workflowNodeIdToPositions 
                                            ? this.workflowNodeIdToPositions[maxPositionWorkflowNodeId] : []);

            this.minHeight = 0;
            this.noNewPositions = true;
            for (var n = 0; n < this.workflowNodeJoins.length; n++) {
                var workflowNodeJoin = this.workflowNodeJoins[n];
                var workflowNodeId = workflowNodeJoin.workflowNodeId;
                var workflowNodePositionJoins = (workflowNodeId in this.workflowNodeIdToPositions ? this.workflowNodeIdToPositions[workflowNodeId] : []);

                var workflowNodePositionIdToBaulose = new Object();
                for (var z = 0; z < workflowNodePositionJoins.length; z++) {
                    var workflowNodePositionId = workflowNodePositionJoins[z].workflowNodePositionId;
                    
                    //check for results
                    if (workflowNodeJoin.workflowNodeTemplatePosition ==1 && !(workflowNodePositionId in this.workflowNodeInitiatorPositionIdToHasResults))
                    this.noNewPositions &= false;
                    
                    var baulose = (workflowNodePositionId in this.workflowNodePositionIdToBaulose ? this.workflowNodePositionIdToBaulose[workflowNodePositionId] : []);
                    workflowNodePositionIdToBaulose[workflowNodePositionId] = baulose;              
                }                   
                for (var z = 0; z < maxPositionPositionJoins.length; z++) {
                    var maxPositionPositionJoin = maxPositionPositionJoins[z];
                    var maxPositionId = maxPositionPositionJoin.workflowNodePositionId;
                    var baulose = (maxPositionId in this.workflowNodePositionIdToBaulose ? this.workflowNodePositionIdToBaulose[maxPositionId] : []);
                    workflowNodePositionIdToBaulose[maxPositionId] = baulose;                                  
                }                    

                if (!(workflowNodeId in this.nodeIdToEditInfo)) {
                    var showBaulosForAllNodes = false;
                    for (var z = 0; z < this.projectJoins.length; z++) {
                        var projectJoin = this.projectJoins[z];
                        showBaulosForAllNodes |= projectJoin.projectConfigWorkflowBaulosForAllNodes;
                    }

                    var nodeEditWidget = new WorkflowNodeEditWidget({
                        applicationContext : this.applicationContext,
                                     index : n,
                               showDueDate : workflowNodeJoin.workflowNodeTemplatePosition == 1,
                                showBaulos : workflowNodeJoin.workflowNodeTemplatePosition == 1 || showBaulosForAllNodes
                    });
                    this.nodeIdToEditInfo[workflowNodeId] = {
                        nodeEditWidget : nodeEditWidget
                    };
                    on(nodeEditWidget, "reloadRequested", lang.hitch(this, function() {
                        this.reload();
                    }));

                    var nodeEditTopDiv = nodeEditWidget.getContainer();
                    domConstruct.place(nodeEditTopDiv, this.nodeEditDiv);

                    domStyle.set(nodeEditTopDiv, "top", "0px");
                    domStyle.set(nodeEditTopDiv, "left", "0px");
                }

                nodeEditWidget = this.nodeIdToEditInfo[workflowNodeId].nodeEditWidget;
                nodeEditWidget.setData({
                                               workflowNodeJoin : workflowNodeJoin,
                                      workflowNodePositionJoins : workflowNodePositionJoins,
                                       maxPositionPositionJoins : maxPositionPositionJoins,
                                workflowNodePositionIdToBaulose : workflowNodePositionIdToBaulose,
                        workflowNodePositionIdToInitiatorTokens : this.workflowNodePositionIdToInitiatorTokens,
                            workflowNodePositionIdToOwnerTokens : this.workflowNodePositionIdToOwnerTokens,
                                         baulosMetaInformations : this.baulosMetaInformations,
                                                   projectJoins : this.projectJoins,
                                            workflowInitialized : this.workflowInitialized,
                    workflowNodeInitiatorPositionIdToHasResults : this.workflowNodeInitiatorPositionIdToHasResults,
                        initiatorPositionIdToHasFreigabeResults : this.initiatorPositionIdToHasFreigabeResults,
                        						  globalActions : this.globalActions
                });
            }           

            var totalWidth = 1250;
            var paddingX = 10;
            var paddingY = 15;
            var epsilon = 1e-7;     
            var currLineHeight = 0;
            var totalNeededHeight = 0;
            var lines = [[]];
            var line = 0;
            var x = 0;
            for (var v = 0; v < this.workflowNodeJoins.length; v++) {
                var currWorkflowNodeJoin = this.workflowNodeJoins[v];
                var currWorkflowNodeId = currWorkflowNodeJoin.workflowNodeId;
                var editInfo = this.nodeIdToEditInfo[currWorkflowNodeId];
                var editWidget = editInfo.nodeEditWidget;

                var widthFraction = editWidget.getWidthFraction();
                var height = editWidget.getHeight();

                // Arrange widgets in lines.  Each line gets the height of its highest widget.
                // Widgets are placed horizontally side by side, as long as there is horizontal space.          
                var lineInfo = {
                    expandHeightIfSpaceAvailable : editWidget.doExpandHeightIfSpaceAvailable(),
                                      editWidget : editWidget,
                                           width : widthFraction * totalWidth               
                };                      
                if (x + (widthFraction * totalWidth) <= totalWidth + epsilon || x <= epsilon) {
                    // There is space right of the previous widget.
                    lineInfo.x = x;
                    currLineHeight = Math.max(currLineHeight, height);
                    x += widthFraction * totalWidth;
                } else {
                    // No space right of the previous widget, start next line, but before, define the height
                    // of all widgets of the previous line.                 
                    totalNeededHeight += currLineHeight;
                    for (var w = 0; w < lines[line].length; w++) {
                        lines[line][w].height = currLineHeight;
                    }

                    lineInfo.x = 0;
                    currLineHeight = height;
                    line++;
                    lines.push([]);
                    x = widthFraction * totalWidth;                  
                }

                lines[line].push(lineInfo);
            }

            // Heights at the last line
            totalNeededHeight += currLineHeight;
            for (var r = 0; r < lines[line].length; r++) {
                lines[line][r].height = currLineHeight;
            }

            // Find out wether we have that less space that we need to make the nodeEditDiv higher than the available space.
            // This will trigger an additional scrollbar, thus we try to avoid it usually.          
            var availableHeight = this.contentHeight - 80;
            this.nodeDivHeight = availableHeight < totalNeededHeight ? totalNeededHeight : availableHeight;
            domStyle.set(this.nodeEditDiv, "height", this.nodeDivHeight + "px");

            // Find out which height is occupied by the fixed heights, and how many lines want to occupy additional vertical space
            var fixedHeightSum = 0;
            var numberOfFreeHeightLines = 0;
            for (var q = 0; q < lines.length; q++) {
                var fixedHeightHere = false;
                for (var s = 0; s < lines[q].length; s++) {
                    fixedHeightHere |= !lines[q][s].expandHeightIfSpaceAvailable;
                }

                fixedHeightSum += lines[q][0].height;
                if (!fixedHeightHere) {
                    numberOfFreeHeightLines++;
                }
            }

            // Find out how much additional space each of those lines can gain
            var freeHeightSum = this.nodeDivHeight - fixedHeightSum;
            var freeHeightPerLine = freeHeightSum / numberOfFreeHeightLines;        

            // And finally, assemble all those pieces of information, and place the editWidgets accordingly.
            var y = 0;
            for (var l = 0; l < lines.length; l++) {
                var currHeight = (lines[l].length > 0 ? lines[l][0].height + (lines[l][0].expandHeightIfSpaceAvailable ? freeHeightPerLine : 0) : 0);
                for (var m = 0; m < lines[l].length; m++) {
                    var currLineInfo = lines[l][m];
                    currLineInfo.editWidget.place({
                             x : currLineInfo.x + (m > 0 ? paddingX / 2 : 0),
                             y : y + (l > 0 ? paddingY : 0),
                         width : currLineInfo.width - (m < lines[l].length - 1 ? paddingX / 2 : 0),
                        height : currHeight - (l > 0 ? paddingY : 0)
                    }); 
                }

                y += currHeight;                    
            }           
        },          

        destroy : function() {
            this.inherited(arguments);

            for (var id in this.nodeIdToEditInfo) {
                this.nodeIdToEditInfo[id].nodeEditWidget.destroy();
            }           
        }
    });

    DefineWorkflowPage.AsyncOperation = {
        INITIALIZE : "Initialize"
    };

    return DefineWorkflowPage;
});
