/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = workflowNodePositionList
////i18n-prefix = workflowNodePositionList


define([ "cdes/planning/workflow/WorkflowNodeParticipantChooseDialog",
    "cdes/planning/workflow/DueDateEditWidget",
    "cdes/planning/workflow/OptionalDueDateEditWidget",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/ClazzesVoc",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/EditDialog",
    "clazzes/widgets/layout/InfoDialog",
    "clazzes/widgets/layout/ChooseDialog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    WorkflowNodeParticipantChooseDialog,
    DueDateEditWidget,
    OptionalDueDateEditWidget,
    ActionHelper,
    CodeHelper,
    ListWidget,
    ClazzesVoc,
    TinyLog,
    DateHelper,
    FancyButton,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    EditDialog,
    InfoDialog,             
    ChooseDialog,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    domClass,
    domConstruct,
    on,
    string,     
    declare,
    lang,
    Memory,
    Trackable,
    i18n) {

    var className = "at.cdes.web.planning.workflow.WorkflowNodePositionListWidget";

    var log = new TinyLog(className);

    var WorkflowNodePositionListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);
        this.columnWidthKey = "workflowActivityResultList/" + this.index + "/columnWidths",

            this.topDiv = this.constructTopDiv();


            this.allFieldsValid = true;
            },

        getWidgetId : function() {
            return "WorkflowNodePositionListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },



        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            // ProjectParticipant
            columns.push({
                    field : "_projectParticipant",
                       id : "projectParticipant",
                formatter : lang.hitch(this, this.projectParticipantFormatter),
                 sortable : true,
                    label : i18n.workflowNodePositionListProjectParticipantColumn
            });     

            if(this.showBaulos) {
                // Baulos
                columns.push({
                        field : "_baulos",
                           id : "baulos",
                    formatter : lang.hitch(this, this.baulosFormatter),
                     sortable : true,
                        label : i18n.workflowNodePositionListBaulosColumn
                });
            }                            

            if (this.showDueDate) {                    
                // DueDate
                columns.push({
                         field : "_dueDate",
                            id : "dueDate",
                    renderCell : lang.hitch(this, this.renderDueDateCell),
                      sortable : true,
                         label : i18n.workflowNodePositionListDueDateColumn
                });

                // OptionalDueDate
                columns.push({
                         field : "_optionalDueDate",
                            id : "optionalDueDate",
                    renderCell : lang.hitch(this, this.renderOptionalDueDateCell),
                      sortable : true,
                         label : i18n.workflowNodePositionListOptionalDueDateColumn
                });
            }


            columns.push({
                     field : "workflowNodePositionId",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : false,
                     label : i18n.actionColumnCaption
            });

            return columns;
        },

        projectParticipantFormatter : function(_projectParticipant, workflowNodePositionJoin) {
        
        	var res ="";
        	var isActualOwner = false;
        	if (workflowNodePositionJoin.workflowNodePositionId in this.workflowNodePositionIdToOwnerTokens)
        		isActualOwner = true;
            var projectParticipantString = this.getProjectParticipantString(workflowNodePositionJoin);
            if (isActualOwner)
            	res = "<b>" + projectParticipantString + "</b>" /*+ " <--"*/;
        	else
        		res = projectParticipantString;
            return res;     
        },

        getProjectParticipantString : function(workflowNodePositionJoin) {
            return string.substitute(i18n.projectParticipantNameOrganisationFirstwComment, {
                           organisationName : workflowNodePositionJoin.organisationName,
                            personGivenName : workflowNodePositionJoin.personGivenName,
                              personSurName : workflowNodePositionJoin.personSurName,
                projectParticipationComment : (workflowNodePositionJoin.projectParticipationComment!=null && workflowNodePositionJoin.projectParticipationComment.length>0)?" - "+workflowNodePositionJoin.projectParticipationComment:""
            });
        },

        baulosFormatter : function(_baulos, workflowNodePositionJoin) {
            var workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;
            var baulose = (workflowNodePositionId in this.workflowNodePositionIdToBaulose ? this.workflowNodePositionIdToBaulose[workflowNodePositionId] : []);
            baulose.sort(function(baulosOne, baulosTwo) {
                return baulosOne.value - baulosTwo.value;
            });     

            var baulosString = "";
            for (var n = 0; n < baulose.length; n++) {
                var baulos = baulose[n];
                baulosString += baulos.value;
                if (n < baulose.length - 1) {
                    baulosString += ", ";
                }
            }       

            return baulosString;        
        },

        renderDueDateCell : function(workflowNodePositionJoin, data, cell) {
            var node = domConstruct.create("div", null, null);

            var dueDateText;
            if (workflowNodePositionJoin.workflowNodePositionDueDateRemark != null) {
                dueDateText = CodeHelper.getI18nDueDateRemark(workflowNodePositionJoin.workflowNodePositionDueDateRemark);
            } else if (workflowNodePositionJoin.workflowNodePositionDueDate != null) {
                dueDateText = DateHelper.formatUtcSecondsWithTimeZone(workflowNodePositionJoin.workflowNodePositionDueDate,
                    this.applicationContext.getTimeZone(), i18n.datePattern); 
            } else {
                dueDateText = "\u2015";            
            }            
            DOMHelper.createTextNode("span", dueDateText, node, "");

            var workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;
            var ownerTokens = workflowNodePositionId in this.workflowNodePositionIdToOwnerTokens ? this.workflowNodePositionIdToOwnerTokens[workflowNodePositionId] : [];
            var initiatorPositionHasResult = workflowNodePositionId in this.workflowNodeInitiatorPositionIdToHasResults ? true : false;
            
            // enable if not workflowInitialized and not finished (position has no token but result)
            var buttonEnabled = !this.workflowInitialized && !initiatorPositionHasResult;
            // if workflowInitialized enable only if position has token (not finished) and ownerPositionId == initiatorPositionId
            for (var n = 0; n < ownerTokens.length; n++) {
                buttonEnabled |= ownerTokens[n].ownerPositionId == ownerTokens[n].initiatorPositionId;
            }               

            if (buttonEnabled) {
                var button;
                if (workflowNodePositionJoin.workflowNodePositionDueDateRemark != null
                    || workflowNodePositionJoin.workflowNodePositionDueDate != null) {
                    button = this.constructDueDateEditButton(workflowNodePositionJoin, false);
                } else {
                    button = this.constructDueDateNewButton(workflowNodePositionJoin, false);
                }            
                
                domConstruct.place(button.domNode, node);
            }
            return node;        
        },      

        constructDueDateNewButton : function(workflowNodePositionJoin, optionalDueDate) {
            var button = new FancyButton({
                    title : (optionalDueDate ? i18n.workflowNodePositionListNewOptionalDueDateToolTip : i18n.workflowNodePositionListNewDueDateCaption),         
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
            });

            domClass.add(button.domNode, "listButton workflowNodePositionListMixedCellButton");

            on(button, "click", lang.hitch(this, function() {
                if (optionalDueDate) {
                    this.editOptionalDueDate(workflowNodePositionJoin);
                } else {
                    this.editDueDate(workflowNodePositionJoin);
                }                   

            }));

            return button;      
        },      


        constructDueDateEditButton : function(workflowNodePositionJoin, optionalDueDate) {
            var button = new FancyButton({
                    title : (optionalDueDate ? i18n.workflowNodePositionListEditOptionalDueDateCaption : i18n.workflowNodePositionListEditDueDateCaption),         
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
            });

            domClass.add(button.domNode, "listButton workflowNodePositionListMixedCellButton");

            on(button, "click", lang.hitch(this, function() {
                if (optionalDueDate) {
                    this.editOptionalDueDate(workflowNodePositionJoin);
                } else {
                    this.editDueDate(workflowNodePositionJoin);
                }                   
            }));

            return button;      
        },      

        renderOptionalDueDateCell : function(workflowNodePositionJoin, data, cell) {
            var node = domConstruct.create("div", null, null);

            var optionalDueDateText;
            if (workflowNodePositionJoin.workflowNodePositionOptionalDueDate != null) {
                optionalDueDateText = DateHelper.formatUtcSecondsWithTimeZone(workflowNodePositionJoin.workflowNodePositionOptionalDueDate,
                    this.applicationContext.getTimeZone(), i18n.datePattern); 
            } else {
                optionalDueDateText = i18n.nothing;
            }       

            DOMHelper.createTextNode("span", optionalDueDateText, node, "");

            var workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;
            var ownerTokens = workflowNodePositionId in this.workflowNodePositionIdToOwnerTokens ? this.workflowNodePositionIdToOwnerTokens[workflowNodePositionId] : [];
            var buttonEnabled = false /*this.workflowInitialized*/;
            // enable only if position has token (not finished) and ownerPositionId == initiatorPositionId
            for (var n = 0; n < ownerTokens.length; n++) {
                buttonEnabled |= ownerTokens[n].ownerPositionId == ownerTokens[n].initiatorPositionId;
            }               

            if (buttonEnabled) {
                var button;
                if (workflowNodePositionJoin.workflowNodePositionOptionalDueDate == null) {
                    button = this.constructDueDateNewButton(workflowNodePositionJoin, true);
                } else {
                    button = this.constructDueDateEditButton(workflowNodePositionJoin, true);
                }            

                domConstruct.place(button.domNode, node);
            }

            return node;        
        },      

        renderActionCell : function(workflowNodePositionJoin, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            var workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;
            var nodePosition = workflowNodePositionJoin.workflowNodeTemplatePosition;             
            var initiatorTokens = workflowNodePositionId in this.workflowNodePositionIdToInitiatorTokens ? this.workflowNodePositionIdToInitiatorTokens[workflowNodePositionId] : [];
            var ownerTokens = workflowNodePositionId in this.workflowNodePositionIdToOwnerTokens ? this.workflowNodePositionIdToOwnerTokens[workflowNodePositionId] : [];
            var initiatorPositionHasResult = workflowNodePositionId in this.workflowNodeInitiatorPositionIdToHasResults ? true : false;
            var numberOfPositions = this.workflowNodePositionJoins.length;
            
            // enable if not workflowInitialized and not finished (position has no token but result)
            var buttonEnabled = !this.workflowInitialized && !initiatorPositionHasResult;
            // if workflowInitialized enable only if position has token (not finished) and ownerPositionId == initiatorPositionId
            for (var n = 0; n < ownerTokens.length; n++) {
                buttonEnabled |= ownerTokens[n].ownerPositionId == ownerTokens[n].initiatorPositionId;
            }               
            // also for node Zustimmung (!this.workflowNodeIsMandatory)

            // var correspondingLastWorkflowNodePositionId = this.getCorrespondingLastWorkflowNodePositionId(workflowNodePositionId);
            var hasReleaseResults = (workflowNodePositionId in this.initiatorPositionIdToHasFreigabeResults
                && this.initiatorPositionIdToHasFreigabeResults[workflowNodePositionId]);
            
			var hasSuperAdminRight = this.globalActions && "superAdminRight" in this.globalActions;
            //ReinitButton if token has finished and HasFreigabeResult or if there is no FreigabeResult and no token (second case only for hasSuperAdminRight)
            if (this.workflowNodeTemplatePosition == 1 && initiatorTokens.length == 0 && hasReleaseResults) {
                var reinitButton = this.constructReinitButton(workflowNodePositionJoin, false);
                domConstruct.place(reinitButton.domNode, buttonDiv);
            } else if (this.workflowNodeTemplatePosition == 1 && hasSuperAdminRight && initiatorTokens.length == 0 && ownerTokens.length == 0) {
                var reinitButton = this.constructReinitButton(workflowNodePositionJoin, true);
                domConstruct.place(reinitButton.domNode, buttonDiv);
            }
            
			var mayDelete = true; 
			//always true if !this.workflowInitialized 
    		//For node 1 (Durchführung) not allowed in case of existing result
    		//for node 2 (Zustimmung) allways because workflowNodeIsMandatory and task will be moved
    		//For node 3 (Freigabe) not allowed in case of existing task or if there is only one last position
        	if (this.workflowInitialized && 
        			(nodePosition == 1 && initiatorPositionHasResult ||
        				nodePosition == 3 && (workflowNodePositionJoin.workflowNodePositionId in this.workflowNodePositionIdToOwnerTokens || numberOfPositions == 1)))
        		mayDelete = false;

            if (mayDelete) {
                var removeParticipantButton = this.constructRemoveParticipantButton(workflowNodePositionJoin);
                domConstruct.place(removeParticipantButton.domNode, buttonDiv);
            }
            if (buttonEnabled || !this.workflowNodeIsMandatory || this.workflowNodeTemplatePosition > 1) {
                var replaceParticipantButton = this.constructReplaceParticipantButton(workflowNodePositionJoin);
                domConstruct.place(replaceParticipantButton.domNode, buttonDiv);
            }

            return buttonDiv;
        },

        getCorrespondingLastWorkflowNodePositionId : function(workflowNodePositionId) {
            var baulose = (workflowNodePositionId in this.workflowNodePositionIdToBaulose
                ? this.workflowNodePositionIdToBaulose[workflowNodePositionId] : null);
            var firstBaulos = (baulose != null && baulose.length > 0 ? baulose[0] : null);

            if (firstBaulos != null) {
                var firstBaulosId = firstBaulos.metaInformationId;
                for (var n = 0; n < this.maxPositionPositionJoins.length; n++) {
                    var currMaxPositionJoin = this.maxPositionPositionJoins[n];
                    var currMaxWorkflowNodePositionId = currMaxPositionJoin.workflowNodePositionId;
                    var currMaxBaulose = (currMaxWorkflowNodePositionId in this.workflowNodePositionIdToBaulose
                        ? this.workflowNodePositionIdToBaulose[currMaxWorkflowNodePositionId] : []);
                    var currMaxBaulos = (currMaxBaulose != null && currMaxBaulose.length > 0 ? currMaxBaulose[0] : null);
                    var currMaxBaulosId = (currMaxBaulos != null ? currMaxBaulos.metaInformationId : null);
                    if (firstBaulosId == currMaxBaulosId) {
                        return currMaxWorkflowNodePositionId;
                    }
                }
            }                

            for (var n = 0; n < this.maxPositionPositionJoins.length; n++) {
                var currMaxPositionJoin = this.maxPositionPositionJoins[n];
                var currMaxWorkflowNodePositionId = currMaxPositionJoin.workflowNodePositionId;
                var currMaxBaulose = (currMaxWorkflowNodePositionId in this.workflowNodePositionIdToBaulose
                    ? this.workflowNodePositionIdToBaulose[currMaxWorkflowNodePositionId] : []);
                if (currMaxBaulose == null || currMaxBaulose.length == 0) {
                    return currMaxWorkflowNodePositionId;
                }                        
            }                    
            
            return null;
        },            

        setIsWorkflowInitialized : function(workflowInitialized) {
            if (workflowInitialized != this.workflowInitialized) {
                this.workflowInitialized = workflowInitialized;
                this.reload();
            }               
        },

        editDueDate : function(workflowNodePositionJoin) {
            var contentWidget = new DueDateEditWidget({
                applicationContext : this.applicationContext
            });

            var editDialog = new EditDialog({
                contentWidget : contentWidget,
                defaultWidth  : 570,  // Should be in sync with corresponding rules in CSS (i.e. .strokeStyleEditTopDiv)
                defaultHeight : 80,
                        title : i18n.workflowNodePositionListEditDueDateCaption,
                      buttons : [ { type : ClazzesVoc.Button.SAVE },
                          { type : InfoDialog.Button.ABORT, title : i18n.abortToolTip } ]
            });
            editDialog.setData({
                           id : workflowNodePositionJoin.workflowNodePositionId,
                      dueDate : workflowNodePositionJoin.workflowNodePositionDueDate,
                dueDateRemark : workflowNodePositionJoin.workflowNodePositionDueDateRemark
            });
            on(editDialog, "updated", lang.hitch(this, this.emitReloadRequested));      
            editDialog.show();

            on(editDialog, "dialogClosed", function() {
                contentWidget.destroy();
            });                               
        },

        editOptionalDueDate : function(workflowNodePositionJoin) {
            var contentWidget = new OptionalDueDateEditWidget({
                applicationContext : this.applicationContext
            });

            var editDialog = new EditDialog({
                contentWidget : contentWidget,
                defaultWidth  : 320,  // Should be in sync with corresponding rules in CSS (i.e. .strokeStyleEditTopDiv)
                defaultHeight : 40,
                        title : (workflowNodePositionJoin.workflowNodePositionOptionalDueDate ? i18n.workflowNodePositionListEditOptionalDueDateCaption : i18n.workflowNodePositionListNewOptionalDueDateCaption),
                      buttons : [ { type : ClazzesVoc.Button.SAVE },
                          { type : InfoDialog.Button.ABORT, title : i18n.abortToolTip } ]
            });
            editDialog.setData({
                             id : workflowNodePositionJoin.workflowNodePositionId,
                optionalDueDate : workflowNodePositionJoin.workflowNodePositionOptionalDueDate
            });
            on(editDialog, "updated", lang.hitch(this, this.emitReloadRequested));
            editDialog.show();

            on(editDialog, "dialogClosed", function() {
                contentWidget.destroy();
            });                               
        },      

        emitReloadRequested : function() {
            on.emit(this, "reloadRequested");
        },

        constructReinitButton : function(workflowNodePositionJoin, restore) {
            var button = new FancyButton({
                    title : restore?i18n.workflowNodePositionListRestoreToolTip:i18n.workflowNodePositionListReinitToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 reloadButton" //TODO: has to be replaced by reinitWorkflowButton
            });

            domClass.add(button.domNode, "listButton workflowNodePositionListMixedCellButton");

            on(button, "click", lang.hitch(this, function() {
                this.askReinitWorkflowNodePosition(workflowNodePositionJoin);
            }));
            return button;
        },      

        constructRemoveParticipantButton : function(workflowNodePositionJoin) {
            var button = new FancyButton({
                    title : i18n.workflowNodePositionListDeleteProjectToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton workflowNodePositionListMixedCellButton");

            on(button, "click", lang.hitch(this, function() {
                this.askRemoveWorkflowNodePosition(workflowNodePositionJoin);
            }));
            return button;
        },      

        constructReplaceParticipantButton : function(workflowNodePositionJoin) {
            var button = new FancyButton({
                    title : i18n.workflowNodePositionListReplaceProjectToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 replaceButton"
            });

            domClass.add(button.domNode, "listButton workflowNodePositionListMixedCellButton");

            on(button, "click", lang.hitch(this, function() {
                this.askReplaceWorkflowNodePosition(workflowNodePositionJoin);
                //                              this.doReplaceWorkflowNodePosition(workflowNodePositionJoin);
            }));
            return button;
        },      

        askReinitWorkflowNodePosition : function(workflowNodePositionJoin) {
            var participant = this.getProjectParticipantString(workflowNodePositionJoin);
            var question = string.substitute(i18n.workflowNodePositionListAskReinitDialogQuestion, {
                participant : participant               
            });             

            InfoDialog.showQuestion({
                  title : i18n.workflowNodePositionListAskReinitDialogCaption,
                message : question,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doReinitWorkflowNodePosition(workflowNodePositionJoin);
                    })},                                       
                    { type : InfoDialog.Button.NO }
                ]
            });
        },    

        doReinitWorkflowNodePosition : function(workflowNodePositionJoin) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(WorkflowNodePositionListWidget.AsyncOperation.REINIT);
            planningNotificationService.reinitWorkflowNodePosition(organisationPersonId, workflowNodePositionId).then(
                lang.hitch(this, function(allowed) {
                    this.registerAsyncOperationFinished(WorkflowNodePositionListWidget.AsyncOperation.REINIT);

                    if (allowed) {
                        this.emitReloadRequested();
                    } else {
                        InfoDialog.showError({
                              title : i18n.workflowNodePositionListReinitBlockedCaption,
                            message : i18n.workflowNodePositionListReinitBlockedText
                        });
                    }                       
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : WorkflowNodePositionListWidget.AsyncOperation.REINIT,
                                opName : "reinitWorkflowNodePosition",
                               message : i18n.workflowNodePositionListReinitFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [reinitWorkflowNodePosition]", err);
                    }));                        
        },            

        askRemoveWorkflowNodePosition : function(workflowNodePositionJoin) {
            var participant = this.getProjectParticipantString(workflowNodePositionJoin);
            
            var question = string.substitute(i18n.workflowNodePositionListAskDeleteDialogQuestion, {
                participant : participant               
            });
            //position is owner --> we have a task
            var nodePosition = workflowNodePositionJoin.workflowNodeTemplatePosition;             
        	if (workflowNodePositionJoin.workflowNodePositionId in this.workflowNodePositionIdToOwnerTokens){
	    		//For node 2 (Zustimmung) we will also move the task
	    		if (nodePosition == 2)
	        		question += " "+i18n.workflowNodePositionListAskDeleteWithTaskMoveDialogQuestion;
	        	else
        			question += " "+i18n.workflowNodePositionListAskDeleteWithTaskDialogQuestion;
        	}
            InfoDialog.showQuestion({
                  title : i18n.workflowNodePositionListAskDeleteDialogCaption,
                message : question,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doRemoveWorkflowNodePosition(workflowNodePositionJoin);
                    })},                                       
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        doRemoveWorkflowNodePosition : function(workflowNodePositionJoin) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(WorkflowNodePositionListWidget.AsyncOperation.DELETE);
            return planningNotificationService.deleteWorkflowNodePosition(organisationPersonId, workflowNodePositionId).then(
                lang.hitch(this, function(returnType) {
                    this.registerAsyncOperationFinished(WorkflowNodePositionListWidget.AsyncOperation.DELETE);

                    if (returnType < 0) {
				    	//return types:
				    	// -1  Freigabeknoten nicht besetzt
				        // -2  Freigabeknoten kein Freigebender für Baulos bzw. alle Baulose vorhanden
				        // -3  Freigabeknoten hat Aufgabe und kann nicht gelöscht werden
				        // -4  Aufgabe konnte nicht an nächsten Knoten weitergereicht werden
        				// -5  Löschen nicht möglich, da bereits Prüfergebnisse vorhanden sind
                    	var errorMessage = i18n.workflowNodePositionListDeleteBlockedText;
                    	if (returnType == -1)
                    		errorMessage = i18n.workflowNodePositionListDeleteNoReleasePosition;
                    	else if (returnType == -2)
                    		errorMessage = i18n.workflowNodePositionListDeleteNoReleasePositionForBaulos;
                    	else if (returnType == -3)
                    		errorMessage = i18n.workflowNodePositionListDeleteTokenAtReleasePosition;
                    	else if (returnType == -4)
                    		errorMessage = i18n.workflowNodePositionListDeleteTokenCouldNotBeMoved;
                    	else if (returnType == -5)
                    		errorMessage = i18n.workflowNodePositionListDeleteHasAllreadyResult;
                    	
                        InfoDialog.showError({
                              title : i18n.workflowNodePositionListDeleteBlockedCaption,
                            message : errorMessage
                        });
                    } else {                      
                        this.emitReloadRequested();
                    } 
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : WorkflowNodePositionListWidget.AsyncOperation.DELETE,
                                opName : "deleteWorkflowNodePosition",
                               message : i18n.workflowNodePositionListDeletePositionFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [deleteWorkflowNodePosition]", err);
                    }));                        

        },          

        askReplaceWorkflowNodePosition : function(workflowNodePositionJoin) {
            var participant = this.getProjectParticipantString(workflowNodePositionJoin);
            var question = string.substitute(i18n.workflowNodePositionListAskReplaceDialogQuestion, {
                participant : participant               
            });             

            InfoDialog.showQuestion({
                  title : i18n.workflowNodePositionListAskReplaceDialogCaption,
                message : question,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doReplaceWorkflowNodePosition(workflowNodePositionJoin);
                    })},                                       
                    { type : InfoDialog.Button.NO }
                ]
            });                         
        },

        doReplaceWorkflowNodePosition : function(workflowNodePositionJoin) {
            this.workflowNodePositionId = workflowNodePositionJoin.workflowNodePositionId;
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var roleTypeId = this.workflowNodeTemplateRoleTypeId;
            var projectIds = [];
            for (var n = 0; n < this.projectJoins.length; n++) {
                projectIds.push(this.projectJoins[n].projectId);
            }

            var projectService = this.applicationContext.getService("projectService");
            this.registerAsyncOperationStarted(WorkflowNodePositionListWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS);
            projectService.getParticipationJoins(organisationPersonId, roleTypeId, projectIds).then(
                lang.hitch(this, function(participationJoins) {
                    this.registerAsyncOperationFinished(WorkflowNodePositionListWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS);
                    this.possibleParticipationJoins = participationJoins;
                    this.openParticipantChooseDialog(participationJoins, workflowNodePositionJoin.workflowNodePositionId);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : WorkflowNodePositionListWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS,
                                opName : "getParticipationJoins",
                               message : i18n.workflowNodeEditGetParticipationJoinsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getParticipationJoins]", err);
                    }));

        },          

        openParticipantChooseDialog : function(participationJoins, workflowNodePositionId) {
            this.workflowNodePositionId = workflowNodePositionId;
            this.possibleParticipationJoins = participationJoins;
            var position = this.workflowNodeTemplatePosition;
            var dueDateHeight = 80;
            var participantGridWidth = 500;
            var baulosGridWidth = 150;
            var gridHeight = 320;

            var defaultWidth = participantGridWidth + 15;
            var defaultHeight = gridHeight + 15;

            var chooseDialog = new WorkflowNodeParticipantChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.workflowNodePositionListReplaceParticipantDialogCaption,
                           buttons : [ 
                               { type : ChooseDialog.Button.CHOOSE,
                                    name : "selectButton",                                          
                                   label : i18n.workflowNodePositionListReplaceParticipantButtonCaption,
                                   title : i18n.workflowNodePositionListReplaceParticipantButtonToolTip
                               },
                               { type : InfoDialog.Button.ABORT,
                                   title : i18n.abortToolTip }
                           ],
                      defaultWidth : defaultWidth,
                     defaultHeight : defaultHeight,
                     dueDateHeight : dueDateHeight,
              participantGridWidth : participantGridWidth,
                   baulosGridWidth : baulosGridWidth,
                        gridHeight : gridHeight,                
                      enterDueDate : false,
        participationSelectionMode : "single",
                       enterBaulos : false,
            baulosMetaInformations : null,
                participationJoins : participationJoins         
            });

            on(chooseDialog, "valueChosen", lang.hitch(this, function(params) {
                var selectedParticipationJoins = params.selectedParticipationJoins;
                var dueDate = params.dueDate;
                var dueDateRemark = params.dueDateRemark;               

                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var participationId = selectedParticipationJoins[0].projectParticipationId;

                var planningNotificationService = this.applicationContext.getService("planningNotificationService");
                this.registerAsyncOperationStarted(WorkflowNodePositionListWidget.AsyncOperation.REPLACE_POSITION);
                planningNotificationService.replaceWorkflowNodePositionsPP(organisationPersonId, this.workflowNodePositionId, participationId).then(
                    lang.hitch(this, function(alreadyExistingPair) {
                        this.registerAsyncOperationFinished(WorkflowNodePositionListWidget.AsyncOperation.REPLACE_POSITION);

                        if (alreadyExistingPair != null) {
                            var alreadyExistingPairs = [];
                            alreadyExistingPairs.push(alreadyExistingPair);
                            this.showAlreadyExistingInfoDialog(alreadyExistingPairs, position, lang.hitch(this, this.emitReloadRequested));
                        } else {
                            this.emitReloadRequested();
                        }                       
                    }),
                    lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : WorkflowNodePositionListWidget.AsyncOperation.REPLACE_POSITION,
                                    opName : "replaceWorkflowNodePositionsPP",
                                   message : i18n.workflowNodePositionListReplaceWorkflowNodePositionsFailed
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [replaceWorkflowNodePositionsPP]", err);
                        }));            
            }));            

            chooseDialog.show(null);
        },          

        emitReloadRequested : function() {
            on.emit(this, "reloadRequested");
        },          

        constructTopDiv : function() {
            return this.constructGrid({
                idProperty : "workflowNodePositionId", 
                    gridId : "WorkflowNodePositionListWidgetGrid",
                  idSuffix : this.index.toString()                    
            });
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.workflowNodePositionJoins = params.workflowNodePositionJoins;
            this.maxPositionPositionJoins = params.maxPositionPositionJoins;
            this.workflowNodePositionIdToBaulose = params.workflowNodePositionIdToBaulose;
            this.workflowNodePositionIdToInitiatorTokens = params.workflowNodePositionIdToInitiatorTokens;
            this.workflowNodePositionIdToOwnerTokens = params.workflowNodePositionIdToOwnerTokens;
            this.workflowNodeInitiatorPositionIdToHasResults = params.workflowNodeInitiatorPositionIdToHasResults;
            this.initiatorPositionIdToHasFreigabeResults = params.initiatorPositionIdToHasFreigabeResults;
            this.workflowNodeIsMandatory = params.workflowNodeTemplateMandatory;
            this.projectJoins = params.projectJoins;
            this.workflowNodeTemplateRoleTypeId = params.workflowNodeTemplateRoleTypeId;
            this.workflowNodeTemplatePosition = params.workflowNodeTemplatePosition;
            this.baulosMetaInformations = params.baulosMetaInformations;
            // this.openParticipantChooseDialog = params.openParticipantChooseDialog;
            this.showAlreadyExistingInfoDialog = params.showAlreadyExistingInfoDialog;
            this.globalActions = params.globalActions;
            
            this.updateAuxiliaryData();

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.workflowNodePositionJoins.length; n++) { // TODO
                var joinDto = this.workflowNodePositionJoins[n]; // TODO
                this.updateAuxiliaryDataForJoinDto(joinDto);
            }
        },

        updateAuxiliaryDataForJoinDto : function(joinDto) {
            joinDto._projectParticipant = this.getProjectParticipantString(joinDto);
            joinDto._baulos = this.baulosFormatter(null, joinDto);
            joinDto._dueDate = joinDto.workflowNodePositionDueDate != null ? joinDto.workflowNodePositionDueDate : joinDto.workflowNodePositionDueDateRemark;
            joinDto._optionalDueDate = joinDto.workflowNodePositionOptionalDueDate;
        },

        reload : function(params) {

            this.store.setData(this.workflowNodePositionJoins);

            this.grid.set("sort", "projectParticipant", false);
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        getRowId : function(joinDto) {
            return ""; // TODO
        },

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    WorkflowNodePositionListWidget.AsyncOperation = {
        DELETE : "Delete",
        GET_PROJECT_PARTICIPATIONS : "GetProjectParticipations",
        REINIT : "Reinit",
        REPLACE_POSITION : "ReplacePosition"
    };

    return WorkflowNodePositionListWidget;
});
