/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningReport
////i18n-prefix = planningReport

define([ "cdes/core/CdesVoc",
    "cdes/planning/report/PlanningNotificationReportCoverWidget",
    "cdes/planning/report/PlanningNotificationReportDataWidget",
    "cdes/planning/report/PlanningNotificationReportOptionsWidget",
    "cdes/widget/ContextBar",
    "cdes/widget/search/SearchEditWidget",
    "clazzes/ClazzesVoc",
    "clazzes/TinyLog",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/EditDialog",
    "clazzes/widgets/layout/InfoDialog",
    "dijit/form/Button",
    "dijit/form/Select",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/json",
    "dojo/on",      
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
    PlanningNotificationReportCoverWidget,
    PlanningNotificationReportDataWidget,
    PlanningNotificationReportOptionsWidget,
    ContextBar,
    SearchEditWidget,
    ClazzesVoc,
    TinyLog,
    FancyButton,
    topic,               
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    EditDialog,
    InfoDialog,
    Button,
    Select,
    domClass,
    domConstruct,
    domStyle,
    json,
    on,             
    string,
    declare,
    lang,
    i18n) {
    var className = "at.cdes.web.widget.base.SearchControllingWidget";

    var log = new TinyLog(className);

    var SearchControllingWidget = declare(className, ContentWidget, {
        constructSearchSelect : function(captionBarDiv) {
            var searchSelect = new Select({
                label : this.searchSelectLabel,
                title : this.searchSelectToolTip                
            });
            domClass.add(searchSelect.domNode, this.searchSelectCssClass);
            domConstruct.place(searchSelect.domNode, captionBarDiv);

            WidgetHelper.handleSelectEvents(searchSelect, lang.hitch(this, function() {
                var searchId = WidgetHelper.getSelectValue(searchSelect);
                if (searchId != null && searchId != CdesVoc.WHATEVER) {
                    if (searchId != this.lastSearchId) {
                        this.processChangedSearch(searchId);
                    }
                } else {
                    this.processSearchSelectionReset();
                }                   

                this.lastSearchId = searchId;
            }));

            return searchSelect;            
        },

        processChangedSearch : function(searchId) {
            var searchJoin = this.idToSearchJoin[searchId];
            this.searchSelect.set("title", string.substitute(i18n.searchControllingPersonToolTip, {
                givenName : searchJoin.personGivenName,
                  surName : searchJoin.personSurName
            }));

            var currSearchJoin = this.idToSearchJoin[searchId];
            var parsedJsonContent = currSearchJoin.searchContent != null ? json.parse(currSearchJoin.searchContent, true) : null;
            this.storeParsedSearchJsonContent(parsedJsonContent);
            this.updateSearchDataWithSelectedSearchProperties(currSearchJoin);
            this.updateWidgetsFromData();                                
        },


        storeParsedSearchJsonContent : function(parsedJsonContent) {
            // summary:
            //     Store the given json string (determined from the search Select just before)
            //     into this widget, if appropriate.         
        },            

        fetchSearchContentAsJson : function() {
            // summary:
            //     Returns the content of the current search (e.g. stored in the this-pointer of this widget),
            //     serialized as json.             
        },            

        updateSearchDataWithSelectedSearchProperties : function(currSearch) {
            // summary:
            //     Updates the content of the current search (e.g. stored in the this-pointer of this widget) with the
            //     properties of the given search (especially its name), if appropriate.    
        },

        processSearchSelectionReset : function() {
            // summary:
            //     On a reset of the search Select (i.e., nothing is selected after the reset),
            //     this function updates the content of the current search (e.g. stored in the
            //     this-pointer of this widget) with the          
        },

        getProjectIdFromPageContext : function() {
            return null;            
        },            

        loadSearch : function(mode) {
            this.registerAsyncOperationStarted(SearchControllingWidget.AsyncOperation.LOAD_SEARCH);
            this.callSearchQuery().then(
                lang.hitch(this, function(searchInfo) {

					var searchJoinsList = searchInfo.searchJoins;
					this.hasProjects = searchInfo.hasProjects;;
                    this.idToSearchJoin = new Object();
                    for (var n = 0; n < searchJoinsList.length; n++) {
                        var searchJoin = searchJoinsList[n];
                        this.idToSearchJoin[searchJoin.searchId] = searchJoin;
                    }
                    this.updateSearchSelect(mode);
                    //this.updateWidgetState();

                    this.registerAsyncOperationFinished(SearchControllingWidget.AsyncOperation.LOAD_SEARCH);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : SearchControllingWidget.AsyncOperation.LOAD_SEARCH,
                                opName : "getAllOwnSearches",
                               message : i18n.planningNotificationReportGetSearchFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getAllOwnSearches]", err);
                    }));
        },          

        updateSearchSelect : function(mode) {
            var options = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];

            var pageContextPersonId = this.applicationContext.getPageContextPersonId();
            var showAll = this.showAllCheckBox != null && this.showAllCheckBox.get("checked");
            var oldValue = this.searchSelect.get("value");
            var foundOldValue = (oldValue == null || oldValue == CdesVoc.WHATEVER);
            for (var id in this.idToSearchJoin) {
                var searchJoin = this.idToSearchJoin[id];

                if (showAll || searchJoin.personId == pageContextPersonId) {
                    foundOldValue |= (oldValue == searchJoin.searchId);
                    options.push({
                        label : searchJoin.searchName != null ? searchJoin.searchName : "",
                        value : searchJoin.searchId                       
                    });         
                }
            }

            options.sort(function(optionOne, optionTwo) {
                if (optionOne.value == CdesVoc.WHATEVER) {
                    return -1;
                } else if (optionTwo.value == CdesVoc.WHATEVER) {
                    return 1;
                } else {
                    return optionOne.label.localeCompare(optionTwo.label);
                }                           
            });                 

            if (!foundOldValue) {
                this.searchSelect.set("value", CdesVoc.WHATEVER);
            }                

            WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.searchSelect, options);
            if (!this.searchSelectInitialized) {
                this.searchSelect.set("value", CdesVoc.WHATEVER);
                this.searchSelectInitialized = true;                    
            }                   

            if (mode != null && mode == ContentWidget.Mode.CREATE) {
                // Poor mans version of select the new Search: Simply take the search instance with the highest id.
                var maxId = null;
                for (var id in this.idToSearchJoin) {
                    maxId = maxId == null ? id : Math.max(id, maxId);
                }                           

                WidgetHelper.setSelectValue(this.searchSelect, maxId);
            }

            var selectedValue = WidgetHelper.getSelectValue(this.searchSelect);
            if (selectedValue != null && selectedValue != CdesVoc.WHATEVER) {
                var currSearchJoin = this.idToSearchJoin[selectedValue];
                this.updateSearchDataWithSelectedSearchProperties(currSearchJoin);
            } else {
                this.processSearchSelectionReset();
            }
        },

        constructNewSearchButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : this.searchCreateToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
            });

            domClass.add(button.domNode, "listButton planningNotificationReportNewButton");

            on(button, "click", lang.hitch(this, function() {
                this.openSearchEditDialog(ContentWidget.Mode.CREATE);
            }));

            domConstruct.place(button.domNode, captionBarDiv);      

            return button;            
        },

        constructSaveSearchButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : this.searchEditToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 saveButton"
            });

            domClass.add(button.domNode, "listButton planningNotificationReportSaveButton");

            on(button, "click", lang.hitch(this, function() {
                var searchId = this.searchSelect.get("value");
                if (searchId != CdesVoc.WHATEVER) {
                    this.updateDataFromWidgets();

                    var serializedConfig = this.fetchSearchContentAsJson();

                    var searchJoin = this.idToSearchJoin[searchId];
                    var search = {                                    
                               id : searchJoin.searchId,
                         personId : searchJoin.searchPersonId,
                             name : searchJoin.searchName,
                         pageName : searchJoin.searchPageName,
                          project : searchJoin.searchProject,
                          content : serializedConfig,
                        networkId : searchJoin.searchNetworkId
                    };                                        
                    var projectId = this.getProjectIdFromPageContext();
                    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();                    
                    
                    var utilService = this.applicationContext.getService("utilService");
                    this.registerAsyncOperationStarted(SearchControllingWidget.AsyncOperation.SAVE);
                    utilService.saveOrUpdateSearch(organisationPersonId, this.searchPageName, projectId, search).then(
                        lang.hitch(this, function() {
                            this.loadSearch();
                            var msg = string.substitute(i18n.planningNotificationReportSaveSuccessful, {
                                name : search.name
                            });
                            topic.publish("message/ok", msg);
                            this.registerAsyncOperationFinished(SearchControllingWidget.AsyncOperation.SAVE);
                        }),
                        lang.hitch(this, function(err) {
                            ErrorHelper.processAsyncError({
                                           err : err,
                                        widget : this,
                                asyncOperation : SearchControllingWidget.AsyncOperation.SAVE,
                                        opName : "saveOrUpdateReportOptions",
                                       message : i18n.searchEditSaveOrUpdateFailed
                            });
                        })).otherwise(
                            lang.hitch(this, function(err) {
                                log.error("Error while calling function [saveOrUpdateReportOptions]", err);
                            }));                        
                }
            }));

            domConstruct.place(button.domNode, captionBarDiv);      

            return button;            
        },          

        constructEditSearchButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : this.searchRenameToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
            });

            domClass.add(button.domNode, "listButton planningNotificationReportEditButton");

            on(button, "click", lang.hitch(this, function() {
                this.openSearchEditDialog(ContentWidget.Mode.EDIT);
            }));

            domConstruct.place(button.domNode, captionBarDiv);      

            return button;                        
        },

        constructDeleteSearchButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : this.searchDeleteToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton planningNotificationReportDeleteButton");

            on(button, "click", lang.hitch(this, function() {
                this.askDeleteSearch();
            }));

            domConstruct.place(button.domNode, captionBarDiv);      

            return button;                        
        },

        askDeleteSearch : function() {
            var searchId = WidgetHelper.getSelectValue(this.searchSelect);
            if (searchId != null && searchId != CdesVoc.WHATEVER) {
                var searchJoin = this.idToSearchJoin[searchId];
                var message = string.substitute(this.searchDeleteQuestionDialogText, {
                    name : searchJoin.searchName
                });             

                InfoDialog.showQuestion({
                      title : this.searchDeleteQuestionDialogCaption,
                    message : message,
                    buttons : [
                        { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                            this.doDeleteSearch(searchId);
                        })},                                
                        { type : InfoDialog.Button.NO }
                    ]
                });             
            }
        },          

        doDeleteSearch : function(searchId) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(SearchControllingWidget.AsyncOperation.DELETE);
            var utilService = this.applicationContext.getService("utilService");
            utilService.deleteSearch(organisationPersonId, searchId).then(
                lang.hitch(this, function() {
                    this.updateReportSelect();
                    this.searchSelect.set("value", CdesVoc.WHATEVER);               
                    this.registerAsyncOperationFinished(SearchControllingWidget.AsyncOperation.DELETE);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : SearchControllingWidget.AsyncOperation.DELETE,
                                opName : "deleteSearch",
                               message : i18n.planningNotificationReportDeleteFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [deleteSearch]", err);
                    }));            
        },

        openSearchEditDialog : function(mode) {
            this.updateDataFromWidgets();

            var searchJoin = null;
            if (mode == ContentWidget.Mode.EDIT) {
                var searchId = WidgetHelper.getSelectValue(this.searchSelect);
                if (searchId != null && searchId != CdesVoc.WHATEVER) {
                    searchJoin = this.idToSearchJoin[searchId];
                }

                // If there is no search selected, i.e. searchId == CdesVoc.WHATEVER (the "..." item), abort here.
                if (searchJoin == null) {
                    return;
                }                  
            }           

            var search;
            if (searchJoin != null) {
                search = {                                    
                           id : searchJoin.searchId,
                     personId : searchJoin.searchPersonId,
                         name : searchJoin.searchName,
                     pageName : searchJoin.searchPageName,
                      project : searchJoin.searchProject,
                      content : searchJoin.searchContent,
                    networkId : searchJoin.searchNetworkId
                };                                        
            }                        

            var contentWidget = new SearchEditWidget({
                        applicationContext : this.applicationContext,
                                      mode : mode,
                            searchPageName : this.searchPageName,
                                 nameLabel : i18n.planningReportSearchEditNameLabel,
                                 projectId : this.getProjectIdFromPageContext(),
                searchCreateRefusedMessage : this.searchCreateRefusedMessage
            });

            var dialogTitle = null;
            if (mode == ContentWidget.Mode.CREATE) {
                dialogTitle = this.searchCreateCaption;
            } else if (mode == ContentWidget.Mode.EDIT) {
                dialogTitle = this.searchEditCaption;
            } else {
                throw new Error("Unknown mode [" + mode + "]");
            }           

            var editDialog = new EditDialog({
                contentWidget : contentWidget,
                defaultWidth  : 320,  // Should be in sync with corresponding rules in CSS
                defaultHeight : 45,
                        title : dialogTitle,
                      buttons : [ { type : ClazzesVoc.Button.SAVE },
                          { type : InfoDialog.Button.ABORT, title : i18n.abortToolTip } ]
            });

            var serializedConfig = this.fetchSearchContentAsJson();
            editDialog.setData({
                serializedConfig : serializedConfig,
                          search : search
            });
            on(editDialog, "updated", lang.hitch(this, function() {
                this.updateReportSelect(mode);
            }));                
            editDialog.show();

            on(editDialog, "dialogClosed", function() {
                contentWidget.destroy();
            });            
        },

        updateReportSelect : function(mode) {
            this.loadSearch(mode);
        }
    });

    SearchControllingWidget.AsyncOperation = {
        LOAD_SEARCH : "LoadSearch",
        SAVE : "Save",
        DELETE : "Delete"        
    };

    return SearchControllingWidget;
});
