/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = jobResultList
////i18n-prefix = jobResultList


define([ "cdes/core/CdesVoc",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
    ListWidget,
    TinyLog,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    domClass,
    domConstruct,
    on,     
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.admin.job.JobResultListWidget";

    var log = new TinyLog(className);

    var JobResultListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "JobResultListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "jobResultList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                   field : "category",
                      id : "category",
                sortable : true,
                   label : i18n.jobResultListCategoryColumn
            });

            if (this.showDocumentVersion) {
                columns.push({
                        field : "documentVersionId",
                           id : "documentVersionId",
                     sortable : true,
                        label : i18n.jobResultListDocumentVersionIdColumn
                });

                columns.push({
                        field : "documentVersionName",
                           id : "documentVersionName",
                     sortable : true,
                        label : i18n.jobResultListDocumentVersionNameColumn
                });
            }

            if (this.showPlanningNotificationOrder) {
                columns.push({
                        field : "serialNumber",
                           id : "serialNumber",
                     sortable : true,
                        label : i18n.planningNotificationOrderSerialNumberLabel
                });
                columns.push({
                        field : "textPrefix",
                           id : "textPrefix",
                     sortable : true,
                        label : i18n.planningNotificationOrderTextLabel
                });
                columns.push({
                        field : "notificationTitle",
                           id : "notificationTitle",
                     sortable : true,
                        label : i18n.planningNotificationOrderPlanningNotificationLabel
                });                                
            }                

            columns.push({
                   field : "message",
                      id : "message",
                sortable : true,
                   label : i18n.jobResultListMessageColumn
            });

            return columns;
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "_id", 
                    gridId : "JobResultListWidgetGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                /*          
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort", e.sort);
                */
            }));

            return grid;        
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.messageDtos = params.messageDtos;
            this.showDocumentVersion = params.showDocumentVersion;
            this.showPlanningNotificationOrder = params.showPlanningNotificationOrder;            
            this.grid.set("columns", this.constructColumns());

            this.restoreColumnWidths();

            this.reload();
        },

        reload : function() {

            // Distribute artificial ids, as there are no real ones
            for (var n = 0; n < this.messageDtos.length; n++) {
                this.messageDtos[n]._id = n;
            }                

            this.store.setData(this.messageDtos);
            /*
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort");

            if (oldSort == null) {
                this.grid.set("sort", "code", false);
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }       
            */
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();

        },

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    JobResultListWidget.AsyncOperation = {
    };

    return JobResultListWidget;
});
