/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = dueDateEdit
////i18n-prefix = dueDateEdit


define([ "cdes/util/CodeHelper",
	"cdes/widget/CalendarSpinner",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/RadioButton",
	"dijit/form/Select",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CodeHelper,
			CalendarSpinner,
			TinyLog,
			DateTimeSpinBox,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			RadioButton,
			Select,
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.workflow.DueDateEditWidget";

	var log = new TinyLog(className);

	var DueDateEditWidget = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
			this.changed = true;
		},

		getWidgetId : function() {
			return "DueDateEditWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "dueDateEditTopDiv");

			DOMHelper.createTextNode("div", i18n.dueDateEditDueDateLabel, topDiv, "propertyLabel dueDateEditDueDateLabel");

			// DueDate RadioButton + DateTimeSpinBox
			this.dueDateRadioButton = new RadioButton({
				name : "dueDateChooseMode",
				label : i18n.dueDateEditExplicitDueDateLabel,
				/*		   title : i18n.dueDateEditExplicitDueDateToolTip, */ // Removed on ÖBB Request
				checked : true
			});
			domClass.add(this.dueDateRadioButton.domNode, "fixedDialogWidget dueDateEditExplicitDueDateRadioButton");
			domConstruct.place(this.dueDateRadioButton.domNode, topDiv);
			WidgetHelper.handleRadioButtonEvents(this.dueDateRadioButton, lang.hitch(this, this.onDueDateModeChange));

			DOMHelper.createTextNode("div", i18n.dueDateEditAsDateLabel, topDiv, "fixedDialogWidget dueDateEditAsDateLabel");

			this.dueDateSpinner = new CalendarSpinner({
				label : i18n.dueDateEditExplicitDueDateLabel,
				/*     			    title : i18n.dueDateEditExplicitDueDateToolTip, */ // Removed on ÖBB Request
				pattern : i18n.datePattern,
				timeZone : this.applicationContext.getTimeZone(),
				dndEnabled : false,
				rowObjectToString : null
			});
			domClass.add(this.dueDateSpinner.domNode, "fixedDialogWidget dueDateEditExplicitDueDateSpinner");
			domConstruct.place(this.dueDateSpinner.domNode, topDiv);
			WidgetHelper.handleSpinnerEvents(this.dueDateSpinner, lang.hitch(this, this.updateWidgetState));

			// DueDateRemark RadioButton + Select
			this.dueDateRemarkRadioButton = new RadioButton({
				name : "dueDateChooseMode",
				label : i18n.dueDateEditRemarkDueDateLabel,
				/*		   title : i18n.dueDateEditRemarkDueDateToolTip, */ // Removed on ÖBB Request
				checked : false		 
			});
			domClass.add(this.dueDateRemarkRadioButton.domNode, "fixedDialogWidget dueDateEditRemarkDueDateRadioButton");
			domConstruct.place(this.dueDateRemarkRadioButton.domNode, topDiv);
			WidgetHelper.handleRadioButtonEvents(this.dueDateRemarkRadioButton, lang.hitch(this, this.onDueDateModeChange));

			DOMHelper.createTextNode("div", i18n.dueDateEditAsRemarkLabel, topDiv, "fixedDialogWidget dueDateEditAsRemarkLabel");

			// DueDateRemarkSelect
			this.dueDateRemarkSelect = new Select({
				label : i18n.dueDateEditRemarkDueDateLabel,
				/* 		    title : i18n.dueDateEditRemarkDueDateToolTip, */ // Removed on ÖBB Request
				options : CodeHelper.getDueDateRemarkOptions(),		 
				disabled : true	 
			});
			domClass.add(this.dueDateRemarkSelect.domNode, "fixedDialogWidget dueDateEditDueDateRemarkSelect");
			domConstruct.place(this.dueDateRemarkSelect.domNode, topDiv);
//			WidgetHelper.handleSelectEvents(this.dueDateRemarkSelect, lang.hitch(this, this.updateWidgetState));


			return topDiv;
		},

		onDueDateModeChange : function(e) {
			this.explicitDueDate = (e.target == this.dueDateRadioButton.focusNode);
			this.updateWidgetState();	    
		},

		setData : function(workflowNodePosition) {
			this.workflowNodePosition = workflowNodePosition;
			this.reload();	    
		},

		reload : function() {
			this.updateWidgetsFromData();
		},

		updateWidgetState : function() {
			this.dueDateSpinner.set("disabled", !this.explicitDueDate);
			this.dueDateRemarkSelect.set("disabled", this.explicitDueDate);	    

			var allFieldsValid = this.dueDateSpinner.isValid();
			if (this.allFieldsValid != allFieldsValid) {
				this.allFieldsValid = allFieldsValid;
				on.emit(this, "validStateChange");		
			}
		},

		updateWidgetsFromData : function() {
			this.dueDateSpinner.setUtcSeconds(this.workflowNodePosition.dueDate);
			this.dueDateRemarkSelect.set("value", this.workflowNodePosition.dueDateRemark);	    

			this.dueDateRadioButton.set("checked", !this.workflowNodePosition.dueDateRemark);
			this.dueDateRemarkRadioButton.set("checked", !!this.workflowNodePosition.dueDateRemark);
			this.explicitDueDate = !this.workflowNodePosition.dueDateRemark;
			this.updateWidgetState();	    
		},

		updateDataFromWidgets : function() {
			if (this.explicitDueDate) {
				this.workflowNodePosition.dueDate = this.dueDateSpinner.getUtcSeconds();
				this.workflowNodePosition.dueDateRemark = null;		
			} else {
				this.workflowNodePosition.dueDate = null;
				this.workflowNodePosition.dueDateRemark = this.dueDateRemarkSelect.get("value");	
			}		
		},

		save : function() {
			this.updateDataFromWidgets();

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var workflowNodePositionId = this.workflowNodePosition.id;
			var dueDate = this.workflowNodePosition.dueDate;
			var dueDateRemark = this.workflowNodePosition.dueDateRemark;	    

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(DueDateEditWidget.AsyncOperation.SAVE);
			return planningNotificationService.updateDueDate(organisationPersonId, workflowNodePositionId, dueDate, dueDateRemark).then(
					lang.hitch(this, function() {
						this.registerAsyncOperationFinished(DueDateEditWidget.AsyncOperation.SAVE);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : DueDateEditWidget.AsyncOperation.SAVE,
							opName : "updateDueDate",
							message : i18n.dueDateEditUpdateDueDateFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [updateDueDate]", err);
							}));			    
		},	    

		destroy : function() {
			this.inherited(arguments);
		}
	});

	DueDateEditWidget.AsyncOperation = {
			SAVE : "Save"
	};

	return DueDateEditWidget;
});
