define([
        "clazzes/TinyLog",
        "clazzes/util/StringHelper"
       ],
    function(
    		TinyLog,
    		StringHelper) {
	
	var className = "at.cdes.web.util.ActionHelper";
	
	var log = new TinyLog(className);
	
    var ActionHelper = {
    	
    		transformObjectPlannerIdToActions : function(objectPlannerIdToActions) {
    			for (var objectPlannerId in objectPlannerIdToActions) {
    				var actionArray = objectPlannerIdToActions[objectPlannerId];
    				var actionSet = new Object();
    				for (var n = 0; n < actionArray.length; n++) {
    					actionSet[actionArray[n]] = true;
    				}
    				objectPlannerIdToActions[objectPlannerId] = actionSet;
    			}
    			return objectPlannerIdToActions;
    		},
    		
    		hasAnyObjectPlannerEditPermission : function(objectPlannerIdToActions) {
    			for (var objectPlannerId in objectPlannerIdToActions) {
    				var actions = objectPlannerIdToActions[objectPlannerId];
    				if (   "editPlanDeliverCatalogueDates" in actions
    					|| "editPlanDeliverCatalogueStartDate" in actions
    					|| "editPlanDeliverCatalogueEndDate" in actions
    					|| "editPlanDeliverCatalogue" in actions) {
    					return true;
    				}
    			}
    			return false;
    		},
    		
    		hasAnyObjectPlannerNewPermission : function(objectPlannerIdToActions) {
    			for (var objectPlannerId in objectPlannerIdToActions) {
    				var actions = objectPlannerIdToActions[objectPlannerId];
    				if (   "editPlanDeliverCatalogue" in actions) {
    					return true;
    				}
    			}
    			return false;
    		},

    		hasObjectPlannerPermission : function(objectPlannerIdToAction, objectPlannerId, action) {
    			return objectPlannerId in objectPlannerIdToAction && action in objectPlannerIdToAction[objectPlannerId];
    		},
    		
    		convertNetworkIdToActions : function(networkIdToActions) {
    			for (var networkId in networkIdToActions) {
    				var actionArray = networkIdToActions[networkId];
    				var actionSet = new Object();
    				for (var n = 0; n < actionArray.length; n++) {
    					actionSet[actionArray[n]] = true;
    				}
    				networkIdToActions[networkId] = actionSet;
    			}
    			return networkIdToActions;
    		},
    		
    		hasActionsForNetwork : function(networkIdToActions, networkId, actions) {
    			if (networkId == null) {
    				return false;
    			} else {
        			var actionsForNetwork = (networkId in networkIdToActions ? networkIdToActions[networkId] : null);
        			if (actionsForNetwork) {
        				for (var n = 0; n < actions.length; n++) {
        					if (!(actions[n] in actionsForNetwork)) {
        						return false;
        					}
        				}
        				return true;
        			} else {
        				return false;
        			}      				
    			}  			
    		},
    		
    		hasActions : function(networkIdToActions, actionsToCheck) {
    			for (var networkId in networkIdToActions) {
    				var actionsForNetwork = networkIdToActions[networkId];
    				for (var n = 0; n < actionsToCheck.length; n++) {
    					if (actionsToCheck[n] in actionsForNetwork) {
    						return true;
    					}
    				}
    			}
    			return false;
    		},
    		
    		hasActionsForAnyNetwork : function(networkIdToActions, networkIds, actions) {
    			if (networkIds == null) {
    				return false;
    			} else {
    				for (var n = 0; n < networkIds.length; n++) {
    					var networkId = networkIds[n];
    					
            			var actionsForNetwork = (networkId in networkIdToActions ? networkIdToActions[networkId] : null);
            			if (actionsForNetwork) {
            				var success = true;
            				for (var n = 0; n < actions.length; n++) {
            					if (!(actions[n] in actionsForNetwork)) {
            						success = false;
            					}
            				}
            				
            				if (success) {
            					return true;
            				}
            			}
    				}
    				return false;
    			}  			
    		},

        hasActionsForAnyNetworkInList : function(networkIdToActionsList, networkIdsList, actions) {
            if (typeof actions == "string") {
                actions = [ actions ];
            }

    	    if (networkIdsList == null) {
    			return false;
    	    } else {
	    		for (var n = 0; n < networkIdsList.length; n++) {
	    		    var networkId = networkIdsList[n];
	    		    
	            	    var actionsForNetworkList = (networkId in networkIdToActionsList ? networkIdToActionsList[networkId] : null);
	            	    if (actionsForNetworkList) {
		            		var success = true;
		            		for (var u = 0; u < actions.length; u++) {
	                            var successForAction = false;
	                            for (var z = 0; z < actionsForNetworkList.length; z++) {
	                                successForAction |= (actions[u] == actionsForNetworkList[z]);
	                            }
	                            if (!successForAction) {
	                                success = false;
	                            }
		            		}
		            		
		            		if (success) {
		            		    return true;
		            		}
	            	    }
	    		}
    			return false;
    	    }  			
        }
    };
    return ActionHelper;
});
