define([ 
         "clazzes/TinyLog",
         "clazzes/util/DOMHelper",
         "clazzes/widgets/layout/ContentWidget",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 DOMHelper,
    		 ContentWidget,
    		 domClass,
    		 domConstruct,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.widget.ErrorPage";

	var log = new TinyLog(className);
	
    var ErrorPage = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "ErrorPage";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {    		
    		var topDiv = domConstruct.create("div", null, null);
    		
    		this.messageDiv = DOMHelper.createTextNode("div", "", topDiv, "errorPageMessageDiv");
    		
    		return topDiv;
    	},
    	
    	setData : function(message) {
    		this.message = message;
    		this.reload();
    	},
    	
    	reload : function() {
    		DOMHelper.setInnerText(this.messageDiv, this.message);
    	},
    	
    	resize : function() {
    		// Nothing to be done here
    	}
    });
    
    return ErrorPage;
});