/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationTemplateEdit
////i18n-prefix = planningNotificationTemplateEdit


define([ "cdes/planning/template/MetaTagListWidget",
	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dijit/form/CheckBox",
	"dijit/form/TextBox",
	"dijit/form/Textarea",
	"dijit/form/ValidationTextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(MetaTagListWidget,
			ContextBar,
			TinyLog,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			Button,
			CheckBox,
			TextBox,
			Textarea,
			ValidationTextBox,
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.template.PlanningNotificationTemplateEditPage";

	var log = new TinyLog(className);

	var PlanningNotificationTemplateEditPage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			this.allFieldsValid = true;
			this.asyncOperationRunning = false;	    

			this.reload();
		},

		getWidgetId : function() {
			return "PlanningNotificationTemplateEditPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			var captionLabel = null;
			if (this.mode == ContentWidget.Mode.CREATE) {
				captionLabel = i18n.planningNotificationTemplateEditCreatePageCaption;
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				captionLabel = i18n.planningNotificationTemplateEditEditPageCaption;
			} else {
				throw new Error("Mode [" + this.mode + "] is not supported.");
			}		

			this.captionDiv = DOMHelper.createTextNode("h1", captionLabel, captionBarDiv, "cdesGeneralPageCaption");

			return captionBarDiv;
		},

		getBackParams : function() {
			var backParams = new Object();
			if (this.mode == ContentWidget.Mode.EDIT) {
				backParams = {
						mode : ContentWidget.Mode.EDIT,
						id : this.id
				};
			}		

			return backParams;
		},	    

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationTemplateEditPageContentDiv");

			var templateDiv = this.constructTemplateDiv();
			domConstruct.place(templateDiv, contentDiv);	    

			var buttonDiv = this.constructButtonDiv();
			domConstruct.place(buttonDiv, contentDiv);

			// List Widget
			this.listWidget = new MetaTagListWidget({
				applicationContext : this.applicationContext,
				backPage : "planningNotificationTemplateEdit",
				backParams : this.getBackParams()
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domClass.add(this.listWidgetDiv, "fixedDialogWidget planningNotificationTemplateEditMetaTagList");	    
			domConstruct.place(this.listWidgetDiv, contentDiv);
			on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

                    this.listWidget.restoreColumnWidths();

			return contentDiv;
		},

		constructTemplateDiv : function() {
			var templateDiv = domConstruct.create("div", null, null);
			domClass.add(templateDiv, "fixedDialogWidget planningNotificationTemplateEditTemplateDiv");

			// NameTextBox
			DOMHelper.createTextNode("div", i18n.planningNotificationTemplateListNameColumn, templateDiv, "propertyLabel planningNotificationTemplateEditNameLabel");
			this.nameTextBox = new ValidationTextBox({
				label : i18n.planningNotificationTemplateListNameColumn,
				title : i18n.planningNotificationTemplateEditNameToolTip,
				maxLength : 127	
			});
			domClass.add(this.nameTextBox.domNode, "fixedDialogWidget planningNotificationTemplateEditNameTextBox");
			domConstruct.place(this.nameTextBox.domNode, templateDiv);
			WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.updateWidgetState));
			WidgetHelper.setMustField(this.nameTextBox, true);

			// CommentTextarea
			DOMHelper.createTextNode("div", i18n.planningNotificationTemplateListCommentColumn, templateDiv, "propertyLabel planningNotificationTemplateEditCommentLabel");
			this.commentTextArea = new Textarea({
				label : i18n.planningNotificationTemplateListCommentColumn,
				title : i18n.planningNotificationTemplateEditCommentToolTip,
				maxLength : 255	
			});
			domClass.add(this.commentTextArea.domNode, "fixedDialogWidget planningNotificationTemplateEditCommentTextArea");
			domConstruct.place(this.commentTextArea.domNode, templateDiv);
			WidgetHelper.handleTextBoxEvents(this.commentTextArea, lang.hitch(this, this.updateWidgetState));

			// GlobalCheckBox
			DOMHelper.createTextNode("div", i18n.planningNotificationTemplateListGlobalTemplateColumn, templateDiv,
			"propertyLabel planningNotificationTemplateEditGlobalLabel");
			this.globalCheckBox = new CheckBox({
				label : i18n.planningNotificationTemplateListGlobalTemplateColumn,
				title : i18n.unused
			});
			domClass.add(this.globalCheckBox.domNode, "fixedDialogWidget planningNotificationTemplateEditGlobalCheckBox");
			domConstruct.place(this.globalCheckBox.domNode, templateDiv);
			WidgetHelper.handleCheckBoxEvents(this.globalCheckBox, lang.hitch(this, this.updateWidgetState));

			return templateDiv;	    
		},	    

		constructButtonDiv : function() {
			var buttonDiv = domConstruct.create("div", null, null);
			domClass.add(buttonDiv, "fixedDialogWidget planningNotificationTemplateEditButtonDiv");

			// Save button
			this.saveButton = new Button({
				label : i18n.saveAndExitButtonCaption,
				title : i18n.planningNotificationTemplateEditSaveToolTip
			});
			domClass.add(this.saveButton.domNode, "planningNotificationTemplateEditSaveButton");
			domConstruct.place(this.saveButton.domNode, buttonDiv);

			//	    on(this.saveButton, "click", lang.hitch(this, this.save));
			on(this.saveButton, "click", lang.hitch(this, this.save));

			// Abort button
			this.abortButton = new Button({
				label : i18n.abortButtonCaption,
				title : i18n.planningNotificationTemplateEditAbortToolTip
			});
			domClass.add(this.abortButton.domNode, "planningNotificationTemplateEditAbortButton");
			domConstruct.place(this.abortButton.domNode, buttonDiv);
			on(this.abortButton, "click", lang.hitch(this, this.abort));

			this.metaTagHintDiv = DOMHelper.createTextNode("div", i18n.planningNotificationTemplateEditMetaTagSaveHint, buttonDiv,
			"propertyLabel planningNotificationTemplateEditMetaTagHint");

			// New MetaTag Button
			this.newMetaTagButton = new Button({
				label : i18n.planningNotificationTemplateEditNewMetaTagButtonCaption,
				title : i18n.planningNotificationTemplateEditNewMetaTagButtonToolTip
			});
			domClass.add(this.newMetaTagButton.domNode, "planningNotificationTemplateEditNewMetaTagButton");
			domConstruct.place(this.newMetaTagButton.domNode, buttonDiv);

			on(this.newMetaTagButton, "click", lang.hitch(this, function() {
				this.applicationContext.setPage("metaTagEdit",
						{ mode : ContentWidget.Mode.CREATE, planningNotificationTemplateId : this.template.id },
						{ backPage : "planningNotificationTemplateEdit", backParams : this.getBackParams() });
			}));

			return buttonDiv;
		},

		save : function() {
			this.updateDataFromWidgets();

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(PlanningNotificationTemplateEditPage.AsyncOperation.SAVE);
			if (this.mode == ContentWidget.Mode.CREATE) {
				planningNotificationService.createTemplate(this.template).then(
						lang.hitch(this, function(template) {
							this.template = template;
							this.metaTags = [];
							this.updateWidgetsFromData();			
							this.mode = ContentWidget.Mode.EDIT;
							this.registerAsyncOperationFinished(PlanningNotificationTemplateEditPage.AsyncOperation.SAVE);
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationTemplateEditPage.AsyncOperation.SAVE,
								opName : "createTemplate",
								message : i18n.planningNotificationTemplateEditCreateTemplateFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [createTemplate]", err);
								}));
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				planningNotificationService.updateTemplate(this.template).then(
						lang.hitch(this, function(template) {
							this.registerAsyncOperationFinished(PlanningNotificationTemplateEditPage.AsyncOperation.SAVE);
							if (this.backPage != null) {
								this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
							}
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationTemplateEditPage.AsyncOperation.SAVE,
								opName : "updateTemplate",
								message : i18n.planningNotificationTemplateEditUpdateTemplateFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [updateTemplate]", err);
								}));
			} else {
				throw new Error("Mode [" + this.mode + "] is not supported.");		
			}		
		},	    

		abort : function() {
			if (this.backPage != null) {
				this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
			}
		},

		resize : function(newSize) {
			var totalHeight = newSize.h;

			var contentHeight = totalHeight
			- this.captionBarDiv.offsetHeight
			- 20;

			var listHeight = contentHeight - 110;  // top of listWidget inside contentDiv

			this.listWidget.resize({ h : listHeight });
			domStyle.set(this.contentDiv, "height", contentHeight + "px");
		},

		setData : function() {

		},

		reload : function() {
			if (this.mode == ContentWidget.Mode.CREATE) {
				this.updateWidgetState();		
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				this.registerAsyncOperationStarted(PlanningNotificationTemplateEditPage.AsyncOperation.LOAD);

				planningNotificationService.getTemplateInfo(this.id).then(
						lang.hitch(this, function(templateInfo) {
							this.template = templateInfo.planningNotificationTemplate;
							this.metaTags = templateInfo.metaTags;			

							this.updateWidgetsFromData();
							this.registerAsyncOperationFinished(PlanningNotificationTemplateEditPage.AsyncOperation.LOAD);
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationTemplateEditPage.AsyncOperation.LOAD,
								opName : "getTemplateInfo",
								message : i18n.planningNotificationTemplateEditGetTemplateInfoFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [getTemplateInfo]", err);
								}));
			} else {
				throw new Error("Mode [" + this.mode + "] is not supported.");
			}		
		},

		updateWidgetState : function() {
			if (this.mode == ContentWidget.Mode.CREATE) {
//				this.saveButton.set("label", i18n.createButtonCaption);
				this.saveButton.set("title", i18n.planningNotificationTemplateEditCreateToolTip);
				domClass.replace(this.listWidgetDiv, "invisible", "visible");
				if (this.metaTagHintDiv != null) {
					domClass.replace(this.metaTagHintDiv, "visible", "invisible");
				}

				if (this.newMetaTagButton != null) {
					domClass.replace(this.newMetaTagButton.domNode, "invisible", "visible");
				}			
			} else if (this.mode == ContentWidget.Mode.EDIT) {
//				this.saveButton.set("label", i18n.saveButtonCaption);
				this.saveButton.set("title", i18n.planningNotificationTemplateEditSaveToolTip);
				domClass.replace(this.listWidgetDiv, "visible", "invisible");
				if (this.metaTagHintDiv != null) {
					domClass.replace(this.metaTagHintDiv, "invisible", "visible");
				}
				if (this.newMetaTagButton != null) {
					domClass.replace(this.newMetaTagButton.domNode, "visible", "invisible");
				}
			} else {
				throw new Error("Mode [" + this.mode + "] not supported.");
			}		

			WidgetHelper.updateEmptyTextBoxState(this.nameTextBox);
			var allFieldsValid = WidgetHelper.isTextBoxValid(this.nameTextBox);

			var disableSaveButton = !allFieldsValid || this.isAsyncOperationRunning();
			if (disableSaveButton == null) {
				throw new Error("disableSaveButton evaluates to null");		
			}		

			this.saveButton.set("disabled", disableSaveButton);
		},

		updateWidgetsFromData : function() {
			this.nameTextBox.set("value", this.template.name);
			this.commentTextArea.set("value", this.template.comment);
			this.globalCheckBox.set("value", this.template.globalTemplate);

			this.listWidget.setData({
				metaTags : this.metaTags
			});			    
		},	    

		updateDataFromWidgets : function() {
			if (this.mode == ContentWidget.Mode.CREATE) {
				this.template = {
						name : this.nameTextBox.get("value"),
						comment : this.commentTextArea.get("value"),
						globalTemplate : this.globalCheckBox.get("checked")		    
				};
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				this.template.name = this.nameTextBox.get("value");
				this.template.comment = this.commentTextArea.get("value");
				this.template.globalTemplate = this.globalCheckBox.get("checked");		
			} else {
				throw new Error("Mode [" + this.mode + "] not supported.");
			}
		},	    

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationTemplateEditPage.AsyncOperation = {
			LOAD : "Load",
			SAVE : "Save"
	};

	return PlanningNotificationTemplateEditPage;
});
