define([ 
        "cdes/core/DataModel",
        "cdes/organisation/OrganisationEditWidget",
        "cdes/organisation/OrganisationMemberListWidget",
        "cdes/organisation/SimilarOrganisationChooseDialog",
        "cdes/widget/ContextBar",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/DataHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/JoinHelper",
        "clazzes/util/StringHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         DataModel,
         OrganisationEditWidget,
         OrganisationMemberListWidget,
         SimilarOrganisationChooseDialog,
         ContextBar,
         TinyLog,
         FancyButton,
         topic,
         DOMHelper,
         DataHelper,
         ErrorHelper,
         JoinHelper,
         StringHelper,
         IconTitlePane,
         ContentWidget,
         InfoDialog,
         domClass,
         domConstruct,
         domStyle,
         on,
         string,
         declare,
         lang,
         i18n
         ) {
    

    var className = "at.cdes.web.organisation.OrganisationEditPage";

    var log = new TinyLog(className);
    
    var OrganisationEditPage = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this, params);

            if (this.mode == ContentWidget.Mode.SHOW || this.mode == ContentWidget.Mode.EDIT) {
                this.organisationId = this.id;
            }

            this.topDiv = this.constructTopDiv();
            this.updateWidgetState();

            this.allFieldsValid = true;

            this.reload();
        },
        
        getWidgetId : function() {
            return "OrganisationEditPage";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {                  
            var topDiv = domConstruct.create("div", null, null);

            // Context Bar
/*            this.contextBar = new ContextBar({
                applicationContext : this.applicationContext,
                              mode : ContextBar.Mode.DEFAULT
            });
            this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
            this.contextBarDiv = this.contextBar.getContainer();
            domClass.add(this.contextBarDiv, "organisationEditPageContextBarDiv");
            domConstruct.place(this.contextBarDiv, topDiv); 
*/            
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "organisationEditPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);
            
            // Organisation TitlePane
            this.titlePaneDiv = domConstruct.create("div", null, null);
            domClass.add(this.titlePaneDiv, "organisationEditPageTitlePaneDiv");
            domConstruct.place(this.titlePaneDiv, topDiv);

            this.constructOrganisationTitlePane(topDiv);
            this.constructMemberTitlePane(topDiv);

            return topDiv;
        },
        
        constructCaptionBar : function() {
            // Caption Bar consisting of caption and context bar right of the caption
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", "", captionBarDiv, "organisationEditPageCaption");
            
            this.constructSaveButton(captionBarDiv);
            this.constructSaveAndExitButton(captionBarDiv);
            this.constructAbortButton(captionBarDiv);

            return captionBarDiv;
        },
        
        constructSaveButton : function(captionBarDiv) {
            this.saveButton = new FancyButton({ 
                label : i18n.saveButtonCaption,
                title : i18n.saveButtonCaption
            });
            domClass.add(this.saveButton.domNode, "textButton captionBarButton organisationEditPageSaveButton");
            domConstruct.place(this.saveButton.domNode, captionBarDiv);

            on(this.saveButton, "click", lang.hitch(this, function() {
                this.prepareSave(null);
            }));
        },

        constructSaveAndExitButton : function(captionBarDiv) {
            this.saveAndExitButton = new FancyButton({ 
                label : i18n.saveAndExitButtonCaption,
                title : i18n.saveAndExitButtonCaption
            });
            domClass.add(this.saveAndExitButton.domNode, "textButton captionBarButton organisationEditPageSaveAndExitButton");
            domConstruct.place(this.saveAndExitButton.domNode, captionBarDiv);

            on(this.saveAndExitButton, "click", lang.hitch(this, this.saveAndExit));
        },

        constructAbortButton : function(captionBarDiv) {
            var label = this.mode == ContentWidget.Mode.EDIT ? i18n.abortButtonCaption : i18n.closeButtonCaption;

            this.abortButton = new FancyButton({ 
                label : label,
                title : label
            });
            domClass.add(this.abortButton.domNode, "textButton captionBarButton organisationEditPageAbortButton");
            domConstruct.place(this.abortButton.domNode, captionBarDiv);

            on(this.abortButton, "click", lang.hitch(this, this.abort));
        },

        prepareSave : function(successCallback) {
            this.editWidget.updateDataFromWidgets();

            var organisation = new Object();
            JoinHelper.copyJoinAttributes(this.organisationJoin, "organisation", organisation, null, DataModel.ORGANISATION_ATTRIBUTES);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(OrganisationEditPage.AsyncOperation.GET_SIMILAR_ORGANISATIONS);
            var organisationService = this.applicationContext.getService("organisationService");
            organisationService.getSimilarOrganisations(organisationPersonId, organisation).then(
                lang.hitch(this, function(organisationInfos) {
                    this.registerAsyncOperationFinished(OrganisationEditPage.AsyncOperation.GET_SIMILAR_ORGANISATIONS);

                    if (organisationInfos.length > 0) {
                        this.showSimilarOrganisationsChooseDialog(organisationInfos, successCallback);
                    } else {
                        this.save(successCallback);
                    }
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : OrganisationEditPage.AsyncOperation.GET_SIMILAR_ORGANISATIONS,
                                opName : "getSimilarOrganisations",
                               message : i18n.organisationEditPageGetSimilarOrganisationsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getSimilarOrganisations]", err);
                    }));
        },

        showSimilarOrganisationsChooseDialog : function(organisationInfos, successCallback) {
            var chooseDialog = new SimilarOrganisationChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.organisationEditPageSaveSimilarPersonFound,
                           buttons : [ {
                                type : InfoDialog.Button.CUSTOM,
                                name : "ignoreButton",
                               label : i18n.personEditPageSaveIgnoreWarningAndSave,
                               title : i18n.personEditPageSaveIgnoreWarningAndSave,
                                 fct : lang.hitch(this, function() {
                                     this.save(successCallback);
                                 })
                           },
                                      {    type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip,
                                          label : i18n.personEditPageSaveContinueEditingLabel,
                                          title : i18n.organisationEditPageSaveContinueEditingToolTip
                                      }
                           ],
                      defaultWidth : 700,
                     defaultHeight : 300
            });
            chooseDialog.setData({
                organisationInfos : organisationInfos
            });
            chooseDialog.show(null);
        },

        save : function(successCallback) {
            var organisation = new Object();
            JoinHelper.copyJoinAttributes(this.organisationJoin, "organisation", organisation, null, DataModel.ORGANISATION_ATTRIBUTES);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(OrganisationEditPage.AsyncOperation.SAVE);
            var organisationService = this.applicationContext.getService("organisationService");
            var networkId = this.mode == ContentWidget.Mode.CREATE ? this.networkId : null;

            organisationService.saveOrUpdateOrganisation(organisationPersonId, organisation, networkId).then(
                lang.hitch(this, function(organisationInfo) {
                    var successMessage = string.substitute(i18n.organisationEditSaveSuccessful, {
                        organisationName : organisationInfo.organisationJoin.organisationName
                    });
                    topic.publish("message/ok", successMessage);

                    // After a save, we are always in EDIT mode.
                    this.mode = ContentWidget.Mode.EDIT;
                    this.setOrganisationInfo(organisationInfo);
                    this.updateWidgetsFromData();
                    this.editWidget.resetOldOrganisationJoin();
                    this.editWidget.updateWidgetState();

                    this.registerAsyncOperationFinished(OrganisationEditPage.AsyncOperation.SAVE);
                    // Do anythig desired afterwards, e.g. returning to main person list, 
                    // inviting for certificate, etc.
                    if (successCallback) {
                        successCallback();
                    }
                }), lang.hitch(this, function(err) {
                    var failMessage = string.substitute(i18n.organisationEditPageSaveOrUpdateOrganisationFailed, {
                        organisationName : organisation.name
                    });
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : OrganisationEditPage.AsyncOperation.SAVE,
                                opName : "saveOrUpdateOrganisation",
                               message : failMessage
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [saveOrUpdateOrganisation]", err);
                    }));            
        },

        saveAndExit : function() {
            this.prepareSave(lang.hitch(this, this.abort));
        },

        abort : function() {
            this.applicationContext.popLastPageHistoryPage({ cameBack : true});
        },

        resize : function(newSize, givenOrganisationTitlePaneHeight) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;

            var titlePaneHeight = totalHeight
//                                - this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                                - this.captionBarDiv.offsetHeight
                                - 16;

            domStyle.set(this.titlePaneDiv, "height", titlePaneHeight + "px");

            var memberHeight = titlePaneHeight;
            if (givenOrganisationTitlePaneHeight != null) {
                memberHeight -= givenOrganisationTitlePaneHeight;
            } else {
                if (this.organisationDataTitlePane != null && this.organisationDataTitlePane.domNode != null) {
                    var offsetHeight = this.organisationDataTitlePane.domNode.offsetHeight;
                    if (offsetHeight != null && !isNaN(offsetHeight)) {
                        memberHeight -= offsetHeight;
                    }
                }
            }

            if (this.memberTitlePane != null && this.memberTitlePane.containerNode != null) {
                var containerNode = this.memberTitlePane.containerNode;
                var paddingHeight = domStyle.get(containerNode, "padding-top") + domStyle.get(containerNode, "padding-bottom");
                if (paddingHeight != null && !isNaN(paddingHeight)) {
                    memberHeight -= paddingHeight;
                }
            }
            if (this.memberTitlePane != null && this.memberTitlePane.titleBarNode != null) {
                var titleBarHeight = this.memberTitlePane.titleBarNode.offsetHeight;
                if (titleBarHeight != null && !isNaN(titleBarHeight)) {
                    memberHeight -= titleBarHeight;
                }
            }

            memberHeight -= 3;

            this.memberWidget.resize({ h : memberHeight });
        },
        
        setData : function() {
        },
        
        setOrganisationInfo : function(organisationInfo) {
            this.editWidget.setOrganisations(organisationInfo.organisations);
            this.organisationJoin = organisationInfo.organisationJoin;
            this.organisationPersonJoins = organisationInfo.organisationPersonJoins;
            this.actions = DataHelper.getAsSet(organisationInfo.actions);
        },

        reload : function(successCallback) {
            var organisationService = this.applicationContext.getService("organisationService");

            if (this.mode == ContentWidget.Mode.CREATE) {
                this.registerAsyncOperationStarted(OrganisationEditPage.AsyncOperation.GET_CREATE_INFO);
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                organisationService.getOrganisationCreateInfo(organisationPersonId, this.networkId).then(
                    lang.hitch(this, function(organisationInfo) {
                        this.registerAsyncOperationFinished(OrganisationEditPage.AsyncOperation.GET_CREATE_INFO);

                        this.organisationJoin = new Object();
                        this.updateWidgetsFromData();

                        this.editWidget.setOrganisations(organisationInfo.organisations);
                    }), lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : OrganisationEditPage.AsyncOperation.GET_CREATE_INFO,
                                    opName : "getOrganisationCreateInfo",
                                   message : i18n.organisationEditGetOrganisationCreateInfoFailed
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [getOrganisationEditInfo]", err);
                        }));
            } else if (this.mode == ContentWidget.Mode.SHOW || this.mode == ContentWidget.Mode.EDIT) {
                this.registerAsyncOperationStarted(OrganisationEditPage.AsyncOperation.GET_DATA);
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                organisationService.getOrganisationEditInfo(organisationPersonId, this.organisationId).then(
                    lang.hitch(this, function(organisationInfo) {
                        this.registerAsyncOperationFinished(OrganisationEditPage.AsyncOperation.GET_DATA);
                        this.setOrganisationInfo(organisationInfo);

                        this.updateWidgetsFromData();

                        var successMessage = string.substitute(i18n.organisationEditGetOrganisationEditInfoSuccess, {
                            organisationName : this.organisationJoin.organisationName
                        });
                        topic.publish("message/ok", successMessage);
                    }), lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : OrganisationEditPage.AsyncOperation.GET_DATA,
                                    opName : "getOrganisationEditInfo",
                                   message : i18n.organisationEditGetOrganisationEditInfoFailed
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [getOrganisationEditInfo]", err);
                        }));
            } else {
                throw new Error("Illegal mode of OrganisationEditPage: [" + this.mode + "]");
            }
        },
        
        updateWidgetState : function() {
            var operationRunning = this.isAsyncOperationRunning();

            var changed = this.editWidget.isChanged();

			var saveDisabled = true;
			if (this.mode != ContentWidget.Mode.SHOW)
				saveDisabled = !changed || !this.editWidget.isValid();

            this.saveButton.set("disabled", !!saveDisabled);
            this.saveAndExitButton.set("disabled", !!saveDisabled);

        	if (this.mode == ContentWidget.Mode.SHOW) {
                domClass.add(this.saveButton.domNode, "hidden");
                domClass.add(this.saveAndExitButton.domNode, "hidden");
            }else{
                domClass.remove(this.saveButton.domNode, "hidden");
                domClass.remove(this.saveAndExitButton.domNode, "hidden");
            }

            var caption;
            if (this.mode == ContentWidget.Mode.EDIT) {
                caption = i18n.organisationEditPageEditCaption;
            } else if (this.mode == ContentWidget.Mode.SHOW) {
                caption = i18n.organisationEditPageShowCaption;
            } else {
                caption = i18n.organisationEditPageCreateCaption;
            }
            
            DOMHelper.setInnerText(this.captionDiv, string.substitute(caption, {
                organisationName : this.organisation != null && !StringHelper.isEmpty(this.organisation.name) ? this.organisation.name : ""
            }));

            var allFieldsValid = this.editWidget.isValid();
/*
            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;

                this.editWidget.updateWidgetState();
            }
*/
        },
        
        updateWidgetsFromData : function() {            
            this.editWidget.setData(this.organisationJoin);

            if (this.mode == ContentWidget.Mode.SHOW || this.mode == ContentWidget.Mode.EDIT) {
                this.memberWidget.setData({
                           organisationJoin : this.organisationJoin,
                    organisationPersonJoins : this.organisationPersonJoins,
                                    actions : this.actions
                });
            }
        },

        constructOrganisationTitlePane : function() {
            this.editWidget = new OrganisationEditWidget({
                applicationContext : this.applicationContext,
                              mode : this.mode
            });
            this.organisationDataTitlePane = new IconTitlePane({
                       title   : i18n.organisationEditOrganisationDataOpenCaption,
                       content : this.editWidget.getContainer(),
                    toggleable : false,
                          open : true,
                postTitleClick : lang.hitch(this, this.organisationDataPostTitleClick)
            });
            domConstruct.place(this.organisationDataTitlePane.domNode, this.titlePaneDiv);
            on(this.editWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));
            on(this.editWidget, "changedStateChange", lang.hitch(this, this.updateWidgetState));
        },

        getMemberCaption : function(open) {
            var rawString = open ? i18n.organisationEditMemberOpenCaption : i18n.organisationEditMemberClosedCaption;
            return rawString;
        },

        constructMemberTitlePane : function() {
            this.memberWidget = new OrganisationMemberListWidget({
                applicationContext : this.applicationContext,
                              mode : this.mode
            });
            this.memberTitlePane = new IconTitlePane({
                         title : this.getMemberCaption(true),
                       content : this.memberWidget.getContainer(),
                    toggleable : true,
                          open : true,
                postTitleClick : lang.hitch(this, this.memberPostTitleClick)
            });
            domConstruct.place(this.memberTitlePane.domNode, this.titlePaneDiv);
        },        

        organisationDataPostTitleClick : function() {
            var open = this.organisationDataTitlePane.get("open");

            if (open) {
                this.organisationDataTitlePane.set("title", i18n.organisationEditOrganisationDataOpenCaption);
            } else {
                this.organisationDataTitlePane.set("title", i18n.organisationEditOrganisationDataClosedCaption);
            }

            // Unfortunately, the new height of the organisationDataTitlePane becomes
            // available for programmatic fetching something like 0.5s after the
            // click triggering this event handler, for reasons of visual effects.
            // Thus, don't try to derive it from DOM tree here.
            var assumedHeight = open ? 190 : 29;
            this.resize(null, assumedHeight);
        },

        memberPostTitleClick : function() {
            var open = this.memberTitlePane.get("open");
            this.memberTitlePane.set("title", this.getMemberCaption(open));
        }
    });
    
    OrganisationEditPage.AsyncOperation = {
        GET_CREATE_INFO : "GetCreateInfo",
        GET_DATA : "GetData",
        GET_SIMILAR_ORGANISATIONS : "GetSimilarOrganisations",
        SAVE : "Save"
    };
    
    return OrganisationEditPage;
});
