/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = projectParticipationPage
////i18n-prefix = projectParticipationPage


define(["cdes/core/CdesVoc",
        "cdes/project/ProjectParticipationColumnWidget",
        "cdes/project/ProjectParticipationListWidget",
        "cdes/project/ProjectParticipationSearchWidget",
        "cdes/util/ColumnHelper",
        "cdes/util/SearchPageHelper",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",       
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         CdesVoc,
         ProjectParticipationColumnWidget,
         ProjectParticipationListWidget,
         ProjectParticipationSearchWidget,
         ColumnHelper,
         SearchPageHelper,
         TinyLog,
         DateHelper,
         FancyButton,
         topic,
         DOMHelper,
         ErrorHelper,
         ContentWidget,
         domClass,
         domConstruct,
         domStyle,
         ioQuery,
         on,             
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.project.ProjectParticipationPage";

    var log = new TinyLog(className);

    var ProjectParticipationPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.reloadSearchInfo();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ProjectParticipationPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.participationPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            this.constructBackButton(captionBarDiv);

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute wholeRegion");

            // Search Widget
            this.searchWidget = new ProjectParticipationSearchWidget({
                applicationContext : this.applicationContext,
                          personId : this.personId
            });
            this.searchWidgetDiv = this.searchWidget.getContainer();
            domConstruct.place(this.searchWidgetDiv, contentDiv);
            on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));                   
            on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));

            // Column Widget
            this.columnWidget = new ProjectParticipationColumnWidget({
                applicationContext : this.applicationContext
            });
            this.columnWidgetDiv = this.columnWidget.getContainer();
            domConstruct.place(this.columnWidgetDiv, contentDiv);
            on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.resize));                   
	    on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));
            
            this.statusBarDiv = SearchPageHelper.constructSingleLineStatusBarWithQuickSearch({
                                 baseWidget : this,
                processQuickSearchChangeFct : lang.hitch(this, this.processQuickSearchChange),
                        clearQuickSearchFct : lang.hitch(this, this.clearQuickSearch)
            });

            domClass.add(this.statusBarDiv, "participationPageStatusBar");
            domConstruct.place(this.statusBarDiv, contentDiv);

            // List Widget
            this.listWidget = new ProjectParticipationListWidget({
                applicationContext : this.applicationContext,
                          backPage : "projectParticipationList",
                        backParams : new Object()
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domClass.add(this.listWidgetDiv, "fixedDialogWidget listWidget");       
            domConstruct.place(this.listWidgetDiv, contentDiv);
            // Reload data after certain operations which change state have been performed
            on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

            this.listWidget.restoreColumnWidths();

            return contentDiv;
        },

        constructBackButton : function(captionBarDiv) {
            var label = i18n.back;
            this.backButton = new FancyButton({ 
                label : label,
                title : label
            });
            domClass.add(this.backButton.domNode, "textButton captionBarButton participationPageBackButton");
            domConstruct.place(this.backButton.domNode, captionBarDiv);

            on(this.backButton, "click", lang.hitch(this, this.abort));
        },

        abort : function() {
            this.applicationContext.popLastPageHistoryPage({ cameBack : true});
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;                   

            var tableHeight = totalHeight
                            - this.captionBarDiv.offsetHeight
                            - this.searchWidgetDiv.offsetHeight
                            - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom")
                            - this.columnWidgetDiv.offsetHeight
                            - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom")
                            - this.statusBarDiv.offsetHeight
                            - 16;
            this.listWidget.resize({ h : tableHeight });
        },

	getAutomaticColumnSettings : function(searchModel) {
	    return {
		        showNetwork : true,
		        showProject : true,
		   showOrganisation : true,
                       showCdesRole : true,
                    showParticipant : true,
                showMainParticipant : true,
                     showSubProject : true
	    };		
	},

	processColumnsChanged : function(columnId) {
	    var columnSettings = this.columnWidget.getColumnSettings();
	    this.listWidget.setColumns(columnSettings, columnId);
	},

        reloadSearchInfo : function() {
            this.doReloadSearchInfo();
        },

        getDefaultColumnSettings : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldColumnSettings = this.applicationContext.getFromLocalStorage([organisationPersonId], "participation/columns");
            if (oldColumnSettings != null) {
                return oldColumnSettings;
            } else {
                return this.getAutomaticColumnSettings(null);
            }
        },

        doReloadSearchInfo : function() {
            // For now, probably place it into the handler lateron
            var defaultColumnSettings = this.getDefaultColumnSettings();
    		this.columnWidget.setData(defaultColumnSettings);

            var prevSeconds = DateHelper.getCurrentTimeSeconds();

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(ProjectParticipationPage.AsyncOperation.LOAD_SEARCH_INFO);
            var projectService = this.applicationContext.getService("projectService");
            projectService.getParticipationSearchInfo(organisationPersonId, this.personId).then(
                lang.hitch(this, function(searchInfo) {
                    this.registerAsyncOperationFinished(ProjectParticipationPage.AsyncOperation.LOAD_SEARCH_INFO);

                    var postSeconds = DateHelper.getCurrentTimeSeconds();
                    var duration = postSeconds - prevSeconds;
                    this.logSearchInfoDetails(searchInfo, duration);

                    this.searchWidget.setSearchInfo(searchInfo);
                    this.personName = searchInfo.personName;
                    this.reload();
                    /*
                    this.administratedNetworks = searchInfo.administratedNetworks;
                    this.searchWidget.setSearchInfo(searchInfo);
                    this.listWidget.setAdministratedNetworks(searchInfo.administratedNetworks);
                    this.networkActions = searchInfo.networkActions;

                    if (this.exportToPdfButton == null && this.networkActions != null && ("editPerson" in this.networkActions || "showPerson" in this.networkActions)) {
                    this.exportToPdfButton = this.constructExportToPdfButton(this.captionBarDiv);
                }
                    
                    //if (this.newButton == null && this.networkActions != null && "editPerson" in this.networkActions) {
                    if (this.newButton == null && this.administratedNetworks != null && this.administratedNetworks.length > 0) {
                    this.newButton = this.constructNewButton(this.captionBarDiv);
                }
                    //this.reload();
                    */
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ProjectParticipationPage.AsyncOperation.LOAD_SEARCH_INFO,
                                opName : "getParticipationSearchInfo",
                               message : i18n.participationPageSearchInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getParticipationSearchInfo]", err);
                    }));
        },

        getMapSize : function(map) {
            var count = 0;
            for (var id in map) {
                count++;
            }
            return count;
        },

        logSearchInfoDetails : function(searchInfo, duration) {
            var networkCount = searchInfo.networks != null ? searchInfo.networks.length : 0;
            var projectCount = searchInfo.projects != null ? searchInfo.projects.length : 0;
            var organisationCount = searchInfo.organisations != null ? searchInfo.organisations.length : 0;
            var cdesRoleCount = searchInfo.cdesRoles != null ? searchInfo.cdesRoles.length : 0;
            var organisationPersonCount = searchInfo.organisationPersons != null ? searchInfo.organisationPersons.length : 0;
            var personCount = searchInfo.persons != null ? searchInfo.persons.length : 0;
            var subProjectCount = searchInfo.subProjects != null ? searchInfo.subProjects.length : 0;
            var objectReleaseCount = searchInfo.idToObjectRelease != null
                                   ? this.getMapSize(searchInfo.idToObjectRelease) : 0;
            var objectPlannerReleaseCount = searchInfo.objectPlannerReleases != null ? searchInfo.objectPlannerReleases.length : 0;
            var objectPlannerPositionDefinitionCount = searchInfo.idToObjectPlannerPositionDefinition != null
                                                     ? this.getMapSize(searchInfo.idToObjectPlannerPositionDefinition) : 0;
            var reviewCycleInstanceReleasedCount = searchInfo.reviewCycleInstanceReleaseds != null
                                                 ? searchInfo.reviewCycleInstanceReleaseds.length : 0;
            var reviewCycleCount = searchInfo.idToReviewCycle != null
                                 ? this.getMapSize(searchInfo.idToReviewCycle) : 0;
            var reviewCycleCellCount = searchInfo.reviewCycleCells != null ? searchInfo.reviewCycleCells.length : 0;
            var reviewCycleNodeCount = searchInfo.reviewCycleNodes != null ? searchInfo.reviewCycleNodes.length : 0;
            var realmCount = searchInfo.realms != null ? searchInfo.realms.length : 0;

            log.info("Fetched participationSearchInfo in [" + duration.toFixed(2) + "s]");
            log.info("... [" + networkCount + "] networks");
            log.info("... [" + projectCount + "] projects");
            log.info("... [" + organisationCount + "] organisations");
            log.info("... [" + cdesRoleCount + "] cdesRoles");
            log.info("... [" + organisationPersonCount + "] organisationPersons");
            log.info("... [" + personCount + "] persons");
            log.info("... [" + subProjectCount + "] subProjects");
            log.info("... [" + objectReleaseCount + "] objectReleases");
            log.info("... [" + objectPlannerReleaseCount + "] objectPlannerReleases");
            log.info("... [" + objectPlannerPositionDefinitionCount + "] objectPlannerPositionDefinitions");
            log.info("... [" + reviewCycleInstanceReleasedCount + "] reviewCycleInstanceReleaseds");
            log.info("... [" + reviewCycleCount + "] reviewCycles");
            log.info("... [" + reviewCycleCellCount + "] reviewCycleCells");
            log.info("... [" + reviewCycleNodeCount + "] reviewCycleNodes");
            log.info("... [" + realmCount + "] realms");
        },        

        cloneAndConvertSearchModelForServer : function(searchModel) {
            return {
                                       basePersonId : searchModel.basePersonId,
                                mainParticipantFlag : searchModel.mainParticipantFlag,
                                           personId : searchModel.personId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.personId : null,
                                         personName : searchModel.personName,
                                     organisationId : searchModel.organisationId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.organisationId : null,
                                   organisationName : searchModel.organisationName,
                                         cdesRoleId : searchModel.cdesRoleId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.cdesRoleId : null,
                                       cdesRoleName : searchModel.cdesRoleName,
                                          networkId : searchModel.networkId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.networkId : null,
                                        networkName : searchModel.networkName,
                                          projectId : searchModel.projectId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.projectId : null,
                                    projectCodeName : searchModel.projectCodeName,
                                       subProjectId : searchModel.subProjectId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.subProjectId : null,
                                 subProjectCodeName : searchModel.subProjectCodeName,
                                    objectReleaseId : searchModel.objectReleaseId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.objectReleaseId : null,
                              objectReleaseCodeName : searchModel.objectReleaseCodeName,
                             objectPlannerReleaseId : searchModel.objectPlannerReleaseId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.objectPlannerReleaseId : null,
                       objectPlannerReleaseCodeArea : searchModel.objectPlannerReleaseCodeArea,
                  objectPlannerPositionDefinitionId : searchModel.objectPlannerPositionDefinitionId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.objectPlannerPositionDefinitionId : null,
                objectPlannerPositionDefinitionName : searchModel.objectPlannerPositionDefinitionName,
                      reviewCycleInstanceReleasedId : searchModel.reviewCycleInstanceReleasedId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.reviewCycleInstanceReleasedId : null,
                    reviewCycleInstanceReleasedName : searchModel.reviewCycleInstanceReleasedName,
                                      reviewCycleId : searchModel.reviewCycleId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.reviewCycleId : null,
                                    reviewCycleName : searchModel.reviewCycleName,
                                  reviewCycleCellId : searchModel.reviewCycleCellId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.reviewCycleCellId : null,
                                reviewCycleCellName : searchModel.reviewCycleCellName,
                                  reviewCycleNodeId : searchModel.reviewCycleNodeId != CdesVoc.MagicSelectOption.ALL
                                                                            ? searchModel.reviewCycleNodeId : null,
                                reviewCycleNodeName : searchModel.reviewCycleNodeName,
                                            realmId : searchModel.realmId != CdesVoc.MagicSelectOption.ALL
                                                                           ? searchModel.realmId : null,
                                          realmName : searchModel.realmName,
            };
        },

        setData : function() {
            this.reload();
        },

        reload : function() {
            var columnSettings = this.columnWidget.getColumnSettings();
            this.listWidget.setData({
                participationListJoins : [],
                        columnSettings : columnSettings
            });

            this.registerAsyncOperationStarted(ProjectParticipationPage.AsyncOperation.LOAD);

            DOMHelper.setInnerText(this.statusDiv, i18n.searchRuns);
            var prevSeconds = DateHelper.getCurrentTimeSeconds();

            var searchModel = this.searchWidget.getSearchModel();
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.applicationContext.storeInLocalStorage([organisationPersonId], "/participationList/search", searchModel);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

            var projectService = this.applicationContext.getService("projectService");
            projectService.getParticipationListJoins(organisationPersonId, searchModel).then(
                lang.hitch(this, function(participationJoins) {
                    this.registerAsyncOperationFinished(ProjectParticipationPage.AsyncOperation.LOAD);

                    var postSeconds = DateHelper.getCurrentTimeSeconds();
                    var duration = postSeconds - prevSeconds;
                    log.info("Fetched [" + participationJoins.length
                             + "] participation joins in [" + duration + "s]");
                    
                    var searchInfoString = this.getSearchInfoString(participationJoins.length, duration);
                    topic.publish("message/ok", searchInfoString);
                    DOMHelper.setInnerText(this.statusDiv, searchInfoString);

                    this.listWidget.setData({
                        participationListJoins : participationJoins
                    });
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ProjectParticipationPage.AsyncOperation.LOAD,
                                opName : "getParticipationListJoins",
                               message : i18n.participationPageLoadDataFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getParticipationListJoins]", err);
                    }));
        },

        getSearchInfoString : function(count, duration) {
            var searchInfo = string.substitute(i18n.participationPageSearchResult, {
                count : count,
                duration : duration.toFixed(2)
            });
            return searchInfo;
        },

        processQuickSearchChange : function() {
            var newSearch = this.quickSearchTextBox.get("value");
            if (newSearch != this.lastQuickSearch) {
                this.listWidget.filter(newSearch);
                this.lastQuickSearch = newSearch;
            }
        },
        
        clearQuickSearch : function() {
            this.quickSearchTextBox.set("value", "", false);
            this.processQuickSearchChange();
        },

        updateWidgetState : function() {
            var asyncRunning = this.isAsyncOperationRunning();
            if (this.searchWidget != null) {
                this.searchWidget.setAsyncRunning(asyncRunning);
            }
            DOMHelper.setInnerText(this.captionDiv, i18n.participationPageCaption + " " + this.personName);
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    ProjectParticipationPage.AsyncOperation = {
        LOAD : "Load",
        LOAD_SEARCH_INFO : "LoadSearchInfo"
    };

    return ProjectParticipationPage;
});
