/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = anlagentypImport
//// i18n-prefix = anlagentypImport

define([ 
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ChooseDialog",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Form",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",  
    "dojo/string",
    "dojox/form/Uploader",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
    TinyLog,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ChooseDialog,                
    ContentWidget,
    Form,
    domClass,
    domConstruct,
    domStyle,
    on,
    declare,
    lang,
    string,
    Uploader,    
    i18n) {

        var className = "at.cdes.web.widget.msp.AnlagentypChooseDialog";

        var log = new TinyLog(className);

        var AnlagentypImportDialog = declare(className, ChooseDialog, {

            constructChooseWidget : function() {
                // summary:
                //     Constructs the widget in which the user chooses some piece of data.
                // description:
                //     That widget must be saved in the variable this.content, and will 
                //     subsequently be placed in the dialog by superclass code.
                //     If some value is chosen by the user in that widget (e.g. a choosable 
                //     tree node is clicked), the subclass must call setChosenValue.  
                //     Optionally, after doing so, the subclass may emit the valueChosen 
                //     event, and close the dialog (e.g. on a double click into the tree).

                var topDiv = domConstruct.create("div", null, null);
                domClass.add(topDiv, "refNodeOfPositionAbsolute anlagentypImportTopDiv");

                DOMHelper.createTextNode("div", i18n.anlagentypImportPleaseUploadLabel, topDiv, "fixedDialogWidget anlagentypImportPleaseUploadLabel");

     	        // Import form etc.
    	        var importFrame = this.applicationContext.getFancyIFrame();
    		
    	        this.importForm = new Form({method : "post", encType : "multipart/form-data"});
    	        domClass.add(this.importForm.domNode, "fixedDialogWidget anlagentypImportImportForm");
    	        domConstruct.place(this.importForm.domNode, topDiv);
    	        
    	        this.importForm.set("target", importFrame.id);

     	        // Import
     	        this.fileUploadLabel = DOMHelper.createTextNode("div", i18n.anlagentypImportFileLabel, topDiv, "propertyLabel anlagentypImportFileUploadLabel");
    	        this.uploader = new dojox.form.Uploader({
		        name : "uploadedFile",
		    multiple : false,
		        type : "file",
		       label : i18n.chooseFile
    	        });
    	        domClass.add(this.uploader.domNode, "fixedDialogWidget anlagentypImportFileUpload");
    	        domConstruct.place(this.uploader.domNode, this.importForm.domNode);
                
                this.fileInfoLabel = domConstruct.create("div", null, null);
                domClass.add(this.fileInfoLabel, "fixedDialogWidget anlagentypImportFileInfoLabel");
                domConstruct.place(this.fileInfoLabel, topDiv);                

                var url = "/cdes-dojo-impl/tempFileUpload";
    	        this.uploader.set("url", url);
    	        this.importForm.set("action", url);
                
    	        this.uploader.startup();
                
    	        on(this.uploader, "change", lang.hitch(this, function(fileInfos) {
		    var fileSizeInfos = [];
		    for (var n = 0; n < fileInfos.length; n++) {
                        var name = fileInfos[n].name;
                        var size = fileInfos[n].size;
                        var fileInfoString = string.substitute(i18n.anlagentypImportFileInfoLabel, {
                            name : name,
                            size : (size / 1000).toFixed(1)                            
                        });                            

                        DOMHelper.setInnerText(this.fileInfoLabel, fileInfoString);
		    }

                    this.importForm.submit();                    
                }));                    

	        log.info("Setting up documentLoad");
	        this.documentLoadRegistration = on(importFrame, "documentLoad", lang.hitch(this, function(e) {
		    log.info("Called documentLoad with event", e);

		    var tempFileName = e.document ? e.document.body.innerHTML : null;
		    log.info("Received tempFileName = [" + tempFileName + "]");
		    if (log.isDebugEnabled()) {
		        log.debug("Received tempFileName = [" + tempFileName + "]");
		    }
                    this.tempFileName = tempFileName;
                    this.updateWidgetState();
	        }));		
                this.content = topDiv;
            },

                updateWidgetState : function() {
                    if (this.selectButton != null) {
                        this.selectButton.set("disabled", this.tempFileName == null);
                    }
                },      

                  emitValueChosen : function(buttonName) {
                      on.emit(this, "valueChosen", {
             tempFileName : this.tempFileName
                      });                          
                  },

                          destroy : function() {
                              this.inherited(arguments);
                          }
        });

        AnlagentypImportDialog.AsyncOperation = {
        };                        

        return AnlagentypImportDialog;
    });

