/*
* $Id: mda-web.js 1262 2013-06-01 16:53:45Z mda $
*
* Copyright (C) 2016 ev-i IT GmbH
*/

require([
    "cdes/admin/db/DBAdminPage",
    "clazzes/LoginGuardRpcService",
    "clazzes/LogMessagePaneWithHistory",
    "clazzes/TinyLog",
    "clazzes/util/DataHelper",
    "clazzes/util/DOMHelper",
    "dgrid/Grid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-construct",
    "dojo/json",
    "dojo/on",
    "dojo/ready", 
    "dojo/date/locale",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/store/Memory",
    "dojox",
    "dojox/rpc/JsonRPC",
    "dojo/text!/cdes/svc/adminServiceWeb?smd",
    "dojo/domReady!"
], function(
    DBAdminPage,
    LoginGuardRpcService,
    LogMessagePaneWithHistory,
    TinyLog,
    DataHelper,
    DOMHelper,
    Grid,
    ColumnResizer,
    DijitRegistry,
    domConstruct,
    json,
    on,
    ready,
    locale,
    declare,
    lang,
    Memory,
    dojox,
    JsonRPC,
    adminServiceSmd
) {

    ready(function() {
	
	// workaround for enforced named parameters in dojox.rpc-1.9+
	// actually, this is a dojo bug...
	var envDef = dojox.rpc.envelopeRegistry.match("JSON-RPC-2.0");
	
	if (envDef && envDef.namedParams) {
	    envDef.namedParams = false;
	}				

	var log = new TinyLog("cdes-web");
	log.info("Starting up cdes-web");
	
	this.adminService = new LoginGuardRpcService(json.parse(adminServiceSmd));
	
	var deferred = this.adminService.showAdminPage();
	deferred.then(lang.hitch(this, function() {
	    this.logMessagePane = new LogMessagePaneWithHistory();
	    
	    this.page = new DBAdminPage();
	    var topDiv = this.page.getContainer();
	    domConstruct.place(topDiv, "appLayout");	
	    domConstruct.place(this.logMessagePane.domNode, "appLayout");
	    
	    this.page.resize({ w : window.innerWidth, h : window.innerHeight - this.logMessagePane.domNode.offsetHeight});
	    on(window, "resize", lang.hitch(this, function(e) {
		this.page.resize({ w : window.innerWidth, h : window.innerHeight - this.logMessagePane.domNode.offsetHeight });
	    }));
	}), lang.hitch(this, function(err) {    			
	    log.error("Error on calling getVersionInfo", err);
	})).otherwise(lang.hitch(this, function(err) {
	    log.error("Error while processing the results of calling getVersionInfo: ", err);
	}));				
    });
});
