define([ 
    "cdes/util/ColumnHelper",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/IconTitlePane",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/CheckBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/Evented",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
    ColumnHelper,
    TinyLog,
    DOMHelper,
    WidgetHelper,
    IconTitlePane,
    ContentWidget,
    CheckBox,
    domClass,
    domConstruct,
    Evented,
    on,
    declare,
    lang,
    i18n
) {
    
    var className = "at.cdes.web.certificate.CertificateColumnWidget";

    var log = new TinyLog(className);
    
    var CertificateColumnWidget = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.topDiv = this.constructTopDiv();
            this.updateTitlePane();
            
            this.allFieldsValid = true;
        },
        
        getWidgetId : function() {
            return "CertificateColumnWidget";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute certificateColumnTopDivReduced");
            
            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);
            
            return topDiv;
        },
        
        updateTitlePane : function() {
            var open = this.titlePane.get("open");
            if (open) {
                this.titlePane.set("title", i18n.columnOpenCaption);
                domClass.replace(this.topDiv, "certificateColumnTopDivFull", "certificateColumnTopDivReduced");
            } else {
                this.titlePane.set("title", i18n.columnClosedCaption);
                domClass.replace(this.topDiv, "certificateColumnTopDivReduced", "certificateColumnTopDivFull");
            }               
        },
        
        postTitleClick : function() {
            this.updateTitlePane();
            on.emit(this, "titlePaneToggled");
        },
        
        constructTitlePane : function() {
            var columnDiv = this.constructColumnDiv();
            
            var titlePane = new IconTitlePane({
                       title   : i18n.columnOpenCaption,
                       content : columnDiv,
                    toggleable : true,
                          open : false,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "occupyWholeParent");
            
            return titlePane;
        },
        
        constructColumnDiv : function() {
            var columnDiv = domConstruct.create("div", null, null);
            domClass.add(columnDiv, "refNodeOfPositionAbsolute certificateColumnDiv");
            
            // Name
            this.nameCheckBox = new CheckBox({
                label : i18n.certificateNameColumnLabel,
                title : i18n.certificateNameColumnToolTip
            });
            domClass.add(this.nameCheckBox.domNode, "fixedDialogWidget certificateNameColumnCheckBox");
            domConstruct.place(this.nameCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateNameColumnLabel, columnDiv, "fixedDialogWidget certificateNameColumnLabel");
            this.handleCheckBoxEvents(this.nameCheckBox, "personId");            
            
            // Network
            this.networkCheckBox = new CheckBox({
                label : i18n.certificateNetworkColumnLabel,
                title : i18n.certificateNetworkColumnToolTip
            });
            domClass.add(this.networkCheckBox.domNode, "fixedDialogWidget certificateNetworkColumnCheckBox");
            domConstruct.place(this.networkCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateNetworkColumnLabel, columnDiv, "fixedDialogWidget certificateNetworkColumnLabel");              
            this.handleCheckBoxEvents(this.networkCheckBox, "networkName");
            
            // Organisation
            this.organisationCheckBox = new CheckBox({
                label : i18n.certificateOrganisationColumnLabel,
                title : i18n.certificateOrganisationColumnToolTip
            });
            domClass.add(this.organisationCheckBox.domNode, "fixedDialogWidget certificateOrganisationColumnCheckBox");
            domConstruct.place(this.organisationCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateOrganisationColumnLabel, columnDiv, "fixedDialogWidget certificateOrganisationColumnLabel");                    
            this.handleCheckBoxEvents(this.organisationCheckBox, "organisationId");
            
            // Valid
            this.validCheckBox = new CheckBox({
                label : i18n.certificateValidColumnLabel,
                title : i18n.certificateValidColumnToolTip
            });
            domClass.add(this.validCheckBox.domNode, "fixedDialogWidget certificateValidColumnCheckBox");
            domConstruct.place(this.validCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateValidColumnLabel, columnDiv, "fixedDialogWidget certificateValidColumnLabel");                  
            this.handleCheckBoxEvents(this.validCheckBox, "valid");
            
            // Issuer
            this.issuerCheckBox = new CheckBox({
                label : i18n.certificateIssuerColumnLabel,
                title : i18n.certificateIssuerColumnToolTip
            });
            domClass.add(this.issuerCheckBox.domNode, "fixedDialogWidget certificateIssuerColumnCheckBox");
            domConstruct.place(this.issuerCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateIssuerColumnLabel, columnDiv, "fixedDialogWidget certificateIssuerColumnLabel");                
            this.handleCheckBoxEvents(this.issuerCheckBox, "issuerPersonId");
            
            // Status
            this.statusCheckBox = new CheckBox({
                label : i18n.certificateStatusColumnLabel,
                title : i18n.certificateStatusColumnToolTip
            });
            domClass.add(this.statusCheckBox.domNode, "fixedDialogWidget certificateStatusColumnCheckBox");
            domConstruct.place(this.statusCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateStatusColumnLabel, columnDiv, "fixedDialogWidget certificateStatusColumnLabel");
            this.handleCheckBoxEvents(this.statusCheckBox, "certificateMayLogin");
            
            // Invitation
            this.invitationCheckBox = new CheckBox({
                label : i18n.certificateInvitationColumnLabel,
                title : i18n.certificateInvitationColumnToolTip
            });
            domClass.add(this.invitationCheckBox.domNode, "fixedDialogWidget certificateInvitationColumnCheckBox");
            domConstruct.place(this.invitationCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateInvitationColumnLabel, columnDiv, "fixedDialogWidget certificateInvitationColumnLabel");
            this.handleCheckBoxEvents(this.invitationCheckBox, "certificateRequestCreated");
            
            // Invitator
            this.invitatorCheckBox = new CheckBox({
                label : i18n.certificateInvitatorNameColumnLabel,
                title : i18n.certificateInvitatorNameColumnToolTip
            });
            domClass.add(this.invitatorCheckBox.domNode, "fixedDialogWidget certificateInvitatorNameColumnCheckBox");
            domConstruct.place(this.invitatorCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateInvitatorNameColumnLabel, columnDiv, "fixedDialogWidget certificateInvitatorNameColumnLabel");
            this.handleCheckBoxEvents(this.invitatorCheckBox, "invitatorPersonId");
            
            // Requested
            this.requestedCheckBox = new CheckBox({
                label : i18n.certificateRequestedNameColumnLabel,
                title : i18n.certificateRequestedNameColumnToolTip
            });
            domClass.add(this.requestedCheckBox.domNode, "fixedDialogWidget certificateRequestedColumnCheckBox");
            domConstruct.place(this.requestedCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateRequestedNameColumnLabel, columnDiv, "fixedDialogWidget certificateRequestedNameColumnLabel");
            this.handleCheckBoxEvents(this.requestedCheckBox, "certificateRequestRequestDatetime");
            
            // Serial number
            this.serialNumberCheckBox = new CheckBox({
                label : i18n.certificateSerialNumberColumnLabel,
                title : i18n.certificateSerialNumberColumnToolTip
            });
            domClass.add(this.serialNumberCheckBox.domNode, "fixedDialogWidget certificateSerialNumberCheckBox");
            domConstruct.place(this.serialNumberCheckBox.domNode, columnDiv);
            DOMHelper.createTextNode("div", i18n.certificateSerialNumberColumnLabel, columnDiv, "fixedDialogWidget certificateSerialNumberLabel");
            this.handleCheckBoxEvents(this.serialNumberCheckBox, "certificateCertSerial");
            
            return columnDiv;
        },
        
        handleCheckBoxEvents : function(checkBox, columnId) {
            WidgetHelper.handleCheckBoxEvents(checkBox, lang.hitch(this, function() {
                ColumnHelper.emitColumnsChanged(this.applicationContext, this, "/certificate/columns", columnId);
            }));                        
        },

        setData : function(columnSettings) {
            this.columnSettings = columnSettings;
            this.reload();
        },
        
        reload : function() {
            this.nameCheckBox.set("checked", this.columnSettings.showName);
            this.networkCheckBox.set("checked", this.columnSettings.showNetwork);
            this.organisationCheckBox.set("checked", this.columnSettings.showOrganisation);
            this.validCheckBox.set("checked", this.columnSettings.showValid);
            this.issuerCheckBox.set("checked", this.columnSettings.showIssuer);
            this.statusCheckBox.set("checked", this.columnSettings.showStatus);
            this.invitationCheckBox.set("checked", this.columnSettings.showInvitation);
            this.invitatorCheckBox.set("checked", this.columnSettings.showInvitator);
            this.requestedCheckBox.set("checked", this.columnSettings.showRequested);
            this.serialNumberCheckBox.set("checked", this.columnSettings.showSerialNumber);
        },
        
        updateDataFromWidgets : function() {
            this.columnSettings.showName = this.nameCheckBox.get("checked");
            this.columnSettings.showNetwork = this.networkCheckBox.get("checked");
            this.columnSettings.showOrganisation = this.organisationCheckBox.get("checked");
            this.columnSettings.showValid = this.validCheckBox.get("checked");
            this.columnSettings.showIssuer = this.issuerCheckBox.get("checked");
            this.columnSettings.showStatus = this.statusCheckBox.get("checked");
            this.columnSettings.showInvitation = this.invitationCheckBox.get("checked");
            this.columnSettings.showInvitator = this.invitatorCheckBox.get("checked");
            this.columnSettings.showRequested = this.requestedCheckBox.get("checked");
            this.columnSettings.showSerialNumber = this.serialNumberCheckBox.get("checked");
        },
        
        getColumnSettings : function() {
            return this.columnSettings;
        }
    });
    
    return CertificateColumnWidget;
});
