define([
    "dojo/sniff",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"        
],
function(
    sniff,
    i18n
) {
    
    var CdesVoc = {

        WHATEVER : "Whatever",
        PLEASE_CHOOSE : "__PLEASE_CHOOSE__",

        WORKFLOW_ENTITIY_STATUS_NOT_INITIALIZED : -1,

        ArchiveScope : {
                    ARCHIVE_SCOPE_RECENT : 1,
                       ARCHIVE_SCOPE_ALL : 2,
            ARCHIVE_SCOPE_ALLWITHHISTORY : 3
        },            

        ArchiveFileFormat : {
            ARCHIVE_TYPE_ORIGINAL : 0,
                 ARCHIVE_TYPE_PDF : 1,
                ARCHIVE_TYPE_BOTH : 2
        },            

        MailSendMode : {
             NEVER : { label : i18n.emailSendModeNever, value : "NEVER" },
             BRIEF : { label : i18n.emailSendModeBrief, value : "BRIEF" },
            ALWAYS : { label : i18n.emailSendModeAlways, value : "ALWAYS" }
        },

        FileFormat : {
            PDF : { label : i18n.pdfLabel, value : "PDF" },
            XLS : { label : i18n.xlsLabel, value : "XLS" }            
        },

        LayoutFormat : {
            PORTRAIT : { label : i18n.portraitLabel, value : "PORTRAIT" },
           LANDSCAPE : { label : i18n.landscapeLabel, value : "LANDSCAPE" }            
        },

        Module : {
            CORE : "Core",
            PLANNING_NOTIFICATION : "PlanningNotification"          
        },          
        
        ReportFileFormat : {
            PDF : { label : i18n.pdfLabel, value : "PDF" },
            PDF_LIST : { label : i18n.pdfListLabel, value : "PDF_LIST" },           
            XLS : { label : i18n.xlsLabel, value : "XLS" }            
        },
        
        SearchPageName : {
            DOCUMENT_LIST : "DocumentList",
            PLANNING_NOTIFICATION_REPORT : "ReportConfig"
        },            

        TaskSearchMode : {
              OWN : "OWN",
             OPEN : "OPEN",
             LATE : "LATE",
            BATCH : "BATCH"            
        },            

        CertificateStatus : {
            NO_CERTIFICATE : "NoCertificate",
              INVITATION : "Invitation",
                 REQUEST : "Request",
            VALID_EXPIRES_SOON : "ValidExpiresSoon",
                   VALID : "Valid",
                 EXPIRED : "Expired",
            INCONSISTENT : "Inconsistent"                   
        },
        
        OrderStepMode : {
            UNDEFINED : 0,
             ACCEPTED : 1,
             DECLINED : 2
        },
        
        ProjectAccess : {
            INVISIBLE : 0,
            READ_ONLY : 1,
            READ_WRITE : 2,
            INVISIBLE_FOR_NON_ADMIN : 3,
            READ_ONLY_FOR_NON_ADMIN : 4
        },
        
        DocumentDateHistoryModType : {
            START : 1,
              END : 2,
             BOTH : 3
        },
        
        DocumentModifiedState : {
            NOT_MODIFIED : 0,
            NEW : 1,
            DATE_MODIFIED : 2,
            CONTENT_MODIFIED : 3
        },
        
        DocumentNumberUniqueness : {
            OBJECT : "Object",
            OBJECT_PLANNER : "ObjectPlanner"
        },
        
        DocumentVersionStatus : {
                      INREVIEW : 1,
               RELEASEDPOSITIV : 2,
               RELEASEDNEGATIV : 3,
            INVALIDATEDVERSION : 4,
                INVALIDATEDALL : 5,
                   NOTINREVIEW : 6,
                       DELETED : 7,
                   PREREVIEWED : 8,
                        ACTIVE : 9,
                       ASBUILT : 10,
                   NOTUPLOADED : 11,
                      REPLACED : 12,
                       ABORTED : 13
        },
        
        ReviewCycleStatusSearchDelay : {
            NO_DELAY : 1,
            DELAY : 2,
            LONG_DELAY : 3            
        },            

        JobState : {
              SCHEDULED : 0,
                STARTED : 1,
            INTERRUPTED : 2,
               FINISHED : 3,
                 FAILED : 4
        },            

        JobType : {
            EXPORT_PDF_REPORT : 0,
            EXPORT_XLS_REPORT : 1,
            EXPORT_DOCUMENTS_TO_MSP : 2,
            EXPORT_STATUTORY_DUTY_TO_MSP : 3,
            EXPORT_DOCUMENT_ARCHIVE : 4            
        },                                                

        PlanningNotificationType : {
              UPLOADED : 0,
            REFERENCED : 1                  
        },                  

        PlotPropertyColor : {
            CHROMATICITY_MONOCHROME : 0,
            CHROMATICITY_IN_COLOR : 1,
            CHROMATICITY_LIKE_TEMPLATE : 2
        },

        ProjectStatus : {
                ACTIVE : 0,
            ARCHIVING_REQUESTED : 1,
              ARCHIVED : 2,
            DATA_FILES_DELETED : 3,
            RESTORATION_REQUESTED : 4,
              RESTORED : 5,
              INACTIVE : 6,
            UNFINISHED : 7,
            PLANNING_NOTIFICATION_PROJECT : 10
        },                           
        
        TagFormat : {
            TEXT : 0,
            DATE : 1,
            DATE_TIME : 2                    
        },                               

        // Caution: Keep in sync with at.cdes.impl.dao.unionComponent.CertificateJoinComponent
        CertificateJoinComponent : {
            CERTIFICATES : 1,
             INVITATIONS : 2,
            WITHOUT_CERTIFICATE : 3                 
        },
        
        doCorrectDates : function() {
            //                      return !sniff("trident");
            return false;
        },

        UserCategory : {
     	    OWN_USER : "OwnUser"
        },

        MagicSelectOption : {
              ALL : "___All___",
            EMPTY : "___Empty___",
            PLEASE_CHOOSE : "___PleaseChoose___"
        }        
    };
    
    return CdesVoc;
});
