/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationReportCover
////i18n-prefix = planningNotificationReportCover



define([
	"cdes/planning/report/PlanningNotificationReportDataWidget",
	"cdes/planning/report/PlanningNotificationReportStepWidget",
	"cdes/planning/util/PlanningNotificationHelper",
	"clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/WidgetHelper",
	"dijit/form/Button",
	"dijit/form/Textarea",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(
			PlanningNotificationReportDataWidget,
			PlanningNotificationReportStepWidget,             
			PlanningNotificationHelper,
			TinyLog,
			DOMHelper,
			WidgetHelper,
			Button,
			Textarea,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.report.PlanningNotificationReportCoverWidget";

	var log = new TinyLog(className);

	var PlanningNotificationReportCoverWidget = declare(className, PlanningNotificationReportStepWidget, {

		constructor : function() {
		},

		initialize : function() {
			DOMHelper.createTextNode("div", i18n.planningNotificationReportCoverCommentLabel, this.topDiv, "fixedDialogWidget planningNotificationReportCoverCommentLabel");

			this.commentTextArea = new Textarea({
				label : i18n.planningNotificationReportCoverCommentLabel,
				title : i18n.planningNotificationReportCoverCommentToolTip,
				maxLength : 255		
			});
			domClass.add(this.commentTextArea.domNode, "fixedDialogWidget planningNotificationReportCoverCommentTextArea");
			domConstruct.place(this.commentTextArea.domNode, this.topDiv);
		},

		getWidgetId : function() {
			return "PlanningNotificationReportCoverWidget";
		},

		getPageCaption : function() {
			return i18n.planningNotificationReportCoverPageCaption;
		},		

		getComment : function() {
			return this.commentTextArea.get("value");
		},		

		processNetworkChange : function() {
			// Nothing to be done here, comment doesn't depend on network		
		},		

		getStepForwardCaption : function() {
			if (this.config.options && this.config.options.reportType == "INDIVIDUAL") {
				return i18n.planningNotificationReportGotoDataCaption;
			} else {
				return i18n.planningNotificationReportDoGenerateCaption;
			}                
		},		

		getStepForwardToolTip : function() {
			if (this.config.options && this.config.options.reportType == "INDIVIDUAL") {
				return i18n.planningNotificationReportGotoDataToolTip;
			} else {
				return i18n.planningNotificationReportDoGenerateToolTip;
			}                
		},		


		getCustomButtons : function() {
			if (!this.showExportToMspButton()) {
				return [];               
			} else {
				var exportToMspButton = new Button({
					label : i18n.planningNotificationReportDataMspButtonCaption,
					title : i18n.planningNotificationReportDataMspButtonToolTip
				});
				domClass.add(exportToMspButton.domNode, "planningNotificationReportDataMspButton");
				on(exportToMspButton, "click", lang.hitch(this, function() {
					this.triggerExportReport(true);
				}));               

				return [ exportToMspButton ];
			}
		},

		showExportToMspButton : function() {
			return false; /*!(this.config != null && this.config.options && this.config.options.reportType == "INDIVIDUAL");*/
		},

		performStepForward : function(stepWidgets) {
			this.storeConfigToLocalStorage();


			if (this.config.options.reportType == "INDIVIDUAL") {
				return this.createOrReuseStepForwardWidget(stepWidgets, "PlanningNotificationReportDataWidget", lang.hitch(this, function() {
					return new PlanningNotificationReportDataWidget({
						applicationContext : this.applicationContext
					});
				}));
			} else if (this.config.options.reportType == "ALL") {
				return this.triggerExportReport(false);
			} else {
				return null;
			}                
		},        

		triggerExportReport : function(askForMsp) {
			return PlanningNotificationHelper.triggerExportReport(this.applicationContext, this, this.config, null, [], askForMsp);
		},

		setData : function(config) {
			this.config = config;

			this.reload();
		},

		reload : function() {
			this.updateWidgetsFromData();
			this.updateWidgetState();
		},

		updateWidgetsFromData : function() {
			this.commentTextArea.set("value", this.config.cover.comment);
		},	    

		updateDataFromWidgets : function() {
			this.config.cover.comment = this.commentTextArea.get("value");
		},

		updateWidgetState : function() {
			var mayStepForward = true;//(this.data != null && this.data.reportType == "INDIVIDUAL");
			var doShowExportToMspButton = this.showExportToMspButton();
			if (mayStepForward != this.mayStepForward) {
				this.mayStepForward = mayStepForward;
				on.emit(this, "mayStepChanged");                
			}

			if (doShowExportToMspButton != this.doShowExportToMspButton) {
				on.emit(this, "customButtonsChanged", this);
			}                                    
		},

		destroy : function() {
			this.inherited(arguments);
		}
	});

	PlanningNotificationReportCoverWidget.AsyncOperation = {
	};

	PlanningNotificationReportCoverWidget.getDefaultConfig = function() {
		return {
			comment : ""
		};	    
	};

	return PlanningNotificationReportCoverWidget;
});
