/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationProjectPage
////i18n-prefix = planningNotificationProjectPage


define([ "cdes/core/CdesVoc",
	"cdes/planning/project/PlanningNotificationProjectListWidget",
	"cdes/util/ActionHelper",
	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",	 
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			PlanningNotificationProjectListWidget,
			ActionHelper,
			ContextBar,
			TinyLog,
			topic,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			Button,
			domClass,
			domConstruct,
			domStyle,
			on,		
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.project.PlanningNotificationProjectPage";

	var log = new TinyLog(className);

	var PlanningNotificationProjectPage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			
			this.reload();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationProjectPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			topic.subscribe("context/change", lang.hitch(this, function() {
				this.reload();
			}));

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			// List Widget
			this.listWidget = new PlanningNotificationProjectListWidget({
				applicationContext : this.applicationContext,
				backPage : "planningNotificationProjectList",
				backParams : new Object()
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domConstruct.place(this.listWidgetDiv, topDiv);

			// Reload data after certain operations which change state have been performed
			on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

            this.listWidget.restoreColumnWidths();

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationProjectPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			return captionBarDiv;
		},

		constructNewButton : function() {
			// New Button     		
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			if (ActionHelper.hasActionsForNetwork(this.networkIdToActions, networkId, ["insertPlanningNotificationProject"])) {
				this.newButton = new Button({
					label : i18n.projectPageNewLabel,
					title : i18n.planningNotificationProjectPageNewToolTip
				});
				domClass.add(this.newButton.domNode, "fixedDialogWidget planningNotificationTemplatePageNewButton");
				domConstruct.place(this.newButton.domNode, this.captionBarDiv);

				on(this.newButton, "click", lang.hitch(this, function() {
					this.applicationContext.setPage("projectEdit",
							{ mode : ContentWidget.Mode.CREATE, module : CdesVoc.Module.PLANNING_NOTIFICATION },
							{ backPage : "planningNotificationProjectList", backParams : new Object() });
				}));
			}		


			return this.captionBarDiv;
		},

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationProjectPageContentDiv");

			return contentDiv;
		},

		resize : function(newSize) {
			if (newSize) {
				this.lastNewSize = newSize;
			}

			var totalHeight = this.lastNewSize.h;    		

			var tableHeight = totalHeight
			//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			//	- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
			//	- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
			// 	- this.statusBarDiv.offsetHeight
			- 16;
			this.listWidget.resize({ h : tableHeight });
		},

		setData : function() {

		},

		reload : function() {
			if (log.isDebugEnabled()) {
				log.debug("Started PlanningNotificationProjectPage.reload, about to call contextBar.reload()");	    
			}		


			//this.contextBar.reload();
			this.listWidget.setData({ projects : [] });

			var networkId = this.applicationContext.getPageContextPnNetworkId();

			if (log.isDebugEnabled()) {
				log.debug("About to call getPlanningNotificationProjects with networkId = [" + networkId + "]");
			}

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

			this.registerAsyncOperationStarted(PlanningNotificationProjectPage.AsyncOperation.LOAD_DATA);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getPlanningNotificationProjects(organisationPersonId, networkId).then(
					lang.hitch(this, function(projectInfo) {
						this.registerAsyncOperationFinished(PlanningNotificationProjectPage.AsyncOperation.LOAD_DATA);

						var projects = projectInfo.projects;
						var projectIdToAllowedActions = projectInfo.projectIdToAllowedActions;
						this.networkIdToActions = new Object();
						for (var networkId in projectInfo.networkIdToActions) {
							var actions = projectInfo.networkIdToActions[networkId];
							var actionSet = new Object();
							for (var n = 0; actions && n < actions.length; n++) {
								actionSet[actions[n]] = true;
							}
							this.networkIdToActions[networkId] = actionSet;			    
						}			

						if (this.newButton == null) {			
							this.constructNewButton();
						}			

						if (log.isDebugEnabled()) {
							log.debug("... Successfully loaded [" + projects.length + "] projects, for network = [" + networkId + "]");
						}

						this.listWidget.setData({ 
							projects : projects,
							projectIdToAllowedActions : projectIdToAllowedActions,
							actionsForNetwork : networkId in this.networkIdToActions ? this.networkIdToActions[networkId] : null
						});

						var message = string.substitute(i18n.planningNotificationProjectSearchSuccessful, {
							count : projects.length
						});
						topic.publish("message/ok", message);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationProjectPage.AsyncOperation.LOAD_DATA,
							opName : "getPlanningNotificationProjects",
							message : i18n.planningNotificationProjectPageGetProjectsFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationProjects]", err);
							}));
		},

		updateWidgetState : function() {

		},

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationProjectPage.AsyncOperation = {
			LOAD_DATA : "LoadData"	
	};

	return PlanningNotificationProjectPage;
});
