/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */
define(["dojo/string",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"], function(dojoString, i18n) {

    return {
        validateAnswer: function(answer, minLength) {
            if (answer == null || answer.trim().length <= 0) {
                return "MISSING";
            }

            if (answer.length < minLength) {
                return "TOO_SHORT";
            }

            var hasIllegalChars = answer.match(/[^A-Za-z0-9\.\-\_\/\\\!\?\,\:\(\)\[\]\{\}öÖäÄüÜß\%\§\$\&\€]/);
            if (hasIllegalChars) {
                return "INVALID_CHARACTERS";
            }

            return "OK";
        },

        getAnswerMessage: function(error, securityAnswerMinLength) {
            switch (error) {
                case "MISSING":
                return i18n.securityQuestionAnswerMissing;
                case "TOO_SHORT":
                return dojoString.substitute(i18n.securityQuestionAnswerTooShort, {
                   minLength : securityAnswerMinLength
                });
                case "INVALID_CHARACTERS":
                return i18n.securityQuestionAnswerInvalidCharacters;
                case "OK":
                throw new Error("Cannot call getAnswerMessage with none.");
            }
        },
    };
});
