/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

//// css-prefix = mspProjectChoose
//// i18n-prefix = mspProjectChoose

         
         
define([ 
	 "clazzes/TinyLog",
         "clazzes/dateTime/DateHelper",
         "clazzes/dateTime/FancyDate",
    "clazzes/dgrid/ItemChooseWidget",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ChooseDialog",
    "clazzes/widgets/layout/ContentWidget",
    "dojo/dom-class",
	 "dojo/dom-construct",
	 "dojo/dom-style",
	 "dojo/on",
	 "dojo/_base/declare",
	 "dojo/_base/lang",	 
	 "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
       function(
		TinyLog,
                DateHelper,
		FancyDate,
           ItemChooseWidget,
           ErrorHelper,
           ChooseDialog,                
           ContentWidget,
	   domClass,
		domConstruct,
		domStyle,
		on,
		declare,
		lang,		
		i18n) {

    var className = "at.cdes.web.widget.msp.MspProjectChooseDialog";

    var log = new TinyLog(className);

        var MspProjectChooseDialog = declare(className, [ChooseDialog, ContentWidget], {

	    constructChooseWidget : function() {
	    // summary:
	    //     Constructs the widget in which the user chooses some piece of data.
	    // description:
	    //     That widget must be saved in the variable this.content, and will 
	    //     subsequently be placed in the dialog by superclass code.
	    //     If some value is chosen by the user in that widget (e.g. a choosable 
	    //     tree node is clicked), the subclass must call setChosenValue.  
	    //     Optionally, after doing so, the subclass may emit the valueChosen 
	    //     event, and close the dialog (e.g. on a double click into the tree).

            // Set up widgets
            var columns = [];
            columns.push({
                    field : "title",
                       id : "title",                
                  sortable : true,
                     label : i18n.mspProjectChooseProjectCaption
            });                

		    this.itemChooseWidget = new ItemChooseWidget({
					applicationContext : this.applicationContext,
					     selectionMode : "single",
		                    idProperty : "id",                
		                       columns : columns
		    });		
		    on(this.itemChooseWidget, "selectionChanged", lang.hitch(this, function(mspItems) {
				this.mspItem = mspItems != null && mspItems.length > 0 ? mspItems[0] : null;
				this.updateWidgetState();		
		    }));		
            this.content = this.itemChooseWidget.getContainer();

            // Populate grid
            var mspService = this.applicationContext.getService("mspService");
            this.registerAsyncOperationStarted(MspProjectChooseDialog.AsyncOperation.GET_PROJECTS);
            mspService.getProjects().then(
                lang.hitch(this, function(mspProjectItems) {
                    this.registerAsyncOperationFinished(MspProjectChooseDialog.AsyncOperation.GET_PROJECTS);

                    mspProjectItems.sort(function(itemOne, itemTwo) {
                        var titleOne = itemOne.title != null ? itemOne.title : "";
                        var titleTwo = itemTwo.title != null ? itemTwo.title : "";
                        return titleOne.localeCompare(titleTwo);
                    });                        

                    this.itemChooseWidget.setData(mspProjectItems);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : MspProjectChooseDialog.AsyncOperation.GET_PROJECTS,
                                opName : "getProjects",
                               message : i18n.mspProjectChooseGetProjectsFailed
                    });
                })
            ).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Error while calling function [getProjects]", err);
                }));                    
        },

		updateWidgetState : function() {
            // Button is constructed in ChooseDialog.show, call to constructWidgets,
            // however updateWidgetState might be called from ChooseDialog.show, call
            // to constructChooseWidget in the line above the constructWidgets call...            
            if (this.selectButton != null) {
                this.selectButton.set("disabled", this.asyncOperationRunning);
            }
		},	    

		emitValueChosen : function(buttonName) {
	            on.emit(this, "valueChosen", this.mspItem);
		},

        destroy : function() {
            this.inherited(arguments);
	    	this.itemChooseWidget.destroy();
        }
    });

    MspProjectChooseDialog.AsyncOperation = {
        GET_PROJECTS : "GetProjects"        
    };                        

    return MspProjectChooseDialog;
});

