define([
        "cdes/core/CdesVoc",
        "clazzes/TinyLog",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		CdesVoc,
    		TinyLog,
    		i18n
    		) {
	
	var className = "at.cdes.web.util.StyleHelper";
	
	var log = new TinyLog(className);
	
    var StyleHelper = {
    		
    	getDocumentVersionStatusCSS : function(joinDto) {
    		if (   joinDto.objectPlannerInactive != null && joinDto.objectPlannerInactive != 0
    		    && joinDto.documentVersionStatus != null && joinDto.documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
    			return "documentVersionStatusUInactive";
    		} else if (joinDto.documentVersionStatus != null && (   joinDto.documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
    														     || joinDto.documentVersionStatus == CdesVoc.DocumentVersionStatus.DELETED)) {
    			return "documentVersionStatusX";
    		} else if (joinDto.documentVersionStatus != null && joinDto.documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
    			return "documentVersionStatusU";
    		} else {
    			return "";
    		}
    	}
    };
    return StyleHelper;
});