define([
        "cdes/widget/choose/ItemChooseDialog",
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/StringHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/InfoDialog",
        "dojo/dom-attr",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/string",
        "dojo/topic",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         ItemChooseDialog,
         TinyLog,
         DOMHelper,
         ErrorHelper,
         StringHelper,
         ChooseDialog,
         InfoDialog,
         domAttr,
         domClass,
         domConstruct,
         on,
         string,
         topic,
         lang,
         i18n
         ) {
    
    var className = "at.cdes.web.organisation.OrganisationHelper";
    
    var log = new TinyLog(className);
    
    var OrganisationHelper = {
    
        constructOrganisationPersonTable : function(params) {
            var unitName = params.unitName;
            var postalAddress = params.postalAddress;
            var postalCode = params.postalCode;
            var localityName = params.localityName;
            var countryDescDe = params.countryDescDe;
            var mail = params.mail;
            var phone = params.phone;
            var mobile = params.mobile;
            var fax = params.fax;

            var phoneTable = domConstruct.create("table", null, null);

            if (postalAddress != null && postalAddress.length > 0){
                if (unitName != null && unitName.length > 0) {
	            	var unitNameRow = domConstruct.create("tr", null, phoneTable);
		            DOMHelper.createTextNode("td", i18n.personListUnit, unitNameRow, "personListPhonePrefix phoneLineItem");
		            DOMHelper.createTextNode("td", unitName, unitNameRow, "phoneLineItem");
                }
            	var postalAddressRow = domConstruct.create("tr", null, phoneTable);
	            DOMHelper.createTextNode("td", "", postalAddressRow, "personListPhonePrefix phoneLineItem");
	            //DOMHelper.createTextNode("td", postalAddress, postalAddressRow, "phoneLineItem");
                var addressCell = domConstruct.create("td", null, postalAddressRow);
                domClass.add(addressCell, "phoneLineItem");
	            if (postalAddress!=null) {
		            var tokens = postalAddress.split("\n");
		            for (var n = 0; n < tokens.length; n++) {
		                var token = tokens[n];
						DOMHelper.createTextNode("div", token, addressCell, null);
					}
		        }
	            var postalCodeRow = domConstruct.create("tr", null, phoneTable);
	            DOMHelper.createTextNode("td", "", postalCodeRow, "personListPhonePrefix phoneLineItem");
	            DOMHelper.createTextNode("td", postalCode + " " + localityName, postalCodeRow, "phoneLineItem");
	            
	            var countryDescDeRow = domConstruct.create("tr", null, phoneTable);
	            DOMHelper.createTextNode("td", "", countryDescDeRow, "personListPhonePrefix phoneLineItem");
	            DOMHelper.createTextNode("td", countryDescDe, countryDescDeRow, "phoneLineItem");
        	}

            var mailRow = domConstruct.create("tr", null, phoneTable);
            var phoneRow = domConstruct.create("tr", null, phoneTable);
            var mobileRow = domConstruct.create("tr", null, phoneTable);
            var faxRow = domConstruct.create("tr", null, phoneTable);

            DOMHelper.createTextNode("td", i18n.personListEmailPrefix, mailRow, "personListPhonePrefix phoneLineItem");
            var link = domConstruct.create("a", null, null);
            domClass.add(link, "personListMailLink phoneLineItem");
            domAttr.set(link, "href", "mailto:" + mail);
            DOMHelper.setInnerText(link, mail);
            domConstruct.place(link, mailRow);

            DOMHelper.createTextNode("td", i18n.personListPhonePrefix, phoneRow, "personListPhonePrefix phoneLineItem");
            DOMHelper.createTextNode("td", phone, phoneRow, "phoneLineItem");

            DOMHelper.createTextNode("td", i18n.personListMobilePrefix, mobileRow, "personListPhonePrefix phoneLineItem");
            DOMHelper.createTextNode("td", mobile, mobileRow, "phoneLineItem");

            DOMHelper.createTextNode("td", i18n.personListFaxPrefix, faxRow, "personListPhonePrefix phoneLineItem");
            DOMHelper.createTextNode("td", fax, faxRow, "phoneLineItem");

            return phoneTable;
        },

        organisationAddressFormatter : function(organisationId, organisationJoin) {
        	var postalAddress_org = StringHelper.getNonNullString(organisationJoin.organisationPostalAddress);
            var postalAddress = OrganisationHelper.renderLineBreak(postalAddress_org);
            var postalCode = StringHelper.getNonNullString(organisationJoin.organisationPostalCode);
            var localityName = StringHelper.getNonNullString(organisationJoin.organisationLocalityName);
            var country = StringHelper.getNonNullString(organisationJoin.countryDescDe);

            return postalAddress + "<br>" + postalCode + " " + localityName + "<br>" + country;
        },

        getOrganisationAddressString : function(organisationJoin) {
            var postalAddress = StringHelper.getNonNullString(organisationJoin.organisationPostalAddress).trim();
            var postalCode = StringHelper.getNonNullString(organisationJoin.organisationPostalCode).trim();
            var localityName = StringHelper.getNonNullString(organisationJoin.organisationLocalityName).trim();
            var country = StringHelper.getNonNullString(organisationJoin.countryDescDe).trim();

            return postalAddress + " " + postalCode + " " + localityName + " " + country;
        },

        hasOrganisationInfoContextNetwork : function(applicationContext, organisationInfo) {
            var found = false;
            var contextNetworkId = applicationContext.getPageContextNetworkId();
            var networks = organisationInfo.networks;
            for (var n = 0; n < networks.length; n++) {
                var network = networks[n];
                found |= (network.id == contextNetworkId);
            }
            return found;
        },

        mergeOrganisationInfosIntoJoins : function(organisationInfos) {
            var organisationJoins = [];
            for (var n = 0; n < organisationInfos.length; n++) {
                var organisationInfo = organisationInfos[n];
                var organisationJoin = organisationInfo.organisationJoin;
                organisationJoin.networks = organisationInfo.networks;
                organisationJoin.memberInfos = organisationInfo.memberInfos;
                organisationJoin.organisationPersonJoins = organisationInfo.organisationPersonJoins;
                organisationJoin.actions = organisationInfo.actions;
                organisationJoins.push(organisationJoin);
            }
            return organisationJoins;
        },

        getOrganisationInfoByMergedJoin : function(organisationJoin) {
            var organisationInfo = {
                organisationJoin : organisationJoin,
                networks : organisationJoin.networks,
                memberInfos : organisationJoin.memberInfos,
                organisationPersonJoins : organisationJoin.organisationPersonJoins,
                actions : organisationJoin.actions
            };
            return organisationInfo;
        },

        askAddOrganisationToAdminNetwork : function(params) {
            var applicationContext = params.applicationContext;
            var administratedNetworks = params.administratedNetworks;
            var organisationJoin = params.organisationJoin;
            var widget = params.widget;                        

            if (administratedNetworks.length == 1) {
                OrganisationHelper.askAddOrganisationToNetwork(params, administratedNetworks[0]);
            } else if (administratedNetworks.length > 1) {
                OrganisationHelper.chooseNetworkAndReferenceOrganisation(params);
            }            
        },        

        chooseNetworkAndReferenceOrganisation : function(params) {
            var applicationContext = params.applicationContext;
            var administratedNetworks = params.administratedNetworks;
            var organisationJoin = params.organisationJoin;
            var widget = params.widget;                        
            administratedNetworks.sort(function(networkOne, networkTwo) {
                var nameOne = networkOne.name != null ? networkOne.name : "";
                var nameTwo = networkTwo.name != null ? networkTwo.name : "";
                return nameOne.localeCompare(nameTwo);
            });

            var columns = [];
            columns.push({
                   field : "name",
                      id : "name",
                sortable : true,
                   label : i18n.nameLabel
            });

            var chooseDialog = new ItemChooseDialog({
                applicationContext : applicationContext,
                             title : i18n.organisationPageChooseNetworkCaption,
                           columns : columns,
                     selectionMode : "extended",
                        idProperty : "id",
                           buttons : [ 
                                      { type : ChooseDialog.Button.CHOOSE,
                                          name : "selectButton"
                                      },
                                      { type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip }
                           ],
                      defaultWidth : 500,
                     defaultHeight : 200,
                             items : administratedNetworks
            });
            on(chooseDialog, "valueChosen", lang.hitch(this, function(networks) {
                OrganisationHelper.addOrganisationToNetwork({
                    applicationContext : applicationContext,
                      organisationJoin : organisationJoin,
                              networks : networks,
                                widget : widget
                });
            }));
            chooseDialog.show(null);            
        },

        askAddOrganisationToContextNetwork : function(params) {            
            var applicationContext = params.applicationContext;
            var contextNetwork = applicationContext.getPageContextNetwork();
            OrganisationHelper.askAddOrganisationToNetwork(params, contextNetwork);
        },

        askAddOrganisationToNetwork : function(params, network) {
            var organisationJoin = params.organisationJoin;
            var widget = params.widget;
            
            var question = string.substitute(i18n.organisationListAskAddToNetworkQuestion, {
                organisationName : organisationJoin.organisationName,
                     networkName : network.name
            });

            InfoDialog.showQuestion({
                  title : i18n.organisationListAskAddToNetworkCaption,
                message : question,
                buttons : [
                           { type : InfoDialog.Button.YES, fct : lang.hitch(widget, function() {
                               params.networks = [ network ];
                               OrganisationHelper.addOrganisationToNetwork(params);
                           })},                           
                           { type : InfoDialog.Button.NO }
                ]
            });            
        },

        addOrganisationToNetwork : function(params) {
            var applicationContext = params.applicationContext;
            var organisationJoin = params.organisationJoin;
            var networks = params.networks;
            var widget = params.widget;
            
            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();

            widget.registerAsyncOperationStarted(OrganisationHelper.AsyncOperation.ADD_TO_NETWORK);

            var networkIds = [];
            for (var n = 0; n < networks.length; n++) {
                var network = networks[n];
                networkIds.push(network.id);
            }

            var organisationService = applicationContext.getService("organisationService");
            organisationService.addOrganisationToNetworks(organisationPersonId, organisationJoin.organisationId, networkIds).then(
                lang.hitch(widget, function(result) {
                    widget.registerAsyncOperationFinished(OrganisationHelper.AsyncOperation.ADD_TO_NETWORK);

                    var networkNamesString = "";
                    for (var z = 0; z < networks.length; z++) {
                        networkNamesString += ((z > 0 ? ", " : "") + networks[z].name);
                    }

                    var successMessage = string.substitute(i18n.organisationListWidgetAddOrganisationToNetworkSuccess, {
                        organisationName : organisationJoin.organisationName,
                            networkNames : networkNamesString
                    });
                    topic.publish("message/ok", successMessage);
                    on.emit(this, "doSearch");
                }), lang.hitch(widget, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : widget,
                        asyncOperation : OrganisationHelper.AsyncOperation.ADD_TO_NETWORK,
                                opName : "addOrganisationToNetwork",
                               message : i18n.organisationListWidgetAddOrganisationToNetworkFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [addOrganisationToNetwork]", err);
                    }));
        },        

        renderLineBreak : function(data) {
            if ((typeof data === 'string' || data instanceof String) && data != null && data.length > 0 && data.indexOf("\n") != -1){
            	//data = data.replace("\n/g", "<br>"); doesn't work
			    while (data.indexOf("\n") != -1)
			        data = data.replace("\n", "<br>");
        	}
            //var node = domConstruct.create("span", { innerHTML : data!=null?data:"" }, null);
            return data;
        }             
    };

    OrganisationHelper.AsyncOperation = {
        ADD_TO_NETWORK : "AddToNetwork"
    };
    
    return OrganisationHelper;
});
