define([ 
        "cdes/core/DataModel",
        "cdes/util/NameHelper",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateTimeSpinBox",
        "clazzes/form/FancyComboBox",
        "clazzes/form/FancyComboBoxMenu",
        "clazzes/util/DOMHelper",
        "clazzes/util/JoinHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/Button",
        "dijit/form/RadioButton",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/store/Memory",
        "dojox/uuid/generateTimeBasedUuid",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         DataModel,
         NameHelper,
         TinyLog,
         DateTimeSpinBox,
         FancyComboBox,
         FancyComboBoxMenu,
         DOMHelper,
         JoinHelper,
         WidgetHelper,
         ContentWidget,
         Button,
         RadioButton,
         Select,
         TextBox,
         domClass,
         domConstruct,
         on,
         declare,
         lang,
         Memory,
         generateTimeBasedUuid,
         i18n
         ) {
    

    var className = "at.cdes.web.person.PersonEditWidget";

    var log = new TinyLog(className);
    
    var PersonEditWidget = declare(className, ContentWidget, {
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.topDiv = this.constructTopDiv();
            
            this.allFieldsValid = true;
            this.updateWidgetState();
        },
        
        getWidgetId : function() {
            return "PersonEditWidget";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute personEditTopDiv");
            
            // Generating a unique name for the button group, to avoid problems if the widget is ever inserted multiple times into the same application
            var uuid = generateTimeBasedUuid();
            
            // Gender
            DOMHelper.createTextNode("div", i18n.personEditGenderLabel, topDiv, "propertyLabel personEditGenderLabel");
            
            var options = [ { label : i18n.personEditMaleLabel,    value : "m" },
                           { label : i18n.personEditFemaleLabel,  value : "f" },
                           { label : i18n.unknownGender, value : "-" }
            ];
            this.genderSelect = new Select({
                  label : i18n.personEditGenderLabel,
                  title : i18n.personEditGenderToolTip,
                options : options
            });
            domClass.add(this.genderSelect.domNode, "fixedDialogWidget personEditGenderSelect");
            domConstruct.place(this.genderSelect.domNode, topDiv);                  
            WidgetHelper.handleSelectEvents(this.genderSelect, lang.hitch(this, this.updateWidgetState));
            
            /*              
            // Male Radio Button
            this.maleRadioButton = new RadioButton({
            name : "PersonGender_" + uuid,
            label : i18n.personEditMaleLabel,
            title : i18n.personEditMaleToolTip
        });
            domClass.add(this.maleRadioButton.domNode, "fixedDialogWidget personEditMaleRadioButton");
            domConstruct.place(this.maleRadioButton.domNode, topDiv);
            //WidgetHelper.onRadioButtonGUIChange(this.maleRadioButton, lang.hitch(this, this.onModeRadioButtonsChanged));
            DOMHelper.createTextNode("div", i18n.personEditMaleLabel, topDiv, "fixedDialogWidget personEditMaleLabel");
            
            // Female Radio Button
            this.femaleRadioButton = new RadioButton({
            name : "PersonGender_" + uuid,
            label : i18n.personEditFemaleLabel,
            title : i18n.personEditFemaleToolTip
        });
            domClass.add(this.femaleRadioButton.domNode, "fixedDialogWidget personEditFemaleRadioButton");
            domConstruct.place(this.femaleRadioButton.domNode, topDiv);
            //WidgetHelper.onRadioButtonGUIChange(this.femaleRadioButton, lang.hitch(this, this.onModeRadioButtonsChanged));
            DOMHelper.createTextNode("div", i18n.personEditFemaleLabel, topDiv, "fixedDialogWidget personEditFemaleLabel");
            */              
            // Title
            DOMHelper.createTextNode("div", i18n.personEditTitleLabel, topDiv, "propertyLabel personEditTitleLabel");
            this.personTitleTextBox = new TextBox({
                			label : i18n.personEditTitleLabel,
                			title : i18n.personEditTitleToolTip,
                		maxLength : 30
            });
            domClass.add(this.personTitleTextBox.domNode, "fixedDialogWidget personEditTitleTextBox");              
            WidgetHelper.handleTextBoxEvents(this.personTitleTextBox, lang.hitch(this, this.updateWidgetState));
            domConstruct.place(this.personTitleTextBox.domNode, topDiv);
            
            // Givenname
            DOMHelper.createTextNode("div", i18n.personEditGivenNameLabel, topDiv, "propertyLabel personEditGivenNameLabel");
            this.personGivenNameComboBox = new FancyComboBox({
                            label : i18n.personEditGivenNameLabel,
                            title : i18n.personEditGivenNameToolTip,
		        		queryExpr : "*${0}*",
	     			 autoComplete : false,
		    		dropDownClass : FancyComboBoxMenu,
                menuItemClassName : "personEditNameComboBoxMenuItem",
                		maxLength : 30
            });
            domClass.add(this.personGivenNameComboBox.domNode, "fixedDialogWidget personEditGivenNameTextBox");              
            domConstruct.place(this.personGivenNameComboBox.domNode, topDiv);
            WidgetHelper.handleComboBoxEvents(this.personGivenNameComboBox, lang.hitch(this, function() {
                if (this.personGivenNameComboBox.item != null && this.personGivenNameComboBox.item.id != null) {
                    var selectedPersonId = this.personGivenNameComboBox.item.id;
                    var selectedPerson = this.idToPerson[selectedPersonId];
                    if (selectedPerson != null) {
                        this.personGivenNameComboBox.set("value", selectedPerson.givenName);
                        this.personSurNameComboBox.set("value", selectedPerson.surName);
                        this.personGivenNameComboBox.item = null;
                    }
                }
                this.updateWidgetState();
            }));
            WidgetHelper.setMustField(this.personGivenNameComboBox, true);
            
            // Surname
            DOMHelper.createTextNode("div", i18n.personEditSurNameLabel, topDiv, "propertyLabel personEditSurNameLabel");
            this.personSurNameComboBox = new FancyComboBox({
                            label : i18n.personEditSurNameLabel,
                            title : i18n.personEditSurNameToolTip,
		        		queryExpr : "*${0}*",
		     		 autoComplete : false,
		    		dropDownClass : FancyComboBoxMenu,
                menuItemClassName : "personEditNameComboBoxMenuItem",
                		maxLength : 30
            });
            domClass.add(this.personSurNameComboBox.domNode, "fixedDialogWidget personEditSurNameTextBox");                  
            domConstruct.place(this.personSurNameComboBox.domNode, topDiv);
            WidgetHelper.handleComboBoxEvents(this.personSurNameComboBox, lang.hitch(this, function() {
                if (this.personSurNameComboBox.item != null && this.personSurNameComboBox.item.id != null) {
                    var selectedPersonId = this.personSurNameComboBox.item.id;
                    var selectedPerson = this.idToPerson[selectedPersonId];
                    if (selectedPerson != null) {
                        this.personGivenNameComboBox.set("value", selectedPerson.givenName);
                        this.personSurNameComboBox.set("value", selectedPerson.surName);
                        this.personSurNameComboBox.item = null;
                    }
                }
                this.updateWidgetState();
            }));
            WidgetHelper.setMustField(this.personSurNameComboBox, true);
            
            // Login
            DOMHelper.createTextNode("div", i18n.personEditLoginLabel, topDiv, "propertyLabel personEditLoginLabel invisible");
            this.personLoginTextBox = new TextBox({
                   label : i18n.personEditLoginLabel,
                   title : i18n.personEditLoginToolTip,
                disabled : true
            });
            domClass.add(this.personLoginTextBox.domNode, "fixedDialogWidget personEditLoginTextBox invisible");              
            domConstruct.place(this.personLoginTextBox.domNode, topDiv);
            
            // ZT Permission
            DOMHelper.createTextNode("div", i18n.personEditZTPermissionLabel, topDiv, "propertyLabel personEditZTPermissionLabel");
            
            var options = [ { label : i18n.yes, value : "y" },
                           { label : i18n.no,  value : "n" } 
            ];
            this.ztPermissionSelect = new Select({
                  label : i18n.personEditZTPermissionLabel,
                  title : i18n.personEditZTPermissionToolTip,
                options : options
            });
            domClass.add(this.ztPermissionSelect.domNode, "fixedDialogWidget personEditZTPermissionSelect");
            domConstruct.place(this.ztPermissionSelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.ztPermissionSelect, lang.hitch(this, this.updateWidgetState));

            // UserLocale
            //check if configuration permits selection of the user locale (this.enableLocaleSelection)
            DOMHelper.createTextNode("div", i18n.personEditUserLocaleLabel, topDiv, "propertyLabel personEditUserLocaleLabel");
            var userLocaleOptions = [{ label : i18n.german,   value : "de" },
                                     { label : i18n.english,  value : "en" },
                                     { label : i18n.slovene,  value : "sl" }/*,
                                     { label : i18n.italian,  value : "it" }*/
            ];
            this.userLocaleSelect = new Select({
                  label : i18n.personEditUserLocaleLabel,
                  title : i18n.personEditUserLocaleToolTip,
                options : userLocaleOptions
            });
            domClass.add(this.userLocaleSelect.domNode, "fixedDialogWidget personEditUserLocaleSelect");
            domConstruct.place(this.userLocaleSelect.domNode, topDiv);
            WidgetHelper.setMustField(this.userLocaleSelect, true);
            WidgetHelper.handleSelectEvents(this.userLocaleSelect, lang.hitch(this, this.updateWidgetState));
            
            // Role
            DOMHelper.createTextNode("div", i18n.personEditRoleLabel, topDiv, "propertyLabel personEditRoleLabel");
            
            var options = [ 
            ];
            this.roleSelect = new Select({
                  label : i18n.personEditRoleLabel,
                  title : i18n.personEditRoleToolTip,
                options : options
            });
            domClass.add(this.roleSelect.domNode, "fixedDialogWidget personEditRoleSelect");
            domConstruct.place(this.roleSelect.domNode, topDiv);                    
            WidgetHelper.handleSelectEvents(this.roleSelect, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.setMustField(this.roleSelect, true);
            
            return topDiv;
        },
        
        updateWidgetState : function() {
            this.updateDataFromWidgets();

            WidgetHelper.updateEmptyTextBoxState(this.personGivenNameComboBox);
            WidgetHelper.updateEmptyComboBoxState(this.personSurNameComboBox);
            WidgetHelper.updateEmptySelectState(this.roleSelect);
            WidgetHelper.updateEmptySelectState(this.userLocaleSelect);

            var disabled = this.isAsyncOperationRunning() || this.mode == ContentWidget.Mode.SHOW;
            this.genderSelect.set("disabled", disabled);
            this.personTitleTextBox.set("disabled", disabled);
            this.ztPermissionSelect.set("disabled", disabled);
            this.personGivenNameComboBox.set("disabled", disabled);
            this.personSurNameComboBox.set("disabled", disabled);
            this.roleSelect.set("disabled", disabled || !this.hasRolesGlobalOverview);
            this.userLocaleSelect.set("disabled", disabled || !this.enableLocaleSelection);

            var givenNameValid = WidgetHelper.isTextBoxValid(this.personGivenNameComboBox);
            var surNameValid = WidgetHelper.isTextBoxValid(this.personSurNameComboBox);
            var roleValid = WidgetHelper.getSelectValue(this.roleSelect) != null;
            var userLocaleValid = WidgetHelper.getSelectValue(this.userLocaleSelect) != null;

            var allFieldsValid = givenNameValid && surNameValid && roleValid;

            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;
                on.emit(this, "validStateChange");
            }

            var changed = JoinHelper.isChanged(this.oldPerson, this.person, DataModel.PERSON_ATTRIBUTES);
            changed |= this.personVariables != null && (this.oldUserLocale != this.personVariables.userLocale);
            
            if (changed != this.changed) {
                this.changed = changed;
                on.emit(this, "changedStateChange");
            }
        },

        constructGivenNameMemory : function(persons) {
            var data = [];
            if (persons) {
                for (var n = 0; n < persons.length; n++) {
                    data.push({
                        name : NameHelper.getPersonCommonName(persons[n]),
                          id : persons[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            return new Memory({
                data : data
            });            
        },

        constructSurNameMemory : function(persons) {
            var data = [];
            if (persons) {
                for (var n = 0; n < persons.length; n++) {
                    data.push({
                        name : NameHelper.getPersonCommonName(persons[n]),
                          id : persons[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            return new Memory({
                data : data
            });
        },

        setPersons : function(persons) {
            this.idToPerson = new Object();
            for (var n = 0; n < persons.length; n++) {
                var person = persons[n];
                this.idToPerson[person.id] = person;
            }
            
            var givenNameMemory = this.constructGivenNameMemory(persons);
            this.personGivenNameComboBox.set("store", givenNameMemory);
            var surNameMemory = this.constructSurNameMemory(persons);
            this.personSurNameComboBox.set("store", surNameMemory);
        },

        setData : function(personEditInfo) {
            this.person = personEditInfo.person;
            this.personVariables = personEditInfo.personVariables;
            this.oldPerson = JoinHelper.clone(this.person, DataModel.PERSON_ATTRIBUTES);
            this.oldUserLocale = this.personVariables.userLocale;
            this.organisationPersonJoins = personEditInfo.organisationPersonJoins;
            this.availableRoles = personEditInfo.availableRoles;
            this.hasRolesGlobalOverview = personEditInfo.hasRolesGlobalOverview;
            this.enableLocaleSelection = personEditInfo.enableLocaleSelection;

            this.reload();
        },
        
        reload : function() {
            if (this.person != null && this.person.id != null) {
                if (this.person.gender == "m" || this.person.gender == "f") {
                    this.genderSelect.set("value", this.person.gender);     
                } else {
                    this.genderSelect.set("value", "-");
                }                       

                this.personTitleTextBox.set("value", this.person.title);
                this.personGivenNameComboBox.set("value", this.person.givenName);
                this.personSurNameComboBox.set("value", this.person.surName);
                this.personLoginTextBox.set("value", this.person.login);
                this.userLocaleSelect.set("value", this.personVariables.userLocale);
                
                this.ztPermissionSelect.set("value", this.person.ztPermission ? "y" : "n");
            } else {
                this.ztPermissionSelect.set("value", "n");
            }

            this.updateRoleSelect();
            this.updateWidgetState();
        },

        updateRoleSelect : function() {
            if (this.availableRoles && !this.rolesAlreadySet) {
                var options = [];
                var defaultRoleId = null;
                for (var n = 0; n < this.availableRoles.length; n++) {
                    var role = this.availableRoles[n];
                    var id = role.id;
                    var name = role.name;
                    options.push({ label : name, value : id });

                    if (role.contextDefaultRoleFlag) {
                        defaultRoleId = id;
                    }
                }
                this.roleSelect.set("options", options);

                if (this.person == null || this.person.id == null) {
                    WidgetHelper.setSelectValue(this.roleSelect, defaultRoleId);
                } else {
                    WidgetHelper.setSelectValue(this.roleSelect, this.person.roleId);
                }

                this.rolesAlreadySet = true;
            }
        },

        updateDataFromWidgets : function() {
            if (this.person != null) {
                this.person.gender = WidgetHelper.getSelectValue(this.genderSelect);
                this.person.title = this.personTitleTextBox.get("value");
                this.person.givenName = this.personGivenNameComboBox.get("value");
                this.person.surName = this.personSurNameComboBox.get("value");
                var ztPermissionValue = WidgetHelper.getSelectValue(this.ztPermissionSelect);
                this.person.ztPermission = ztPermissionValue == "y";
                this.person.roleId = WidgetHelper.getSelectValue(this.roleSelect);

                this.personVariables.userLocale = WidgetHelper.getSelectValue(this.userLocaleSelect);
            }
        }
    });
    
    return PersonEditWidget;
});
