define([ 
         "cdes/plot/PlotOrderEditWidget",
         "cdes/widget/ContextBar",
         "clazzes/TinyLog",
         "clazzes/LoginGuardXhr",
         "clazzes/util/DataHelper",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/DisableButton",
         "clazzes/widgets/layout/InfoDialog",
         "dijit/form/Button",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/io-query",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 PlotOrderEditWidget,
    		 ContextBar,
    		 TinyLog,
    		 LoginGuardXhr,
    		 DataHelper,
    		 DOMHelper,
             ErrorHelper,
    		 ContentWidget,
    		 DisableButton,
             InfoDialog,
    		 Button,
    		 domClass,
    		 domConstruct,
    		 domStyle,
    		 ioQuery,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plot.PlotOrderEditPage";

	var log = new TinyLog(className);
	
    var PlotOrderEditPage = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
			this.updateWidgetState();
    		
    		//var networkId = this.applicationContext.getPageContextNetworkId();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlotOrderEditPage";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {    		
    		var topDiv = domConstruct.create("div", null, null);
    		
    		// Caption Bar
    		this.captionBarDiv = this.constructCaptionBar();
    		domClass.add(this.captionBarDiv, "plotOrderEditPageCaptionBar");
    		domConstruct.place(this.captionBarDiv, topDiv);
    		
    		// Export to pdf button
    		this.exportToPdfButton = this.constructExportToPdfButton();
    		
    		// Back button
    		this.backButton = this.constructBackButton();
    		
    		// Receipt Button
    		this.receiptButton = this.constructReceiptButton();
    		
    		// Receipt caption
    		this.receiptCaption = this.constructReceiptLabel();
    		domConstruct.place(this.receiptCaption, this.captionBarDiv);
   		
    		// EditWidget
    		this.editWidgetTopDiv = domConstruct.create("div", null, null);
            domClass.add(this.editWidgetTopDiv, "plotOrderEditPageEditWidgetTopDiv");
    		
    		this.editWidget = new PlotOrderEditWidget({
    			applicationContext : this.applicationContext
    		});
    		this.editWidgetDiv = this.editWidget.getContainer();
    		domConstruct.place(this.editWidgetDiv, this.editWidgetTopDiv);
    		
    		domConstruct.place(this.editWidgetTopDiv, topDiv);
    		
    		return topDiv;
    	},
    	
    	constructCaptionBar : function() {
    		// Caption Bar consisting of caption and context bar right of the caption
    		var captionBarDiv = domConstruct.create("div", null, null);
    		
    		// Caption
    		this.captionDiv = DOMHelper.createTextNode("h1", i18n.plotOrderEditPageCaption, captionBarDiv, "plotOrderEditPageCaption");
     		
    		return captionBarDiv;
    	},    	
    	
    	constructExportToPdfButton : function() {
    		var exportToPdfButton = new DisableButton({
                label : i18n.plotOrderEditPageExportToPdfButtonCaption,
            showLabel : false,
                title : i18n.plotOrderEditPageExportToPdfButtonToolTip,
              onClick : lang.hitch(this, function() {
            	  this.exportToPdf();
              }),
            iconClass : "exportToPdfButton",
              "class" : "cdesWebButton17x18 gridButton",
     controllerWidget : this,
         disableEvent : "disableButtons",
     _destroyOnRemove : true
       	 	});    		
    		domConstruct.place(exportToPdfButton.domNode, this.captionBarDiv);    		
    		return exportToPdfButton;    		
    	},
    	
    	exportToPdf : function() {
    		if (this.plotOrderId != null) {
	
				var url = "/cdes/app?service=OOo2PDFService/0/ShowPlotOrderOOo/pdf/showProject/Plotauftrag&sp=" + this.plotOrderId  + "&sp=0"
						+ "&ts=" + dojoConfig.tabSessionId;
				window.open(url);     		
       		} else {
       			throw new Error("Trying to export to pdf without plotOrderId being set.");
       		}    			
    	},
    	
    	constructReceiptLabel : function() {
    		return DOMHelper.createTextNode("h3", "", null, "plotOrderEditReceiptCaption");
    	},
    	
    	constructReceiptButton : function() {
    		var receiptButton = new DisableButton({
                          label : i18n.plotOrderEditPageExportReceiptButtonCaption,
                      showLabel : false,
                          title : i18n.plotOrderEditPageExportReceiptButtonToolTip,
                        onClick : lang.hitch(this, function() {
            	           this.exportReceipt();
                        }),
                      iconClass : "exportToPdfButton",
                        "class" : "cdesWebButton17x18 gridButton plotOrderEditReceiptButton invisible",
               controllerWidget : this,
                   disableEvent : "disableButtons",
               _destroyOnRemove : true
       	 	});    		
    		domConstruct.place(receiptButton.domNode, this.captionBarDiv);    		
    		return receiptButton;    		
    	},
    	
    	constructBackButton : function() {
    		this.backButton = new Button({
    			   label : this.from!=null&&this.from=="plotOrders"? i18n.back : i18n.plotOrderPageCaption,
		           title : i18n.backToolTip
    		});
    		domClass.add(this.backButton.domNode, "plotOrderEditBackButton");
    		on(this.backButton, "click", lang.hitch(this, function() {
    			this.applicationContext.setPage("plotOrders", {}, {});
    		}));
    		domConstruct.place(this.backButton.domNode, this.captionBarDiv);    		
    	},
    	
    	exportReceipt : function() {
    		if (this.multipleReceipts != null) {
    			//zip archive in case of multiple recipients
    			if (this.multipleReceipts) {
    	    		InfoDialog.showQuestion({
    	    			  title : i18n.plotOrderEditMultipleReceiptsQuestionCaption,
    	    			message : i18n.plotOrderEditMultipleReceiptsQuestionContent,
    	    			buttons : [
    	    			           { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
    	    		    	    		if (this.plotOrderId != null) {
    	    		    	    			document.location.href = "/cdes/app?service=SecureDirectService/1/ShowPlotOrder/showProject/deliveryNoteBulkDownload&sp=" + this.plotOrderId + "&ts=" + dojoConfig.tabSessionId;
    	    		    	       		} else {
    	    		    	       			throw new Error("Trying to export to pdf without plotOrderId being set.");
    	    		    	       		}    			
    	    			           })},    			           
    	    			           { type : InfoDialog.Button.NO }
    	    			           ]
    	      		});    				
    			} else {
	    			var url = "/cdes/app?service=OOo2PDFService/1/PlotOrderDeliveryNoteOOo/pdf/showProject/Lieferschein&sp=" + this.plotOrderId + "&sp=0" + "&ts=" + dojoConfig.tabSessionId;
	    			window.open(url);
    			}   			
    		}
    	},
    	
    	resize : function() {    		
    		
    		var contentHeight = window.innerHeight
    					//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
    					- this.captionBarDiv.offsetHeight
    					- 32;

    		domStyle.set(this.editWidgetTopDiv, "height", contentHeight + "px");
    		
    	},
    	
    	setData : function(plotOrderId) {
    		this.plotOrderId = plotOrderId;
    		
    		//registerPage
    		var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
    		var pageName = "plotOrderEdit&sp=" + this.plotOrderId;
    		
    		tabSessionContextService.addToPageList(dojoConfig.tabSessionId, pageName, false).then(lang.hitch(this, function() {
					log.info("Called UpdatePageContextService");
			}),
			lang.hitch(this, function(err) {
		        ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : null,
                            opName : "UpdatePageContextService",
                           message : i18n.updatePageContextServiceFailedMessage
		        });     				
			})).otherwise(lang.hitch(this, function(err) {
				log.error("Error while processing UpdatePageContextService: ", err);
			}));
    		
    		var deferred = this.editWidget.setData(plotOrderId);
    		this.reload();
    		
    		deferred.then(lang.hitch(this, function(plotOrderEditJoins) {
    			this.plotOrderEditJoins = plotOrderEditJoins;
    			this.updateWidgetState();
    		}));
    	},
    	
    	reload : function() {
    		//this.contextBar.reload();    	
            this.resize();

    	},
    	
    	updateWidgetState : function() {
    		var operationRunning = this.isAsyncOperationRunning();
    		domClass.remove(this.receiptButton.domNode, "visible invisible");
    		domClass.remove(this.receiptCaption, "visible invisible");
    		
    		var plotOrderJoin = this.plotOrderEditJoins != null && this.plotOrderEditJoins.length > 0 ? this.plotOrderEditJoins[0] : null;
    		var showReceipt = plotOrderJoin != null && plotOrderJoin.acceptanceStepId != null && plotOrderJoin.acceptanceStepFinished != null;
    		
    		if (showReceipt) {
    			domClass.add(this.receiptButton.domNode, "visible");
    			domClass.add(this.receiptCaption, "visible");
    		} else {
    			domClass.add(this.receiptButton.domNode, "invisible");
    			domClass.add(this.receiptCaption, "invisible");
    		}
    		
    		var seenPlotOrderItemIds = new Object();
    		var seenDeliveryAddresses = new Object();
    		for (var n = 0; this.plotOrderEditJoins != null && n < this.plotOrderEditJoins.length; n++) {
    			var currJoin = this.plotOrderEditJoins[n];
    			if (!(currJoin.plotOrderItemId in seenPlotOrderItemIds)) {
    				seenPlotOrderItemIds[currJoin.plotOrderItemId] = true;
    				
    				var addressString = currJoin.deliveryAddressOrganisationName + ";"
    								  + currJoin.deliveryAddressGivenName + ";"
    								  + currJoin.deliveryAddressSurName + ";"
    								  + currJoin.deliveryAddressPostalAddress + ";"
    								  + currJoin.deliveryAddressPostalCode + ";"
    								  + currJoin.deliveryAddressLocalityName;
    				seenDeliveryAddresses[addressString] = true;
    			}
    		}
    		
    		this.multipleReceipts = DataHelper.getMapSize(seenDeliveryAddresses)>1?1:0;
    		var receiptLabel = (this.multipleReceipts ? i18n.plotOrderEditMultipleReceiptsCaption : i18n.plotOrderEditOneReceiptCaption);
    		DOMHelper.setInnerText(this.receiptCaption, receiptLabel);
    		
    	},
    });
    
    return PlotOrderEditPage;
});
