define([], function() {
    return {
        validate: function(password, passwordMinLength) {
            if (password == null || password.length === 0) {
                return "MISSING";
            }

            if (password.length < passwordMinLength) {
                return "TOO_SHORT";
            }

            var hasIllegalChars = password.match(/[^A-Za-z0-9\.\-\_\/\\\!\?\,\:\(\)\[\]\{\}öÖäÄüÜß\%\§\$\&\€]/);
            if (hasIllegalChars) {
                return "ILLEGAL_CHARS";
            }

            var hasLowerCase = password.match(/[a-z]/)!=null?1:0;
            var hasUpperCase = password.match(/[A-Z]/)!=null?1:0;
            var hasDigit = password.match(/[0-9]/)!=null?1:0;
            var hasOther = password.match(/[^A-Za-z0-9]/)!=null?1:0;
            /*
            const hasLowerCase = /\p{Ll}/u.test(password);
            const hasUpperCase = /\p{Lu}/u.test(password);
            const hasDigit = /\p{Nd}/u.test(password);
            const hasOther = /[^\p{Nd}\p{Ll}\p{Lu}]/u.test(password);
            */

            const numCategories = hasLowerCase + hasUpperCase + hasDigit + hasOther;

            if (numCategories < 3) {
                return "LACKING_DIVERSITY";
            }

            return "OK";
        }
    };
});
