/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningReport
////i18n-prefix = planningReport


define([ "cdes/core/CdesVoc",
	"cdes/planning/report/PlanningNotificationReportCoverWidget",
	"cdes/planning/report/PlanningNotificationReportDataWidget",
	"cdes/planning/report/PlanningNotificationReportOptionsWidget",
	"cdes/widget/ContextBar",
	"cdes/widget/base/SearchControllingWidget",
	"cdes/widget/search/SearchEditWidget",
	"clazzes/ClazzesVoc",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/EditDialog",
	"clazzes/widgets/layout/InfoDialog",
	"dijit/form/Button",
    "dijit/form/CheckBox",
	"dijit/form/Select",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/json",
	"dojo/on",	 
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			PlanningNotificationReportCoverWidget,
			PlanningNotificationReportDataWidget,
			PlanningNotificationReportOptionsWidget,
			ContextBar,
			SearchControllingWidget,
			SearchEditWidget,
			ClazzesVoc,
			TinyLog,
			FancyButton,
			topic,               
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			EditDialog,
			InfoDialog,
			Button,
            CheckBox,
			Select,
			domClass,
			domConstruct,
			domStyle,
			json,
			on,		
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.report.PlanningNotificationReportPage";

	var log = new TinyLog(className);

	var PlanningNotificationReportPage = declare(className, SearchControllingWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.searchSelectLabel = i18n.planningNotificationReportSearchLabel;
			this.searchSelectToolTip = i18n.planningNotificationReportSearchToolTip;
			this.searchCreateCaption = i18n.planningReportCreateSearchCaption;
			this.searchCreateToolTip = i18n.planningNotificationReportNewSearchButtonToolTip;            
			this.searchCreateRefusedMessage = i18n.planningNotificationReportCreateRefusedMessage;
			this.searchEditCaption = i18n.planningReportEditSearchCaption;
			this.searchEditToolTip = i18n.planningNotificationReportSaveSearchButtonToolTip;            
			this.searchRenameToolTip = i18n.planningNotificationReportEditSearchButtonToolTip;
			this.searchDeleteQuestionDialogCaption = i18n.planningReportSearchAskDeleteDialogCaption;
			this.searchDeleteQuestionDialogText = i18n.planningReportSearchAskDeleteDialogQueston;
			this.searchDeleteToolTip = i18n.planningNotificationReportDeleteSearchButtonToolTip;            

			this.searchSelectCssClass = "listButton planningNotificationSearchSelect";
			this.searchPageName = CdesVoc.SearchPageName.PLANNING_NOTIFICATION_REPORT;
			this.hasProjects = false;

			this.initialize();
			this.topDiv = this.constructTopDiv();

			this.loadSearch();
			this.updateWidgetState();	    

			this.allFieldsValid = true;

		},

		callSearchQuery : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		    var networkId = this.applicationContext.getPageContextPnNetworkId();
            var showAll = this.showAllCheckBox.get("checked"); //will be used later locally
		    var utilService = this.applicationContext.getService("utilService");
		    return utilService.getPlanningNotificationReportSearchs(organisationPersonId, networkId, true);
		},            

		storeParsedSearchJsonContent : function(parsedJsonContent) {
			this.config = parsedJsonContent;
		},            

		fetchSearchContentAsJson : function() {
			return json.stringify(this.config);
		},            

		updateSearchDataWithSelectedSearchProperties : function(currSearch) {
			this.config.options.reportName = currSearch.searchName != null ? currSearch.searchName : null;
			
			//if 'Gesamtbericht' we have to set to first pageWidget
			if (this.config.options.reportType == "ALL" && this.currPageWidgetIndex > 0) {
				//if last pageWidget (reportData)
				if (this.currPageWidgetIndex < this.pageWidgets.length) {
					var currWidget = this.pageWidgets[this.currPageWidgetIndex];
					domClass.add(currWidget.getContainer(), "hidden");
					if (currWidget != null) {
						currWidget.stepBackwardHandler();
					}
				}
				this.currPageWidgetIndex = 0;
				var firstWidget = this.pageWidgets[this.currPageWidgetIndex];		    
				domClass.remove(firstWidget.getContainer(), "hidden");

				firstWidget.updateWidgetState();
				this.updateWidgetState();
				this.updateCustomButtons(firstWidget);
			}

		},            

        processSearchSelectionReset : function() {
            this.searchSelect.set("title", "");
		    this.config.options.reportName = null;
		    //this.config = this.initializeDefaultConfig();
		    this.updateWidgetsFromData();
		},

		getProjectIdFromPageContext : function() {
			return this.applicationContext.getPageContextPnProjectId();
		},            

		getWidgetId : function() {
			return "PlanningNotificationReportPage";
		},

		getDataId : function() {
			return null;
		},

		initialize : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();	    
			this.config = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationReport/config");
			//log.info("Loaded config from  [" + organisationPersonId + "] and networkId [" + networkId + "]", this.config);

			if (this.config == null) {
				this.config = this.initializeDefaultConfig();
			} else {
				// Fallback case if (ancient?) configs that are only partly filled exist.
				if (this.config.options == null) {
					this.config.options = PlanningNotificationReportOptionsWidget.getDefaultConfig();
				}
				if (this.config.cover == null) {
					this.config.cover = PlanningNotificationReportCoverWidget.getDefaultConfig();
				}
				if (this.config.data == null) {
					this.config.data = PlanningNotificationReportDataWidget.getDefaultConfig();
				}                    
			}                
		},	    

		initializeDefaultConfig : function() {
		    var defaultConfig = {
			options : PlanningNotificationReportOptionsWidget.getDefaultConfig(),
			  cover : PlanningNotificationReportCoverWidget.getDefaultConfig(),
			   data : PlanningNotificationReportDataWidget.getDefaultConfig()
		    };
		    return defaultConfig;
		},
		
		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Context Bar
/*			this.contextBar = new ContextBar({
				applicationContext : this.applicationContext,
				mode : ContextBar.Mode.PLANNING_NOTIFICATION,
				editable : true		 
			});
			this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
			this.contextBarDiv = this.contextBar.getContainer();
			domConstruct.place(this.contextBarDiv, topDiv);
*/
			topic.subscribe("context/change", lang.hitch(this, function() {
				for (var n = 0; n < this.pageWidgets.length; n++) {
					this.pageWidgets[n].processNetworkChange();
				}		
			}));

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
		    var captionBarDiv = domConstruct.create("div", null, null);

		    // Caption
		    this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationReportConfigPageCaption, captionBarDiv, "cdesGeneralPageCaption");
                    
		    DOMHelper.createTextNode("span", i18n.planningNotificationReportSearchLabel, captionBarDiv, "planningNotificationReportSearchLabel");
		    this.searchSelect = this.constructSearchSelect(captionBarDiv);
                    this.showAllCheckBox= this.constructShowAllCheckBox(captionBarDiv);                    
		    DOMHelper.createTextNode("span", i18n.planningNotificationReportShowAllLabel, captionBarDiv, "planningNotificationReportShowAllLabel");
		    this.newSearchButton = this.constructNewSearchButton(captionBarDiv);
		    this.saveButton = this.constructSaveSearchButton(captionBarDiv);
		    this.editSearchButton = this.constructEditSearchButton(captionBarDiv);
		    this.deleteSearchButton = this.constructDeleteSearchButton(captionBarDiv);	    
		    this.backButton = this.constructBackButton(captionBarDiv);
		    this.forwardButton = this.constructForwardButton(captionBarDiv);
                    
			var pageContext = this.applicationContext.getPageContext();
//			if (pageContext.cdesDojoImplBundleVersion.indexOf("SNAPSHOT") != -1) {
//			this.constructOutputLocalStorageToLogButton(captionBarDiv);
//			this.constructDeleteLocalStorageButton(captionBarDiv);
//			}

		    return captionBarDiv;
		},

                constructShowAllCheckBox : function(captionBarDiv)  {
                    var showAllCheckBox = new CheckBox({
                        label : i18n.planningNotificationReportShowAllLabel,
                        title : i18n.planningNotificationReportShowAllToolTip                        
                    });
                    domClass.add(showAllCheckBox.domNode, "planningNotificationReportShowAllCheckBox");
                    domConstruct.place(showAllCheckBox.domNode, captionBarDiv);

                    WidgetHelper.handleCheckBoxEvents(showAllCheckBox, lang.hitch(this, function() {
                        var showAll = this.showAllCheckBox.get("checked");
                        if (showAll != this.showAll) {
                            this.updateSearchSelect();
                            this.showAll = showAll;                            
                        }                          
                    })); 

                    return showAllCheckBox;                    
                },    

		constructBackButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.planningNotificationReportBackButtonCaption,
				title : i18n.planningNotificationReportBackButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationReportBackButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				if (this.currPageWidgetIndex > 0) {
					if (this.currPageWidgetIndex < this.pageWidgets.length) {
						var currWidget = this.pageWidgets[this.currPageWidgetIndex];
						domClass.add(currWidget.getContainer(), "hidden");
						if (currWidget != null) {
							currWidget.stepBackwardHandler();
						}
					}

					this.currPageWidgetIndex--;
					var prevWidget = this.pageWidgets[this.currPageWidgetIndex];		    
					domClass.remove(prevWidget.getContainer(), "hidden");

					prevWidget.updateWidgetState();
					this.updateWidgetState();

					this.updateCustomButtons(prevWidget);
				}
			}));		
			return button;
		},

		constructForwardButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.planningNotificationReportForwardButtonCaption,
				title : i18n.planningNotificationReportForwardButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationReportForwardButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {

				var currWidget = this.pageWidgets[this.currPageWidgetIndex];
				var isLastWidget = this.currPageWidgetIndex >= this.pageWidgets.length - 1;
				var newWidget = currWidget.performStepForward(this.pageWidgets);
				if (newWidget != null) {
					newWidget.setData(this.config);		
					domClass.add(currWidget.getContainer(), "hidden");
					for (var n = 0; n < this.pageWidgets.length; n++) {
						if (this.pageWidgets[n] == newWidget) {
							this.currPageWidgetIndex = n;			
						}
					}

					if (isLastWidget) {
						domConstruct.place(newWidget.getContainer(), this.contentDiv);
					} else {
						domClass.remove(newWidget.getContainer(), "hidden");
					}

					newWidget.updateWidgetState();

					this.updateCustomButtons(newWidget);
				}

				this.updateWidgetState();
			}));		
			return button;
		},

		updateCustomButtons : function(newWidget) {
			if (this.customButtons != null) {
				for (var z = 0; z < this.customButtons.length; z++) {
					domConstruct.destroy(this.customButtons[z].domNode);
				}                    
			}     
			this.customButtons = newWidget.getCustomButtons();
			var currPrevNode = this.forwardButton.domNode;
			for (var n = 0; n < this.customButtons.length; n++) {
				domConstruct.place(this.customButtons[n].domNode, currPrevNode, "after");
				currPrevNode = this.customButtons[n].domNode;
				//don't enable customButtons if no projects are available           
				if (!this.hasProjects)
					this.customButtons[n].set("disabled", true);
			}                                    
		},
/*
		constructOutputLocalStorageToLogButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.planningNotificationReportOutputLocalStorageToLogCaption,
				title : i18n.planningNotificationReportOutputLocalStorageToLogToolTip
			});
			domClass.add(button.domNode, "planningNotificationReportOutputLocalStorageToLogButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var networkId = this.applicationContext.getPageContextPnNetworkId();	    
				var config = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationReport/config");
				var jsonString = json.stringify(config);

				var utilService = this.applicationContext.getService("utilService");
				utilService.printLocalStorageToDebug([{
					organisationPersonId : organisationPersonId,
					networkId : networkId,
					key : "/planningNotificationReport/config",
					json : jsonString
				}]).then(
						lang.hitch(this, function() {
							topic.publish("message/ok", i18n.planningNotificationReportOutputLocalStorageToLogSuccess);
						}),
						lang.hitch(this, function(err) {
							topic.publish("message/error", i18n.planningNotificationReportOutputLocalStorageToLogFailed);
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [printLocalStorageToDebug]", err);
								}));
			}));

			return button;	    
		},	

		constructDeleteLocalStorageButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.planningNotificationReportDeleteLocalStorageCaption,
				title : i18n.planningNotificationReportDeleteLocalStorageToolTip
			});
			domClass.add(button.domNode, "planningNotificationReportDeleteLocalStorageButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var networkId = this.applicationContext.getPageContextPnNetworkId();	    
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationReport/config", null);
				topic.publish("message/ok", i18n.planningNotificationReportDeleteLocalStorageSuccess);
			}));

			return button;	    
		},	
*/
		constructContentDiv : function() {
			this.contentDiv = domConstruct.create("div", null, null);
			domClass.add(this.contentDiv, "refNodeOfPositionAbsolute planningNotificationReportContentDiv");

			var pageWidget = new PlanningNotificationReportOptionsWidget({
				applicationContext : this.applicationContext
			});
			domConstruct.place(pageWidget.getContainer(), this.contentDiv);
			on(pageWidget, "stepWidgetChanged", lang.hitch(this, this.updateWidgetState));
			on(pageWidget, "customButtonsChanged", lang.hitch(this, function(widget) {
				this.updateCustomButtons(widget);
			}));                
			pageWidget.setData(this.config);	    

			this.pageWidgets = [ pageWidget ];
			this.currPageWidgetIndex = 0;	    

			return this.contentDiv;
		},

		resize : function(newSize) {
			if (newSize) {
				this.lastNewSize = newSize;
			}

			if (this.lastNewSize == null) {
				return ;
			}		

			var totalHeight = this.lastNewSize.h;    		

			var contentHeight = totalHeight
			//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			//	- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
			//	- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
			// 	- this.statusBarDiv.offsetHeight
			- 16;

			domStyle.set(this.contentDiv, "height", contentHeight + "px");

			for (var n = 0; n < this.pageWidgets.length; n++) {
				this.pageWidgets[n].resize({ h : contentHeight });
			}		
		},

		setData : function() {

		},

		reload : function() {

		},

		updateWidgetsFromData : function() {
			for (var n = 0; n < this.pageWidgets.length; n++) {
				this.pageWidgets[n].setData(this.config);
			}		
		},

		updateDataFromWidgets : function() {
			for (var n = 0; n < this.pageWidgets.length; n++) {
				this.pageWidgets[n].updateDataFromWidgets();
			}		
		},	    

		updateWidgetState : function() {

			if (this.currPageWidgetIndex != null) {
				var pageWidget = this.pageWidgets[this.currPageWidgetIndex];

				var pageCaption = pageWidget.getPageCaption();
				DOMHelper.setInnerText(this.captionDiv, pageCaption);

				this.backButton.set("disabled", this.currPageWidgetIndex == 0);
				//don't enable Button if no projects are available           
				if (!this.hasProjects)
					this.forwardButton.set("disabled", true);	    
				else
					this.forwardButton.set("disabled", pageWidget.disableStepForward());	    

				var forwardButtonCaption = pageWidget.getStepForwardCaption();
				this.forwardButton.set("label", forwardButtonCaption);	    

				var forwardButtonToolTip = pageWidget.getStepForwardToolTip();
				this.forwardButton.set("title", forwardButtonToolTip);	    

				this.resize();		
			} else {
				if (this.backButton != null) {
					this.backButton.set("disabled", true);		    
				}

				if (this.forwardButton != null) {
					this.forwardButton.set("disabled", true);
				}		    
			}
		},

		destroy : function() {
			this.inherited(arguments);
		}
	});

	PlanningNotificationReportPage.AsyncOperation = {
	};

	return PlanningNotificationReportPage;
});
